/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.servlet.ServletContext;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.stream.Streams;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.gc.GarbageCollector;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeLockType;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.NameGenerationHelper;
import org.jahia.services.content.NodeIteratorImpl;
import org.jahia.services.content.decorator.JCRComponentNode;
import org.jahia.services.content.decorator.JCRFileNode;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Template;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ServletContextAware;

public final class JCRContentUtils
implements ServletContextAware {
    private static final Value[] EMPTY_VALUES = new Value[0];
    public static final Pattern COLON_PATTERN = Patterns.COLON;
    public static final Comparator<NodeType> NODE_TYPE_NAME_COMPARATOR = new Comparator<NodeType>(){

        @Override
        public int compare(NodeType o1, NodeType o2) {
            return o1 == o2 ? 0 : o1.getName().compareTo(o2.getName());
        }
    };
    private static final String PREFIX = Jahia.getContextPath() + "/modules/";
    private static final Logger logger = LoggerFactory.getLogger(JCRContentUtils.class);
    private static Map<String, Boolean> iconsPresence = new ConcurrentHashMap<String, Boolean>(512, 0.8f, 32);
    private static volatile JCRContentUtils instance;
    private final Map<String, String> fileExtensionIcons;
    private final Map<String, List<String>> mimeTypes;
    private final Map<String, String> defaultUserFolderTypes;
    private NameGenerationHelper nameGenerationHelper;
    private Set<String> unsupportedMarkForDeletionNodeTypes = Collections.emptySet();
    private Pattern handleFallbackLocaleForPath;
    private ServletContext servletContext;

    public JCRContentUtils(Map<String, List<String>> mimeTypes, Map<String, String> fileExtensionIcons, Map<String, String> defaultUserFolderTypes) {
        instance = this;
        this.mimeTypes = UnmodifiableMap.decorate(mimeTypes);
        this.fileExtensionIcons = UnmodifiableMap.decorate(fileExtensionIcons);
        this.defaultUserFolderTypes = UnmodifiableMap.decorate(defaultUserFolderTypes);
    }

    public static JCRContentUtils getInstance() {
        if (instance == null) {
            throw new UnsupportedOperationException("JCRContentUtils is not initialized yet");
        }
        return instance;
    }

    public static int callDataStoreGarbageCollector() throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInJCR(JCRSessionWrapper session) throws RepositoryException {
                int deleted = 0;
                try (GarbageCollector gc = ((SessionImpl)session.getProviderSession(session.getNode("/").getProvider())).createDataStoreGarbageCollector();){
                    gc.mark();
                    deleted = gc.sweep();
                    logger.info("Datastore garbage collector deleted {} data records", (Object)deleted);
                }
                return deleted;
            }
        });
    }

    public static boolean check(String icon) {
        String moduleId = StringUtils.substringBefore((String)icon, (String)"/");
        String pathAfter = StringUtils.substringAfter((String)icon, (String)"/");
        JahiaTemplatesPackage module = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(moduleId);
        icon = module.getId() + "/" + module.getVersion() + "/" + pathAfter;
        Boolean present = iconsPresence.get(icon);
        if (present == null) {
            present = module.resourceExists(pathAfter + ".png");
            iconsPresence.put((String)icon, present);
        }
        return present;
    }

    public static void clearAllLocks(final String path, final boolean processChildNodes, String workspace) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, null, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRContentUtils.clearAllLocks(path, processChildNodes, session);
                return null;
            }
        });
    }

    private static void clearAllLocks(String path, boolean processChildNodes, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper node = session.getNode(path);
        node.clearAllLocks();
        if (processChildNodes) {
            JCRNodeIteratorWrapper iterator = node.getNodes();
            while (iterator.hasNext()) {
                JCRNodeWrapper child = (JCRNodeWrapper)iterator.next();
                JCRContentUtils.clearAllLocks(child.getPath(), processChildNodes, session);
            }
        }
    }

    public static Value createValue(Object objectValue, ValueFactory factory) {
        if (objectValue instanceof String) {
            return factory.createValue((String)objectValue);
        }
        if (objectValue instanceof Boolean) {
            return factory.createValue(((Boolean)objectValue).booleanValue());
        }
        if (objectValue instanceof Long) {
            return factory.createValue(((Long)objectValue).longValue());
        }
        if (objectValue instanceof Integer) {
            return factory.createValue(((Integer)objectValue).longValue());
        }
        if (objectValue instanceof Calendar) {
            return factory.createValue((Calendar)objectValue);
        }
        if (objectValue instanceof Date) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime((Date)objectValue);
            return factory.createValue((Calendar)c);
        }
        if (objectValue instanceof byte[] || objectValue instanceof File) {
            Value value;
            InputStream is = null;
            try {
                is = objectValue instanceof File ? new BufferedInputStream(new FileInputStream((File)objectValue)) : new ByteArrayInputStream((byte[])objectValue);
                value = factory.createValue(factory.createBinary(is));
            }
            catch (Exception e) {
                try {
                    throw new IllegalArgumentException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return value;
        }
        logger.warn("Do not know, how to handle value of type {}", (Object)objectValue.getClass().getName());
        return null;
    }

    public static Value[] createValues(Collection<?> objectValues, ValueFactory factory) {
        if (objectValues == null) {
            return null;
        }
        if (objectValues.isEmpty()) {
            return EMPTY_VALUES;
        }
        ArrayList<Value> vals = new ArrayList<Value>(objectValues.size());
        for (Object objValue : objectValues) {
            vals.add(JCRContentUtils.createValue(objValue, factory));
        }
        return vals.toArray(EMPTY_VALUES);
    }

    public static String decodeJCRNamePrefix(String encodedPrefix) {
        String originalPrefix = encodedPrefix.replace("\\3A", ":");
        return originalPrefix;
    }

    public static void deleteJackrabbitIndexes(File repositoryHome) {
        if (repositoryHome == null || !repositoryHome.isDirectory()) {
            return;
        }
        logger.info("Removing JCR repository indexes in repository {}", (Object)repositoryHome);
        FileUtils.deleteQuietly((File)new File(repositoryHome, "index"));
        File workspaces = new File(repositoryHome, "workspaces");
        FileUtils.deleteQuietly((File)new File(new File(workspaces, "default"), "index"));
        FileUtils.deleteQuietly((File)new File(new File(workspaces, "live"), "index"));
        logger.info("...done removing index folders.");
    }

    public static File downloadFileContent(JCRNodeWrapper node) throws IOException {
        return JCRContentUtils.downloadFileContent(node, File.createTempFile("data", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFileContent(JCRNodeWrapper node, File targetFile) throws IOException {
        InputStream is = node.getFileContent().downloadFile();
        if (is == null) {
            throw new IllegalArgumentException("Provided node has no file content");
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile));
        try {
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
        return targetFile;
    }

    public static String encodeJCRNamePrefix(String originalPrefix) {
        String encodedPrefix = originalPrefix.replace(":", "\\3A");
        return encodedPrefix;
    }

    public static String escapeLocalNodeName(String name) {
        name = name.trim();
        StringBuilder buffer = new StringBuilder(name.length() * 2);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '[' || ch == ']' || ch == '*' || ch == '|') {
                buffer.append('%');
                buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
                buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
                continue;
            }
            if (ch == '/' || ch == '<' || ch == '>' || ch == '\\' || Character.isWhitespace(ch)) {
                if (buffer.length() <= 0) continue;
                buffer.append(' ');
                continue;
            }
            buffer.append(ch);
        }
        return Normalizer.normalize(buffer.toString(), Normalizer.Form.NFC).trim();
    }

    public static String escapeNodePath(String path) {
        StringBuilder buffer = new StringBuilder(path.length() * 2);
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (ch == '[' || ch == ']' || ch == '*' || ch == '|') {
                buffer.append('%');
                buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
                buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String findAvailableNodeName(Node dest, String name) {
        return JCRContentUtils.findAvailableNodeName(dest, name, true);
    }

    public static String findAvailableNodeName(Node dest, String name, boolean hasExtension) {
        int und;
        int dot;
        try {
            dest.getNode((String)name);
        }
        catch (RepositoryException e) {
            return name;
        }
        int i = 1;
        String basename = name;
        String ext = "";
        if (hasExtension && (dot = basename.lastIndexOf(46)) > 0) {
            ext = basename.substring(dot);
            basename = basename.substring(0, dot);
        }
        if ((und = basename.lastIndexOf(45)) > -1 && Patterns.NUMBERS.matcher(basename.substring(und + 1)).matches()) {
            basename = basename.substring(0, und);
        }
        try {
            while (true) {
                String newSuffix = hasExtension ? "-" + i++ + ext : "-" + i++;
                name = basename + newSuffix;
                int maxNameSize = SettingsBean.getInstance().getMaxNameSize();
                if (((String)name).length() > maxNameSize) {
                    name = basename.substring(0, (basename.length() <= maxNameSize ? basename.length() : maxNameSize) - newSuffix.length()) + newSuffix;
                }
                dest.getNode((String)name);
            }
        }
        catch (RepositoryException e) {
            return name;
        }
    }

    public static JCRNodeWrapper findDisplayableNode(JCRNodeWrapper node, RenderContext context) {
        Template template = null;
        JCRNodeWrapper currentNode = node;
        try {
            while (template == null && currentNode != null) {
                template = RenderService.getInstance().resolveTemplate(new org.jahia.services.render.Resource(currentNode, "html", null, "page"), context);
                if (template != null) continue;
                currentNode = currentNode.getParent();
            }
        }
        catch (Exception e) {
            currentNode = null;
        }
        return currentNode;
    }

    public static JCRNodeWrapper findDisplayableNode(JCRNodeWrapper node, RenderContext context, JCRSiteNode contextSite) {
        if (contextSite != null) {
            JCRSiteNode old = context.getSite();
            context.setSite(contextSite);
            JCRNodeWrapper displayableNode = JCRContentUtils.findDisplayableNode(node, context);
            context.setSite(old);
            return displayableNode;
        }
        return JCRContentUtils.findDisplayableNode(node, context);
    }

    public static String generateNodeName(String text) {
        return JCRContentUtils.generateNodeName(text, SettingsBean.getInstance().getMaxNameSize());
    }

    public static String generateNodeName(String text, int maxLength) {
        String nodeName = text.toLowerCase();
        nodeName = Normalizer.normalize(nodeName, Normalizer.Form.NFKD);
        nodeName = Patterns.ACCENTS.matcher(nodeName).replaceAll("");
        Matcher matcher = Patterns.NON_ALLOWED_CHARS.matcher(nodeName);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String replacement = Patterns.CHARMAP.getProperty(matcher.group(0));
            if (replacement == null) {
                replacement = "-";
            }
            matcher.appendReplacement(buffer, "");
            buffer.append(replacement);
        }
        matcher.appendTail(buffer);
        nodeName = buffer.toString();
        nodeName = Patterns.NON_ALLOWED_CHARS.matcher(nodeName).replaceAll("-");
        nodeName = Patterns.CONSECUTIVE_DASHES.matcher(nodeName).replaceAll("-");
        nodeName = Patterns.HEADING_DASH.matcher(nodeName).replaceAll("");
        if (nodeName.length() > maxLength) {
            nodeName = nodeName.substring(0, maxLength);
        }
        return StringUtils.isNotEmpty((String)(nodeName = Patterns.TRAILING_DASH.matcher(nodeName).replaceAll(""))) ? nodeName : "untitled";
    }

    public static Set<String> getAssignableMixins(JCRNodeWrapper node) throws RepositoryException {
        TreeSet<String> mixins = new TreeSet<String>();
        HashSet<String> existingMixins = new HashSet<String>(node.getNodeTypes());
        existingMixins.add("mix:shareable");
        NodeTypeIterator allMixins = node.getSession().getWorkspace().getNodeTypeManager().getMixinNodeTypes();
        while (allMixins.hasNext()) {
            String nt = allMixins.nextNodeType().getName();
            if (existingMixins.contains(nt) || !node.canAddMixin(nt)) continue;
            mixins.add(nt);
        }
        return mixins;
    }

    public static List<JCRNodeWrapper> getChildrenOfType(JCRNodeWrapper node, String type) {
        return JCRContentUtils.getChildrenOfType(node, type, 0);
    }

    public static List<JCRNodeWrapper> getChildrenOfType(JCRNodeWrapper node, String type, int limit) {
        List<JCRNodeWrapper> children = null;
        if (node == null) {
            return null;
        }
        if (type.contains(",")) {
            String[] typesToCheck = Patterns.COMMA.split(type);
            LinkedList<JCRNodeWrapper> matchingChildren = new LinkedList<JCRNodeWrapper>();
            try {
                JCRNodeIteratorWrapper iterator = node.getNodes();
                block2: while (iterator.hasNext() && (limit <= 0 || matchingChildren.size() != limit)) {
                    Node child = iterator.nextNode();
                    for (String matchType : typesToCheck) {
                        if (!child.isNodeType(matchType)) continue;
                        matchingChildren.add((JCRNodeWrapper)child);
                        continue block2;
                    }
                }
            }
            catch (RepositoryException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            children = matchingChildren;
        } else {
            children = JCRContentUtils.getNodes(node, type, limit);
        }
        return children;
    }

    public static String getContentNodeName(Node node) throws RepositoryException {
        return node.getName();
    }

    public static String getContentObjectPath(Node node) throws RepositoryException {
        StringBuilder path = new StringBuilder(64);
        path.append("/").append(JCRContentUtils.getContentNodeName(node));
        Node parent = null;
        try {
            parent = node.getParent();
        }
        catch (ItemNotFoundException e) {
            parent = null;
        }
        while (parent != null) {
            String name = JCRContentUtils.getContentNodeName(parent);
            path.insert(0, name);
            if (!"/".equals(name) && name.length() > 0) {
                path.insert(0, "/");
            }
            try {
                parent = parent.getParent();
            }
            catch (ItemNotFoundException e) {
                parent = null;
            }
        }
        return path.toString();
    }

    public static NodeIterator getDescendantNodes(JCRNodeWrapper node, String type) {
        try {
            return node.getSession().getWorkspace().getQueryManager().createQuery("select * from [" + type + "] as sel where isdescendantnode(sel,['" + JCRContentUtils.sqlEncode(node.getPath()) + "'])", "JCR-SQL2").execute().getNodes();
        }
        catch (InvalidQueryException e) {
            logger.error("Error while retrieving nodes", (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving nodes", (Throwable)e);
        }
        return NodeIteratorImpl.EMPTY;
    }

    public static String getDisplayLabel(Object item, Locale locale, ExtendedNodeType nodeTypeForSearchingLabel) {
        if (item != null) {
            try {
                if (item instanceof Property) {
                    Property property = (Property)item;
                    PropertyDefinition propertyDefintion = property.getDefinition();
                    if (propertyDefintion != null && propertyDefintion instanceof ExtendedPropertyDefinition) {
                        ExtendedPropertyDefinition itemDef = (ExtendedPropertyDefinition)propertyDefintion;
                        return itemDef.getLabel(locale, nodeTypeForSearchingLabel);
                    }
                    logger.error("PropertyDefinition doesn't implement 'org.jahia.services.content.nodetypes.ExtendedPropertyDefinition'");
                } else if (item instanceof PropertyDefinition) {
                    if (item instanceof ExtendedPropertyDefinition) {
                        ExtendedPropertyDefinition itemDef = (ExtendedPropertyDefinition)item;
                        return itemDef.getLabel(locale, nodeTypeForSearchingLabel);
                    }
                    logger.error("PropertyDefinition doesn't implement 'org.jahia.services.content.nodetypes.ExtendedPropertyDefinition'");
                } else if (item instanceof NodeType) {
                    NodeType nodeType = (NodeType)item;
                    if (nodeType instanceof ExtendedNodeType) {
                        ExtendedNodeType extendNodeType = (ExtendedNodeType)nodeType;
                        return extendNodeType.getLabel(locale);
                    }
                    logger.error("nodeType doesn't implement 'org.jahia.services.content.nodetypes.ExtendedNodeType'");
                } else {
                    logger.error("Object must be a 'javax.jcr.Property' or 'javax.jcr.nodetype.NodeType'");
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static String getExpandedName(String name, NamespaceRegistry namespaceRegistry) throws RepositoryException {
        if (!((String)name).startsWith("{")) {
            name = ((String)name).contains(":") ? "{" + namespaceRegistry.getURI(StringUtils.substringBefore((String)name, (String)":")) + "}" + StringUtils.substringAfter((String)name, (String)":") : "{}" + (String)name;
        }
        return name;
    }

    public static String getJCRName(String qualifiedName, NamespaceRegistry namespaceRegistry) throws RepositoryException {
        if (((String)qualifiedName).startsWith("{")) {
            String uri = StringUtils.substringBetween((String)qualifiedName, (String)"{", (String)"}");
            qualifiedName = uri.isEmpty() ? StringUtils.substringAfter((String)qualifiedName, (String)"}") : namespaceRegistry.getPrefix(uri) + ":" + StringUtils.substringAfter((String)qualifiedName, (String)"}");
        }
        return qualifiedName;
    }

    public static String getIconWithContext(ExtendedNodeType type) throws RepositoryException {
        String icon = JCRContentUtils.getIcon(type, null);
        if (icon == null) {
            icon = JCRContentUtils.getIcon(NodeTypeRegistry.getInstance().getNodeType("jmix:droppableContent"));
        }
        return PREFIX + icon;
    }

    public static String getIcon(ExtendedNodeType type) throws RepositoryException {
        return JCRContentUtils.getIcon(type, null);
    }

    private static String getIcon(ExtendedNodeType type, String subType) throws RepositoryException {
        String icon = JCRContentUtils.getIconsFolder(type) + JCRContentUtils.replaceColon(type.getName()) + (String)(StringUtils.isEmpty((String)subType) ? "" : "_" + subType);
        if (JCRContentUtils.check(icon)) {
            return icon;
        }
        if (!StringUtils.isEmpty((String)subType) && JCRContentUtils.check(icon = JCRContentUtils.getIconsFolder(type) + JCRContentUtils.replaceColon(type.getName()))) {
            return icon;
        }
        for (ExtendedNodeType nodeType : type.getSupertypes()) {
            icon = JCRContentUtils.getIconsFolder(nodeType) + JCRContentUtils.replaceColon(nodeType.getName());
            if (!JCRContentUtils.check(icon)) continue;
            return icon;
        }
        return null;
    }

    public static String getIcon(JCRNodeWrapper f) throws RepositoryException {
        return JCRContentUtils.getIconWithContext(f, false);
    }

    public static String getIconWithContext(JCRNodeWrapper f, boolean useContext) throws RepositoryException {
        ExtendedNodeType primaryNodeType = f.getPrimaryNodeType();
        String folder = JCRContentUtils.getIconsFolder(primaryNodeType);
        if (f.isNodeType("jmix:hasIcon") && f.hasProperty("j:icon")) {
            return ((JCRFileNode)f.getProperty("j:icon").getNode()).getUrl();
        }
        if (f.isFile()) {
            String nodeName = f.getName();
            String icon = FilenameUtils.indexOfExtension((String)nodeName) != -1 ? org.jahia.utils.FileUtils.getFileIcon(nodeName) : org.jahia.utils.FileUtils.getFileIconFromMimetype(f.getFileContent().getContentType());
            return (useContext ? PREFIX : "") + folder + "jnt_file_" + icon;
        }
        if (f instanceof JCRComponentNode) {
            String type = f.getName();
            ExtendedNodeType nt = primaryNodeType;
            if (!"components".equals(type)) {
                try {
                    nt = NodeTypeRegistry.getInstance().getNodeType(type);
                }
                catch (NoSuchNodeTypeException noSuchNodeTypeException) {
                    // empty catch block
                }
            }
            return (useContext ? PREFIX : "") + JCRContentUtils.getIcon(nt, JCRContentUtils.getSubType(nt, f));
        }
        if (!f.getProvider().isDefault() && f.isNodeType("jnt:folder")) {
            return (useContext ? PREFIX : "") + folder + "remoteFolder";
        }
        return (useContext ? PREFIX : "") + JCRContentUtils.getIcon(primaryNodeType, JCRContentUtils.getSubType(primaryNodeType, f));
    }

    private static String getSubType(ExtendedNodeType nt, JCRNodeWrapper f) {
        String subType = null;
        try {
            if ("jnt:virtualsite".equals(nt.getName()) && f.hasProperty("j:moduleType")) {
                subType = f.getPropertyAsString("j:moduleType");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return subType;
    }

    public static String getIconsFolder(ExtendedNodeType primaryNodeType) throws RepositoryException {
        String systemId = primaryNodeType.getSystemId();
        JahiaTemplatesPackage aPackage = !systemId.startsWith("system-") && !"default".equals(systemId) ? ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(systemId) : null;
        return aPackage != null ? aPackage.getId() + "/icons/" : "assets/icons/";
    }

    public static JCRNodeLockType getLockType(String lockTypeToken) {
        JCRNodeLockType type = JCRNodeLockType.UNKNOWN;
        if (lockTypeToken != null && lockTypeToken.length() > 1) {
            if (lockTypeToken.charAt(0) == ' ') {
                if (lockTypeToken.startsWith(" deletion ")) {
                    type = JCRNodeLockType.DELETION;
                } else if (lockTypeToken.endsWith(":validation")) {
                    type = JCRNodeLockType.WORKFLOW;
                }
            } else {
                type = JCRNodeLockType.USER;
            }
        }
        return type;
    }

    public static Set<JCRNodeLockType> getLockTypes(Map<String, List<String>> lockInfos) {
        Set<JCRNodeLockType> types = Collections.emptySet();
        if (lockInfos != null && !lockInfos.isEmpty()) {
            types = new HashSet<JCRNodeLockType>(4);
            for (List<String> infos : lockInfos.values()) {
                for (String lockToken : infos) {
                    types.add(JCRContentUtils.getLockType(lockToken));
                }
            }
        }
        return types;
    }

    public static String getNameFromPath(String path) {
        String[] pathNames = JCRContentUtils.splitJCRPath(path);
        return pathNames[pathNames.length - 1];
    }

    public static List<JCRNodeWrapper> getNodes(JCRNodeWrapper node, String type) {
        return JCRContentUtils.getNodes(node, type, 0);
    }

    public static List<JCRNodeWrapper> getNodes(JCRNodeWrapper node, String type, int limit) {
        try {
            ArrayList<JCRNodeWrapper> res = new ArrayList<JCRNodeWrapper>();
            JCRNodeIteratorWrapper ni = node.getNodes();
            while (ni.hasNext() && (limit <= 0 || res.size() != limit)) {
                JCRNodeWrapper child = (JCRNodeWrapper)ni.next();
                if (!StringUtils.isEmpty((String)type) && !child.isNodeType(type)) continue;
                res.add(child);
            }
            return res;
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving nodes", (Throwable)e);
            return new LinkedList<JCRNodeWrapper>();
        }
    }

    public static JCRNodeWrapper getOrAddPath(JCRSessionWrapper session, JCRNodeWrapper parentNode, String path, String pathNodeType) throws RepositoryException {
        String[] subPaths = JCRContentUtils.splitJCRPath(path);
        JCRNodeWrapper node = parentNode;
        for (String subPath : subPaths) {
            if (!StringUtils.isNotBlank((String)subPath) || "*".equals(subPath)) continue;
            try {
                node = node.getNode(subPath);
                session.checkout(node);
            }
            catch (PathNotFoundException e) {
                if (node == null) continue;
                session.checkout(node);
                node = node.addNode(subPath, pathNodeType);
            }
        }
        return node;
    }

    public static String getParentJCRPath(String path) {
        String[] pathNames = JCRContentUtils.splitJCRPath(path);
        StringBuilder parentPath = new StringBuilder();
        if (path.startsWith("/")) {
            parentPath.append("/");
        }
        for (int i = 0; i < pathNames.length - 1; ++i) {
            parentPath.append(pathNames[i]);
            if (i >= pathNames.length - 2) continue;
            parentPath.append("/");
        }
        return parentPath.toString();
    }

    public static JCRNodeWrapper getParentOfType(JCRNodeWrapper node, String type) {
        JCRNodeWrapper matchingParent = null;
        try {
            for (JCRNodeWrapper parent = node.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.isNodeType(type)) continue;
                matchingParent = parent;
                break;
            }
        }
        catch (ItemNotFoundException parent) {
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving nodes parent node. Cause: " + e.getMessage(), (Throwable)e);
        }
        return matchingParent;
    }

    public static JCRNodeWrapper getPathFolder(JCRNodeWrapper root, String name, String options, String nodeType) throws RepositoryException {
        JCRNodeWrapper result = root;
        if (options.contains("initials")) {
            String s = "" + Character.toUpperCase(name.charAt(0));
            result = !result.hasNode(s) ? result.addNode(s, nodeType) : result.getNode(s);
        }
        return result;
    }

    private static ExtendedPropertyDefinition getPropertyDefExtension(PropertyDefinition propDef) {
        try {
            return NodeTypeRegistry.getInstance().getNodeType(propDef.getDeclaringNodeType().getName()).getPropertyDefinition(propDef.getName());
        }
        catch (NoSuchNodeTypeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static PropertyDefinition getPropertyDefinition(NodeType type, String property) throws RepositoryException {
        PropertyDefinition foundDefintion = null;
        PropertyDefinition[] pds = type.getDeclaredPropertyDefinitions();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDefinition pd = pds[i];
            if (!pd.getName().equals(property)) continue;
            foundDefintion = pd;
            break;
        }
        return foundDefintion;
    }

    public static PropertyDefinition getPropertyDefinition(String nodeType, String property) throws RepositoryException {
        return JCRContentUtils.getPropertyDefinition(NodeTypeRegistry.getInstance().getNodeType(nodeType), property);
    }

    public static int getPropertyDefSelector(ItemDefinition itemDef) {
        ExtendedPropertyDefinition propDefExtension = null;
        if (itemDef instanceof PropertyDefinition) {
            propDefExtension = JCRContentUtils.getPropertyDefExtension((PropertyDefinition)itemDef);
        }
        return propDefExtension != null ? propDefExtension.getSelector() : 0;
    }

    public static String getSiteKey(String jcrNodePath) {
        return jcrNodePath != null ? (jcrNodePath.startsWith("/sites/") ? StringUtils.substringBetween((String)jcrNodePath, (String)"/sites/", (String)"/") : null) : null;
    }

    public static String getSystemSitePath() {
        return "/sites/systemsite";
    }

    public static Object getValue(Value propertyValue) throws ValueFormatException, RepositoryException {
        Object value = propertyValue.getString();
        switch (propertyValue.getType()) {
            case 6: {
                value = propertyValue.getBoolean();
                break;
            }
            case 5: {
                value = propertyValue.getDate();
                break;
            }
            case 3: 
            case 12: {
                value = propertyValue.getDecimal().longValue();
                break;
            }
            case 4: {
                value = propertyValue.getDouble();
            }
        }
        return value;
    }

    public static boolean hasPermission(String workspaceName, String permissionName, String nodeUUID) {
        try {
            JCRSessionWrapper session = JCRTemplate.getInstance().getSessionFactory().getCurrentUserSession(workspaceName);
            JCRNodeWrapper node = session.getNodeByIdentifier(nodeUUID);
            return node.hasPermission(permissionName);
        }
        catch (Exception e) {
            logger.error("Error while checking permission " + permissionName + " for node UUID " + nodeUUID, (Throwable)e);
            return false;
        }
    }

    public static void importSkeletons(String skeletonLocations, String targetPath, JCRSessionWrapper session) throws IOException, InvalidSerializedDataException, RepositoryException {
        JCRContentUtils.importSkeletons(skeletonLocations, targetPath, session, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importSkeletons(String skeletonLocations, String targetPath, JCRSessionWrapper session, int importUUIDBehavior, Map<String, String> replacements) throws IOException, InvalidSerializedDataException, RepositoryException {
        for (Resource resource : SpringContextSingleton.getInstance().getResources(skeletonLocations)) {
            logger.info("Importing data using skeleton [{}]", (Object)resource);
            InputStream is = null;
            try {
                is = resource.getInputStream();
                session.importXML(targetPath, is, importUUIDBehavior, 0, replacements, null);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public static void importSkeletons(String skeletonLocations, String targetPath, JCRSessionWrapper session, Map<String, String> replacements) throws IOException, InvalidSerializedDataException, RepositoryException {
        JCRContentUtils.importSkeletons(skeletonLocations, targetPath, session, 0, replacements);
    }

    public static boolean isADisplayableNode(JCRNodeWrapper node, RenderContext context) {
        Template template = null;
        JCRNodeWrapper currentNode = node;
        try {
            template = RenderService.getInstance().resolveTemplate(new org.jahia.services.render.Resource(currentNode, "html", null, "page"), context);
            return template != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMimeTypeGroup(String mimeType, String mimeTypeGroup) {
        return JCRContentUtils.isMimeTypeGroup(mimeType, StringUtils.split((String)mimeTypeGroup, (String)", ;|"));
    }

    public static boolean isMimeTypeGroup(String mimeType, String ... mimeTypeGroups) {
        if (mimeType == null) {
            return false;
        }
        boolean found = false;
        for (String grp : mimeTypeGroups) {
            String mime;
            List<String> mimeTypes = JCRContentUtils.getInstance().getMimeTypes().get(grp);
            if (mimeTypes == null) continue;
            Iterator<String> iterator = mimeTypes.iterator();
            while (iterator.hasNext() && !(found = (mime = iterator.next()).contains("*") ? Pattern.matches(StringUtils.replace((String)StringUtils.replace((String)mime, (String)".", (String)"\\."), (String)"*", (String)".*"), mimeType) : mime.equals(mimeType))) {
            }
            if (found) break;
        }
        return found;
    }

    public static boolean isLanguageInvalid(Node node, String languageCode) throws RepositoryException {
        boolean invalid = false;
        if (node.hasProperty("j:invalidLanguages")) {
            Value[] values;
            for (Value value : values = node.getProperty("j:invalidLanguages").getValues()) {
                if (!value.getString().equals(languageCode)) continue;
                invalid = true;
                break;
            }
        }
        return invalid;
    }

    public static boolean isLockedAndCannotBeEdited(JCRNodeWrapper node) throws RepositoryException {
        boolean isLocked;
        block4: {
            if (node == null) {
                return false;
            }
            String username = node.getSession().getUser().getName();
            String lockOwner = node.getLockOwner();
            isLocked = node.isLocked() && (lockOwner == null || !lockOwner.equals(username));
            try {
                JCRValueWrapper[] values;
                if (isLocked || !node.hasProperty("j:lockTypes")) break block4;
                for (JCRValueWrapper value : values = node.getProperty("j:lockTypes").getValues()) {
                    if (value.getString().startsWith(username)) continue;
                    isLocked = true;
                    break;
                }
            }
            catch (PathNotFoundException e) {
                logger.debug("concurrency issue lock is not present anymore");
            }
        }
        return isLocked;
    }

    public static boolean isNodeType(JCRNodeWrapper node, Iterable<String> types) throws RepositoryException {
        if (node == null || types == null) {
            return false;
        }
        boolean matches = false;
        for (String matchType : types) {
            if (!node.isNodeType(matchType)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public static boolean isNodeType(JCRNodeWrapper node, String ... types) throws RepositoryException {
        if (node == null || types == null) {
            return false;
        }
        boolean matches = false;
        for (String matchType : types) {
            if (!node.isNodeType(matchType)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public static boolean isNodeType(JCRNodeWrapper node, String type) throws RepositoryException {
        if (node == null || StringUtils.isEmpty((String)type)) {
            return false;
        }
        boolean matches = false;
        if (type.contains(",")) {
            String[] types;
            for (String matchType : types = Patterns.COMMA.split(type)) {
                if (!node.isNodeType(matchType)) continue;
                matches = true;
                break;
            }
        } else {
            matches = node.isNodeType(type);
        }
        return matches;
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public static boolean isNotJcrUuid(String uuid) {
        return StringUtils.isEmpty((String)uuid) || uuid.contains("/");
    }

    public static boolean isValidFilename(String name) {
        return !name.startsWith(" ") && !name.endsWith(" ") && name.matches("([^\\*:/\\\\<>|?\"])*");
    }

    public static final boolean isValidWorkspace(String workspace) {
        return JCRContentUtils.isValidWorkspace(workspace, false);
    }

    public static final boolean isValidWorkspace(String workspace, boolean allowBlank) {
        return StringUtils.isEmpty((String)workspace) ? allowBlank : "default".equals(workspace) || "live".equals(workspace);
    }

    public static void registerNamespace(Session session, String prefix, String uri) throws RepositoryException {
        NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        ImmutableSet prefixes = ImmutableSet.copyOf((Object[])namespaceRegistry.getPrefixes());
        if (!prefixes.contains(prefix)) {
            namespaceRegistry.registerNamespace(prefix, uri);
            session.setNamespacePrefix(prefix, uri);
        }
    }

    public static String replaceColon(String name) {
        return name != null ? StringUtils.replace((String)name, (String)":", (String)"_") : name;
    }

    @Deprecated(since="8.2.0.0", forRemoval=true)
    public static long size(RangeIterator iterator) {
        long size = iterator.getSize();
        if (size <= 0L) {
            logger.debug("The size of the iterator is not known, it will be consumed to calculate the size");
            size = 0L;
            while (iterator.hasNext()) {
                ++size;
                iterator.next();
            }
        }
        return size;
    }

    public static String[] splitJCRPath(String path) {
        ArrayList<String> result = new ArrayList<String>();
        int pathPos = 0;
        if (path.startsWith("/")) {
            ++pathPos;
        }
        int nextSlashPos = -1;
        do {
            StringBuilder currentName = new StringBuilder();
            if (path.indexOf(123, pathPos) == pathPos) {
                int endingBracketPos = path.indexOf(125, pathPos + 1);
                currentName.append(path.substring(pathPos, endingBracketPos + 1));
                pathPos = endingBracketPos + 1;
            }
            if ((nextSlashPos = path.indexOf(47, pathPos)) > -1) {
                currentName.append(path.substring(pathPos, nextSlashPos));
                pathPos = nextSlashPos + 1;
            } else {
                currentName.append(path.substring(pathPos));
            }
            result.add(currentName.toString());
        } while (nextSlashPos > -1);
        return result.toArray(new String[result.size()]);
    }

    public static String stringToJCRPathExp(String str) {
        return ISO9075.encodePath((String)str);
    }

    public static String stringToJCRSearchExp(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Must pass a valid String");
        }
        int length = (str = str.trim()).length();
        if (length == 0) {
            return "''";
        }
        int nextDoubleQuote = str.indexOf(34);
        if (nextDoubleQuote < 0) {
            return JCRContentUtils.stringToQueryLiteral(str);
        }
        StringBuilder stringBuilder = new StringBuilder(length + 10);
        stringBuilder.append(str.substring(0, nextDoubleQuote));
        char previousChar = '\u0000';
        boolean hasStartingDoubleQuote = false;
        for (int i = nextDoubleQuote; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                if (!hasStartingDoubleQuote) {
                    nextDoubleQuote = str.indexOf(34, i + 1);
                    if (nextDoubleQuote < 0) {
                        if (previousChar != '\\') {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(str.substring(i, length));
                        break;
                    }
                    hasStartingDoubleQuote = true;
                } else {
                    hasStartingDoubleQuote = false;
                }
            }
            stringBuilder.append(c);
            previousChar = c;
        }
        return JCRContentUtils.stringToQueryLiteral(stringBuilder.toString());
    }

    public static String stringToQueryLiteral(String str) {
        return "'" + Patterns.SINGLE_QUOTE.matcher(str).replaceAll("''") + "'";
    }

    public static String unescapeLocalNodeName(String encodedLocalName) {
        return encodedLocalName != null && encodedLocalName.indexOf(37) != -1 ? Text.unescapeIllegalJcrChars((String)encodedLocalName) : encodedLocalName;
    }

    public String generateNodeName(JCRNodeWrapper parent, String nodeType) {
        return this.getNameGenerationHelper().generatNodeName(parent, nodeType);
    }

    public String generateNodeName(JCRNodeWrapper parent, String defaultLanguage, ExtendedNodeType nodeType, String targetName) {
        return this.getNameGenerationHelper().generatNodeName(parent, defaultLanguage, nodeType, targetName);
    }

    public Map<String, String> getFileExtensionIcons() {
        return this.fileExtensionIcons;
    }

    public Map<String, List<String>> getMimeTypes() {
        return this.mimeTypes;
    }

    public NameGenerationHelper getNameGenerationHelper() {
        return this.nameGenerationHelper;
    }

    public Set<String> getUnsupportedMarkForDeletionNodeTypes() {
        return this.unsupportedMarkForDeletionNodeTypes;
    }

    public void setNameGenerationHelper(NameGenerationHelper nameGenerationHelper) {
        this.nameGenerationHelper = nameGenerationHelper;
    }

    public void setUnsupportedMarkForDeletionNodeTypes(Set<String> unsupportedMarkForDeletionNodeTypes) {
        this.unsupportedMarkForDeletionNodeTypes = unsupportedMarkForDeletionNodeTypes;
    }

    public Pattern getHandleFallbackLocaleForPathPattern() {
        return this.handleFallbackLocaleForPath;
    }

    public void setHandleFallbackLocaleForPath(String handleFallbackLocaleForPath) {
        this.handleFallbackLocaleForPath = StringUtils.isNotEmpty((String)handleFallbackLocaleForPath) ? Pattern.compile(handleFallbackLocaleForPath) : null;
    }

    public static List<Map<String, Object>> getRolesForNode(JCRNodeWrapper node, boolean includeInherited, boolean expandGroups, String roles, int limit, boolean latestFirst) {
        LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
        Map<String, List<String[]>> entries = node.getAclEntries();
        if (latestFirst) {
            entries = JCRContentUtils.reverse(entries);
        }
        String siteKey = null;
        List<String> rolesList = Arrays.asList(StringUtils.splitByWholeSeparator((String)roles, null));
        JahiaUserManagerService userService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        JahiaGroupManagerService groupService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        for (Map.Entry<String, List<String[]>> entry : entries.entrySet()) {
            Object name;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String entryKey = entry.getKey();
            if (siteKey == null) {
                try {
                    JCRSiteNode resolveSite = node.getResolveSite();
                    siteKey = resolveSite != null ? resolveSite.getSiteKey() : null;
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (entryKey.startsWith("u:")) {
                name = StringUtils.substringAfter((String)entryKey, (String)"u:");
                JCRUserNode u = userService.lookupUser((String)name, siteKey);
                if (u == null) {
                    logger.warn("User {} cannot be found. Skipping.", name);
                    continue;
                }
                hashMap.put("principalType", "user");
                hashMap.put("principal", u);
            } else if (entryKey.startsWith("g:")) {
                name = StringUtils.substringAfter((String)entryKey, (String)"g:");
                JCRGroupNode g = groupService.lookupGroup(siteKey, (String)name);
                if (g == null) {
                    g = groupService.lookupGroup(null, (String)name);
                }
                if (g == null) {
                    logger.warn("Group {} cannot be found. Skipping.", name);
                    continue;
                }
                hashMap.put("principalType", "group");
                hashMap.put("principal", g);
            }
            for (String[] details : entry.getValue()) {
                if (!details[1].equals("GRANT") || !rolesList.isEmpty() && !rolesList.contains(details[2]) || !includeInherited && !details[0].equals(node.getPath())) continue;
                if (!hashMap.containsKey("roles")) {
                    hashMap.put("roles", new LinkedList());
                    results.add(hashMap);
                }
                ((List)hashMap.get("roles")).add(details[2]);
            }
            if (limit <= 0 || results.size() < limit) continue;
            break;
        }
        if (expandGroups) {
            LinkedList<Map> expandedResults = new LinkedList<Map>();
            for (Map map : results) {
                if (map.get("principalType").equals("group")) {
                    JCRGroupNode g = (JCRGroupNode)map.get("principal");
                    Set<JCRUserNode> principals = g.getRecursiveUserMembers();
                    for (JCRUserNode user : principals) {
                        HashMap<String, Object> m = new HashMap<String, Object>(map);
                        m.put("principalType", "user");
                        m.put("principal", user);
                        expandedResults.add(m);
                    }
                    continue;
                }
                expandedResults.add(map);
            }
            results = expandedResults;
        }
        return results;
    }

    public static <T> Map<String, T> reverse(Map<String, T> orderedMap) {
        if (orderedMap == null || orderedMap.isEmpty()) {
            return orderedMap;
        }
        LinkedHashMap<String, T> reversed = new LinkedHashMap<String, T>(orderedMap.size());
        ListIterator<String> li = new LinkedList<String>(orderedMap.keySet()).listIterator(orderedMap.size());
        while (li.hasPrevious()) {
            String key = li.previous();
            reversed.put(key, orderedMap.get(key));
        }
        return reversed;
    }

    public static String sqlEncode(String s) {
        return s != null && s.indexOf(39) != -1 ? Patterns.SINGLE_QUOTE.matcher(s).replaceAll("''") : s;
    }

    public static JCRNodeWrapper getParentWithAclInheritanceBroken(JCRNodeWrapper node) throws RepositoryException {
        JCRNodeWrapper found = null;
        JCRNodeWrapper parent = node;
        try {
            while (!(parent = parent.getParent()).getAclInheritanceBreak()) {
            }
            found = parent;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return found;
    }

    public static String getMimeType(String fileName) {
        return fileName != null ? JCRContentUtils.getInstance().servletContext.getMimeType(fileName.toLowerCase()) : null;
    }

    public static String getMimeType(String fileName, String fallbackMimeType) {
        return StringUtils.defaultIfEmpty((String)JCRContentUtils.getMimeType(fileName), (String)fallbackMimeType);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public JCRNodeWrapper getUserPrivateFilesFolder(JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper privateFilesFolder = this.getDefaultUserFolder(session, "/files/private", false);
        if (privateFilesFolder.isNew()) {
            privateFilesFolder.grantRoles("u:" + session.getUser().getName(), Collections.singleton("owner"));
            privateFilesFolder.setAclInheritanceBreak(true);
            session.save();
        }
        return privateFilesFolder;
    }

    public JCRNodeWrapper getDefaultUserFolder(JCRSessionWrapper session, String path) throws RepositoryException {
        return this.getDefaultUserFolder(session, path, true);
    }

    public JCRNodeWrapper getDefaultUserFolder(JCRSessionWrapper session, String path, boolean saveIfCreate) throws RepositoryException {
        String primaryNodeTypeName;
        if (StringUtils.isEmpty((String)path)) {
            return session.getUserNode();
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if ((primaryNodeTypeName = this.defaultUserFolderTypes.get(path)) == null) {
            throw new IllegalArgumentException("Unknown default user folder: " + (String)path + ". Known default user folders are: " + this.defaultUserFolderTypes);
        }
        String userPath = session.getUserNode().getPath();
        if (!session.itemExists(userPath + (String)path)) {
            String name = StringUtils.substringAfterLast((String)path, (String)"/");
            JCRNodeWrapper parentUserFolder = this.getDefaultUserFolder(session, StringUtils.substringBeforeLast((String)path, (String)"/"), false);
            JCRNodeWrapper userFolder = parentUserFolder.addNode(name, primaryNodeTypeName);
            if (saveIfCreate) {
                session.save();
            }
            return userFolder;
        }
        return session.getNode(userPath + (String)path);
    }

    public static boolean isUserMemberOfGroup(String siteKey, String groupName, String userName, String userRealm, boolean isRoot) {
        return "guest".equals(groupName) || "users".equals(groupName) || "site-users".equals(groupName) && (userRealm == null || userRealm.equals(siteKey)) || isRoot && JahiaGroupManagerService.POWERFUL_GROUPS.contains(groupName) || JahiaGroupManagerService.getInstance().isMember(userName, userRealm, groupName, siteKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean needVersion(JCRNodeWrapper node, Set<String> versionedTypes, Set<String> excludedVersionedTypes) throws RepositoryException {
        boolean isVersionedType = Streams.stream(versionedTypes.stream()).anyMatch(arg_0 -> ((JCRNodeWrapper)node).isNodeType(arg_0));
        if (isVersionedType) {
            if (Streams.stream(excludedVersionedTypes.stream()).anyMatch(arg_0 -> ((JCRNodeWrapper)node).isNodeType(arg_0))) return false;
            return true;
        }
        if (!node.isNodeType("mix:versionable")) {
            if (!node.isNodeType("mix:simpleVersionable")) return false;
        }
        JCRNodeWrapper parent = node.getParent();
        if (!Streams.stream(versionedTypes.stream()).anyMatch(arg_0 -> ((JCRNodeWrapper)parent).isNodeType(arg_0))) return false;
        if (Streams.stream(excludedVersionedTypes.stream()).anyMatch(arg_0 -> ((JCRNodeWrapper)node).isNodeType(arg_0))) return false;
        return true;
    }

    public static Set<String> splitAndUnify(String input, String separator) {
        String[] tokens = StringUtils.split((String)input, (String)separator);
        if (tokens == null || tokens.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(Arrays.asList(tokens));
        return result;
    }
}

