/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.RangeIteratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionIteratorWrapper
extends RangeIteratorImpl
implements VersionIterator {
    private static final Logger logger = LoggerFactory.getLogger(VersionIteratorWrapper.class);
    private VersionIterator ni;
    private JCRNodeWrapper nextNode = null;
    private JCRSessionWrapper session;
    private JCRStoreProvider provider;

    public VersionIteratorWrapper(VersionIterator ni, JCRSessionWrapper session, JCRStoreProvider provider) {
        super((Iterator<?>)ni, ni.getSize());
        this.ni = ni;
        this.session = session;
        this.provider = provider;
        this.prefetchNext();
    }

    private void prefetchNext() {
        block4: while (true) {
            try {
                while (true) {
                    Version n = null;
                    while (this.ni.hasNext() && n == null) {
                        n = this.ni.nextVersion();
                    }
                    if (n == null) break;
                    try {
                        this.nextNode = this.provider.getNodeWrapper((Node)n, this.session);
                        break block4;
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        continue;
                    }
                    break;
                }
                this.nextNode = null;
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void skip(long skipNum) {
        int i = 0;
        while ((long)i < skipNum) {
            this.prefetchNext();
            ++i;
        }
        if (this.nextNode == null) {
            throw new NoSuchElementException();
        }
    }

    public long getSize() {
        return this.ni.getSize();
    }

    public long getPosition() {
        return this.ni.getPosition() - (long)(this.nextNode != null ? 1 : 0);
    }

    public Node nextNode() {
        return (Node)this.next();
    }

    public Version nextVersion() {
        return (Version)this.next();
    }

    public boolean hasNext() {
        return this.nextNode != null;
    }

    public Object next() {
        return this.wrappedNext();
    }

    private JCRNodeWrapper wrappedNext() {
        JCRNodeWrapper res = this.nextNode;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.prefetchNext();
        return res;
    }

    public void remove() {
        this.ni.remove();
    }
}

