/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFileNode
extends JCRNodeDecorator {
    protected static final Logger logger = LoggerFactory.getLogger(JCRFileNode.class);

    public JCRFileNode(JCRNodeWrapper node) throws RepositoryException {
        super(node);
    }

    @Override
    public String getDisplayableName() {
        try {
            if (this.isNodeType("nt:folder")) {
                return super.getDisplayableName();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String title = null;
        String name = null;
        try {
            title = this.getProperty("jcr:title").getValue().getString();
        }
        catch (RepositoryException e) {
            logger.debug("could not retrieve jcr:title of " + this.getPath());
        }
        name = this.getUnescapedName();
        return title != null ? name + " (" + title + ")" : name;
    }
}

