/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;
import org.jahia.api.Constants;
import org.jahia.services.content.JCRItemWrapper;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPropertyWrapperImpl;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.LazyPropertyIterator;
import org.jahia.services.content.NodeIteratorImpl;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFrozenNodeAsRegular
extends JCRNodeWrapperImpl {
    private static Logger logger = LoggerFactory.getLogger(JCRFrozenNodeAsRegular.class);
    private Date versionDate = null;
    private String versionLabel = null;

    public JCRFrozenNodeAsRegular(Node objectNode, String path, JCRNodeWrapper parent, JCRSessionWrapper session, JCRStoreProvider provider, Date versionDate, String versionLabel) throws RepositoryException {
        super(objectNode, path, parent, session, provider);
        this.versionDate = versionDate;
        this.versionLabel = versionLabel;
        if (path == null) {
            this.localPathInProvider = this.localPath = this.internalGetPath();
        }
    }

    public String internalGetPath() {
        try {
            Property property = this.objectNode.getProperty("j:fullpath");
            return property.getString();
        }
        catch (RepositoryException e) {
            Object currentPath = this.getName();
            try {
                JCRNodeWrapper currentParent = this.getParent();
                while (currentParent != null) {
                    currentPath = currentParent.getName() + "/" + (String)currentPath;
                    try {
                        currentParent = currentParent.getParent();
                    }
                    catch (ItemNotFoundException infe) {
                        currentParent = null;
                    }
                }
                if (currentPath != null && !((String)currentPath).startsWith("/")) {
                    currentPath = "/" + (String)currentPath;
                }
            }
            catch (RepositoryException ex) {
                logger.error(e.getMessage(), (Throwable)ex);
            }
            return currentPath;
        }
    }

    private List<JCRNodeWrapper> internalGetChildren() throws RepositoryException {
        JCRNodeIteratorWrapper ni1 = super.getNodes();
        String path = this.getPath();
        ArrayList<JCRNodeWrapper> childEntries = new ArrayList<JCRNodeWrapper>();
        while (ni1.hasNext()) {
            JCRNodeWrapper child = (JCRNodeWrapper)ni1.next();
            try {
                if (child.isNodeType("nt:versionedChild")) {
                    VersionHistory vh = (VersionHistory)this.getSession().getProviderSession(this.provider).getNodeByIdentifier(child.getProperty("jcr:childVersionHistory").getValue().getString());
                    Version closestVersion = null;
                    if (this.versionLabel != null) {
                        closestVersion = JCRVersionService.findVersionByLabel(vh, this.versionLabel);
                    }
                    if (closestVersion == null && this.versionDate != null) {
                        closestVersion = JCRVersionService.findClosestVersion(vh, this.versionDate);
                    }
                    if (closestVersion == null) continue;
                    try {
                        childEntries.add(this.provider.getNodeWrapper(closestVersion.getFrozenNode(), path + "/" + child.getName(), this, this.session));
                    }
                    catch (PathNotFoundException pathNotFoundException) {}
                    continue;
                }
                childEntries.add(child);
            }
            catch (ItemNotFoundException e) {
                logger.debug("Item was not found in this workspace", (Throwable)e);
            }
        }
        return childEntries;
    }

    private JCRNodeWrapper superGetNode(String relPath) throws RepositoryException {
        return super.getNode(relPath);
    }

    @Override
    public JCRNodeWrapper getNode(String relPath) throws PathNotFoundException, RepositoryException {
        if (relPath.startsWith("/")) {
            throw new IllegalArgumentException("relPath in not a relative path " + relPath);
        }
        StringTokenizer st = new StringTokenizer(relPath, "/");
        JCRNodeWrapper current = this;
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            if (next.equals("..")) {
                current = current.getParent();
                continue;
            }
            if (next.equals(".")) continue;
            JCRNodeWrapper child = null;
            child = current instanceof JCRFrozenNodeAsRegular ? ((JCRFrozenNodeAsRegular)current).superGetNode(next) : current.getNode(next);
            if (child.isNodeType("nt:versionedChild")) {
                VersionHistory vh = (VersionHistory)this.getSession().getProviderSession(this.provider).getNodeByIdentifier(child.getProperty("jcr:childVersionHistory").getValue().getString());
                Version closestVersion = null;
                if (this.versionLabel != null) {
                    closestVersion = JCRVersionService.findVersionByLabel(vh, this.versionLabel);
                }
                if (closestVersion == null && this.versionDate != null) {
                    closestVersion = JCRVersionService.findClosestVersion(vh, this.versionDate);
                }
                if (closestVersion != null) {
                    current = this.provider.getNodeWrapper(closestVersion.getFrozenNode(), this.session);
                    continue;
                }
                throw new ItemNotFoundException(relPath);
            }
            current = child;
        }
        return current;
    }

    @Override
    public JCRNodeIteratorWrapper getNodes() throws RepositoryException {
        List<JCRNodeWrapper> childEntries = this.internalGetChildren();
        return new NodeIteratorImpl(childEntries.iterator(), (long)childEntries.size());
    }

    @Override
    public JCRNodeIteratorWrapper getNodes(String[] nameGlobs) throws RepositoryException {
        List<JCRNodeWrapper> childEntries = this.internalGetChildren();
        LinkedList<JCRNodeWrapper> childs = new LinkedList<JCRNodeWrapper>();
        block0: for (JCRNodeWrapper childEntry : childEntries) {
            for (String nameGlob : nameGlobs) {
                if (!ChildrenCollectorFilter.matches((String)childEntry.getName(), (String)nameGlob)) continue;
                childs.add(childEntry);
                continue block0;
            }
        }
        return new NodeIteratorImpl(childs.iterator(), (long)childs.size());
    }

    @Override
    public JCRNodeIteratorWrapper getNodes(String namePattern) throws RepositoryException {
        List<JCRNodeWrapper> childEntries = this.internalGetChildren();
        LinkedList<JCRNodeWrapper> childs = new LinkedList<JCRNodeWrapper>();
        for (JCRNodeWrapper childEntry : childEntries) {
            if (!ChildrenCollectorFilter.matches((String)childEntry.getName(), (String)namePattern)) continue;
            childs.add(childEntry);
        }
        return new NodeIteratorImpl(childs.iterator(), (long)childs.size());
    }

    @Override
    public String getPrimaryNodeTypeName() throws RepositoryException {
        return this.objectNode.getProperty("jcr:frozenPrimaryType").getString();
    }

    private JCRNodeWrapper findRegularParentNode() throws RepositoryException {
        String frozenUUID = this.objectNode.getProperty("jcr:frozenUuid").getString();
        JCRNodeWrapper regularNode = this.getSession().getNodeByUUID(frozenUUID, false);
        if (regularNode != null) {
            return regularNode.getParent();
        }
        return null;
    }

    private JCRNodeWrapper findClosestParentVersionedChildNode(Version version) throws RepositoryException {
        QueryWrapper childQuery = this.getSession().getWorkspace().getQueryManager().createQuery("select * from [nt:versionedChild] where [jcr:childVersionHistory] = '" + version.getContainingHistory().getIdentifier() + "'", "JCR-SQL2");
        QueryResult childQueryResult = childQuery.execute();
        NodeIterator childIterator = childQueryResult.getNodes();
        long shortestLapse = Long.MAX_VALUE;
        JCRNodeWrapper closestVersionedChildNode = null;
        while (childIterator.hasNext()) {
            JCRNodeWrapper currentFrozenNodeParent;
            JCRNodeWrapper childNode = (JCRNodeWrapper)childIterator.nextNode();
            JCRNodeWrapper parentFrozenNode = childNode.getParent();
            if (parentFrozenNode.getParent().isNodeType("nt:version")) {
                Version parentVersion = (Version)parentFrozenNode.getParent();
                long currentLapse = this.versionDate.getTime() - parentVersion.getCreated().getTime().getTime();
                if (currentLapse < 0L || currentLapse >= shortestLapse) continue;
                shortestLapse = currentLapse;
                closestVersionedChildNode = childNode;
                continue;
            }
            if (!parentFrozenNode.getParent().isNodeType("nt:frozenNode")) continue;
            for (currentFrozenNodeParent = parentFrozenNode.getParent(); currentFrozenNodeParent != null && currentFrozenNodeParent.isNodeType("nt:frozenNode"); currentFrozenNodeParent = currentFrozenNodeParent.getParent()) {
            }
            if (currentFrozenNodeParent.isNodeType("nt:version")) {
                Version parentVersion = (Version)currentFrozenNodeParent.getParent();
                long currentLapse = this.versionDate.getTime() - parentVersion.getCreated().getTime().getTime();
                if (currentLapse < 0L || currentLapse >= shortestLapse) continue;
                shortestLapse = currentLapse;
                closestVersionedChildNode = childNode;
                continue;
            }
            logger.error("Integrity error, found frozen node with a parent that is not a frozen node nor a version node ! Ignoring it !");
        }
        return closestVersionedChildNode;
    }

    @Override
    public String getName() {
        if ((this.localPath.equals("/") || this.localPath.equals(this.provider.getRelativeRoot())) && this.provider.getMountPoint().length() > 1) {
            String mp = this.provider.getMountPoint();
            return mp.substring(mp.lastIndexOf(47) + 1);
        }
        return StringUtils.substringAfterLast((String)this.localPath, (String)"/");
    }

    @Override
    public ExtendedNodeType getPrimaryNodeType() throws RepositoryException {
        String frozenPrimaryNodeType = this.objectNode.getProperty("jcr:frozenPrimaryType").getString();
        return NodeTypeRegistry.getInstance().getNodeType(frozenPrimaryNodeType);
    }

    @Override
    public PropertyIterator getProperties() throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        if (locale != null) {
            return new LazyPropertyIterator(this, locale);
        }
        return new LazyPropertyIterator(this);
    }

    @Override
    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        Locale locale = this.getSession().getLocale();
        if (locale != null) {
            return new LazyPropertyIterator((JCRNodeWrapper)this, locale, namePattern);
        }
        return new LazyPropertyIterator((JCRNodeWrapper)this, null, namePattern);
    }

    @Override
    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        return super.getProperties(nameGlobs);
    }

    @Override
    public JCRPropertyWrapper getProperty(String name) throws PathNotFoundException, RepositoryException {
        Locale locale = this.getSession().getLocale();
        ExtendedPropertyDefinition epd = this.getApplicablePropertyDefinition(name);
        if (locale != null && epd != null && epd.isInternationalized()) {
            try {
                Node localizedNode = this.getI18N(locale);
                return new JCRPropertyWrapperImpl(this, localizedNode.getProperty(name), this.getSession(), this.getProvider(), epd, name);
            }
            catch (ItemNotFoundException e) {
                return super.getProperty(name);
            }
        }
        return super.getProperty(name);
    }

    @Override
    public boolean isNodeType(String path) throws RepositoryException {
        ExtendedNodeType[] mixins;
        boolean result = false;
        ExtendedNodeType primaryNodeType = this.getPrimaryNodeType();
        result = primaryNodeType.isNodeType(path);
        if (result) {
            return result;
        }
        for (ExtendedNodeType mixin : mixins = this.getMixinNodeTypes()) {
            result = mixin.isNodeType(path);
            if (!result) continue;
            return result;
        }
        return result;
    }

    @Override
    public JCRItemWrapper getAncestor(int i) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        JCRNodeWrapper ancestor = null;
        Property property = this.objectNode.getProperty("j:fullpath");
        if (property != null) {
            StringBuilder builder = new StringBuilder("/");
            int counter = 0;
            for (String pathElement : Patterns.SLASH.split(property.getString())) {
                builder.append(pathElement);
                if (counter++ == i) break;
                if (builder.length() <= 1) continue;
                builder.append("/");
            }
            if (counter < i) {
                throw new ItemNotFoundException();
            }
            try {
                ancestor = this.getSession().getNode(builder.toString());
            }
            catch (PathNotFoundException nfe) {
                throw new ItemNotFoundException("Ancestor not found", (Throwable)nfe);
            }
        }
        return ancestor;
    }

    @Override
    public List<JCRItemWrapper> getAncestors() throws RepositoryException {
        ArrayList<JCRItemWrapper> ancestors = new ArrayList<JCRItemWrapper>();
        Property property = this.objectNode.getProperty("j:fullpath");
        if (property != null) {
            StringBuilder builder = new StringBuilder("/");
            for (String pathElement : Patterns.SLASH.split(property.getString())) {
                builder.append(pathElement);
                try {
                    ancestors.add(this.getSession().getNode(builder.toString()));
                }
                catch (PathNotFoundException pathNotFoundException) {
                }
                catch (AccessDeniedException ade) {
                    return ancestors;
                }
                if (builder.length() <= 1) continue;
                builder.append("/");
            }
        }
        return ancestors;
    }

    @Override
    public ExtendedNodeType[] getMixinNodeTypes() throws RepositoryException {
        if (this.objectNode.hasProperty("jcr:frozenMixinTypes")) {
            Value[] values;
            ArrayList<ExtendedNodeType> mixin = new ArrayList<ExtendedNodeType>();
            Property property = this.objectNode.getProperty("jcr:frozenMixinTypes");
            for (Value value : values = property.getValues()) {
                String curMixinTypeName = value.getString();
                mixin.add(NodeTypeRegistry.getInstance().getNodeType(curMixinTypeName));
            }
            return mixin.toArray(new ExtendedNodeType[mixin.size()]);
        }
        return new ExtendedNodeType[0];
    }

    @Override
    public Node getI18N(Locale locale, boolean fallback) throws RepositoryException {
        Node node1 = super.getI18N(locale, fallback);
        if (node1.hasProperty("jcr:childVersionHistory")) {
            VersionHistory versionHistory = (VersionHistory)this.getSession().getProviderSession(this.provider).getNodeByIdentifier(node1.getProperty("jcr:childVersionHistory").getValue().getString());
            Version v = null;
            if (this.versionLabel != null) {
                v = JCRVersionService.findVersionByLabel(versionHistory, this.versionLabel);
            }
            if (v == null && this.versionDate != null) {
                v = JCRVersionService.findClosestVersion(versionHistory, this.versionDate);
            }
            if (v == null) {
                return null;
            }
            node1 = v.getNode("jcr:frozenNode");
        } else if (node1.hasProperty("jcr:versionHistory")) {
            VersionHistory versionHistory = (VersionHistory)this.getSession().getProviderSession(this.provider).getNodeByIdentifier(node1.getProperty("jcr:versionHistory").getValue().getString());
            Version v = null;
            if (this.versionLabel != null) {
                v = JCRVersionService.findVersionByLabel(versionHistory, this.versionLabel);
            }
            if (v == null && this.versionDate != null) {
                v = JCRVersionService.findClosestVersion(versionHistory, this.versionDate);
            }
            if (v == null) {
                return null;
            }
            node1 = v.getNode("jcr:frozenNode");
        }
        return node1;
    }

    @Override
    public String getUrl() {
        String url = super.getUrl() + "?v=" + this.versionDate.getTime();
        if (this.versionLabel != null) {
            url = url + "&l=" + this.versionLabel;
        }
        return url;
    }

    public void setVersionDate(Date versionDate) {
        this.versionDate = versionDate;
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    @Override
    public boolean copy(String dest) throws RepositoryException {
        return this.copy(dest, this.getName());
    }

    @Override
    public boolean copy(String dest, String name) throws RepositoryException {
        JCRNodeWrapper node = (JCRNodeWrapper)this.getSession().getItem(dest);
        this.copy(node, name, true);
        return true;
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes) throws RepositoryException {
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        boolean copy = this.copy(dest, name, allowsExternalSharedNodes, references);
        ReferencesHelper.resolveCrossReferences(this.getSession(), references);
        return copy;
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, List<String> ignoreNodeTypes, int maxBatch) throws RepositoryException {
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        boolean copy = this.copy(dest, name, allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, new MutableInt(0));
        ReferencesHelper.resolveCrossReferences(this.getSession(), references);
        return copy;
    }

    @Override
    public boolean copy(JCRNodeWrapper dest, String name, boolean allowsExternalSharedNodes, Map<String, List<String>> references, List<String> ignoreNodeTypes, int maxBatch, MutableInt batchCount) throws RepositoryException {
        JCRNodeWrapper copy = null;
        try {
            copy = (JCRNodeWrapper)this.getSession().getItem(dest.getPath() + "/" + name);
            if (!copy.isCheckedOut()) {
                this.getSession().checkout(copy);
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        if (ignoreNodeTypes != null) {
            for (String nodeType : ignoreNodeTypes) {
                if (!this.isNodeType(nodeType)) continue;
                return false;
            }
        }
        batchCount.increment();
        if (maxBatch > 0 && batchCount.intValue() > maxBatch) {
            try {
                this.session.save();
                batchCount.setValue(0);
            }
            catch (ConstraintViolationException e) {
                batchCount.setValue(maxBatch - 1);
            }
        }
        Map<String, String> uuidMapping = this.getSession().getUuidMapping();
        if (copy == null || copy.getDefinition().allowsSameNameSiblings()) {
            if (!dest.isCheckedOut() && dest.isVersioned()) {
                this.getSession().checkout(dest);
            }
            String typeName = this.getPrimaryNodeTypeName();
            copy = dest.addNode(name, typeName, this.getIdentifier(), this.objectNode.getProperty("jcr:created").getDate(), this.objectNode.getProperty("jcr:createdBy").getString(), this.objectNode.getProperty("jcr:lastModified").getDate(), this.objectNode.getProperty("jcr:lastModifiedBy").getString());
        }
        try {
            ExtendedNodeType[] mixin;
            for (ExtendedNodeType aMixin : mixin = this.getMixinNodeTypes()) {
                copy.addMixin(aMixin.getName());
            }
        }
        catch (RepositoryException e) {
            logger.error("Error adding mixin types to copy", (Throwable)e);
        }
        if (copy != null) {
            uuidMapping.put(this.getIdentifier(), copy.getIdentifier());
            if (this.hasProperty("jcr:language")) {
                copy.setProperty("jcr:language", this.objectNode.getProperty("jcr:language").getString());
            }
            this.copyProperties(copy, references);
        }
        JCRNodeIteratorWrapper ni = this.getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper source = (JCRNodeWrapper)ni.next();
            if (source.isNodeType("mix:shareable")) {
                if (uuidMapping.containsKey(source.getIdentifier())) {
                    this.getSession().save();
                    copy.clone(this.getSession().getNodeByUUID(uuidMapping.get(source.getIdentifier())), source.getName());
                    continue;
                }
                if (allowsExternalSharedNodes) {
                    copy.clone(source, source.getName());
                    continue;
                }
                source.copy(copy, source.getName(), allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batchCount);
                continue;
            }
            source.copy(copy, source.getName(), allowsExternalSharedNodes, references, ignoreNodeTypes, maxBatch, batchCount);
        }
        return true;
    }

    @Override
    public void copyProperties(JCRNodeWrapper destinationNode, Map<String, List<String>> references) throws RepositoryException {
        PropertyIterator props = this.getProperties();
        while (props.hasNext()) {
            Property property = props.nextProperty();
            try {
                if (Constants.forbiddenPropertiesToCopy.contains(property.getName())) continue;
                if (property.getType() == 9 || property.getType() == 10) {
                    if (property.getDefinition().isMultiple() && property.isMultiple()) {
                        Value[] values;
                        for (Value value : values = property.getValues()) {
                            this.keepReference(destinationNode, references, property, value.getString());
                        }
                    } else {
                        this.keepReference(destinationNode, references, property, property.getValue().getString());
                    }
                }
                if (property.getDefinition().isMultiple() && property.isMultiple()) {
                    destinationNode.setProperty(property.getName(), property.getValues());
                    continue;
                }
                destinationNode.setProperty(property.getName(), property.getValue());
            }
            catch (Exception e) {
                logger.warn("Unable to copy property '" + property.getName() + "'. Skipping.", (Throwable)e);
            }
        }
    }

    private void keepReference(JCRNodeWrapper destinationNode, Map<String, List<String>> references, Property property, String value) throws RepositoryException {
        if (!references.containsKey(value)) {
            references.put(value, new ArrayList());
        }
        references.get(value).add(destinationNode.getIdentifier() + "/" + property.getName());
    }

    @Override
    public String getIdentifier() throws RepositoryException {
        return this.objectNode.getProperty("jcr:frozenUuid").getString();
    }

    @Override
    public ExtendedPropertyDefinition getApplicablePropertyDefinition(String propertyName) throws ConstraintViolationException, RepositoryException {
        ExtendedPropertyDefinition result = super.getApplicablePropertyDefinition(propertyName);
        if (result != null) {
            return result;
        }
        ExtendedNodeType type = NodeTypeRegistry.getInstance().getNodeType("nt:frozenNode");
        Map<String, ExtendedPropertyDefinition> definitionMap = type.getPropertyDefinitionsAsMap();
        if (definitionMap.containsKey(propertyName)) {
            return definitionMap.get(propertyName);
        }
        return null;
    }

    @Override
    public ExtendedNodeDefinition getApplicableChildNodeDefinition(String childName, String nodeType) throws ConstraintViolationException, RepositoryException {
        try {
            return super.getApplicableChildNodeDefinition(childName, nodeType);
        }
        catch (ConstraintViolationException e) {
            ExtendedNodeType type = NodeTypeRegistry.getInstance().getNodeType("nt:frozenNode");
            Map<String, ExtendedNodeDefinition> definitionMap = type.getChildNodeDefinitionsAsMap();
            if (definitionMap.containsKey(childName)) {
                return definitionMap.get(childName);
            }
            throw new ConstraintViolationException("Cannot find definition for " + childName + " on node " + this.getName() + " (" + this.getPrimaryNodeTypeName() + ")");
        }
    }
}

