/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRLayoutItemNode;
import org.jahia.services.content.decorator.JCRNodeDecorator;

public class JCRLayoutNode
extends JCRNodeDecorator {
    public JCRLayoutNode(JCRNodeWrapper node) {
        super(node);
    }

    public List<JCRLayoutItemNode> getLayoutItems() throws RepositoryException {
        ArrayList<JCRLayoutItemNode> nodes = new ArrayList<JCRLayoutItemNode>();
        JCRNodeIteratorWrapper iterator = this.getNodes();
        while (iterator.hasNext()) {
            nodes.add(new JCRLayoutItemNode((JCRNodeWrapper)iterator.nextNode()));
        }
        return nodes;
    }

    public boolean isLiveDraggable() throws RepositoryException {
        if (this.hasProperty("j:liveDraggable")) {
            return this.getProperty("j:liveDraggable").getBoolean();
        }
        return true;
    }

    public void setLiveDraggable(boolean liveDraggable) throws RepositoryException {
        this.setProperty("j:liveDraggable", liveDraggable);
    }

    public boolean isLiveEditable() throws RepositoryException {
        if (this.hasProperty("j:liveEditable")) {
            return this.getProperty("j:liveEditable").getBoolean();
        }
        return true;
    }

    public void setLiveEditable(boolean liveEditable) throws RepositoryException {
        this.setProperty("j:liveEditable", liveEditable);
    }

    public long getNbColumns() throws RepositoryException {
        if (this.hasProperty("j:nbColumns")) {
            return this.getProperty("j:nbColumns").getLong();
        }
        return 3L;
    }

    public void setNbColumns(long nbColumns) throws RepositoryException {
        this.setProperty("j:nbColumns", nbColumns);
    }

    public String getPage() throws RepositoryException {
        return this.getProperty("j:page").getString();
    }

    public void setPage(String page) throws RepositoryException {
        this.setProperty("j:page", page);
    }

    public JCRLayoutItemNode addLayoutItem(JCRNodeWrapper portletNode, int column, int row, String status) throws RepositoryException {
        JCRNodeWrapper jcrNodeWrapper = this.addNode("j:item", "jnt:layoutItem");
        JCRLayoutItemNode jcrLayoutItemNode = new JCRLayoutItemNode(jcrNodeWrapper);
        jcrLayoutItemNode.setColumnIndex(column);
        jcrLayoutItemNode.setRowIndex(row);
        jcrLayoutItemNode.setStatus(status);
        return jcrLayoutItemNode;
    }
}

