/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.jahia.bin.Jahia;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.interceptor.BaseInterceptor;
import org.jahia.services.content.interceptor.url.URLReplacer;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.HtmlTagAttributeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class URLInterceptor
extends BaseInterceptor
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(URLInterceptor.class);
    public static final String DOC_CONTEXT_PLACEHOLDER = "##doc-context##/";
    public static final String CMS_CONTEXT_PLACEHOLDER = "##cms-context##/";
    public static final Pattern DOC_CONTEXT_PLACEHOLDER_PATTERN = Pattern.compile("##doc-context##/", 16);
    public static final Pattern CMS_CONTEXT_PLACEHOLDER_PATTERN = Pattern.compile("##cms-context##/", 16);
    public static final String MISSING_IMAGE = "/missing-image.png";
    private String dmsContext;
    private String cmsContext;
    private Pattern cmsPattern;
    private Pattern cmsPatternWithContextPlaceholder;
    private Pattern refPattern;
    private List<URLReplacer> urlReplacers;
    private HtmlTagAttributeTraverser urlTraverser;

    private String escape(String s) {
        s = s.replace("{", "\\{");
        s = s.replace("}", "\\}");
        return s;
    }

    public URLInterceptor(HtmlTagAttributeTraverser urlTraverser) {
        this.urlTraverser = urlTraverser;
    }

    @Override
    public void beforeRemove(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (node.isNodeType("jmix:referencesInField")) {
            JCRNodeIteratorWrapper ni = node.getNodes("j:referenceInField*");
            if (definition.isInternationalized()) {
                name = (String)name + "_" + node.getSession().getLocale();
            }
            while (ni.hasNext()) {
                JCRNodeWrapper ref = (JCRNodeWrapper)ni.next();
                if (!((String)name).equals(ref.getProperty("j:fieldName").getString())) continue;
                ref.remove();
            }
        }
    }

    @Override
    public Value beforeSetValue(final JCRNodeWrapper node, String name, final ExtendedPropertyDefinition definition, Value originalValue) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        String result;
        JCRNodeWrapper nodeWithReferences;
        String content = originalValue.getString();
        JCRNodeWrapper jCRNodeWrapper = nodeWithReferences = node.isNodeType("jnt:translation") ? node.getParent() : node;
        if (definition.isInternationalized()) {
            Locale locale = node.getSession().getLocale();
            if (locale == null) {
                if (node.isNodeType("jnt:translation")) {
                    name = (String)name + "_" + node.getProperty("jcr:language").getString();
                }
            } else {
                name = (String)name + "_" + locale;
            }
        }
        final HashMap<String, Long> refs = new HashMap<String, Long>();
        if (logger.isDebugEnabled()) {
            logger.debug("Intercept setValue for " + node.getPath() + "/" + (String)name);
        }
        if (nodeWithReferences.isNodeType("jmix:referencesInField")) {
            JCRNodeIteratorWrapper ni = nodeWithReferences.getNodes("j:referenceInField*");
            while (ni.hasNext()) {
                JCRNodeWrapper ref = (JCRNodeWrapper)ni.next();
                if (!((String)name).equals(ref.getProperty("j:fieldName").getString()) || !ref.hasProperty("j:reference")) continue;
                refs.put(ref.getProperty("j:reference").getString(), Long.valueOf(StringUtils.substringAfterLast((String)ref.getName(), (String)"_")));
            }
        }
        final HashMap newRefs = new HashMap();
        try {
            result = this.urlTraverser.traverse(content, new HtmlTagAttributeTraverser.HtmlTagAttributeVisitor(){

                @Override
                public String visit(String value, RenderContext context, String tagName, String attrName, Resource resource) {
                    if (StringUtils.isNotEmpty((String)value)) {
                        try {
                            for (URLReplacer urlReplacer : URLInterceptor.this.urlReplacers) {
                                if (!urlReplacer.canHandle(tagName, attrName)) continue;
                                value = urlReplacer.replaceRefsByPlaceholders(value, newRefs, refs, node.getSession().getWorkspace().getName(), node.getSession().getLocale(), node, definition);
                                break;
                            }
                        }
                        catch (RepositoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return value;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RepositoryException) {
                throw (RepositoryException)e.getCause();
            }
            throw e;
        }
        HashSet<String> refsToRemove = new HashSet<String>(refs.size());
        if (!newRefs.equals(refs)) {
            if (!newRefs.isEmpty() && !nodeWithReferences.isNodeType("jmix:referencesInField")) {
                nodeWithReferences.addMixin("jmix:referencesInField");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("New references : " + newRefs);
            }
            JCRNodeIteratorWrapper ni = nodeWithReferences.getNodes("j:referenceInField*");
            while (ni.hasNext()) {
                JCRNodeWrapper ref = (JCRNodeWrapper)ni.next();
                if (!((String)name).equals(ref.getProperty("j:fieldName").getString()) || ref.hasProperty("j:reference") && newRefs.containsKey(ref.getProperty("j:reference").getString())) continue;
                refsToRemove.add(ref.getName());
            }
            for (Map.Entry entry : newRefs.entrySet()) {
                if (refs.containsKey(entry.getKey())) continue;
                JCRNodeWrapper ref = nodeWithReferences.addNode("j:referenceInField_" + Text.escapeIllegalJcrChars((String)name) + "_" + entry.getValue(), "jnt:referenceInField");
                ref.setProperty("j:fieldName", (String)name);
                ref.setProperty("j:reference", (String)entry.getKey());
            }
        }
        for (String refToRemove : refsToRemove) {
            nodeWithReferences.getNode(refToRemove).remove();
        }
        if (!result.equals(content)) {
            return node.getSession().getValueFactory().createValue(result);
        }
        return originalValue;
    }

    @Override
    public Value[] beforeSetValues(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value[] originalValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] res = new Value[originalValues.length];
        for (int i = 0; i < originalValues.length; ++i) {
            Value originalValue = originalValues[i];
            res[i] = this.beforeSetValue(node, name, definition, originalValue);
        }
        return res;
    }

    @Override
    public Value afterGetValue(final JCRPropertyWrapper property, Value storedValue) throws ValueFormatException, RepositoryException {
        String result;
        String content = storedValue.getString();
        if (content == null || !content.contains(DOC_CONTEXT_PLACEHOLDER) && !content.contains(CMS_CONTEXT_PLACEHOLDER)) {
            return storedValue;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Intercept getValue for " + property.getPath());
        }
        final HashMap<Long, String> refs = new HashMap<Long, String>();
        ExtendedPropertyDefinition definition = (ExtendedPropertyDefinition)property.getDefinition();
        Object name = definition.getName();
        JCRNodeWrapper parent = property.getParent();
        if (definition.isInternationalized()) {
            name = (String)name + "_" + property.getLocale();
        }
        if (parent.isNodeType("jnt:translation")) {
            parent = parent.getParent();
        }
        if (parent.isNodeType("jmix:referencesInField")) {
            JCRNodeIteratorWrapper ni = parent.getNodes("j:referenceInField*");
            while (ni.hasNext()) {
                JCRNodeWrapper ref = (JCRNodeWrapper)ni.next();
                if (!((String)name).equals(ref.getProperty("j:fieldName").getString()) || !ref.hasProperty("j:reference")) continue;
                try {
                    refs.put(Long.valueOf(StringUtils.substringAfterLast((String)ref.getName(), (String)"_")), ref.getProperty("j:reference").getString());
                }
                catch (PathNotFoundException e) {
                    logger.warn("Unable to get j:reference field on the node {}. Skipping reference.", (Object)ref.getPath());
                }
            }
        }
        try {
            result = this.urlTraverser.traverse(content, new HtmlTagAttributeTraverser.HtmlTagAttributeVisitor(){

                @Override
                public String visit(String value, RenderContext context, String tagName, String attrName, Resource resource) {
                    if (StringUtils.isNotEmpty((String)value)) {
                        try {
                            for (URLReplacer urlReplacer : URLInterceptor.this.urlReplacers) {
                                if (!urlReplacer.canHandle(tagName, attrName)) continue;
                                value = urlReplacer.replacePlaceholdersByRefs(value, refs, property.getSession().getWorkspace().getName(), property.getSession().getLocale(), property.getParent());
                                break;
                            }
                            if ("#".equals(value) && (tagName.toLowerCase().equals("img") || tagName.toLowerCase().equals("source"))) {
                                value = URLInterceptor.MISSING_IMAGE;
                            }
                        }
                        catch (RepositoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return value;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RepositoryException) {
                throw (RepositoryException)e.getCause();
            }
            throw e;
        }
        if (!result.equals(content)) {
            return property.getSession().getValueFactory().createValue(result);
        }
        return storedValue;
    }

    @Override
    public Value[] afterGetValues(JCRPropertyWrapper property, Value[] storedValues) throws ValueFormatException, RepositoryException {
        Value[] res = new Value[storedValues.length];
        for (int i = 0; i < storedValues.length; ++i) {
            Value storedValue = storedValues[i];
            res[i] = this.afterGetValue(property, storedValue);
        }
        return res;
    }

    public void afterPropertiesSet() throws Exception {
        this.dmsContext = Jahia.getContextPath() + "/files/";
        this.cmsContext = Jahia.getContextPath() + "/cms/";
        String pattern = "(((render|edit|live|contribute)/[a-zA-Z]+)|" + this.escape("{mode}") + ")/([a-zA-Z_]+|" + this.escape("{lang}") + ")/(.*)";
        this.refPattern = Pattern.compile("/##ref:link([0-9]+)##(.*)");
        this.cmsPattern = Pattern.compile(this.cmsContext + pattern);
        this.cmsPatternWithContextPlaceholder = Pattern.compile(this.escape(CMS_CONTEXT_PLACEHOLDER) + pattern);
    }

    public void setUrlReplacers(List<URLReplacer> urlReplacers) {
        this.urlReplacers = urlReplacers;
    }

    public String getDmsContext() {
        return this.dmsContext;
    }

    public String getCmsContext() {
        return this.cmsContext;
    }

    public Pattern getCmsPattern() {
        return this.cmsPattern;
    }

    public Pattern getCmsPatternWithContextPlaceholder() {
        return this.cmsPatternWithContextPlaceholder;
    }

    public Pattern getRefPattern() {
        return this.refPattern;
    }
}

