/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor.url;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.interceptor.url.BaseURLReplacer;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;

public class SrcSetURLReplacer
extends BaseURLReplacer {
    public static final String IMG = "img";
    public static final String IMG_SRCSET_ATTR = "srcset";

    @Override
    public boolean canHandle(String tagName, String attrName) {
        return StringUtils.equals((String)IMG, (String)tagName.toLowerCase()) && StringUtils.endsWith((String)attrName.toLowerCase(), (String)IMG_SRCSET_ATTR);
    }

    @Override
    public String replaceRefsByPlaceholders(String originalValue, Map<String, Long> newRefs, Map<String, Long> oldRefs, String workspace, Locale locale, JCRNodeWrapper node, ExtendedPropertyDefinition definition) throws RepositoryException {
        if (StringUtils.isNotEmpty((String)originalValue)) {
            String[] urls;
            for (String url : urls = SrcSetURLReplacer.getURLsFromSrcSet(originalValue)) {
                originalValue = StringUtils.replace((String)originalValue, (String)url, (String)super.replaceRefsByPlaceholders(url, newRefs, oldRefs, workspace, locale, node, definition));
            }
        }
        return originalValue;
    }

    @Override
    public String replacePlaceholdersByRefs(String originalValue, Map<Long, String> refs, String workspaceName, Locale locale, JCRNodeWrapper parent) throws RepositoryException {
        if (StringUtils.isNotEmpty((String)originalValue)) {
            String[] urls;
            String[] stringArray = urls = SrcSetURLReplacer.getURLsFromSrcSet(originalValue);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String url;
                String replacedUrl = super.replacePlaceholdersByRefs(url = stringArray[i], refs, workspaceName, locale, parent);
                originalValue = StringUtils.replace((String)originalValue, (String)url, (String)("#".equals(replacedUrl) ? "/missing-image.png" : replacedUrl));
            }
        }
        return originalValue;
    }

    public static String[] getURLsFromSrcSet(String srcSet) {
        return (String[])Arrays.stream(srcSet.split(",")).map(String::trim).map(entry -> StringUtils.substringBefore((String)entry, (String)" ")).toArray(String[]::new);
    }
}

