/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.jahia.services.content.nodetypes.DynamicValueImpl;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.Lexer;
import org.jahia.services.content.nodetypes.Name;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.SelectorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedPropertyDefinition
extends ExtendedItemDefinition
implements PropertyDefinition {
    private static Logger logger = LoggerFactory.getLogger(ExtendedPropertyDefinition.class);
    private NodeTypeRegistry registry;
    private int requiredType = 0;
    private boolean internationalized = false;
    private Value[] valueConstraints = new Value[0];
    private Value[] defaultValues = new Value[0];
    private boolean multiple;
    public static final int INDEXED_NO = 0;
    public static final int INDEXED_TOKENIZED = 1;
    public static final int INDEXED_UNTOKENIZED = 2;
    public static final int STORE_YES = 0;
    public static final int STORE_NO = 1;
    public static final int STORE_COMPRESS = 2;
    private int index = 1;
    private double scoreboost = 1.0;
    private String analyzer;
    private boolean queryOrderable = true;
    private boolean fulltextSearchable = true;
    private boolean facetable = false;
    private boolean hierarchical = false;
    private String[] availableQueryOperators = Lexer.ALL_OPERATORS;
    private Map<Locale, Map<String, String>> messageMaps = new ConcurrentHashMap<Locale, Map<String, String>>(1);

    public ExtendedPropertyDefinition(NodeTypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void setDeclaringNodeType(ExtendedNodeType declaringNodeType) {
        super.setDeclaringNodeType(declaringNodeType);
        declaringNodeType.setPropertyDefinition(this.getName(), this);
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(int requiredType) {
        this.requiredType = requiredType;
        if (this.selector == 0 && SelectorType.defaultSelectors.get(requiredType) != null) {
            this.setSelector(SelectorType.defaultSelectors.get(requiredType));
        }
    }

    public Value[] getValueConstraintsAsUnexpandedValue() {
        return this.valueConstraints;
    }

    public Value[] getValueConstraintsAsValue() {
        ArrayList<Value> res = new ArrayList<Value>();
        for (int i = 0; i < this.valueConstraints.length; ++i) {
            if (this.valueConstraints[i] instanceof DynamicValueImpl) {
                Value[] v;
                for (Value value : v = ((DynamicValueImpl)this.valueConstraints[i]).expand()) {
                    res.add(value);
                }
                continue;
            }
            res.add(this.valueConstraints[i]);
        }
        return res.toArray(new Value[res.size()]);
    }

    public ValueConstraint[] getValueConstraintObjects() {
        ValueConstraint[] constraintObjs = null;
        try {
            String[] constraints = this.getValueConstraints();
            if (this.requiredType == 9 || this.requiredType == 10) {
                String[] expandedConstraints = new String[constraints.length];
                int i = 0;
                for (String constraint : constraints) {
                    try {
                        ExtendedNodeType nodeType = this.registry.getNodeType(constraint);
                        Name name = nodeType.getNameObject();
                        expandedConstraints[i++] = "{" + name.getUri() + "}" + name.getLocalName();
                    }
                    catch (RepositoryException repositoryException) {
                        // empty catch block
                    }
                }
                constraints = expandedConstraints;
            }
            constraintObjs = ValueConstraint.create((int)this.getRequiredType(), (String[])constraints);
        }
        catch (InvalidConstraintException e) {
            logger.warn("Internal error during creation of constraint.", (Throwable)e);
        }
        return constraintObjs;
    }

    public String[] getValueConstraints() {
        Value[] value = this.getValueConstraintsAsValue();
        String[] res = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            try {
                res[i] = value[i].getString();
                continue;
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return res;
    }

    public void setValueConstraints(Value[] valueConstraints) {
        if (this.requiredType != 6) {
            this.valueConstraints = valueConstraints;
        }
    }

    public Value[] getDefaultValues() {
        return this.getDefaultValues(null);
    }

    public Value[] getDefaultValues(Locale locale) {
        ArrayList<Value> res = new ArrayList<Value>();
        for (int i = 0; i < this.defaultValues.length; ++i) {
            if (this.defaultValues[i] instanceof DynamicValueImpl) {
                Value[] v;
                for (Value value : v = ((DynamicValueImpl)this.defaultValues[i]).expand(locale)) {
                    res.add(value);
                }
                continue;
            }
            res.add(this.defaultValues[i]);
        }
        return res.toArray(new Value[res.size()]);
    }

    public Value[] getDefaultValuesAsUnexpandedValue() {
        return this.defaultValues;
    }

    public boolean hasDynamicDefaultValues() {
        return this.defaultValues.length > 0 && this.defaultValues[0] instanceof DynamicValueImpl;
    }

    public void setDefaultValues(Value[] defaultValues) {
        this.defaultValues = defaultValues;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean isInternationalized() {
        return this.internationalized;
    }

    public void setInternationalized(boolean internationalized) {
        this.internationalized = internationalized;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public double getScoreboost() {
        return this.scoreboost;
    }

    public void setScoreboost(double scoreboost) {
        this.scoreboost = scoreboost;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }

    public void setQueryOrderable(boolean sortable) {
        this.queryOrderable = sortable;
    }

    public boolean isFacetable() {
        return this.facetable;
    }

    public void setFacetable(boolean facetable) {
        this.facetable = facetable;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public void setHierarchical(boolean hierarchical) {
        this.hierarchical = hierarchical;
    }

    public boolean isFullTextSearchable() {
        return this.fulltextSearchable;
    }

    public void setFullTextSearchable(boolean fulltextSearchable) {
        this.fulltextSearchable = fulltextSearchable;
    }

    public String[] getAvailableQueryOperators() {
        return this.availableQueryOperators;
    }

    public void setAvailableQueryOperators(String[] availableQueryOperators) {
        this.availableQueryOperators = availableQueryOperators;
    }

    public String getMessage(String msgKeySuffix, Locale locale) {
        String message;
        Map<String, String> messageMap = this.messageMaps.get(locale);
        if (messageMap == null) {
            messageMap = new HashMap<String, String>();
            this.messageMaps.put(locale, messageMap);
        }
        if ((message = messageMap.get(msgKeySuffix)) == null) {
            message = this.getDeclaringNodeType().lookupLabel((String)(!StringUtils.isEmpty((String)msgKeySuffix) ? this.getResourceBundleKey() + "." + msgKeySuffix : this.getResourceBundleKey()), locale, "");
            messageMap.put(msgKeySuffix, message);
        }
        return message;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendedPropertyDefinition that = (ExtendedPropertyDefinition)o;
        if (this.getName().equals("*")) {
            if (this.requiredType != that.requiredType) {
                return false;
            }
            if (this.multiple != that.multiple) {
                return false;
            }
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public void remove() {
        this.getDeclaringNodeType().removePropertyDefinition(this);
    }

    public String toString() {
        return this.getName();
    }
}

