/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.nodetypes.DynamicValueImpl;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.IndexType;
import org.jahia.services.content.nodetypes.Lexer;
import org.jahia.services.content.nodetypes.OnConflictAction;
import org.jahia.services.content.nodetypes.SelectorType;

public class JahiaCndWriter {
    private static final String INDENT = " ";
    private static final HashSet<String> ALL_OPERATORS = Sets.newHashSet((Object[])Lexer.ALL_OPERATORS);
    private static final BigDecimal ONE = BigDecimal.valueOf(1.0);
    private Writer out;

    public JahiaCndWriter(Writer out) {
        this.out = out;
    }

    public JahiaCndWriter(NodeTypeIterator nti, Map<String, String> namespaces, Writer out) throws IOException {
        this.out = out;
        this.writeNamespaces(namespaces);
        while (nti.hasNext()) {
            ExtendedNodeType ntd = (ExtendedNodeType)nti.nextNodeType();
            this.write(ntd);
        }
    }

    public JahiaCndWriter(Collection<ExtendedNodeType> l, Writer out) throws IOException {
        this.out = out;
        for (ExtendedNodeType aL : l) {
            this.write(aL);
        }
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
        this.out = null;
    }

    private void writeNamespaces(Map<String, String> namespaces) throws IOException {
        for (Map.Entry<String, String> k : namespaces.entrySet()) {
            this.out.write("<" + k.getKey() + " = '" + k.getValue() + "'>\n");
        }
        this.out.write("\n");
    }

    public void write(ExtendedNodeType d) throws IOException {
        this.writeName(d);
        this.writeSupertypes(d);
        this.writeOptions(d);
        this.writeItemDefExtensions(d);
        this.out.write("\n\n");
    }

    private void writeName(ExtendedNodeType ntd) throws IOException {
        this.out.write("[");
        this.out.write(ntd.getName());
        this.out.write("]");
    }

    private void writeSupertypes(ExtendedNodeType ntd) throws IOException {
        ExtendedNodeType[] sta = ntd.getDeclaredSupertypes();
        String delim = " > ";
        for (int i = 0; i < sta.length; ++i) {
            this.out.write(delim);
            this.out.write(sta[i].getName());
            delim = ", ";
        }
    }

    private void writeOptions(ExtendedNodeType ntd) throws IOException {
        String itemsType;
        List<ExtendedNodeType> mixinExtends;
        if (ntd.hasOrderableChildNodes()) {
            this.out.write(" orderable");
        }
        if (ntd.isMixin()) {
            this.out.write(" mixin");
        }
        if (ntd.isAbstract()) {
            this.out.write(" abstract");
        }
        if (!ntd.isQueryable()) {
            this.out.write(" noquery");
        }
        if ((mixinExtends = ntd.getMixinExtends()) != null && !mixinExtends.isEmpty()) {
            this.out.write("\n ");
            this.out.write("extends = ");
            Iterator<ExtendedNodeType> it = mixinExtends.iterator();
            while (it.hasNext()) {
                this.out.write(it.next().getName());
                if (!it.hasNext()) continue;
                this.out.write(", ");
            }
        }
        if ((itemsType = ntd.getItemsType()) != null) {
            this.out.write("\n ");
            this.out.write("itemtype = ");
            this.out.write(itemsType);
        }
    }

    private void writeItemDefExtensions(ExtendedNodeType ntd) throws IOException {
        for (ExtendedItemDefinition itemDefExtension : ntd.getDeclaredItems(true)) {
            if (itemDefExtension.isNode()) {
                this.writeNodeDefExtension(ntd, (ExtendedNodeDefinition)itemDefExtension);
                continue;
            }
            this.writePropertyDefExtension(ntd, (ExtendedPropertyDefinition)itemDefExtension);
        }
    }

    private void writePropertyDefExtension(ExtendedNodeType ntd, ExtendedPropertyDefinition pd) throws IOException {
        String[] availableQueryOperators;
        this.out.write("\n - ");
        this.out.write(pd.getName());
        this.out.write(" (");
        this.out.write(PropertyType.nameFromValue((int)pd.getRequiredType()).toLowerCase());
        if (!(SelectorType.nameFromValue(pd.getSelector()) == null || SelectorType.defaultSelectors.get(pd.getRequiredType()) != null && pd.getSelector() == SelectorType.defaultSelectors.get(pd.getRequiredType()).intValue() && pd.getSelectorOptions().isEmpty())) {
            this.out.write(", ");
            this.out.write(SelectorType.nameFromValue(pd.getSelector()).toLowerCase());
            Map<String, String> selectorOptions = pd.getSelectorOptions();
            if (!selectorOptions.isEmpty()) {
                this.out.write("[");
                Iterator<Map.Entry<String, String>> keys = selectorOptions.entrySet().iterator();
                while (keys.hasNext()) {
                    Map.Entry<String, String> entry = keys.next();
                    String key = entry.getKey();
                    String value = entry.getValue();
                    this.out.write(key);
                    if (StringUtils.isNotBlank((String)value)) {
                        this.out.write("='" + value + "'");
                    }
                    if (!keys.hasNext()) continue;
                    this.out.write(",");
                }
                this.out.write("]");
            }
        }
        this.out.write(")");
        this.writeDefaultValues(pd.getDefaultValuesAsUnexpandedValue());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(pd.getName()) ? " primary" : "");
        if (pd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (pd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (pd.isProtected()) {
            this.out.write(" protected");
        }
        if (pd.isMultiple()) {
            this.out.write(" multiple");
        }
        if (pd.isHidden()) {
            this.out.write(" hidden");
        }
        if (pd.isInternationalized()) {
            this.out.write(" internationalized");
        }
        if (pd.getOnConflict() != 5) {
            this.out.write(" onconflict=" + OnConflictAction.nameFromValue(pd.getOnConflict()));
        }
        if (pd.getIndex() != 1) {
            this.out.write(" indexed=" + IndexType.nameFromValue(pd.getIndex()));
        }
        Double scoreboost = pd.getScoreboost();
        BigDecimal sbBigDecimal = BigDecimal.valueOf(pd.getScoreboost());
        if (!scoreboost.isInfinite() && !scoreboost.isNaN() && sbBigDecimal.compareTo(ONE) != 0) {
            this.out.write(" scoreboost=" + scoreboost);
        }
        if (pd.getAnalyzer() != null) {
            this.out.write(" analyzer=" + pd.getAnalyzer());
        }
        if (pd.isFacetable()) {
            this.out.write(" facetable");
        }
        if (pd.isHierarchical()) {
            this.out.write(" hierarchical");
        }
        if (!pd.isQueryOrderable()) {
            this.out.write(" noqueryorder");
        }
        if (!pd.isFullTextSearchable()) {
            this.out.write(" nofulltext");
        }
        if (pd.getLocalItemType() != null) {
            this.out.write(" itemtype = " + pd.getLocalItemType());
        }
        if (pd.getOnParentVersion() != 2) {
            this.out.write(INDENT);
            this.out.write(OnParentVersionAction.nameFromValue((int)pd.getOnParentVersion()).toLowerCase());
        }
        if ((availableQueryOperators = pd.getAvailableQueryOperators()) != null && availableQueryOperators.length > 0) {
            this.writeQueryOperators(availableQueryOperators);
        }
        this.writeValueConstraints(pd.getValueConstraintsAsValue());
    }

    private void writeQueryOperators(String[] availableQueryOperators) throws IOException {
        if (ALL_OPERATORS.equals(Sets.newHashSet((Object[])availableQueryOperators))) {
            return;
        }
        this.out.write(" queryops '");
        for (int i = 0; i < availableQueryOperators.length; ++i) {
            String op;
            if (i > 0) {
                this.out.write(",");
            }
            if ("jcr.operator.equal.to".equals(op = availableQueryOperators[i])) {
                this.out.write("=");
                continue;
            }
            if ("jcr.operator.not.equal.to".equals(op)) {
                this.out.write("<>");
                continue;
            }
            if ("jcr.operator.less.than".equals(op)) {
                this.out.write("<");
                continue;
            }
            if ("jcr.operator.less.than.or.equal.to".equals(op)) {
                this.out.write("<=");
                continue;
            }
            if ("jcr.operator.greater.than".equals(op)) {
                this.out.write(">");
                continue;
            }
            if ("jcr.operator.greater.than.or.equal.to".equals(op)) {
                this.out.write(">=");
                continue;
            }
            if (!"jcr.operator.like".equals(op)) continue;
            this.out.write("LIKE");
        }
        this.out.write("'");
    }

    private void writeDefaultValues(Value[] dva) throws IOException {
        if (dva != null && dva.length > 0) {
            this.out.write(" = ");
            this.out.write(StringUtils.join(JahiaCndWriter.getValuesAsString(dva), (String)", "));
        }
    }

    private void writeValueConstraints(Value[] vca) throws IOException {
        if (vca != null && vca.length > 0) {
            this.out.write(" < ");
            this.out.write(StringUtils.join(JahiaCndWriter.getValuesAsString(vca), (String)", "));
        }
    }

    public static List<String> getValuesAsString(Value[] values) throws IOException {
        ArrayList<String> valuesAsString = new ArrayList<String>();
        for (Value value : values) {
            StringBuilder sb = new StringBuilder();
            try {
                if (value instanceof DynamicValueImpl) {
                    DynamicValueImpl dynamicValue = (DynamicValueImpl)value;
                    sb.append(JahiaCndWriter.escape(dynamicValue.getFn()));
                    sb.append("(");
                    List<String> p = dynamicValue.getParams();
                    Iterator<String> it = p.iterator();
                    while (it.hasNext()) {
                        sb.append("'");
                        sb.append(JahiaCndWriter.escape(it.next()));
                        sb.append("'");
                        if (!it.hasNext()) continue;
                        sb.append(INDENT);
                    }
                    sb.append(")");
                } else if (value.getString() != null) {
                    sb.append("'");
                    sb.append(JahiaCndWriter.escape(value.getString()));
                    sb.append("'");
                }
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
            valuesAsString.add(sb.toString());
        }
        return valuesAsString;
    }

    private void writeNodeDefExtension(ExtendedNodeType ntd, ExtendedNodeDefinition nd) throws IOException {
        this.out.write("\n + ");
        String name = nd.getName();
        this.out.write(name);
        this.writeRequiredTypes(nd.getRequiredPrimaryTypes());
        this.writeDefaultType(nd.getDefaultPrimaryType());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(nd.getName()) ? " primary" : "");
        if (nd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (nd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (nd.isProtected()) {
            this.out.write(" protected");
        }
        if (nd.allowsSameNameSiblings()) {
            this.out.write(" multiple");
        }
        if (nd.getOnParentVersion() != 2) {
            this.out.write(INDENT);
            this.out.write(OnParentVersionAction.nameFromValue((int)nd.getOnParentVersion()).toLowerCase());
        }
    }

    private void writeRequiredTypes(NodeType[] reqTypes) throws IOException {
        if (reqTypes != null && reqTypes.length > 0) {
            String delim = " (";
            for (int i = 0; i < reqTypes.length; ++i) {
                this.out.write(delim);
                this.out.write(reqTypes[i].getName());
                delim = ", ";
            }
            this.out.write(")");
        }
    }

    private void writeDefaultType(NodeType defType) throws IOException {
        if (defType != null && !defType.getName().equals("*")) {
            this.out.write(" = ");
            this.out.write(defType.getName());
        }
    }

    private static String escape(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(39) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\\' && sb.charAt(i) != '\'') continue;
            sb.insert(i, '\\');
            ++i;
        }
        return sb.toString();
    }
}

