/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jahia.bin.Jahia;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.content.nodetypes.renderer.ChoiceListRenderer;
import org.jahia.services.render.RenderContext;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryFlagChoiceListInitializerAndRendererImpl
implements ChoiceListInitializer,
ChoiceListRenderer {
    private static transient Logger logger = LoggerFactory.getLogger(CountryFlagChoiceListInitializerAndRendererImpl.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        if (values != null) {
            for (ChoiceListValue value : values) {
                try {
                    Object flagPath = "/css/images/flags/shadow/flag_" + Patterns.SPACE.matcher(new Locale("en", value.getValue().getString()).getDisplayCountry(Locale.ENGLISH).toLowerCase()).replaceAll("_") + ".png";
                    flagPath = this.checkFlagPath((String)flagPath);
                    value.addProperty("image", Jahia.getContextPath() + (String)flagPath);
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return values;
        }
        return new ArrayList<ChoiceListValue>();
    }

    @Override
    public Map<String, Object> getObjectRendering(RenderContext context, JCRPropertyWrapper propertyWrapper) throws RepositoryException {
        return this.getObjectRendering(context, null, (Object)propertyWrapper.getValue().getString());
    }

    @Override
    public Map<String, Object> getObjectRendering(RenderContext context, ExtendedPropertyDefinition propDef, Object propertyValue) throws RepositoryException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String displayName = new Locale("en", propertyValue.toString()).getDisplayCountry(context.getMainResource().getLocale());
        String enDisplayName = new Locale("en", propertyValue.toString()).getDisplayCountry(Locale.ENGLISH);
        Object flagPath = "/css/images/flags/shadow/flag_" + Patterns.SPACE.matcher(enDisplayName.toLowerCase()).replaceAll("_") + ".png";
        flagPath = this.checkFlagPath((String)flagPath);
        map.put("displayName", displayName);
        map.put("flag", context.getRequest().getContextPath() + (String)flagPath);
        return map;
    }

    @Override
    public String getStringRendering(RenderContext context, JCRPropertyWrapper propertyWrapper) throws RepositoryException {
        String value = propertyWrapper.isMultiple() ? propertyWrapper.getValues()[0].getString() : propertyWrapper.getValue().getString();
        return this.getStringRendering(context, null, (Object)value);
    }

    @Override
    public String getStringRendering(RenderContext context, ExtendedPropertyDefinition propDef, Object propertyValue) throws RepositoryException {
        String value = propertyValue.toString();
        String displayName = new Locale("en", value).getDisplayCountry(context.getMainResource().getLocale());
        String enDisplayName = new Locale("en", value).getDisplayCountry(Locale.ENGLISH);
        Object flagPath = "/css/images/flags/shadow/flag_" + Patterns.SPACE.matcher(enDisplayName.toLowerCase()).replaceAll("_") + ".png";
        flagPath = this.checkFlagPath((String)flagPath);
        return "<img src=\"" + context.getRequest().getContextPath() + (String)flagPath + "\">&nbsp;<span>" + displayName + "</span>";
    }

    @Override
    public Map<String, Object> getObjectRendering(Locale locale, ExtendedPropertyDefinition propDef, Object propertyValue) throws RepositoryException {
        throw new UnsupportedOperationException("This renderer does not work without RenderContext");
    }

    @Override
    public String getStringRendering(Locale locale, ExtendedPropertyDefinition propDef, Object propertyValue) throws RepositoryException {
        throw new UnsupportedOperationException("This renderer does not work without RenderContext");
    }

    private String checkFlagPath(String flagPath) {
        boolean hasFlag;
        String realFlagPath = JahiaContextLoaderListener.getServletContext().getRealPath(flagPath);
        boolean bl = hasFlag = realFlagPath != null;
        if (hasFlag) {
            try {
                File f = new File(realFlagPath);
                hasFlag = f.exists();
            }
            catch (Exception e) {
                hasFlag = false;
            }
        }
        if (!hasFlag) {
            flagPath = "/css/blank.gif";
        }
        return flagPath;
    }
}

