/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteLanguagesChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static final Logger logger = LoggerFactory.getLogger(SiteLanguagesChoiceListInitializerImpl.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition declaringPropertyDefinition, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        if (context == null) {
            return new ArrayList<ChoiceListValue>();
        }
        JCRNodeWrapper node = (JCRNodeWrapper)context.get("contextNode");
        JCRNodeWrapper parentNode = (JCRNodeWrapper)context.get("contextParent");
        JCRSiteNode site = null;
        try {
            if (node != null) {
                site = node.getResolveSite();
            }
            if (site == null && parentNode != null) {
                site = parentNode.getResolveSite();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (site == null) {
            return new ArrayList<ChoiceListValue>();
        }
        ArrayList<ChoiceListValue> vs = new ArrayList<ChoiceListValue>();
        Set<String> activeLiveLanguages = site.getActiveLiveLanguages();
        for (String activeLiveLanguage : activeLiveLanguages) {
            ChoiceListValue value = new ChoiceListValue();
            value.setStringValue(activeLiveLanguage);
            value.setDisplayName(LanguageCodeConverters.languageCodeToLocale(activeLiveLanguage).getDisplayName(locale));
            vs.add(value);
        }
        Collections.sort(vs);
        return vs;
    }
}

