/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.textextraction;

import java.io.IOException;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.rules.ExtractionService;
import org.jahia.services.content.textextraction.TextExtractorJob;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.scheduler.SchedulerService;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextExtractionListener
extends DefaultEventListener {
    private static final transient Logger logger = LoggerFactory.getLogger(TextExtractionListener.class);
    private ExtractionService extractionService;
    private SchedulerService schedulerService;

    protected void doHandle(Node node, Event event, JCRSessionWrapper s, boolean immediateExtraction) throws AccessDeniedException, ItemNotFoundException, IOException, RepositoryException, SchedulerException {
        Calendar lastModified;
        String mimeType = null;
        try {
            mimeType = node.getProperty("jcr:mimeType").getString();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        if (mimeType == null) {
            return;
        }
        Calendar extractionDate = null;
        if (node.hasProperty("j:lastExtractionDate") && node.hasProperty("j:extractedText")) {
            try {
                extractionDate = node.getProperty("j:lastExtractionDate").getDate();
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
        if (!(extractionDate == null || extractionDate.before(lastModified = node.getProperty("jcr:lastModified").getDate()) && lastModified.getTimeInMillis() - extractionDate.getTimeInMillis() >= 1000L)) {
            return;
        }
        boolean canHandle = false;
        try {
            canHandle = this.extractionService.canHandle((JCRNodeWrapper)node);
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        if (canHandle) {
            JCRNodeWrapper fileNode = (JCRNodeWrapper)node.getParent();
            if (immediateExtraction) {
                ExtractionService.getInstance().extractText(fileNode.getProvider(), fileNode.getPath(), null, this.getWorkspace());
            } else {
                this.scheduleBackgroundExtraction(fileNode, event.getUserID());
            }
        }
    }

    @Override
    public int getEventTypes() {
        return this.extractionService.isEnabled() ? 28 : 0;
    }

    @Override
    public String[] getNodeTypes() {
        return new String[]{"jnt:resource"};
    }

    public void onEvent(final EventIterator eventIterator) {
        final boolean isImport = eventIterator instanceof JCREventIterator && ((JCREventIterator)eventIterator).getOperationType() == 13;
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(null, this.getWorkspace(), new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper s) throws RepositoryException {
                    try {
                        while (eventIterator.hasNext()) {
                            Property p;
                            Event event = eventIterator.nextEvent();
                            String eventPath = event.getPath();
                            if (eventPath.startsWith("/jcr:system") || eventPath.endsWith("/j:extractedText") || (p = (Property)s.getItem(eventPath)).getDefinition() == null || p.getType() != 2) continue;
                            TextExtractionListener.this.doHandle(p.getParent(), event, s, isImport);
                        }
                    }
                    catch (ConstraintViolationException e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    catch (PathNotFoundException e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void scheduleBackgroundExtraction(JCRNodeWrapper fileNode, String user) throws SchedulerException {
        JobDetail jobDetail = BackgroundJob.createJahiaJob("Text extraction for " + fileNode.getName(), TextExtractorJob.class);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("provider", fileNode.getProvider().getMountPoint());
        jobDataMap.put("path", fileNode.getPath());
        jobDataMap.put("workspace", this.getWorkspace());
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduling text extraction background job for file " + fileNode.getPath());
        }
        this.schedulerService.scheduleJobAtEndOfRequest(jobDetail);
    }

    public void setExtractionService(ExtractionService extractionService) {
        this.extractionService = extractionService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }
}

