/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.deamons.filewatcher;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.jahia.services.deamons.filewatcher.FileListener;

public class FileMonitorResult
implements FileListener {
    private List<File> changed = Collections.emptyList();
    private List<File> created = Collections.emptyList();
    private List<File> deleted = Collections.emptyList();

    @Override
    public void fileChanged(File file) {
        if (this.changed.isEmpty()) {
            this.changed = new LinkedList<File>();
        }
        this.changed.add(file);
    }

    @Override
    public void fileCreated(File file) {
        if (this.created.isEmpty()) {
            this.created = new LinkedList<File>();
        }
        this.created.add(file);
    }

    @Override
    public void fileDeleted(File file) {
        if (this.deleted.isEmpty()) {
            this.deleted = new LinkedList<File>();
        }
        this.deleted.add(file);
    }

    public Iterable<File> getAll() {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return IteratorUtils.chainedIterator(FileMonitorResult.this.getDeleted().iterator(), (Iterator)IteratorUtils.chainedIterator(FileMonitorResult.this.getChanged().iterator(), FileMonitorResult.this.getCreated().iterator()));
            }
        };
    }

    public List<File> getAllAsList() {
        LinkedList<File> all = new LinkedList<File>();
        all.addAll(this.deleted);
        all.addAll(this.changed);
        all.addAll(this.created);
        return all;
    }

    public List<File> getChanged() {
        return this.changed;
    }

    public List<File> getCreated() {
        return this.created;
    }

    public List<File> getDeleted() {
        return this.deleted;
    }

    public String getInfo() {
        StringBuilder b = new StringBuilder(64);
        boolean first = true;
        b.append("Created ").append(this.created.size()).append(" files");
        if (!this.created.isEmpty()) {
            b.append(":\n");
            for (File f : this.created) {
                if (first) {
                    first = false;
                } else {
                    b.append("\n");
                }
                b.append("\t").append(f);
            }
        }
        b.append("\nChanged ").append(this.changed.size()).append(" files");
        if (!this.changed.isEmpty()) {
            b.append(":\n");
            first = true;
            for (File f : this.changed) {
                if (first) {
                    first = false;
                } else {
                    b.append("\n");
                }
                b.append("\t").append(f);
            }
        }
        b.append("\nDeleted ").append(this.deleted.size()).append(" files");
        if (!this.deleted.isEmpty()) {
            b.append(":\n");
            first = true;
            for (File f : this.deleted) {
                if (first) {
                    first = false;
                } else {
                    b.append("\n");
                }
                b.append("\t").append(f);
            }
        }
        return b.toString();
    }

    public boolean isEmpty() {
        return this.getChanged().isEmpty() && this.getCreated().isEmpty() && this.getDeleted().isEmpty();
    }

    public String toString() {
        return new StringBuilder(32).append("Created ").append(this.created.size()).append(" files, changed ").append(this.changed.size()).append(" files, deleted ").append(this.deleted.size()).append(" files").toString();
    }
}

