/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.history;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.history.HistoryEntry;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHistoryService
implements Processor,
CamelContextAware {
    private static transient Logger logger = LoggerFactory.getLogger(ContentHistoryService.class);
    private SessionFactory sessionFactoryBean;
    private AtomicLong processedCount = new AtomicLong(0L);
    private AtomicLong ignoredCount = new AtomicLong(0L);
    private AtomicLong insertedCount = new AtomicLong(0L);
    private AtomicLong processedSinceLastReport = new AtomicLong(0L);
    private AtomicLong timeSinceLastReport = new AtomicLong(0L);
    private AtomicLong latestTimeProcessed = new AtomicLong(0L);
    private volatile String lastUUIDProcessed = null;
    private volatile String lastPropertyProcessed = null;
    private volatile String lastActionProcessed = null;
    private static ContentHistoryService instance = new ContentHistoryService();
    private static final Pattern PATTERN = Pattern.compile("([0-9\\-]+ [0-9:,]+) user ([\\sa-zA-Z@.0-9_\\-]*) ip ([0-9.:]*) session ([a-zA-Z@0-9_\\-\\/]*) identifier ([a-zA-Z@0-9_\\-\\/:]*) path (.*) nodetype ([a-zA-Z:]*) (.*)");
    private CamelContext camelContext;
    private String from;
    private Set<String> ignoreProperties = new HashSet<String>();
    private Set<String> ignoreNodeTypes = new HashSet<String>();
    public static final String WITH_COMMENTS_MESSAGE_PART = "with comments ";
    public static final String VIEWED_ACTION_NAME = "viewed";
    public static final String PUBLISHED_ACTION_NAME = "published";

    public void setSessionFactoryBean(SessionFactory sessionFactoryBean) {
        this.sessionFactoryBean = sessionFactoryBean;
    }

    public void setIgnoreProperties(Set<String> ignoreProperties) {
        this.ignoreProperties = ignoreProperties;
    }

    public void setIgnoreNodeTypes(Set<String> ignoreNodeTypes) {
        this.ignoreNodeTypes = ignoreNodeTypes;
    }

    public static ContentHistoryService getInstance() {
        return instance;
    }

    private void initTimestamps(Session session) {
        this.timeSinceLastReport.set(System.currentTimeMillis());
        this.latestTimeProcessed.set(this.getMostRecentTimeInHistory(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String message = (String)exchange.getIn().getBody();
        Matcher matcher = PATTERN.matcher(message);
        if (matcher.matches()) {
            String whatDidWeDo;
            long timer;
            long processedCount;
            block35: {
                int lastSlashPos;
                processedCount = this.processedCount.incrementAndGet();
                this.processedSinceLastReport.incrementAndGet();
                String args = matcher.group(8);
                String propertyName = null;
                String[] argList = args != null && args.length() > 0 ? StringUtils.split((String)args, (char)' ') : ArrayUtils.EMPTY_STRING_ARRAY;
                String objectType = null;
                String action = null;
                if (argList.length >= 2) {
                    objectType = argList[0];
                    action = argList[1];
                }
                if (VIEWED_ACTION_NAME.equals(action)) {
                    this.ignoredCount.incrementAndGet();
                    return;
                }
                String path = matcher.group(6);
                if ("property".equals(objectType) && (lastSlashPos = path.lastIndexOf("/")) > -1) {
                    propertyName = path.substring(lastSlashPos + 1);
                }
                if (propertyName != null && this.ignoreProperties.contains(propertyName)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Ignoring property " + propertyName + " as configured.");
                    }
                    this.ignoredCount.incrementAndGet();
                    return;
                }
                String nodeIdentifier = matcher.group(5);
                if (nodeIdentifier != null && !"null".equals(nodeIdentifier) && this.ignoreNodeTypes.size() > 0) {
                    String matchingNodeType;
                    block34: {
                        matchingNodeType = null;
                        try {
                            matchingNodeType = JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
                                JCRNodeWrapper node = session.getNodeByIdentifier(nodeIdentifier);
                                if (node != null) {
                                    for (String ignoreNodeType : this.ignoreNodeTypes) {
                                        if (!node.isNodeType(ignoreNodeType)) continue;
                                        return ignoreNodeType;
                                    }
                                }
                                return null;
                            });
                        }
                        catch (RepositoryException e) {
                            String nodeType = matcher.group(7);
                            if (nodeType == null || nodeType.length() <= 0 || "null".equals(nodeType)) break block34;
                            try {
                                ExtendedNodeType extendedNodeType = NodeTypeRegistry.getInstance().getNodeType(nodeType);
                                if (extendedNodeType == null) break block34;
                                for (String ignoreNodeType : this.ignoreNodeTypes) {
                                    if (!extendedNodeType.isNodeType(ignoreNodeType)) continue;
                                    matchingNodeType = ignoreNodeType;
                                }
                            }
                            catch (NoSuchNodeTypeException noSuchNodeTypeException) {
                                if (!logger.isDebugEnabled()) break block34;
                                logger.debug("We cannot check if the log entry should be ignored or not because both node type: {} and node: {} are not found, this log entry won't be ignored", (Object)nodeType, (Object)nodeIdentifier);
                            }
                        }
                    }
                    if (matchingNodeType != null) {
                        this.ignoredCount.incrementAndGet();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Ignoring node type " + matchingNodeType + " as configured.");
                        }
                        return;
                    }
                }
                timer = System.currentTimeMillis();
                Session session2 = this.sessionFactoryBean.openSession();
                whatDidWeDo = "inserted";
                boolean shouldSkipInsertion = false;
                try {
                    if (this.latestTimeProcessed.get() == 0L) {
                        this.initTimestamps(session2);
                    }
                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").parse(matcher.group(1));
                    if (this.latestTimeProcessed.get() > date.getTime()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Skipping content history entry since it's date {} is older than last processed date", (Object)date);
                        }
                        this.ignoredCount.incrementAndGet();
                        whatDidWeDo = "skipped";
                        shouldSkipInsertion = true;
                    } else if (this.latestTimeProcessed.get() == date.getTime()) {
                        boolean mustCheckInDB = false;
                        if (this.lastUUIDProcessed != null && this.lastUUIDProcessed.equals(nodeIdentifier) && (this.lastPropertyProcessed != null && this.lastPropertyProcessed.equals(propertyName) || this.lastPropertyProcessed == null && propertyName == null) && this.lastActionProcessed.equals(action)) {
                            mustCheckInDB = true;
                        }
                        if (mustCheckInDB) {
                            Criteria criteria = session2.createCriteria(HistoryEntry.class);
                            criteria.add((Criterion)Restrictions.eq((String)"uuid", (Object)nodeIdentifier));
                            criteria.add((Criterion)Restrictions.eq((String)"date", date != null ? Long.valueOf(date.getTime()) : null));
                            criteria.add((Criterion)Restrictions.eq((String)"propertyName", (Object)propertyName));
                            criteria.add((Criterion)Restrictions.eq((String)"action", (Object)action));
                            HistoryEntry historyEntry = (HistoryEntry)criteria.uniqueResult();
                            if (historyEntry != null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Content history entry " + historyEntry + " already exists, ignoring...");
                                }
                                this.ignoredCount.incrementAndGet();
                                whatDidWeDo = "skipped";
                                shouldSkipInsertion = true;
                            }
                        }
                    }
                    if (shouldSkipInsertion) break block35;
                    session2.beginTransaction();
                    HistoryEntry historyEntry = new HistoryEntry();
                    historyEntry.setDate(date != null ? Long.valueOf(date.getTime()) : null);
                    historyEntry.setPath(path);
                    historyEntry.setUuid(nodeIdentifier);
                    String userKey = matcher.group(2);
                    historyEntry.setUserKey(userKey);
                    historyEntry.setAction(action);
                    historyEntry.setPropertyName(propertyName);
                    Object historyMessage = "";
                    if (PUBLISHED_ACTION_NAME.equals(action) && argList.length >= 8) {
                        String comment;
                        String sourceWorkspace = argList[3];
                        String destinationWorkspace = argList[5];
                        Object historyComments = "";
                        int commentsPos = args.indexOf(WITH_COMMENTS_MESSAGE_PART);
                        if (commentsPos > -1 && (comment = args.substring(commentsPos + WITH_COMMENTS_MESSAGE_PART.length())) != null && !StringUtils.isEmpty((String)comment.trim())) {
                            historyComments = ";;" + comment.trim();
                        }
                        historyMessage = sourceWorkspace + ";;" + destinationWorkspace + (String)historyComments;
                    }
                    historyEntry.setMessage((String)historyMessage);
                    try {
                        session2.save((Object)historyEntry);
                        session2.flush();
                        session2.getTransaction().commit();
                    }
                    catch (Exception e) {
                        session2.getTransaction().rollback();
                        throw e;
                    }
                    this.insertedCount.incrementAndGet();
                    this.latestTimeProcessed.set(date.getTime());
                    this.lastUUIDProcessed = nodeIdentifier;
                    this.lastPropertyProcessed = propertyName;
                    this.lastActionProcessed = action;
                }
                catch (HibernateException e) {
                    whatDidWeDo = "insertion failed";
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    session2.close();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Entry " + whatDidWeDo + " in " + (System.currentTimeMillis() - timer) + " ms");
            }
            if (processedCount % 2000L == 0L) {
                long nowTime = System.currentTimeMillis();
                double elapsedTimeInSeconds = (double)(nowTime - this.timeSinceLastReport.get()) / 1000.0;
                double rate = (double)this.processedSinceLastReport.get() / elapsedTimeInSeconds;
                logger.info("Total count of processed content history messages: {}. Ignored: {}. Inserted: {}. Rate={} msgs/sec.", new Object[]{processedCount, this.ignoredCount, this.insertedCount, rate});
                this.processedSinceLastReport.set(0L);
                this.timeSinceLastReport.set(nowTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HistoryEntry> getNodeHistory(JCRNodeWrapper node, boolean withLanguageNodes) {
        try (Session session = this.sessionFactoryBean.openSession();){
            Criteria criteria = session.createCriteria(HistoryEntry.class);
            HashMap<String, Locale> i18ns = null;
            if (withLanguageNodes) {
                i18ns = new HashMap<String, Locale>(4);
                i18ns.put(node.getIdentifier(), null);
                NodeIterator ni = node.getI18Ns();
                while (ni.hasNext()) {
                    Node n = ni.nextNode();
                    i18ns.put(n.getIdentifier(), LanguageCodeConverters.languageCodeToLocale(n.getProperty("jcr:language").getString()));
                }
                criteria.add(Restrictions.in((String)"uuid", i18ns.keySet()));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"uuid", (Object)node.getIdentifier()));
            }
            Transaction tx = session.beginTransaction();
            List result = criteria.list();
            if (withLanguageNodes) {
                for (HistoryEntry entry : result) {
                    entry.setLocale((Locale)i18ns.get(entry.getUuid()));
                }
            }
            tx.commit();
            List list = result;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long deleteHistoryBeforeDate(Date date) {
        try (Session session = this.sessionFactoryBean.openSession();){
            Transaction tx = session.beginTransaction();
            int deletedEntities = session.createQuery("delete HistoryEntry c where c.date < :date").setLong("date", date != null ? date.getTime() : Long.MAX_VALUE).executeUpdate();
            tx.commit();
            if (deletedEntities > 0) {
                logger.info("Successfully deleted " + deletedEntities + " content history entries before date " + date);
            }
            long l = deletedEntities;
            return l;
        }
    }

    public long getMostRecentTimeInHistory(Session session) {
        Long timeStamp = -1L;
        try {
            timeStamp = (Long)session.createQuery("select max(c.date) as latestDate from HistoryEntry c").uniqueResult();
        }
        catch (Exception e) {
            logger.error("Error while trying to retrieve latest date processed.", (Throwable)e);
        }
        return timeStamp != null ? timeStamp : -1L;
    }

    public void setCamelContext(final CamelContext camelContext) {
        this.camelContext = camelContext;
        final ContentHistoryService contentHistoryService = this;
        try {
            camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from(ContentHistoryService.this.from).filter(this.body().not().contains((Object)" viewed ")).to((Endpoint)new ProcessorEndpoint("contentHistoryService", camelContext, (Processor)contentHistoryService));
                }
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setFrom(String from) {
        this.from = from;
    }
}

