/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.ImportUUIDBehavior;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.CompositeConstraintViolationException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRMultipleValueUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.AttributeProcessor;
import org.jahia.services.importexport.BaseDocumentViewHandler;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.importexport.LegacyImportHandler;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DocumentViewImportHandler
extends BaseDocumentViewHandler
implements ImportUUIDBehavior {
    public static final int IMPORT_UUID_COLLISION_MOVE_EXISTING = 4;
    public static final int ROOT_BEHAVIOUR_IGNORE = 0;
    public static final int ROOT_BEHAVIOUR_REPLACE = 1;
    public static final int ROOT_BEHAVIOUR_RENAME = 2;
    private static Logger logger = LoggerFactory.getLogger(DocumentViewImportHandler.class);
    private int rootBehavior = 1;
    private int maxBatch = SettingsBean.getInstance().getImportMaxBatch();
    private int batchCount = 0;
    private Locator documentLocator;
    private Resource archive;
    private NoCloseZipInputStream zis;
    private ZipEntry nextEntry;
    private List<String> fileList = new ArrayList<String>();
    private String baseFilesPath = "/content";
    private Stack<JCRNodeWrapper> nodes = new Stack();
    private JCRSiteNode site;
    private List<String> dependencies;
    private Map<String, String> uuidMapping;
    private Map<String, String> pathMapping;
    private Map<String, List<String>> references = new HashMap<String, List<String>>();
    private Map<Pattern, String> replacements = Collections.emptyMap();
    private List<AttributeProcessor> attributeProcessors = Collections.emptyList();
    private Set<String> propertiesToSkip = Collections.emptySet();
    private String currentFilePath = null;
    private String ignorePath = null;
    private int error = 0;
    private boolean resolveReferenceAtEnd = true;
    private int uuidBehavior = 0;
    private Map<String, String> placeHoldersMap = new HashMap<String, String>();
    private boolean importUserGeneratedContent = false;
    private int ugcLevel = 0;
    private boolean cleanPreviousLiveImport = false;
    private static final List<String> NO_SUB_NODES_IMPORT = Arrays.asList("jnt:importDropBox", "jnt:referencesKeeper");
    private static final List<String> NO_LIVE_CLEANUP_FOR_PROPS = Arrays.asList("jcr:lastModified", "jcr:lastModifiedBy");
    private List<String> noUpdateTypes = Arrays.asList("jnt:virtualsitesFolder", "jnt:usersFolder", "jnt:groupsFolder", "jnt:user", "jnt:group");
    private Set<String> uuidsSet = new LinkedHashSet<String>();
    private boolean expandImportedFilesOnDisk = SettingsBean.getInstance().isExpandImportedFilesOnDisk();
    private String expandedFolder;
    private Set<String> missingDependencies = new HashSet<String>();
    private JCRSessionWrapper liveSession = null;

    public DocumentViewImportHandler(JCRSessionWrapper session, String rootPath) throws IOException {
        this(session, rootPath, null, null);
    }

    public DocumentViewImportHandler(JCRSessionWrapper session, String rootPath, Resource archive, List<String> fileList) throws IOException {
        super(session);
        JCRNodeWrapper node = null;
        try {
            this.uuidMapping = session.getUuidMapping();
            this.pathMapping = session.getPathMapping();
            node = rootPath == null ? session.getRootNode() : session.getNode(rootPath);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage() + this.getLocation(), (Throwable)e);
            throw new IOException();
        }
        this.nodes.add(node);
        this.archive = archive;
        if (archive != null && !archive.isReadable() && archive instanceof FileSystemResource) {
            this.expandedFolder = archive.getFile().getPath();
            this.expandImportedFilesOnDisk = true;
        } else if (this.expandImportedFilesOnDisk && archive != null) {
            this.expandedFolder = ImportExportBaseService.getExpandFolder(archive, SettingsBean.getInstance().getExpandImportedFilesOnDiskPath()).getPath();
        }
        this.fileList = fileList;
        this.setPropertiesToSkip(new HashSet<String>((Set)SpringContextSingleton.getBean("DocumentViewImportHandler.propertiesToSkip")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String newName;
        String providerKey;
        if (this.error > 0) {
            ++this.error;
            return;
        }
        ++this.batchCount;
        if (this.batchCount > this.maxBatch) {
            try {
                ReferencesHelper.resolveCrossReferences(this.session, this.references, false);
                this.session.save(13);
                this.batchCount = 0;
                this.session.refresh(false);
            }
            catch (CompositeConstraintViolationException e) {
                logger.error("Constraint violation exception", (Throwable)((Object)e));
                throw new SAXException("Cannot save batch", (Exception)((Object)e));
            }
            catch (ConstraintViolationException e) {
                boolean retryToSave;
                boolean bl = retryToSave = e.getMessage().contains("mandatory child node") && this.nodes.size() > 1 && e.getMessage().startsWith(this.nodes.peek().getPath());
                if (!retryToSave) {
                    throw new SAXException("Cannot save batch", (Exception)((Object)e));
                }
            }
            catch (RepositoryException e) {
                throw new SAXException("Cannot save batch", (Exception)((Object)e));
            }
        }
        if (this.ugcLevel > 0 || "live".equals(atts.getValue("j:originWS"))) {
            if (this.importUserGeneratedContent) {
                ++this.ugcLevel;
            } else {
                ++this.error;
                return;
            }
        }
        if (atts.getIndex("j:staticMountPointProviderKey") > -1) {
            providerKey = atts.getValue("j:staticMountPointProviderKey");
            Map<String, JCRStoreProvider> providers = JCRSessionFactory.getInstance().getProviders();
            if (!providers.containsKey(providerKey) || !providers.get(providerKey).isAvailable()) {
                ++this.error;
                return;
            }
        }
        if (atts.getIndex("j:dynamicMountPointProviderPath") > -1) {
            try {
                providerKey = this.session.getNode(atts.getValue("j:dynamicMountPointProviderPath")).getIdentifier();
                Map<String, JCRStoreProvider> providers = JCRSessionFactory.getInstance().getProviders();
                if (!providers.containsKey(providerKey) || !providers.get(providerKey).isAvailable()) {
                    ++this.error;
                    return;
                }
            }
            catch (RepositoryException e) {
                ++this.error;
                return;
            }
        }
        String decodedLocalName = ISO9075.decode((String)localName);
        for (Map.Entry<Pattern, String> entry : this.replacements.entrySet()) {
            decodedLocalName = entry.getKey().matcher(decodedLocalName).replaceAll(entry.getValue());
        }
        String decodedQName = qName.replace(localName, decodedLocalName);
        if (this.rootBehavior == 2 && this.pathes.size() <= 1 && !this.pathMapping.containsKey((String)this.pathes.peek() + "/" + decodedQName) && !decodedQName.equals(newName = JCRContentUtils.findAvailableNodeName(this.nodes.peek(), decodedQName))) {
            this.pathMapping.put(this.nodes.peek().getPath() + "/" + decodedQName + "/", this.nodes.peek().getPath() + "/" + newName + "/");
            decodedQName = newName;
        }
        if (this.rootBehavior == 0 && this.pathes.size() <= 1) {
            this.session.getPathMapping().put("/" + decodedQName + "/", (String)(this.nodes.peek().getPath().equals("/") ? "/" : this.nodes.peek().getPath() + "/"));
            this.pathes.push("");
            return;
        }
        this.pathes.push((String)this.pathes.peek() + "/" + decodedQName);
        try {
            String memberRef;
            String pt;
            Matcher m;
            if (this.ignorePath != null) {
                this.nodes.push(null);
                return;
            }
            Object path = this.nodes.peek().getPath().equals("/") ? "/" + decodedQName : this.nodes.peek().getPath() + "/" + decodedQName;
            if (((String)this.pathes.peek()).startsWith("/users/") && "jnt:user".equals(atts.getValue("jcr:primaryType")) && (m = Pattern.compile("/users/([^/]+)").matcher((CharSequence)this.pathes.peek())).matches()) {
                path = JahiaUserManagerService.getInstance().getUserSplittingRule().getPathForUsername(m.group(1));
            }
            if ("jnt:member".equals(pt = atts.getValue("jcr:primaryType")) && this.nodes.peek().isNodeType("jnt:members") && "j:members".equals(this.nodes.peek().getName()) && (memberRef = atts.getValue("j:member")) != null) {
                JCRNodeWrapper principal;
                String referenceValue = this.getReferenceValue(memberRef, (String)path);
                if (referenceValue.startsWith("/")) {
                    for (String key : this.pathMapping.keySet()) {
                        if (!referenceValue.startsWith(key)) continue;
                        referenceValue = StringUtils.replace((String)referenceValue, (String)key, (String)this.pathMapping.get(key));
                        break;
                    }
                    principal = this.session.getNode(referenceValue);
                } else {
                    principal = this.session.getNodeByIdentifier(memberRef);
                }
                JCRGroupNode groupNode = JahiaGroupManagerService.getInstance().lookupGroupByPath(StringUtils.substringBeforeLast((String)this.nodes.peek().getPath(), (String)"/"), this.session);
                JCRNodeWrapper member = groupNode.addMember(principal);
                if (member != null) {
                    this.uuidsSet.add(member.getIdentifier());
                }
                this.nodes.push(member);
                return;
            }
            if (this.pathMapping.containsKey((String)path + "/")) {
                path = StringUtils.substringBeforeLast((String)this.pathMapping.get((String)path + "/"), (String)"/");
                decodedQName = StringUtils.substringAfter((String)path, (String)"/");
            }
            if (NO_SUB_NODES_IMPORT.contains(pt)) {
                this.ignorePath = path;
            }
            JCRNodeWrapper child = null;
            boolean isValid = true;
            try {
                child = this.session.getNode((String)path);
                if (child.hasPermission("jcr:versionManagement") && child.isVersioned() && !child.isCheckedOut()) {
                    this.session.checkout(child);
                }
            }
            catch (PathNotFoundException e) {
                isValid = false;
            }
            if (!this.importUserGeneratedContent || this.ugcLevel > 0) {
                String originalUuid = atts.getValue("jcr:uuid");
                String uuid = originalUuid;
                if (uuid != null && this.uuidMapping.containsKey(uuid)) {
                    uuid = this.uuidMapping.get(uuid);
                } else if (this.cleanPreviousLiveImport) {
                    uuid = null;
                }
                if (isValid && this.cleanPreviousLiveImport && uuid != null && !child.getIdentifier().equals(uuid)) {
                    child.remove();
                    isValid = false;
                }
                if (!isValid || child.getDefinition() != null && child.getDefinition().allowsSameNameSiblings()) {
                    isValid = false;
                    if (!this.nodes.peek().hasPermission("jcr:addChildNodes")) throw new AccessDeniedException("Missing jcr:addChildNodes permission for user " + this.session.getUser().getName());
                    if ("jnt:acl".equals(pt) && !this.nodes.peek().isNodeType("jmix:accessControlled")) {
                        this.nodes.peek().addMixin("jmix:accessControlled");
                    }
                    Calendar created = null;
                    String createdBy = null;
                    Calendar lastModified = null;
                    String lastModifiedBy = null;
                    if (!StringUtils.isEmpty((String)atts.getValue("jcr:created"))) {
                        created = ISO8601.parse((String)atts.getValue("jcr:created"));
                    }
                    if (!StringUtils.isEmpty((String)atts.getValue("jcr:lastModified"))) {
                        lastModified = ISO8601.parse((String)atts.getValue("jcr:lastModified"));
                    }
                    if (!StringUtils.isEmpty((String)atts.getValue("jcr:createdBy"))) {
                        createdBy = atts.getValue("jcr:createdBy");
                    }
                    if (!StringUtils.isEmpty((String)atts.getValue("jcr:lastModifiedBy"))) {
                        lastModifiedBy = atts.getValue("jcr:lastModifiedBy");
                    }
                    if (!StringUtils.isEmpty((String)uuid)) {
                        switch (this.uuidBehavior) {
                            case 3: {
                                JCRNodeWrapper node2;
                                try {
                                    node2 = this.session.getNodeByUUID(uuid);
                                    if (!node2.isNodeType("mix:shareable")) {
                                        throw new ItemExistsException(uuid);
                                    }
                                }
                                catch (ItemNotFoundException node2) {
                                    // empty catch block
                                }
                            }
                            case 1: {
                                JCRNodeWrapper node2;
                                try {
                                    node2 = this.session.getNodeByUUID(uuid);
                                    if (this.nodes.peek().getPath().startsWith(node2.getPath())) {
                                        String msg = "cannot remove ancestor node";
                                        logger.debug(msg);
                                        throw new ConstraintViolationException(msg);
                                    }
                                    node2.remove();
                                }
                                catch (ItemNotFoundException node) {}
                                break;
                            }
                            case 2: {
                                throw new UnsupportedOperationException();
                            }
                            case 0: {
                                uuid = null;
                                break;
                            }
                            case 4: {
                                JCRNodeWrapper node2;
                                try {
                                    node2 = this.session.getNodeByUUID(uuid);
                                    if (this.nodes.peek().getPath().startsWith(node2.getPath())) {
                                        String msg = "cannot move ancestor node";
                                        logger.debug(msg);
                                        throw new ConstraintViolationException(msg);
                                    }
                                    if (!node2.getPath().equals(path)) {
                                        this.session.move(node2.getPath(), (String)path);
                                        node2 = this.session.getNodeByUUID(uuid);
                                    }
                                    child = node2;
                                    isValid = true;
                                    break;
                                }
                                catch (ItemNotFoundException node) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (!isValid) {
                        try {
                            this.session.checkout(this.nodes.peek());
                        }
                        catch (PathNotFoundException e) {
                            logger.error("Couldn't find parent node " + this.nodes.peek(), (Throwable)e);
                        }
                        try {
                            this.checkDependencies((String)path, pt, atts);
                            child = this.nodes.peek().addNode(decodedQName, pt, uuid, created, createdBy, lastModified, lastModifiedBy);
                        }
                        catch (ConstraintViolationException e) {
                            if (this.pathes.size() > 2 || !this.nodes.peek().getName().equals(decodedQName) || !this.nodes.peek().getPrimaryNodeTypeName().equals(pt)) throw e;
                            this.session.getPathMapping().put("/" + decodedQName, this.nodes.peek().getPath().equals("/") ? "" : this.nodes.peek().getPath());
                            return;
                        }
                    }
                    this.addMixins(child, atts);
                    this.setAttributes(child, atts);
                    this.handleBinary(atts, decodedQName, (String)path, child);
                    this.uuidsSet.add(child.getIdentifier());
                    if (child.isFile() && this.currentFilePath == null) {
                        this.currentFilePath = child.getPath();
                    }
                    if (child.isNodeType("jnt:mountPoint")) {
                        this.session.save(13);
                    }
                } else {
                    if (this.updatesAllowedOnExistingChild(child, atts)) {
                        this.addMixins(child, atts);
                        this.setAttributes(child, atts);
                        this.handleBinary(atts, decodedQName, (String)path, child);
                    }
                    this.uuidsSet.add(child.getIdentifier());
                }
                if (originalUuid != null) {
                    this.uuidMapping.put(originalUuid, child.getIdentifier());
                }
                if (this.nodes.peek().getPrimaryNodeType().hasOrderableChildNodes() && this.nodes.peek().hasPermission("jcr:write") && !JCRSessionFactory.getInstance().getMountPoints().containsKey(child.getPath())) {
                    this.nodes.peek().orderBefore(decodedQName, null);
                }
            }
            if (child == null) {
                ++this.error;
                return;
            } else {
                this.nodes.push(child);
            }
            return;
        }
        catch (NoSuchNodeTypeException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Cannot import " + (String)this.pathes.pop(), (Throwable)e);
            } else {
                logger.warn("Cannot import \"{}\" due to missing node type definition \"{}\"", this.pathes.pop(), (Object)e.getMessage());
            }
            ++this.error;
            return;
        }
        catch (AccessDeniedException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Cannot import " + (String)this.pathes.pop() + this.getLocation(), (Throwable)e);
            } else {
                logger.warn("Cannot import \"{}\" due to \"{}\"", this.pathes.pop(), (Object)e.getMessage());
            }
            ++this.error;
            return;
        }
        catch (RepositoryException re) {
            logger.error("Cannot import " + (String)this.pathes.pop() + this.getLocation(), (Throwable)re);
            ++this.error;
            return;
        }
        catch (Exception re) {
            throw new SAXException(re);
        }
    }

    private boolean updatesAllowedOnExistingChild(JCRNodeWrapper nodeToCheck, Attributes atts) throws RepositoryException {
        if (!nodeToCheck.hasPermission("jcr:modifyProperties") || !nodeToCheck.isCheckedOut() || atts.getValue("jcr:primaryType") == null) {
            return false;
        }
        if (this.cleanPreviousLiveImport && atts.getLength() == 1 && "jcr:primaryType".equals(atts.getQName(0))) {
            return false;
        }
        String primaryNodeTypeName = nodeToCheck.getPrimaryNodeTypeName();
        return !this.noUpdateTypes.contains("jnt:translation".equals(primaryNodeTypeName) ? nodeToCheck.getParent().getPrimaryNodeTypeName() : primaryNodeTypeName);
    }

    private void handleBinary(Attributes atts, String decodedQName, String path, JCRNodeWrapper child) throws IOException, RepositoryException {
        if (this.liveSession != null && this.cleanPreviousLiveImport && atts.getValue("j:isSameAsLiveBinary") != null) {
            try {
                String livePath = child.getCorrespondingNodePath("live");
                JCRNodeWrapper liveNode = this.liveSession.getNode(livePath);
                if (!liveNode.hasProperty("jcr:data")) {
                    throw new RepositoryException("No binary correspondence found in existing live node.");
                }
                this.setJCRDataBinary(child, liveNode.getProperty("jcr:data").getBinary(), atts.getValue("jcr:mimeType"));
            }
            catch (RepositoryException e) {
                this.uploadFile(atts, decodedQName, path, child, "/live-content");
            }
            return;
        }
        this.uploadFile(atts, decodedQName, path, child, this.baseFilesPath);
    }

    private void uploadFile(Attributes atts, String decodedQName, String path, JCRNodeWrapper child, String basePath) throws IOException, RepositoryException {
        if (!this.expandImportedFilesOnDisk) {
            boolean contentFound = this.findContent(basePath);
            if (contentFound) {
                this.uploadFile(atts, decodedQName, path, child, this.zis);
                this.zis.close();
            }
        } else {
            String contentInExpandedPath = this.findContentInExpandedPath(basePath);
            if (contentInExpandedPath != null) {
                FileInputStream is = FileUtils.openInputStream((File)new File(this.expandedFolder + contentInExpandedPath));
                this.uploadFile(atts, decodedQName, path, child, is);
                ((InputStream)is).close();
            }
        }
    }

    private void uploadFile(Attributes atts, String decodedQName, String path, JCRNodeWrapper child, InputStream is) throws RepositoryException {
        if (child.isFile()) {
            String mime = atts.getValue("jcr:mimeType");
            if (mime == null && logger.isWarnEnabled()) {
                mime = JCRContentUtils.getMimeType(decodedQName);
                if (mime != null) {
                    logger.warn("Legacy or invalid import detected for node " + path + ", mime type cannot be resolved from file node, it should come from jcr:content node. Resolved mime type using servlet context instead=" + mime + ".");
                } else {
                    logger.warn("Legacy or invalid import detected for node " + path + ", mime type cannot be resolved from file node, it should come from jcr:content node. Tried resolving mime type using servlet context but it isn't registered!");
                }
            }
            child.getFileContent().uploadFile(is, mime);
        } else {
            this.setJCRDataBinary(child, this.session.getValueFactory().createBinary(is), atts.getValue("jcr:mimeType"));
        }
    }

    private void setJCRDataBinary(JCRNodeWrapper node, Binary binary, String mimeType) throws RepositoryException {
        node.setProperty("jcr:data", binary);
        node.setProperty("jcr:mimeType", mimeType);
        node.setProperty("jcr:lastModified", Calendar.getInstance());
    }

    private void checkDependencies(String path, String pt, Attributes atts) throws RepositoryException {
        if (path.startsWith("/modules/")) {
            ArrayList<ExtendedNodeType> nodeTypes = new ArrayList<ExtendedNodeType>();
            nodeTypes.add(NodeTypeRegistry.getInstance().getNodeType(pt));
            if (atts.getValue("jcr:mixinTypes") != null) {
                for (String mixin : atts.getValue("jcr:mixinTypes").split(" ")) {
                    nodeTypes.add(NodeTypeRegistry.getInstance().getNodeType(mixin));
                }
            }
            JCRSiteNode currentSite = this.nodes.peek().getResolveSite();
            if (this.site == null || !currentSite.getIdentifier().equals(this.site.getIdentifier())) {
                this.dependencies = null;
                this.site = currentSite;
                if (this.site.hasProperty("j:resolvedDependencies")) {
                    this.dependencies = new ArrayList<String>();
                    this.dependencies.add(this.site.getName());
                    for (int i = 0; i < this.dependencies.size(); ++i) {
                        JahiaTemplatesPackage aPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(this.dependencies.get(i));
                        if (aPackage == null) continue;
                        for (JahiaTemplatesPackage depend : aPackage.getDependencies()) {
                            if (this.dependencies.contains(depend.getId())) continue;
                            this.dependencies.add(depend.getId());
                        }
                    }
                }
            }
            for (ExtendedNodeType type : nodeTypes) {
                if (type.getTemplatePackage() == null || this.dependencies == null || this.dependencies.contains(type.getTemplatePackage().getId())) continue;
                String fileName = type.getTemplatePackage().getId();
                logger.debug("Missing dependency : " + path + " (" + type.getName() + ") requires " + fileName + this.getLocation());
                if (this.missingDependencies.contains(fileName)) continue;
                this.missingDependencies.add(fileName);
            }
        }
    }

    private void addMixins(JCRNodeWrapper child, Attributes atts) throws RepositoryException {
        String mixinTypesAttributeValue;
        LinkedHashSet<String> mixinsToAdd;
        if (child.isMarkedForDeletion()) {
            child.unmarkForDeletion();
        }
        LinkedHashSet<String> linkedHashSet = mixinsToAdd = (mixinTypesAttributeValue = atts.getValue("jcr:mixinTypes")) != null ? new LinkedHashSet<String>(Arrays.asList(StringUtils.split((String)mixinTypesAttributeValue, (String)" ,"))) : Collections.emptySet();
        if (this.cleanPreviousLiveImport && !child.isNew() && !child.isNodeType("jmix:autoPublish")) {
            Set mixinsToRemove = Arrays.stream(child.getMixinNodeTypes()).filter(mixin -> !mixinsToAdd.contains(mixin)).collect(Collectors.toSet());
            for (ExtendedNodeType mixinToRemove : mixinsToRemove) {
                child.removeMixin(mixinToRemove.getName());
            }
        }
        for (String mixinToAdd : mixinsToAdd) {
            try {
                child.addMixin(mixinToAdd);
            }
            catch (NoSuchNodeTypeException e) {
                logger.warn("Cannot add node type " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setAttributes(JCRNodeWrapper child, Attributes atts) throws RepositoryException {
        HashSet<String> processedProperties = new HashSet<String>();
        if (child.getPrimaryNodeTypeName().equals("jnt:translation")) {
            String lang = atts.getValue("jcr:language");
            child.setProperty("jcr:language", lang);
            processedProperties.add("jcr:language");
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.getURI(i).equals("http://www.w3.org/2000/xmlns/")) continue;
            String attrName = ISO9075.decode((String)atts.getQName(i));
            String attrValue = atts.getValue(i);
            boolean processed = false;
            for (AttributeProcessor attributeProcessor : this.attributeProcessors) {
                if (!attributeProcessor.process(child, attrName, attrValue)) continue;
                processed = true;
                processedProperties.addAll(attributeProcessor.getPropertyNamesProcessed());
                break;
            }
            if (processed) continue;
            for (String string : this.placeHoldersMap.keySet()) {
                if (!attrValue.contains(string)) continue;
                attrValue = attrValue.replace(string, this.placeHoldersMap.get(string));
            }
            if (this.propertiesToSkip.contains(attrName)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipping property {}", (Object)attrName);
                continue;
            }
            for (Map.Entry entry : this.replacements.entrySet()) {
                attrValue = ((Pattern)entry.getKey()).matcher(attrValue).replaceAll((String)entry.getValue());
            }
            if (attrName.equals("j:privileges") && child.isNodeType("jnt:ace")) {
                attrName = "j:roles";
                if (StringUtils.isEmpty((String)(attrValue = this.mapAclAttributes(child, attrValue)))) {
                    attrValue = "dummy-role";
                }
            }
            if ((attrName.equals("jcr:title") || attrName.equals("jcr:description")) && !child.isNodeType("mix:title")) {
                child.addMixin("mix:title");
            } else if (attrName.equals("j:defaultCategory") && !child.isNodeType("jmix:categorized")) {
                child.addMixin("jmix:categorized");
            }
            ExtendedPropertyDefinition propDef = child.getApplicablePropertyDefinition(attrName);
            if (propDef == null) {
                logger.error("Couldn't find definition for property " + attrName + " in " + child.getPrimaryNodeTypeName() + this.getLocation());
                continue;
            }
            processedProperties.add(attrName);
            if (propDef.getRequiredType() == 9 || propDef.getRequiredType() == 10) {
                String[] stringArray;
                if (attrValue.length() <= 0) continue;
                if (propDef.isMultiple()) {
                    stringArray = Patterns.SPACE.split(attrValue);
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = attrValue;
                }
                String[] stringArray3 = stringArray;
                int idx = 0;
                for (String string : stringArray3) {
                    void var15_31;
                    String string2 = JCRMultipleValueUtils.decode(string);
                    if (StringUtils.isEmpty((String)string2)) continue;
                    String string3 = this.getReferenceValue(string2, child.getPath());
                    if (attrName.equals("j:defaultCategory") && string3.startsWith("/root")) {
                        String string4 = JCRContentUtils.getSystemSitePath() + "/categories" + StringUtils.substringAfter((String)string3, (String)"/root");
                    }
                    if (!this.references.containsKey(var15_31)) {
                        this.references.put((String)var15_31, new ArrayList());
                    }
                    this.references.get(var15_31).add(child.getIdentifier() + "/" + attrName + "[" + idx++ + "]");
                }
                continue;
            }
            if (propDef.isMultiple()) {
                ArrayList<Value> values;
                String[] stringArray = "".equals(attrValue) ? new String[]{} : Patterns.SPACE.split(attrValue);
                ArrayList<Value> oldvalues = new ArrayList<Value>();
                if (child.getRealNode().hasProperty(attrName)) {
                    void var15_34;
                    Value[] oldValues;
                    Value[] valueArray = oldValues = child.getRealNode().getProperty(attrName).getValues();
                    int n = valueArray.length;
                    boolean bl = false;
                    while (var15_34 < n) {
                        Value oldValue = valueArray[var15_34];
                        oldvalues.add(oldValue);
                        ++var15_34;
                    }
                }
                if (this.cleanPreviousLiveImport) {
                    values = new ArrayList<Value>();
                    for (int j = 0; j < stringArray.length; ++j) {
                        values.add(child.getRealNode().getSession().getValueFactory().createValue(JCRMultipleValueUtils.decode(stringArray[j]), propDef.getRequiredType()));
                    }
                    if (values.equals(oldvalues)) continue;
                    child.getRealNode().setProperty(attrName, values.toArray(new Value[values.size()]));
                    continue;
                }
                values = new ArrayList(oldvalues);
                for (int j = 0; j < stringArray.length; ++j) {
                    Value value = child.getRealNode().getSession().getValueFactory().createValue(JCRMultipleValueUtils.decode(stringArray[j]), propDef.getRequiredType());
                    if (oldvalues.contains(value)) continue;
                    values.add(value);
                }
                try {
                    if (values.equals(oldvalues)) continue;
                    child.getRealNode().setProperty(attrName, values.toArray(new Value[values.size()]));
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (child.getRealNode().hasProperty(attrName) && child.getRealNode().getProperty(attrName).getString().equals(attrValue)) continue;
            if (propDef.getRequiredType() == 0) {
                child.getRealNode().setProperty(attrName, attrValue);
                continue;
            }
            child.getRealNode().setProperty(attrName, attrValue, propDef.getRequiredType());
        }
        if (this.cleanPreviousLiveImport && !child.isNew() && !child.isNodeType("jmix:autoPublish")) {
            PropertyIterator propertyIterator = child.getRealNode().getProperties();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                if (NO_LIVE_CLEANUP_FOR_PROPS.contains(property.getName()) || this.propertiesToSkip.contains(property.getName()) || ImportExportBaseService.DEFAULT_PROPERTIES_TO_IGNORE.contains(property.getName()) || processedProperties.contains(property.getName())) continue;
                property.remove();
            }
        }
    }

    private String getReferenceValue(String value, String basePath) throws RepositoryException {
        if (((String)value).startsWith("$currentSite")) {
            value = this.nodes.peek().getResolveSite().getPath() + ((String)value).substring(12);
        } else if (((String)value).startsWith("#")) {
            value = ((String)value).substring(1);
            String rootPath = ((JCRNodeWrapper)this.nodes.firstElement()).getPath();
            if (!rootPath.equals("/")) {
                value = (this.nodes.size() > 1 ? ((JCRNodeWrapper)this.nodes.get(1)).getPath() : basePath) + (String)value;
            }
        }
        return value;
    }

    private boolean findContent(String basePath) throws IOException {
        if (this.archive == null) {
            return false;
        }
        String path = (String)this.pathes.peek();
        if (path.endsWith("/jcr:content")) {
            String[] p = Patterns.SLASH.split(path);
            path = path.replace("/jcr:content", "/" + p[p.length - 2]);
        } else {
            path = JCRContentUtils.replaceColon(path);
        }
        int fileIndex = this.fileList.indexOf(basePath + path);
        if (fileIndex == -1 && path.startsWith("/content")) {
            path = path.substring("/content".length());
            fileIndex = this.fileList.indexOf(basePath + path);
        }
        if (fileIndex != -1) {
            if (this.nextEntry == null || this.fileList.indexOf("/" + this.nextEntry.getName().replace('\\', '/')) > fileIndex) {
                if (this.zis != null) {
                    this.zis.reallyClose();
                }
                this.zis = new NoCloseZipInputStream(new BufferedInputStream(this.archive.getInputStream()));
            }
            do {
                this.nextEntry = this.zis.getNextEntry();
            } while (!("/" + this.nextEntry.getName().replace('\\', '/')).equals(basePath + path));
            return true;
        }
        return false;
    }

    private String findContentInExpandedPath(String basePath) throws IOException {
        if (this.archive == null) {
            return null;
        }
        String path = (String)this.pathes.peek();
        if (path.endsWith("/jcr:content")) {
            String[] p = Patterns.SLASH.split(path);
            path = path.replace("/jcr:content", "/" + p[p.length - 2]);
        } else {
            path = JCRContentUtils.replaceColon(path);
        }
        int fileIndex = this.fileList.indexOf(basePath + path);
        if (fileIndex == -1 && path.startsWith("/content")) {
            path = path.substring("/content".length());
            fileIndex = this.fileList.indexOf(basePath + path);
        }
        if (fileIndex != -1) {
            return basePath + path;
        }
        return null;
    }

    private String mapAclAttributes(JCRNodeWrapper node, String aclValue) {
        HashSet<String> roles = new HashSet<String>();
        if (aclValue.contains("jcr:read")) {
            if (CollectionUtils.isEmpty(LegacyImportHandler.CUSTOM_FILES_READ_ROLES)) {
                roles.addAll(LegacyImportHandler.READ_ROLES);
            } else {
                roles.addAll(LegacyImportHandler.CUSTOM_FILES_READ_ROLES);
            }
        }
        if (aclValue.contains("jcr:write")) {
            if (CollectionUtils.isEmpty(LegacyImportHandler.CUSTOM_FILES_WRITE_ROLES)) {
                roles.addAll(LegacyImportHandler.WRITE_ROLES);
            } else {
                roles.addAll(LegacyImportHandler.CUSTOM_FILES_WRITE_ROLES);
            }
        }
        StringBuilder s = new StringBuilder();
        for (String role : roles) {
            s.append(role).append(" ");
        }
        return s.toString().trim();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.error > 0) {
            --this.error;
            return;
        }
        if (this.ugcLevel > 0) {
            --this.ugcLevel;
        }
        JCRNodeWrapper w = this.nodes.pop();
        this.pathes.pop();
        if (w != null && this.ignorePath != null && w.getPath().equals(this.ignorePath)) {
            this.ignorePath = null;
        }
        if (w != null && this.currentFilePath != null && w.getPath().equals(this.currentFilePath)) {
            this.currentFilePath = null;
        }
        if (w != null && w.isFile()) {
            try {
                if (!w.hasNode("jcr:content") || !w.getNode("jcr:content").hasProperty("jcr:data")) {
                    logger.warn("Cannot find the file content for the node " + w.getPath() + ". Skipping importing it.");
                    JCRNodeIteratorWrapper iterator = w.getNodes();
                    while (iterator.hasNext()) {
                        Node node = iterator.nextNode();
                        this.uuidsSet.remove(node.getIdentifier());
                    }
                    this.uuidsSet.remove(w.getIdentifier());
                    w.remove();
                }
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.zis != null) {
            try {
                this.zis.reallyClose();
            }
            catch (IOException re) {
                throw new SAXException(re);
            }
            this.zis = null;
        }
        try {
            if (this.resolveReferenceAtEnd) {
                ReferencesHelper.resolveCrossReferences(this.session, this.references, false);
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public void setReferences(Map<String, List<String>> references) {
        this.references = references;
    }

    public void setRootBehavior(int rootBehavior) {
        this.rootBehavior = rootBehavior;
    }

    public void setUuidBehavior(int uuidBehavior) {
        this.uuidBehavior = uuidBehavior;
    }

    public void setResolveReferenceAtEnd(boolean resolveReferenceAtEnd) {
        this.resolveReferenceAtEnd = resolveReferenceAtEnd;
    }

    public void setPlaceHoldersMap(Map<String, String> placeHoldersMap) {
        this.placeHoldersMap = placeHoldersMap;
    }

    public List<String> getNoUpdateTypes() {
        return this.noUpdateTypes;
    }

    public void setNoUpdateTypes(List<String> noUpdateTypes) {
        this.noUpdateTypes = noUpdateTypes;
    }

    public boolean isImportUserGeneratedContent() {
        return this.importUserGeneratedContent;
    }

    public void setImportUserGeneratedContent(boolean importUserGeneratedContent) {
        this.importUserGeneratedContent = importUserGeneratedContent;
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public boolean isReplaceMultipleValues() {
        return this.isCleanPreviousLiveImport();
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public void setReplaceMultipleValues(boolean replaceMultipleValues) {
        if (replaceMultipleValues) {
            try {
                this.cleanPreviousLiveImport();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public boolean isEnforceUuid() {
        return this.isCleanPreviousLiveImport();
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public void setEnforceUuid(boolean enforceUuid) {
        if (enforceUuid) {
            try {
                this.cleanPreviousLiveImport();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setReplacements(Map<String, String> replacements) {
        if (replacements == null || replacements.isEmpty()) {
            this.replacements = Collections.emptyMap();
        } else {
            this.replacements = new HashMap<Pattern, String>(replacements.size());
            for (Map.Entry<String, String> repl : replacements.entrySet()) {
                this.replacements.put(Pattern.compile(repl.getKey()), repl.getValue());
            }
        }
    }

    public void setAttributeProcessors(List<AttributeProcessor> attributeProcessors) {
        this.attributeProcessors = attributeProcessors;
    }

    public Set<String> getPropertiesToSkip() {
        return this.propertiesToSkip;
    }

    public void setPropertiesToSkip(Set<String> propertiesToSkip) {
        this.propertiesToSkip = propertiesToSkip == null || propertiesToSkip.isEmpty() ? Collections.emptySet() : propertiesToSkip;
    }

    public List<String> getUuids() {
        return new ArrayList<String>(this.uuidsSet);
    }

    public Set<String> getUuidsSet() {
        return this.uuidsSet;
    }

    public String getBaseFilesPath() {
        return this.baseFilesPath;
    }

    public void setBaseFilesPath(String baseFilesPath) {
        this.baseFilesPath = baseFilesPath;
    }

    public String getLocation() {
        if (this.documentLocator != null) {
            return " (line " + this.documentLocator.getLineNumber() + ", column " + this.documentLocator.getColumnNumber() + ")";
        }
        return "";
    }

    public Set<String> getMissingDependencies() {
        return this.missingDependencies;
    }

    @Override
    public void setDocumentLocator(Locator documentLocator) {
        this.documentLocator = documentLocator;
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public boolean isRemoveMixins() {
        return this.isCleanPreviousLiveImport();
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public void setRemoveMixins(boolean removeMixins) {
        if (removeMixins) {
            try {
                this.cleanPreviousLiveImport();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void configureToRestorePublicationStatuses() {
        this.propertiesToSkip.remove("j:lastPublished");
        this.propertiesToSkip.remove("j:lastPublishedBy");
        this.propertiesToSkip.remove("j:published");
    }

    public void cleanPreviousLiveImport() throws RepositoryException {
        this.cleanPreviousLiveImport = true;
        this.liveSession = JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null);
        this.configureToRestorePublicationStatuses();
        this.setUuidBehavior(4);
    }

    public boolean isCleanPreviousLiveImport() {
        return this.cleanPreviousLiveImport;
    }
}

