/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportContext {
    private static final Logger logger = LoggerFactory.getLogger(ExportContext.class);
    private boolean logProgressEnabled = false;
    private boolean collectBinariesEnabled = false;
    private long nodesToExport = 0L;
    private int exportIndex = 0;
    private long step = 0L;
    private String actualPath;
    private long startedTimeMillis = 0L;
    private final Map<String, Binary> binariesToExport = new HashMap<String, Binary>();
    private ExportContext liveExportContext;

    public ExportContext(boolean logProgressEnabled, boolean collectBinariesEnabled) {
        this.logProgressEnabled = logProgressEnabled;
        this.collectBinariesEnabled = collectBinariesEnabled;
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public ExportContext(long nodesToExport) {
        this.nodesToExport = nodesToExport;
    }

    protected void logExportXmlDocumentElementProcessed(String newPath) {
        long currentStep;
        if (!this.logProgressEnabled) {
            return;
        }
        this.actualPath = newPath;
        ++this.exportIndex;
        if (logger.isDebugEnabled()) {
            logger.debug("Index: {}, Exporting  : {}", (Object)this.exportIndex, (Object)this.actualPath);
        }
        if ((currentStep = (long)this.exportIndex * 10L / this.nodesToExport) > this.step && this.step < 9L) {
            this.step = currentStep;
            logger.info("Export {}%", (Object)(this.step * 10L));
        }
    }

    protected void logExportXmlDocumentStarted(Set<JCRNodeWrapper> sortedNodes, JCRSessionWrapper session, Set<String> nodeTypesToIgnore) throws RepositoryException {
        if (!this.logProgressEnabled) {
            return;
        }
        this.startedTimeMillis = System.currentTimeMillis();
        long result = 0L;
        ArrayList<String> extraPathsToExport = new ArrayList<String>();
        for (JCRNodeWrapper nodesToExport : sortedNodes) {
            if (nodesToExport instanceof JCRSiteNode) {
                Set<String> languages = ((JCRSiteNode)nodesToExport).getLanguages();
                List<String> sitePaths = Collections.singletonList(nodesToExport.getPath());
                result += this.estimateSubNodesNumber(sitePaths, session, nodeTypesToIgnore, null);
                if (languages == null || languages.isEmpty()) continue;
                for (String language : languages) {
                    result += this.estimateSubNodesNumber(sitePaths, session, nodeTypesToIgnore, language);
                }
                continue;
            }
            extraPathsToExport.add(nodesToExport.getPath());
        }
        int maxBatchSize = 100;
        while (!extraPathsToExport.isEmpty()) {
            int toIndex = Math.min(extraPathsToExport.size(), 100);
            List<String> paths = extraPathsToExport.subList(0, toIndex);
            result += this.estimateSubNodesNumber(paths, session, nodeTypesToIgnore, null);
            paths.clear();
        }
        this.nodesToExport = result;
        logger.info("Approximate number of nodes to export: {}, estimated in: {} seconds", (Object)this.nodesToExport, (Object)this.getDuration(this.startedTimeMillis));
    }

    protected void logExportXmlDocumentGenerated() {
        if (!this.logProgressEnabled) {
            return;
        }
        logger.info("Exported {} nodes in {} seconds", (Object)this.exportIndex, (Object)this.getDuration(this.startedTimeMillis));
    }

    protected void collectBinaryToExport(String path, Binary binary) {
        if (this.collectBinariesEnabled) {
            this.binariesToExport.put(path, binary);
        }
    }

    protected boolean isBinaryAlreadyCollected(String path, Binary binary) {
        if (!this.collectBinariesEnabled) {
            return false;
        }
        return binary != null && binary.equals(this.binariesToExport.get(path));
    }

    private long estimateSubNodesNumber(List<String> paths, JCRSessionWrapper session, Set<String> nodeTypesToIgnore, String locale) throws RepositoryException {
        if (paths.isEmpty()) {
            return 0L;
        }
        QueryManagerWrapper queryManagerWrapper = session.getWorkspace().getQueryManager();
        StringBuilder statement = new StringBuilder("SELECT count AS [rep:count(skipChecks=1)] FROM [").append(locale != null ? "jnt:translation" : "nt:base").append("] WHERE (");
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.get(i);
            if (i > 0) {
                statement.append(" OR ");
            }
            statement.append("isdescendantnode(['").append(JCRContentUtils.sqlEncode(path)).append("'])");
        }
        statement.append(")");
        if (locale == null && nodeTypesToIgnore != null && !nodeTypesToIgnore.isEmpty()) {
            statement.append("AND NOT (");
            Iterator<String> nodeTypesToIgnoreIterator = nodeTypesToIgnore.iterator();
            while (nodeTypesToIgnoreIterator.hasNext()) {
                statement.append("[jcr:primaryType] = '").append(JCRContentUtils.sqlEncode(nodeTypesToIgnoreIterator.next())).append("'");
                if (!nodeTypesToIgnoreIterator.hasNext()) continue;
                statement.append(" OR ");
            }
            statement.append(")");
        }
        if (locale != null) {
            statement.append(" AND [jcr:language] = '").append(JCRContentUtils.sqlEncode(locale)).append("'");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing query: {}", (Object)statement);
        }
        return queryManagerWrapper.createQuery(statement.toString(), "JCR-SQL2").execute().getRows().nextRow().getValue("count").getLong();
    }

    private String getDuration(long start) {
        return DateUtils.formatDurationWords(System.currentTimeMillis() - start);
    }

    public ExportContext getLiveExportContext() {
        return this.liveExportContext;
    }

    public void setLiveExportContext(ExportContext liveExportContext) {
        this.liveExportContext = liveExportContext;
    }

    public Map<String, Binary> getBinariesToExport() {
        return Collections.unmodifiableMap(this.binariesToExport);
    }

    public boolean isLogProgressEnabled() {
        return this.logProgressEnabled;
    }

    public void setLogProgressEnabled(boolean logProgressEnabled) {
        this.logProgressEnabled = logProgressEnabled;
    }

    public long getNodesToExport() {
        return this.nodesToExport;
    }

    public void setNodesToExport(long nodesToExport) {
        this.nodesToExport = nodesToExport;
    }

    public int getExportIndex() {
        return this.exportIndex;
    }

    public void setExportIndex(int exportIndex) {
        this.exportIndex = exportIndex;
    }

    public long getStep() {
        return this.step;
    }

    public void setStep(long step) {
        this.step = step;
    }

    public String getActualPath() {
        return this.actualPath;
    }

    public void setActualPath(String actualPath) {
        this.actualPath = actualPath;
    }
}

