/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.jackrabbit.commons.xml.SystemViewExporter;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaForbiddenAccessException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.BundleUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.categories.Category;
import org.jahia.services.categories.CategoryService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.interceptor.TemplateModuleInterceptor;
import org.jahia.services.content.nodetypes.JahiaCndReaderLegacy;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.deamons.filewatcher.JahiaFileWatcherService;
import org.jahia.services.importexport.AttributeProcessor;
import org.jahia.services.importexport.CategoriesImportHandler;
import org.jahia.services.importexport.DataWriter;
import org.jahia.services.importexport.DefinitionsMapping;
import org.jahia.services.importexport.DocumentViewExporter;
import org.jahia.services.importexport.DocumentViewImportHandler;
import org.jahia.services.importexport.ExportContext;
import org.jahia.services.importexport.FilesAclImportHandler;
import org.jahia.services.importexport.ImportExportService;
import org.jahia.services.importexport.ImportZipContext;
import org.jahia.services.importexport.LegacyImportHandler;
import org.jahia.services.importexport.LegacyPidMappingTool;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.services.importexport.SiteImportJob;
import org.jahia.services.importexport.UsersImportHandler;
import org.jahia.services.importexport.XMLContentTransformer;
import org.jahia.services.importexport.XMLFormatDetectionHandler;
import org.jahia.services.importexport.validation.DocumentViewValidationHandler;
import org.jahia.services.importexport.validation.SitesValidator;
import org.jahia.services.importexport.validation.SitesValidatorResult;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.services.importexport.validation.ValidationResults;
import org.jahia.services.render.RenderContext;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.sites.SiteCreationInfo;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.DateUtils;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.jahia.utils.Url;
import org.jahia.utils.xml.JahiaSAXParserFactory;
import org.jahia.utils.zip.DirectoryZipInputStream;
import org.jahia.utils.zip.DirectoryZipOutputStream;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class ImportExportBaseService
extends JahiaService
implements ImportExportService {
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_XML = "text/xml";
    public static final String REPOSITORY_XML = "repository.xml";
    public static final String LIVE_REPOSITORY_XML = "live-repository.xml";
    public static final String USERS_XML = "users.xml";
    public static final String USERS_ZIP = "users.zip";
    public static final String SERVER_PERMISSIONS_XML = "serverPermissions.xml";
    public static final String SITE_PROPERTIES = "site.properties";
    public static final String EXPORT_PROPERTIES = "export.properties";
    public static final String MOUNTS_ZIP = "mounts.zip";
    public static final String REFERENCES_ZIP = "references.zip";
    public static final String ROLES_ZIP = "roles.zip";
    public static final String STATIC_MOUNT_POINT_ATTR = "j:staticMountPointProviderKey";
    public static final String DYNAMIC_MOUNT_POINT_ATTR = "j:dynamicMountPointProviderPath";
    private static final Logger logger = LoggerFactory.getLogger(ImportExportBaseService.class);
    private static final Set<String> KNOWN_IMPORT_CONTENT_TYPES = ImmutableSet.of((Object)"application/zip", (Object)"application/xml", (Object)"text/xml");
    private static final String FILESACL_XML = "filesacl.xml";
    private static final String CATEGORIES_XML = "categories.xml";
    private static final String SITE_PERMISSIONS_XML = "sitePermissions.xml";
    private static final String DEFINITIONS_CND = "definitions.cnd";
    private static final String DEFINITIONS_MAP = "definitions.map";
    private static final FileCleaningTracker fileCleaningTracker = new FileCleaningTracker();
    private static final HashSet<String> SITE_EXPORT_NODE_TYPES_TO_IGNORE = Sets.newHashSet((Object[])new String[]{"jnt:templatesFolder", "jnt:externalUser", "jnt:workflowTask", "jmix:noImportExport"});
    private static final HashSet<String> DEFAULT_EXPORT_NODE_TYPES_TO_IGNORE = Sets.newHashSet((Object[])new String[]{"jnt:virtualsite", "jnt:workflowTask", "jmix:noImportExport"});
    static final HashSet<String> DEFAULT_PROPERTIES_TO_IGNORE = Sets.newHashSet((Object[])new String[]{"j:fullpath", "jcr:predecessors", "j:nodename", "jcr:versionHistory", "jcr:baseVersion", "jcr:isCheckedOut", "jcr:uuid", "jcr:mergeFailed"});
    private static final Pattern ALLOWED_INCLUDED_PATHS = Pattern.compile("^/(groups|settings)(/.*)?$");
    private static final Path EXPORT_PATH;
    private final long scannerInterval = SettingsBean.getInstance().getJahiaSiteImportScannerInterval();
    private final int maxBatch = SettingsBean.getInstance().getImportMaxBatch();
    private JahiaSitesService sitesService;
    private JahiaFileWatcherService fileWatcherService;
    private JCRStoreService jcrStoreService;
    private CategoryService categoryService;
    private SchedulerService schedulerService;
    private List<AttributeProcessor> attributeProcessors;
    private TemplatePackageRegistry templatePackageRegistry;
    private List<XMLContentTransformer> xmlContentTransformers;
    private Map<String, Templates> xsltTemplates = new ConcurrentHashMap<String, Templates>(2);
    private LegacyPidMappingTool legacyPidMappingTool = null;

    private ImportExportBaseService() {
    }

    public static ImportExportBaseService getInstance() {
        return Holder.INSTANCE;
    }

    public static String detectImportContentType(String declaredContentType, String fileName) {
        String contentType = declaredContentType;
        if (!KNOWN_IMPORT_CONTENT_TYPES.contains(contentType) && !KNOWN_IMPORT_CONTENT_TYPES.contains(contentType = JCRContentUtils.getMimeType(fileName))) {
            if (StringUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) {
                contentType = APPLICATION_XML;
            } else if (StringUtils.endsWithIgnoreCase((String)fileName, (String)".zip")) {
                contentType = APPLICATION_ZIP;
            } else {
                logger.error("Unable to detect the content type for file {}. It is neither a ZIP file nor an XML. Skipping import.", (Object)fileName);
            }
        }
        return contentType;
    }

    public static String updatedServerDirectoryPath(String serverDirectoryPath) throws IOException {
        if (serverDirectoryPath == null) {
            return null;
        }
        File exportPath = new File(serverDirectoryPath);
        return exportPath.getCanonicalFile().toPath().startsWith(EXPORT_PATH) ? exportPath.getCanonicalPath() : new File(EXPORT_PATH.toFile(), serverDirectoryPath).getCanonicalPath();
    }

    public static boolean isDirectoryEmpty(String pathStr) throws IOException {
        Path path = new File(pathStr).toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> entries = Files.list(path);){
                boolean bl = !entries.findFirst().isPresent();
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidServerDirectory(String serverDirectory) {
        try {
            File serverDirectoryFile = new File(serverDirectory);
            if (!serverDirectoryFile.getCanonicalFile().toPath().startsWith(EXPORT_PATH)) {
                logger.error("User is trying to export to {} which is outside the allowed location {}", (Object)serverDirectory, (Object)EXPORT_PATH);
                return false;
            }
            if (!ImportExportBaseService.isDirectoryEmpty(serverDirectory)) {
                logger.error("There are already files in the given path {}. You have to use a path, which is empty or does not exist yet.", (Object)serverDirectory);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Invalid server directory path {}", (Object)serverDirectory);
            return false;
        }
    }

    @Override
    public void start() {
        try {
            new ImportFileObserver(SettingsBean.getInstance().getJahiaImportsDiskPath(), false, this.scannerInterval, true);
            EXPORT_PATH.toFile().mkdirs();
        }
        catch (JahiaException je) {
            logger.error("exception with FilesObserver", (Throwable)je);
        }
    }

    public void setExpandImportedFilesOnDisk(boolean expandImportedFilesOnDisk) {
    }

    public void setExpandImportedFilesOnDiskPath(String expandImportedFilesOnDiskPath) {
    }

    public List<AttributeProcessor> getAttributeProcessors() {
        return this.attributeProcessors;
    }

    public void setAttributeProcessors(List<AttributeProcessor> attributeProcessors) {
        this.attributeProcessors = attributeProcessors;
    }

    @Override
    public void stop() {
    }

    public void setSitesService(JahiaSitesService sitesService) {
        this.sitesService = sitesService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setJcrStoreService(JCRStoreService jcrStoreService) {
        this.jcrStoreService = jcrStoreService;
    }

    public void setFileWatcherService(JahiaFileWatcherService fileWatcherService) {
        this.fileWatcherService = fileWatcherService;
    }

    private ImportExportService getOSGIService() {
        ImportExportService override = BundleUtils.getOsgiService(ImportExportService.class, "(jahia.core.service.override=true)");
        if (override != null) {
            logger.info("Using OSGi service override for ImportExportService");
        }
        return override;
    }

    @Override
    public void exportAll(OutputStream outputStream, Map<String, Object> params) throws JahiaException, RepositoryException, IOException, SAXException, TransformerException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.exportAll(outputStream, params);
            return;
        }
        this.exportSites(outputStream, params, this.sitesService.getSitesNodeList());
    }

    @Override
    public void exportSites(OutputStream outputStream, Map<String, Object> params, List<JCRSiteNode> sites) throws RepositoryException, IOException, SAXException, TransformerException, JahiaForbiddenAccessException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.exportSites(outputStream, params, sites);
            return;
        }
        logger.info("Sites {} export started", sites);
        long startSitesExportTime = System.currentTimeMillis();
        String serverDirectory = ImportExportBaseService.updatedServerDirectoryPath((String)params.get("serverDirectory"));
        if (serverDirectory != null && !ImportExportBaseService.isValidServerDirectory(serverDirectory)) {
            logger.error("Invalid server directory {}", (Object)serverDirectory);
            throw new JahiaForbiddenAccessException("The directory " + serverDirectory + " failed the validation check");
        }
        ZipOutputStream zout = this.getZipOutputStream(outputStream, serverDirectory);
        ZipEntry anEntry = new ZipEntry(EXPORT_PROPERTIES);
        zout.putNextEntry(anEntry);
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(zout));){
            bw.write("JahiaRelease = " + Jahia.getReleaseNumber() + "\n");
            bw.write("Patch = " + Jahia.getPatchNumber() + "\n");
            bw.write("BuildNumber = " + Jahia.getBuildNumber() + "\n");
            bw.write("ExportDate = " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date()) + "\n");
            bw.flush();
            HashSet<String> externalReferences = new HashSet<String>();
            JCRSessionWrapper session = this.jcrStoreService.getSessionFactory().getCurrentUserSession().disableSessionCache();
            this.exportSites(params, sites, serverDirectory, zout, externalReferences);
            this.exportUsers(params, serverDirectory, zout, externalReferences, session);
            this.exportRoles(params, serverDirectory, zout, externalReferences, session);
            this.exportMounts(params, zout, externalReferences, session);
            this.exportCustomPath(params, serverDirectory, zout, externalReferences, session);
            this.exportReferences(params, serverDirectory, zout, externalReferences, session);
        }
        logger.info("Total Sites {} export ended in {} seconds", sites, (Object)this.getDuration(startSitesExportTime));
    }

    private void exportSites(Map<String, Object> params, List<JCRSiteNode> sites, String serverDirectory, ZipOutputStream zout, Set<String> externalReferences) throws IOException, RepositoryException, SAXException, TransformerException {
        for (JCRSiteNode jahiaSite : sites) {
            long startSiteExportTime = System.currentTimeMillis();
            logger.info("Exporting site internal nodes {} content started", (Object)jahiaSite.getName());
            if (serverDirectory == null) {
                ZipEntry anEntry = new ZipEntry(jahiaSite.getSiteKey() + ".zip");
                zout.putNextEntry(anEntry);
                this.exportSite(jahiaSite, zout, externalReferences, params, null);
            } else {
                this.exportSite(jahiaSite, zout, externalReferences, params, serverDirectory + "/" + jahiaSite.getSiteKey());
            }
            logger.info("Exporting site internal nodes {} ended in {} seconds", (Object)jahiaSite.getName(), (Object)this.getDuration(startSiteExportTime));
        }
    }

    private void exportReferences(Map<String, Object> params, String serverDirectory, ZipOutputStream zout, Set<String> externalReferences, JCRSessionWrapper session) throws RepositoryException, IOException {
        HashSet<JCRNodeWrapper> refs = new HashSet<JCRNodeWrapper>();
        for (String reference : externalReferences) {
            JCRNodeWrapper node = session.getNodeByUUID(reference);
            if (DEFAULT_EXPORT_NODE_TYPES_TO_IGNORE.contains(node.getPrimaryNodeTypeName())) continue;
            refs.add(node);
        }
        if (!refs.isEmpty()) {
            zout.putNextEntry(new ZipEntry(REFERENCES_ZIP));
            ZipOutputStream zzout = this.getZipOutputStream(zout, serverDirectory + "/references.zip");
            try {
                logger.info("Exporting References Started");
                this.exportNodesWithBinaries(session.getRootNode(), refs, zzout, DEFAULT_EXPORT_NODE_TYPES_TO_IGNORE, externalReferences, params, true);
                logger.info("Exporting References Ended");
            }
            catch (Exception e) {
                logger.error("Cannot export References", (Throwable)e);
            }
            zzout.finish();
        }
        zout.finish();
    }

    private void exportMounts(Map<String, Object> params, ZipOutputStream zout, Set<String> externalReferences, JCRSessionWrapper session) throws RepositoryException, IOException {
        JCRNodeWrapper mounts;
        if (params.containsKey("includeMounts") && session.nodeExists("/mounts") && (mounts = session.getNode("/mounts")).hasNodes()) {
            zout.putNextEntry(new ZipEntry(MOUNTS_ZIP));
            ZipOutputStream zzout = new ZipOutputStream(zout);
            try {
                logger.info("Exporting Mount points Started");
                this.exportNodesWithBinaries(session.getRootNode(), Collections.singleton(mounts), zzout, DEFAULT_EXPORT_NODE_TYPES_TO_IGNORE, externalReferences, params, true);
                logger.info("Exporting Mount points Ended");
            }
            catch (Exception e) {
                logger.error("Cannot export mount points", (Throwable)e);
            }
            zzout.finish();
        }
    }

    private void exportCustomPath(Map<String, Object> params, String serverDirectory, ZipOutputStream zout, Set<String> externalReferences, JCRSessionWrapper session) throws IOException {
        if (params.containsKey("includePaths")) {
            ZipOutputStream zzout;
            HashSet<JCRNodeWrapper> nodes = new HashSet<JCRNodeWrapper>();
            for (String path : (String[])params.get("includePaths")) {
                if (path == null || !ALLOWED_INCLUDED_PATHS.matcher(path).matches()) {
                    logger.warn("Custom additional path: {} is not allowed to be exported, it will be ignored", (Object)path);
                    continue;
                }
                try {
                    nodes.add(session.getNode(path));
                }
                catch (RepositoryException e) {
                    logger.warn("Cannot find node at path {}, it won't be part of the export", (Object)path);
                }
            }
            if (nodes.isEmpty()) {
                logger.info("No nodes to export for custom additional paths");
                return;
            }
            if (serverDirectory == null) {
                zout.putNextEntry(new ZipEntry("customPath.zip"));
                zzout = this.getZipOutputStream(zout, null);
            } else {
                zzout = this.getZipOutputStream(zout, String.format("%s/%s", serverDirectory, "customPath"));
            }
            try {
                logger.info("Exporting custom path started");
                this.exportNodesWithBinaries(session.getRootNode(), nodes, zzout, DEFAULT_EXPORT_NODE_TYPES_TO_IGNORE, externalReferences, params, true);
                logger.info("Exporting custom path Ended");
            }
            catch (Exception e) {
                logger.error("Cannot export custom path", (Throwable)e);
            }
            zzout.finish();
        }
    }

    private void exportRoles(Map<String, Object> params, String serverDirectory, ZipOutputStream zout, Set<String> externalReferences, JCRSessionWrapper session) throws IOException {
        if (params.containsKey("includeRoles")) {
            ZipOutputStream zzout;
            String rolesPath = "roles";
            if (serverDirectory == null) {
                zout.putNextEntry(new ZipEntry(ROLES_ZIP));
                zzout = this.getZipOutputStream(zout, null);
            } else {
                zzout = this.getZipOutputStream(zout, String.format("%s/%s", serverDirectory, rolesPath));
            }
            try {
                logger.info("Exporting Roles Started");
                this.exportNodesWithBinaries(session.getRootNode(), Collections.singleton(session.getNode(String.format("/%s", rolesPath))), zzout, DEFAULT_EXPORT_NODE_TYPES_TO_IGNORE, externalReferences, params, true);
                logger.info("Exporting Roles Ended");
            }
            catch (Exception e) {
                logger.error("Cannot export roles", (Throwable)e);
            }
            zzout.finish();
        }
    }

    private void exportUsers(Map<String, Object> params, String serverDirectory, ZipOutputStream zout, Set<String> externalReferences, JCRSessionWrapper session) throws IOException {
        if (params.containsKey("includeUsers")) {
            ZipOutputStream zzout;
            String usersPath = "users";
            if (serverDirectory == null) {
                zout.putNextEntry(new ZipEntry(USERS_ZIP));
                zzout = this.getZipOutputStream(zout, null);
            } else {
                zzout = this.getZipOutputStream(zout, String.format("%s/%s", serverDirectory, usersPath));
            }
            try {
                logger.info("Exporting Users Started");
                this.exportNodesWithBinaries(session.getRootNode(), Collections.singleton(session.getNode(String.format("/%s", usersPath))), zzout, DEFAULT_EXPORT_NODE_TYPES_TO_IGNORE, externalReferences, params, true);
                logger.info("Exporting Users Ended");
            }
            catch (IOException e) {
                logger.warn("Cannot export due to some IO exception :{}", (Object)e.getMessage());
            }
            catch (Exception e) {
                logger.error("Cannot export Users", (Throwable)e);
            }
            zzout.finish();
        }
    }

    private ZipOutputStream getZipOutputStream(OutputStream outputStream, String serverDirectory) {
        if (serverDirectory != null) {
            File serverDirectoryFile = new File(serverDirectory);
            if (serverDirectoryFile.mkdirs()) {
                return new DirectoryZipOutputStream(serverDirectoryFile, outputStream);
            }
            logger.error("Unable to create directory {}. Check permission", (Object)serverDirectory);
            throw new JahiaRuntimeException("Unable to create directory");
        }
        return new ZipOutputStream(outputStream);
    }

    private void exportSite(JCRSiteNode site, OutputStream out, Set<String> externalReferences, Map<String, Object> params, String serverDirectory) throws RepositoryException, SAXException, IOException, TransformerException {
        ZipOutputStream zout = this.getZipOutputStream(out, serverDirectory);
        zout.putNextEntry(new ZipEntry(SITE_PROPERTIES));
        this.exportSiteInfos(zout, site);
        JCRSessionWrapper session = this.jcrStoreService.getSessionFactory().getCurrentUserSession().disableSessionCache();
        JCRNodeWrapper node = session.getNode(String.format("/sites/%s", site.getSiteKey()));
        Set<JCRNodeWrapper> nodes = Collections.singleton(node);
        this.exportNodesWithBinaries(session.getRootNode(), nodes, zout, SITE_EXPORT_NODE_TYPES_TO_IGNORE, externalReferences, params, true);
        zout.finish();
    }

    @Override
    public void exportZip(JCRNodeWrapper node, JCRNodeWrapper exportRoot, OutputStream out, Map<String, Object> params) throws RepositoryException, SAXException, IOException, TransformerException, JahiaForbiddenAccessException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.exportZip(node, exportRoot, out, params);
            return;
        }
        String serverDirectory = (String)params.get("serverDirectory");
        if (serverDirectory != null && !ImportExportBaseService.isValidServerDirectory(serverDirectory)) {
            logger.error("Invalid server directory {}", (Object)serverDirectory);
            throw new JahiaRuntimeException("The directory " + serverDirectory + " failed the validation check");
        }
        ZipOutputStream zout = this.getZipOutputStream(out, serverDirectory);
        HashSet<JCRNodeWrapper> nodes = new HashSet<JCRNodeWrapper>();
        nodes.add(node);
        this.exportNodesWithBinaries(exportRoot == null ? node : exportRoot, nodes, zout, new HashSet<String>(), null, params, false);
        zout.finish();
    }

    @Override
    public void exportNode(JCRNodeWrapper node, JCRNodeWrapper exportRoot, OutputStream out, Map<String, Object> params) throws RepositoryException, SAXException, IOException, TransformerException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.exportNode(node, exportRoot, out, params);
            return;
        }
        TreeSet<JCRNodeWrapper> nodes = new TreeSet<JCRNodeWrapper>(Comparator.comparing(JCRNodeWrapper::getPath));
        nodes.add(node);
        this.exportNodes(exportRoot == null ? node : exportRoot, nodes, out, new HashSet<String>(), null, params, new ExportContext(false, false));
    }

    @Override
    public void exportDocumentView(JCRNodeWrapper node, ContentHandler handler, boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.exportDocumentView(node, handler, skipBinary, noRecurse);
            return;
        }
        new DocumentViewExporter(node.getSession(), handler, skipBinary, noRecurse).export(node);
    }

    private void exportNodesWithBinaries(JCRNodeWrapper rootNode, Set<JCRNodeWrapper> nodes, ZipOutputStream zout, Set<String> typesToIgnore, Set<String> externalReferences, Map<String, Object> params, boolean logProgress) throws SAXException, IOException, RepositoryException, TransformerException {
        if (params.containsKey("filesToZip")) {
            String[] filesToZip = (String[])params.get("filesToZip");
            byte[] buffer = new byte[4096];
            HashSet<String> exportedFiles = new HashSet<String>();
            for (String file : filesToZip) {
                try {
                    String basePath = rootNode.getParent().getPath();
                    this.zipFiles(StringUtils.equals((String)basePath, (String)"/") ? "" : basePath, zout, buffer, exportedFiles, rootNode.getSession().getNode(file));
                }
                catch (Throwable e) {
                    logger.warn("Unable to add {} to zip file", (Object)file);
                }
            }
            return;
        }
        TreeSet<JCRNodeWrapper> liveSortedNodes = new TreeSet<JCRNodeWrapper>(Comparator.comparing(JCRNodeWrapper::getPath));
        ExportContext liveExportContext = null;
        if (params.containsKey("includeLive") && params.get("includeLive") != null && Boolean.TRUE.equals(params.get("includeLive"))) {
            JCRSessionWrapper liveSession = this.jcrStoreService.getSessionFactory().getCurrentUserSession("live").disableSessionCache();
            try {
                JCRNodeWrapper liveRootNode = liveSession.getNodeByIdentifier(rootNode.getIdentifier());
                for (JCRNodeWrapper node : nodes) {
                    try {
                        liveSortedNodes.add(liveSession.getNodeByIdentifier(node.getIdentifier()));
                    }
                    catch (ItemNotFoundException e) {
                        logger.debug("Item not found in live while exporting {}", (Object)e.getMessage());
                    }
                }
                if (!liveSortedNodes.isEmpty()) {
                    logger.info("Exporting live workspace for nodes {} ...", nodes);
                    zout.putNextEntry(new ZipEntry(LIVE_REPOSITORY_XML));
                    liveExportContext = new ExportContext(logProgress, true);
                    this.exportNodes(liveRootNode, liveSortedNodes, zout, typesToIgnore, externalReferences, params, liveExportContext);
                    zout.closeEntry();
                    this.exportNodesBinary("/live-content", liveExportContext, zout);
                    logger.info("Live workspace exported for nodes {}", nodes);
                }
            }
            catch (RepositoryException e) {
                logger.debug("Item not found in live while exporting {}", (Object)e.getMessage());
            }
        }
        TreeSet<JCRNodeWrapper> sortedNodes = new TreeSet<JCRNodeWrapper>(Comparator.comparing(JCRNodeWrapper::getPath));
        sortedNodes.addAll(nodes);
        for (JCRNodeWrapper liveSortedNode : liveSortedNodes) {
            try {
                sortedNodes.add(rootNode.getSession().getNodeByIdentifier(liveSortedNode.getIdentifier()));
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        logger.info("Exporting default workspace for nodes {} ...", nodes);
        zout.putNextEntry(new ZipEntry(REPOSITORY_XML));
        ExportContext defaultExportContext = new ExportContext(logProgress, true);
        defaultExportContext.setLiveExportContext(liveExportContext);
        this.exportNodes(rootNode, sortedNodes, zout, typesToIgnore, externalReferences, params, defaultExportContext);
        zout.closeEntry();
        this.exportNodesBinary("/content", defaultExportContext, zout);
        logger.info("Default workspace exported for nodes {}", nodes);
    }

    private void zipFiles(String basePath, ZipOutputStream zout, byte[] buffer, Set<String> exportedFiles, JCRNodeWrapper fileNode) throws RepositoryException {
        if (fileNode.isNodeType("nt:file")) {
            block14: {
                if (exportedFiles.contains(fileNode.getIdentifier())) {
                    return;
                }
                exportedFiles.add(fileNode.getIdentifier());
                try {
                    if (!fileNode.hasNode("jcr:content")) {
                        logger.debug("Node {} of type will not be part of the zip ", (Object)fileNode.getPath(), (Object)fileNode.getPrimaryNodeTypeName());
                        return;
                    }
                    JCRNodeWrapper child2 = fileNode.getNode("jcr:content");
                    JCRPropertyWrapper property = child2.getProperty("jcr:data");
                    if (!child2.getProvider().canExportProperty(property)) break block14;
                    try (InputStream is = property.getBinary().getStream();){
                        if (is != null) {
                            int bytesIn;
                            String path = fileNode.getPath().substring(basePath.length());
                            zout.putNextEntry(new ZipEntry(path.substring(1)));
                            while ((bytesIn = is.read(buffer)) != -1) {
                                zout.write(buffer, 0, bytesIn);
                            }
                        }
                    }
                }
                catch (IOException | AssertionError | RepositoryException e) {
                    logger.warn("Unable to export {}", (Object)fileNode.getPath());
                }
            }
            return;
        }
        if (exportedFiles.contains(fileNode.getIdentifier())) {
            return;
        }
        fileNode.getNodes().forEach(child -> {
            try {
                this.zipFiles(basePath, zout, buffer, exportedFiles, (JCRNodeWrapper)child);
            }
            catch (RepositoryException e) {
                logger.warn("Unable to read file {}", (Object)child.getPath());
            }
        });
    }

    private void exportNodes(JCRNodeWrapper rootNode, TreeSet<JCRNodeWrapper> sortedNodes, OutputStream outputStream, Set<String> typesToIgnore, Set<String> externalReferences, Map<String, Object> params, ExportContext exportContext) throws IOException, RepositoryException, SAXException, TransformerException {
        exportContext.logExportXmlDocumentStarted(sortedNodes, rootNode.getSession(), typesToIgnore);
        String xsl = (String)params.get("xsl_path");
        boolean skipBinary = !Boolean.FALSE.equals(params.get("skipBinary"));
        boolean noRecurse = Boolean.TRUE.equals(params.get("noRecurse"));
        OutputStream tmpOut = outputStream;
        if (xsl != null) {
            String filename = Patterns.SPACE.matcher(rootNode.getName()).replaceAll("_");
            File tempFile = File.createTempFile("exportTemplates-" + filename, ".xml");
            tmpOut = new DeferredFileOutputStream(0xA00000, tempFile);
        }
        DataWriter dw = new DataWriter(new OutputStreamWriter(tmpOut, StandardCharsets.UTF_8));
        if (Boolean.TRUE.equals(params.get("systemView"))) {
            SystemViewExporter exporter = new SystemViewExporter((Session)rootNode.getSession(), (ContentHandler)dw, !noRecurse, !skipBinary);
            exporter.export((Node)rootNode);
        } else {
            this.exportNodesUsingDocumentViewExporter(rootNode, sortedNodes, typesToIgnore, externalReferences, params, exportContext, skipBinary, noRecurse, dw);
        }
        exportContext.logExportXmlDocumentGenerated();
        dw.flush();
        if (xsl != null) {
            try (DeferredFileOutputStream stream = (DeferredFileOutputStream)tmpOut;
                 InputStream inputStream = stream.isInMemory() ? new ByteArrayInputStream(stream.getData()) : new BufferedInputStream(new FileInputStream(stream.getFile()));){
                fileCleaningTracker.track(stream.getFile(), (Object)inputStream);
                Transformer transformer = this.getTransformer(xsl);
                long startXmlCleanup = System.currentTimeMillis();
                if (exportContext.isLogProgressEnabled()) {
                    logger.info("Starting cleanup transformation ...");
                    transformer.transform(new StreamSource(inputStream), new StreamResult(outputStream));
                    logger.info("Cleanup transformation finished in {} seconds", (Object)this.getDuration(startXmlCleanup));
                } else {
                    transformer.transform(new StreamSource(inputStream), new StreamResult(outputStream));
                }
            }
        }
    }

    private void exportNodesUsingDocumentViewExporter(JCRNodeWrapper rootNode, TreeSet<JCRNodeWrapper> sortedNodes, Set<String> typesToIgnore, Set<String> externalReferences, Map<String, Object> params, ExportContext exportContext, boolean skipBinary, boolean noRecurse, DataWriter dw) throws RepositoryException, SAXException {
        DocumentViewExporter exporter = new DocumentViewExporter(rootNode.getSession(), dw, skipBinary, noRecurse);
        exporter.setExportContext(exportContext);
        if (externalReferences != null) {
            exporter.setExternalReferences(externalReferences);
        }
        typesToIgnore.add("rep:system");
        if (params.containsKey("includeLive")) {
            exporter.configureForLiveExport();
        }
        exporter.setTypesToIgnore(typesToIgnore);
        exporter.export(rootNode, sortedNodes);
        sortedNodes.addAll(exporter.getNodesList());
    }

    private Transformer getTransformer(String xsl) throws TransformerConfigurationException {
        Templates templates = this.xsltTemplates.get(xsl);
        if (templates == null) {
            templates = new TransformerFactoryImpl().newTemplates((Source)new StreamSource(new File(xsl)));
            this.xsltTemplates.put(xsl, templates);
        }
        return templates.newTransformer();
    }

    private void exportNodesBinary(String basePath, ExportContext exportContext, ZipOutputStream zout) throws IOException {
        long startExportingNodesBinary = System.currentTimeMillis();
        logger.info("Exporting binary nodes ...");
        byte[] buffer = new byte[4096];
        for (Map.Entry<String, Binary> binaryToExport : exportContext.getBinariesToExport().entrySet()) {
            try {
                InputStream is = binaryToExport.getValue().getStream();
                try {
                    int bytesIn;
                    if (is == null) continue;
                    String path = basePath + binaryToExport.getKey();
                    zout.putNextEntry(new ZipEntry(path.substring(1)));
                    while ((bytesIn = is.read(buffer)) != -1) {
                        zout.write(buffer, 0, bytesIn);
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (AssertionError | RepositoryException ex) {
                logger.warn("Cannot export {}", (Object)binaryToExport.getKey(), ex);
            }
        }
        logger.info("Binary nodes exported in {} seconds", (Object)this.getDuration(startExportingNodesBinary));
    }

    private void exportSiteInfos(OutputStream out, JCRSiteNode s) throws IOException {
        OrderedProperties p = new OrderedProperties();
        p.setProperty("sitetitle", s.getTitle());
        p.setProperty("siteservername", s.getServerName());
        p.setProperty("siteservernamealiases", StringUtils.join(s.getServerNameAliases(), (String)", "));
        p.setProperty("sitekey", s.getSiteKey());
        p.setProperty("description", Objects.requireNonNullElse(s.getDescr(), ""));
        p.setProperty("templatePackageName", s.getTemplateFolder());
        p.setProperty("mixLanguage", Boolean.toString(s.isMixLanguagesActive()));
        p.setProperty("defaultLanguage", s.getDefaultLanguage());
        int i = 1;
        for (String string : s.getInstalledModules()) {
            p.setProperty("installedModules." + i++, string);
        }
        Set<String> v = s.getLanguages();
        for (String sls : v) {
            p.setProperty("language." + sls + ".activated", s.getInactiveLiveLanguages().contains(sls) ? "false" : "true");
            p.setProperty("language." + sls + ".mandatory", "" + s.getMandatoryLanguages().contains(sls));
        }
        for (String sls : s.getInactiveLanguages()) {
            p.setProperty("language." + sls + ".disabledCompletely", "true");
        }
        try {
            JahiaSite jahiaSite = this.sitesService.getDefaultSite(s.getSession());
            if (jahiaSite != null && jahiaSite.getSiteKey().equals(s.getName())) {
                p.setProperty("defaultSite", "true");
            }
        }
        catch (RepositoryException repositoryException) {
            logger.error(repositoryException.getMessage(), (Throwable)repositoryException);
        }
        p.store(out, "");
    }

    @Override
    public void importSiteZip(JCRNodeWrapper nodeWrapper) throws RepositoryException, IOException, JahiaException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importSiteZip(nodeWrapper);
            return;
        }
        String uri = nodeWrapper.getPath();
        JCRNodeWrapper contentNode = nodeWrapper.getNode("jcr:content");
        try (ZipInputStream zis = new ZipInputStream(contentNode.getProperty("jcr:data").getBinary().getStream());){
            this.importSiteZip(zis, uri, null, nodeWrapper.getSession());
        }
    }

    @Override
    public void importSiteZip(File file, JCRSessionWrapper session) throws RepositoryException, IOException, JahiaException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importSiteZip(file, session);
            return;
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(file));){
            this.importSiteZip(zis, null, null, session);
        }
    }

    @Override
    public void importSiteZip(Resource file) throws RepositoryException, IOException, JahiaException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importSiteZip(file);
            return;
        }
        this.importSiteZip(file, null);
    }

    @Override
    public void importSiteZip(Resource file, JCRSessionWrapper session) throws RepositoryException, IOException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            try {
                overrideService.importSiteZip(file, session);
            }
            catch (JahiaException e) {
                throw new RepositoryException((Throwable)e);
            }
            return;
        }
        try (ZipInputStream zis = new ZipInputStream(file.getInputStream());){
            this.importSiteZip(zis, null, file, session);
        }
    }

    private void importSiteZip(ZipInputStream zis2, String uri, Resource fileImport, JCRSessionWrapper session) throws IOException {
        boolean serverNameEx;
        boolean siteKeyEx;
        Properties infos;
        block5: {
            ZipEntry z;
            infos = new Properties();
            while ((z = zis2.getNextEntry()) != null) {
                if (!SITE_PROPERTIES.equals(z.getName())) continue;
                infos.load(zis2);
                zis2.closeEntry();
            }
            siteKeyEx = false;
            serverNameEx = false;
            try {
                siteKeyEx = "".equals(infos.get("sitekey")) || this.sitesService.siteExists((String)infos.get("sitekey"), session);
                String serverName = (String)infos.get("siteservername");
                String serverNameAliases = (String)infos.get("siteservernamealiases");
                boolean bl = serverNameEx = "".equals(serverName) || !Url.isLocalhost(serverName) && this.sitesService.getSiteByServerName(serverName, session) != null;
                if (serverNameEx || !StringUtils.isNotEmpty((String)serverNameAliases)) break block5;
                for (String alias : StringUtils.split((String)serverNameAliases, (String)", ")) {
                    if (Url.isLocalhost(alias) || this.sitesService.getSiteByServerName(alias, session) == null) continue;
                    serverNameEx = true;
                    break;
                }
            }
            catch (RepositoryException e) {
                logger.error("Error when getting site", (Throwable)e);
            }
        }
        if (!siteKeyEx && !serverNameEx) {
            this.performSiteImport(uri, fileImport, session, infos);
        }
    }

    private void performSiteImport(final String uri, final Resource fileImport, JCRSessionWrapper session, final Properties infos) {
        String tpl = (String)infos.get("templatePackageName");
        if ("".equals(tpl)) {
            tpl = null;
        }
        try {
            final Locale finalLocale = this.getFinalLocale(infos);
            final String finalTpl = tpl;
            try {
                JCRObservationManager.doWithOperationType(session, 13, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        try {
                            SiteCreationInfo siteCreationInfo = SiteCreationInfo.builder().siteKey(infos.getProperty("sitekey")).serverName(infos.getProperty("siteservername")).serverNameAliases(infos.getProperty("siteservernamealiases")).title(infos.getProperty("sitetitle")).description(infos.getProperty("description")).templateSet(finalTpl).modulesToDeploy(null).locale(finalLocale != null ? finalLocale.toString() : null).siteAdmin(JCRSessionFactory.getInstance().getCurrentUser()).firstImport(fileImport != null ? "fileImport" : "importRepositoryFile").fileImport(fileImport).fileImportName(uri).originatingJahiaRelease(infos.getProperty("originatingJahiaRelease")).build();
                            JahiaSite site = ImportExportBaseService.this.sitesService.addSite(siteCreationInfo, session);
                            ImportExportBaseService.this.importSiteProperties(site, infos, session);
                        }
                        catch (IOException | JahiaException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                if (e.getCause() != null && (e.getCause() instanceof JahiaException || e.getCause() instanceof IOException)) {
                    throw (Exception)e.getCause();
                }
            }
        }
        catch (Exception e) {
            logger.error("Cannot create site " + infos.get("sitetitle"), (Throwable)e);
        }
    }

    private Locale getFinalLocale(Properties infos) {
        Locale locale = null;
        if (infos.getProperty("defaultLanguage") != null) {
            locale = LanguageCodeConverters.languageCodeToLocale(infos.getProperty("defaultLanguage"));
        } else {
            for (Object obj : infos.keySet()) {
                String s = (String)obj;
                if (!s.startsWith("language.") || !s.endsWith(".rank")) continue;
                String code = s.substring(s.indexOf(46) + 1, s.lastIndexOf(46));
                String rank = infos.getProperty(s);
                if (!rank.equals("1")) continue;
                locale = LanguageCodeConverters.languageCodeToLocale(code);
            }
        }
        return locale;
    }

    @Override
    public void importSiteZip(Resource file, JahiaSite site, Map<Object, Object> infos) throws RepositoryException, IOException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importSiteZip(file, site, infos);
            return;
        }
        this.importSiteZip(file, site, infos, null, null);
    }

    @Override
    public void importSiteZip(Resource file, JahiaSite site, Map<Object, Object> infos, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath) throws RepositoryException, IOException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importSiteZip(file, site, infos, legacyMappingFilePath, legacyDefinitionsFilePath);
            return;
        }
        this.importSiteZip(file, site, infos, legacyMappingFilePath, legacyDefinitionsFilePath, this.jcrStoreService.getSessionFactory().getCurrentUserSession(null, null, null));
    }

    public void importSiteZip(Resource file, JahiaSite site, Map<Object, Object> infos, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath, JCRSessionWrapper session) throws RepositoryException, IOException {
        long timerSite = System.currentTimeMillis();
        logger.info("Start import for site {}", (Object)(site != null ? site.getSiteKey() : ""));
        CategoriesImportHandler categoriesImportHandler = new CategoriesImportHandler();
        UsersImportHandler usersImportHandler = new UsersImportHandler(site, session);
        boolean legacyImport = false;
        List<String[]> catProps = null;
        try (ImportZipContext importZipContext = this.initImportZipContext(file);){
            Map<String, String> pathMapping = this.getRegisteredModulesPathMapping(session);
            if (importZipContext.getLoadedImportDescriptorNames().contains(USERS_XML)) {
                importZipContext.executeWithImportDescriptors(Collections.singleton(USERS_XML), (inputStream, name, previousDescriptorResult) -> this.importUsers(inputStream, usersImportHandler, USERS_XML));
            }
            if (importZipContext.getLoadedImportDescriptorNames().stream().anyMatch(s -> s.startsWith("export_"))) {
                legacyImport = true;
            }
            if (importZipContext.getLoadedImportDescriptorNames().contains(SITE_PROPERTIES) && site != null && !site.getSiteKey().equals("systemsite")) {
                importZipContext.executeWithImportDescriptors(Collections.singleton(SITE_PROPERTIES), (inputStream, name, previousDescriptorResult) -> {
                    this.importSiteProperties(inputStream, site, session);
                    return null;
                });
            }
            if (importZipContext.getLoadedImportDescriptorNames().contains(REPOSITORY_XML)) {
                if (site != null && !"systemsite".equals(site.getSiteKey())) {
                    this.checkSiteKeyMapping(importZipContext, site, session, pathMapping);
                }
                this.importZip(null, importZipContext, 0, session, (Set<String>)Sets.newHashSet((Object[])new String[]{USERS_XML, CATEGORIES_XML}), true);
            } else if (site != null) {
                pathMapping.put("/", "/sites/" + site.getSiteKey() + "/files/");
            }
            catProps = this.importAdditionalFilesIfPresentInArchiveOrPerformLegacyImportIfNeeded(importZipContext, site, infos, legacyMappingFilePath, legacyDefinitionsFilePath, session, timerSite, categoriesImportHandler, legacyImport, catProps, pathMapping);
            categoriesImportHandler.setUuidProps(catProps);
            session.save(13);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Done importing site {} in {}", (Object)(site != null ? site.getSiteKey() : ""), (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerSite));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String[]> importAdditionalFilesIfPresentInArchiveOrPerformLegacyImportIfNeeded(ImportZipContext importZipContext, JahiaSite site, Map<Object, Object> infos, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath, JCRSessionWrapper session, long timerSite, CategoriesImportHandler categoriesImportHandler, boolean legacyImport, List<String[]> catProps, Map<String, String> pathMapping) throws IOException, RepositoryException {
        NodeTypeRegistry reg = NodeTypeRegistry.getInstance();
        DefinitionsMapping mapping = null;
        if (!importZipContext.getLoadedImportDescriptorNames().contains(REPOSITORY_XML) || importZipContext.getLoadedImportDescriptorNames().contains(SITE_PROPERTIES) || importZipContext.getLoadedImportDescriptorNames().contains(CATEGORIES_XML) || importZipContext.getLoadedImportDescriptorNames().contains(SITE_PERMISSIONS_XML) || importZipContext.getLoadedImportDescriptorNames().contains(DEFINITIONS_CND) || importZipContext.getLoadedImportDescriptorNames().contains(DEFINITIONS_MAP)) {
            ZipInputStream zis = ImportExportBaseService.getZipInputStream(importZipContext.getArchive());
            try {
                ZipEntry zipentry;
                while ((zipentry = zis.getNextEntry()) != null) {
                    String name = zipentry.getName();
                    if (name.indexOf(92) > -1) {
                        name = name.replace('\\', '/');
                    }
                    if (name.indexOf(47) > -1) {
                        this.importBinaryFileFromOldSiteArchiveFormat(site, session, importZipContext.getLoadedImportDescriptorNames(), pathMapping, zis, zipentry, name);
                    } else if (name.equals(CATEGORIES_XML)) {
                        catProps = this.importCategoriesAndGetUuidProps(zis, categoriesImportHandler);
                    } else if (name.equals(DEFINITIONS_CND)) {
                        reg = this.getSafeNodeTypeRegistryFromLegacyArchive(importZipContext.getArchive(), legacyImport, zis, zipentry);
                    } else if (name.equals(DEFINITIONS_MAP)) {
                        mapping = new DefinitionsMapping();
                        mapping.load(zis);
                    }
                    zis.closeEntry();
                }
            }
            finally {
                ImportExportBaseService.closeInputStream(zis);
            }
        }
        if (legacyImport) {
            this.performLegacyImport(importZipContext.getArchive(), site, infos, legacyMappingFilePath, legacyDefinitionsFilePath, session, timerSite, importZipContext.getLoadedContentFilePaths(), reg, mapping);
        }
        return catProps;
    }

    private NodeTypeRegistry getSafeNodeTypeRegistryFromLegacyArchive(Resource file, boolean legacyImport, ZipInputStream zis, ZipEntry zipentry) throws IOException {
        NodeTypeRegistry reg = new NodeTypeRegistry();
        try {
            for (Map.Entry<String, File> entry : NodeTypeRegistry.getSystemDefinitionsFiles().entrySet()) {
                reg.addDefinitionsFile(entry.getValue(), entry.getKey());
            }
            if (legacyImport) {
                JahiaCndReaderLegacy r = new JahiaCndReaderLegacy(new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8), zipentry.getName(), file.getURL().getPath(), reg);
                r.parse();
            } else {
                reg.addDefinitionsFile((Resource)new InputStreamResource((InputStream)zis, zipentry.getName()), file.getURL().getPath());
            }
        }
        catch (RepositoryException | ParseException e) {
            logger.error(e.getMessage(), e);
        }
        return reg;
    }

    private void importBinaryFileFromOldSiteArchiveFormat(JahiaSite site, JCRSessionWrapper session, Collection<String> importDescriptors, Map<String, String> pathMapping, ZipInputStream zis, ZipEntry zipentry, String name) throws RepositoryException {
        if (!importDescriptors.contains(REPOSITORY_XML) && !importDescriptors.contains(FILESACL_XML)) {
            name = this.convertOldEntryName(pathMapping, name);
            if (!zipentry.isDirectory()) {
                try {
                    String filename = name.substring(name.lastIndexOf(47) + 1);
                    this.ensureFile(session, name, zis, JCRContentUtils.getMimeType(filename), site);
                }
                catch (Exception e) {
                    logger.error("Cannot upload file " + zipentry.getName(), (Throwable)e);
                }
            } else {
                this.ensureDir(session, name, site);
            }
        }
    }

    private String convertOldEntryName(Map<String, String> pathMapping, String name) {
        if (((String)(name = "/" + (String)name)).startsWith("/content/sites")) {
            name = pathMapping.get("/") + StringUtils.stripStart((String)((String)name).replaceFirst("/content/sites/[^/]+/files/", ""), (String)"/");
        } else if (((String)name).startsWith("/users")) {
            Matcher m = Pattern.compile("/users/([^/]+)(/.*)?").matcher((CharSequence)name);
            if (m.matches()) {
                name = ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(m.group(1));
                name = (String)name + "/files" + (m.group(2) != null ? m.group(2) : "");
            }
        } else if (((String)name).startsWith("/content/users")) {
            Matcher m = Pattern.compile("/content/users/([^/]+)(/.*)?").matcher((CharSequence)name);
            if (m.matches()) {
                name = ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(m.group(1));
                name = (String)name + (m.group(2) != null ? m.group(2) : "");
            }
        } else {
            name = pathMapping.get("/") + StringUtils.stripStart((String)name, (String)"/");
        }
        return name;
    }

    private void checkSiteKeyMapping(ImportZipContext importZipContext, JahiaSite site, JCRSessionWrapper session, Map<String, String> pathMapping) throws IOException, RepositoryException {
        logger.info("Check if site node: {} need mapping with siteKey in repository.xml", (Object)site.getSiteKey());
        long timer = System.currentTimeMillis();
        importZipContext.executeWithImportDescriptors(Collections.singleton(REPOSITORY_XML), (inputStream, name, previousDescriptorResult) -> {
            DocumentViewValidationHandler h = new DocumentViewValidationHandler();
            h.setSession(session);
            SitesValidator sitesValidator = new SitesValidator();
            h.setValidators(Collections.singletonList(sitesValidator));
            this.handleImport(inputStream, h, REPOSITORY_XML);
            Map<String, Properties> sites = ((SitesValidatorResult)sitesValidator.getResult()).getSitesProperties();
            for (String siteKeyInImport : sites.keySet()) {
                if ("systemsite".equals(siteKeyInImport)) continue;
                if (siteKeyInImport.equals(site.getSiteKey())) break;
                logger.info("Mapping siteKey from import XML: {} to site node: {}", (Object)siteKeyInImport, (Object)site.getSiteKey());
                pathMapping.put("/sites/" + siteKeyInImport + "/", "/sites/" + site.getSiteKey() + "/");
                break;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Done checking siteKey mapping in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
            }
            return null;
        });
    }

    private Map<String, String> getRegisteredModulesPathMapping(JCRSessionWrapper session) {
        Map<String, String> pathMapping = session.getPathMapping();
        for (JahiaTemplatesPackage pkg : this.templatePackageRegistry.getRegisteredModules().values()) {
            String key = "/modules/" + pkg.getId() + "/";
            pathMapping.computeIfAbsent(key, s -> "/modules/" + pkg.getId() + "/" + pkg.getVersion() + "/");
        }
        return pathMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLegacyImport(Resource file, JahiaSite site, Map<Object, Object> infos, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath, JCRSessionWrapper session, long timerSite, List<String> fileList, NodeTypeRegistry reg, DefinitionsMapping mapping) throws IOException, RepositoryException {
        long timerLegacy = System.currentTimeMillis();
        String originatingJahiaRelease = (String)infos.get("originatingJahiaRelease");
        logger.info("Start legacy import, source version is {}", (Object)originatingJahiaRelease);
        if (legacyMappingFilePath != null) {
            mapping = new DefinitionsMapping();
            try (InputStream fileInputStream = legacyMappingFilePath.getInputStream();){
                mapping.load(fileInputStream);
            }
        }
        if (legacyDefinitionsFilePath != null) {
            reg = this.getLegacyNodeTypeRegistry(file, legacyDefinitionsFilePath, originatingJahiaRelease);
        }
        JCRNodeWrapper siteFolder = session.getNode("/sites/" + site.getSiteKey());
        NoCloseZipInputStream zis = new NoCloseZipInputStream(new BufferedInputStream(file.getInputStream()));
        try {
            ZipEntry zipentry;
            int legacyImportHandlerCtnId = 1;
            while ((zipentry = zis.getNextEntry()) != null) {
                String name = zipentry.getName();
                if (name.equals(FILESACL_XML)) {
                    logger.info("Importing file filesacl.xml");
                    this.importFilesAcl(site, file, zis, mapping, fileList);
                } else if (name.startsWith("export")) {
                    logger.info("Importing file {}", (Object)name);
                    String languageCode = name.indexOf(95) != -1 ? name.substring(7, name.lastIndexOf(46)) : site.getLanguagesAsLocales().iterator().next().toString();
                    zipentry.getSize();
                    LegacyImportHandler importHandler = new LegacyImportHandler(session, siteFolder, reg, mapping, LanguageCodeConverters.languageCodeToLocale(languageCode), infos != null ? originatingJahiaRelease : null, this.legacyPidMappingTool, legacyImportHandlerCtnId);
                    LinkedHashMap<String, List<String>> references = new LinkedHashMap<String, List<String>>();
                    importHandler.setReferences(references);
                    InputStream documentInput = this.getDocumentInput(file, site, timerSite, zis, name, languageCode);
                    this.handleImport(documentInput, importHandler, name);
                    legacyImportHandlerCtnId = importHandler.getCtnId();
                    ReferencesHelper.resolveCrossReferences(session, references);
                    siteFolder.getSession().save(13);
                }
                zis.closeEntry();
            }
            ReferencesHelper.resolveReferencesKeeper(session);
            siteFolder.getSession().save(13);
        }
        finally {
            ImportExportBaseService.closeInputStream(zis);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Done legacy import in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerLegacy));
        }
    }

    private InputStream getDocumentInput(Resource file, JahiaSite site, long timerSite, ZipInputStream zis, String name, String languageCode) throws IOException {
        InputStream documentInput = zis;
        if (this.xmlContentTransformers != null && !this.xmlContentTransformers.isEmpty()) {
            documentInput = new ZipInputStream(file.getInputStream());
            while (!name.equals(documentInput.getNextEntry().getName())) {
            }
            byte[] buffer = new byte[2048];
            File tmpDirectoryForSite = new File(new File(System.getProperty("java.io.tmpdir"), "jahia-migration"), FastDateFormat.getInstance((String)"yyyy_MM_dd-HH_mm_ss_SSS").format(timerSite) + "_" + site.getSiteKey());
            tmpDirectoryForSite.mkdirs();
            File document = new File(tmpDirectoryForSite, "export_" + languageCode + "_00_extracted.xml");
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(document), 2048);){
                int count = 0;
                while ((count = ((InputStream)documentInput).read(buffer, 0, 2048)) > 0) {
                    ((OutputStream)output).write(buffer, 0, count);
                }
                ((OutputStream)output).flush();
            }
            ((InputStream)documentInput).close();
            for (XMLContentTransformer xct : this.xmlContentTransformers) {
                document = xct.transform(document, tmpDirectoryForSite);
            }
            documentInput = new FileInputStream(document);
        }
        return documentInput;
    }

    private NodeTypeRegistry getLegacyNodeTypeRegistry(Resource file, Resource legacyDefinitionsFilePath, String originatingJahiaRelease) throws IOException, RepositoryException {
        NodeTypeRegistry reg = new NodeTypeRegistry();
        if ("6.1".equals(originatingJahiaRelease)) {
            logger.info("Loading the built in 6.1 definitions before processing the provided custom ones");
            List<String> builtInLegacyDefs = Arrays.asList("01-system-nodetypes.cnd", "02-jahiacore-nodetypes.cnd", "03-files-nodetypes.cnd", "04-jahiacontent-nodetypes.cnd", "05-standard-types.cnd", "10-extension-nodetypes.cnd", "11-preferences-nodetypes.cnd");
            Iterator iterator = builtInLegacyDefs.iterator();
            while (iterator.hasNext()) {
                String builtInLegacyDefsFile = (String)iterator.next();
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/jahia/migration/legacyDefinitions/jahia6/" + builtInLegacyDefsFile);
                try {
                    if (inputStream != null) {
                        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                            JahiaCndReaderLegacy r = new JahiaCndReaderLegacy(inputStreamReader, builtInLegacyDefsFile, file.getURL().getPath(), reg);
                            r.parse();
                        }
                        catch (ParseException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    logger.error("Couldn't load {}", (Object)builtInLegacyDefsFile);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        } else {
            try {
                for (Map.Entry<String, File> entry : NodeTypeRegistry.getSystemDefinitionsFiles().entrySet()) {
                    reg.addDefinitionsFile(entry.getValue(), entry.getKey());
                }
            }
            catch (ParseException e) {
                logger.error("Cannot parse definitions : " + e.getMessage(), (Throwable)e);
            }
        }
        try (InputStreamReader streamReader = new InputStreamReader(legacyDefinitionsFilePath.getInputStream(), StandardCharsets.UTF_8);){
            JahiaCndReaderLegacy r = new JahiaCndReaderLegacy(streamReader, legacyDefinitionsFilePath.getFilename(), file.getURL().getPath(), reg);
            r.parse();
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return reg;
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public void cleanFilesList(File expandedFolder) {
        if (expandedFolder == null) {
            return;
        }
        long timer = System.currentTimeMillis();
        logger.info("Start cleaning files expanded to {}", (Object)expandedFolder);
        try {
            FileUtils.deleteDirectory((File)expandedFolder);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Done file cleanup in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
        }
    }

    public JCRNodeWrapper ensureDir(JCRSessionWrapper session, String path, JahiaSite site) throws RepositoryException {
        JCRNodeWrapper dir;
        block11: {
            try {
                dir = session.getNode(path);
                String current = path;
                while (current.lastIndexOf(47) > 0) {
                    JCRNodeWrapper currentNode = session.getNode(current);
                    if ("jnt:virtualsite".equals(currentNode.getPrimaryNodeTypeName())) {
                        if (!currentNode.getName().equals(site.getSiteKey())) {
                            String newName = current.substring(0, current.lastIndexOf(47)) + "/" + site.getSiteKey();
                            session.getPathMapping().put(current, newName);
                            path = path.replace(current, newName);
                            return this.ensureDir(session, path, site);
                        }
                        break;
                    }
                    int endIndex = current.lastIndexOf(47);
                    current = current.substring(0, endIndex);
                }
            }
            catch (PathNotFoundException pnfe) {
                int endIndex = path.lastIndexOf(47);
                if (endIndex == -1) {
                    logger.warn("Cannot create folder {}", (Object)path);
                    return null;
                }
                JCRNodeWrapper parentDir = this.ensureDir(session, path.substring(0, endIndex), site);
                if (parentDir == null) {
                    return null;
                }
                if (parentDir.isNodeType("jnt:virtualsitesFolder")) {
                    dir = parentDir.getNode(site.getSiteKey());
                }
                try {
                    String dirName = path.substring(path.lastIndexOf(47) + 1);
                    if (!StringUtils.isEmpty((String)dirName)) {
                        session.checkout(parentDir);
                        JCRNodeWrapper createdDir = parentDir.createCollection(dirName);
                        createdDir.saveSession();
                    }
                }
                catch (RepositoryException e) {
                    logger.error("RepositoryException", (Throwable)e);
                }
                dir = session.getNode(path);
                if (!logger.isDebugEnabled()) break block11;
                logger.debug("Folder created {}", (Object)path);
            }
        }
        return dir;
    }

    public void ensureFile(JCRSessionWrapper session, String path, InputStream inputStream, String type, JahiaSite destSite) {
        String name = path.substring(path.lastIndexOf(47) + 1);
        try {
            JCRNodeWrapper parentDir = this.ensureDir(session, path.substring(0, path.lastIndexOf(47)), destSite);
            if (parentDir == null) {
                return;
            }
            if (!parentDir.hasNode(name)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Add file to {}", (Object)parentDir.getPath());
                }
                try {
                    if (!parentDir.isCheckedOut()) {
                        session.checkout(parentDir);
                    }
                    JCRNodeWrapper res = parentDir.uploadFile(name, inputStream, type);
                    if (logger.isDebugEnabled()) {
                        logger.debug("File added -> {}", (Object)res);
                    }
                    res.saveSession();
                }
                catch (RepositoryException e) {
                    logger.error("RepositoryException", (Throwable)e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Try to add file {} - already exists", (Object)path);
            }
        }
        catch (RepositoryException e) {
            logger.debug("Cannot add file", (Throwable)e);
        }
    }

    private void importSiteProperties(InputStream is, JahiaSite site, JCRSessionWrapper session) throws IOException {
        logger.info("Loading properties for site {}", (Object)site.getSiteKey());
        long timer = System.currentTimeMillis();
        Properties p = new Properties();
        p.load(is);
        this.importSiteProperties(site, p, session);
        logger.info("Done loading properties for site {} in {}", (Object)site.getSiteKey(), (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFilesAcl(JahiaSite site, Resource file, InputStream is, DefinitionsMapping mapping, List<String> fileList) {
        HashMap<String, File> filePath = new HashMap<String, File>();
        File temp = null;
        try {
            Path tempPath = Files.createTempDirectory("migration", new FileAttribute[0]);
            temp = tempPath.toFile();
            ZipInputStream zis = ImportExportBaseService.getZipInputStream(file);
            try {
                ZipEntry zipentry;
                while ((zipentry = zis.getNextEntry()) != null) {
                    String fileName = zipentry.getName();
                    if (!zipentry.isDirectory()) {
                        fileName = fileName.replace('\\', '/');
                        File newFile = new File(temp, fileName);
                        newFile.getParentFile().mkdirs();
                        FileUtils.copyInputStreamToFile((InputStream)zis, (File)newFile);
                        filePath.put("/" + fileName, newFile);
                    }
                    zis.closeEntry();
                }
            }
            finally {
                ImportExportBaseService.closeInputStream(zis);
            }
            this.handleImport(is, new FilesAclImportHandler(site, mapping, file, fileList, filePath), file.getFilename());
        }
        catch (IOException e) {
            try {
                logger.error("Cannot extract zip", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(temp);
                throw throwable;
            }
            FileUtils.deleteQuietly((File)temp);
        }
        FileUtils.deleteQuietly((File)temp);
    }

    private void importSiteProperties(JahiaSite site, Properties p, JCRSessionWrapper session) {
        Set<Object> keys = p.keySet();
        HashSet<String> languages = new HashSet<String>();
        HashSet<String> inactiveLanguages = new HashSet<String>();
        HashSet<String> inactiveLiveLanguages = new HashSet<String>();
        HashSet<String> mandatoryLanguages = new HashSet<String>();
        List<String> installedModules = site.getInstalledModules();
        try {
            installedModules = this.sitesService.getSiteByKey(site.getSiteKey(), session).getInstalledModules();
        }
        catch (RepositoryException e) {
            logger.error("Cannot get installed modules ", (Throwable)e);
        }
        String templateSet = site.getTemplateFolder();
        JahiaTemplateManagerService templateManagerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        try {
            if (!installedModules.contains(templateSet)) {
                templateManagerService.installModule(templateManagerService.getAnyDeployedTemplatePackage(templateSet), "/sites/" + site.getSiteKey(), session);
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot deploy module " + templateSet, (Throwable)e);
        }
        String defaultLanguage = null;
        String lowestRankLanguage = null;
        int currentRank = 0;
        ArrayList<JahiaTemplatesPackage> modules = new ArrayList<JahiaTemplatesPackage>();
        block24: for (Object key : keys) {
            String property = (String)key;
            String value = p.getProperty(property);
            StringTokenizer st = new StringTokenizer(property, ".");
            String firstKey = st.nextToken();
            try {
                switch (firstKey) {
                    case "language": {
                        String lang = st.nextToken();
                        if (languages.contains(lang)) continue block24;
                        this.addNewLanguageToCorrectSet(p, languages, inactiveLanguages, inactiveLiveLanguages, mandatoryLanguages, lang);
                        if (inactiveLanguages.contains(lang) || !StringUtils.isEmpty((String)lowestRankLanguage) && !p.containsKey("language." + lang + ".rank")) continue block24;
                        int langRank = NumberUtils.toInt((String)p.getProperty("language." + lang + ".rank"));
                        if (currentRank != 0 && langRank >= currentRank) continue block24;
                        currentRank = langRank;
                        lowestRankLanguage = lang;
                        break;
                    }
                    case "defaultLanguage": {
                        defaultLanguage = value;
                        break;
                    }
                    case "mixLanguage": {
                        site.setMixLanguagesActive(Boolean.parseBoolean(value));
                        break;
                    }
                    case "allowsUnlistedLanguages": {
                        site.setAllowsUnlistedLanguages(Boolean.parseBoolean(value));
                        break;
                    }
                    case "description": {
                        site.setDescription(value);
                        break;
                    }
                    case "installedModules": {
                        if (installedModules.contains(value) || templateSet.equals(value)) continue block24;
                        JahiaTemplatesPackage pkg = templateManagerService.getAnyDeployedTemplatePackage(value);
                        if (pkg != null) {
                            modules.add(pkg);
                            break;
                        }
                        logger.info("unable to find module {} in deployed modules", (Object)value);
                        break;
                    }
                    default: {
                        if (!firstKey.startsWith("defaultSite") || !"true".equals(value) || this.sitesService.getDefaultSite(session) != null) continue block24;
                        this.sitesService.setDefaultSite(site, session);
                    }
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot set site property  " + firstKey, (Throwable)e);
            }
        }
        ListOrderedSet siteLangs = ListOrderedSet.decorate(new LinkedList(languages));
        if (!siteLangs.isEmpty()) {
            site.setLanguages((Set<String>)siteLangs);
            site.setInactiveLanguages(inactiveLanguages);
            site.setInactiveLiveLanguages(inactiveLiveLanguages);
            site.setMandatoryLanguages(mandatoryLanguages);
            if (defaultLanguage == null) {
                defaultLanguage = StringUtils.isEmpty(lowestRankLanguage) ? (String)siteLangs.iterator().next() : lowestRankLanguage;
            }
            site.setDefaultLanguage(defaultLanguage);
        } else {
            logger.error("Unable to find site languages in the provided site.properties descriptor. Skip importing site settings.");
        }
        try {
            templateManagerService.installModules(modules, "/sites/" + site.getSiteKey(), session);
            session.save();
        }
        catch (RepositoryException e) {
            logger.error("Cannot deploy module " + modules, (Throwable)e);
        }
    }

    private void addNewLanguageToCorrectSet(Properties p, Set<String> languages, Set<String> inactiveLanguages, Set<String> inactiveLiveLanguages, Set<String> mandatoryLanguages, String lang) {
        languages.add(lang);
        if (!Boolean.parseBoolean(p.getProperty("language." + lang + ".activated", "true"))) {
            inactiveLiveLanguages.add(lang);
        }
        if (Boolean.parseBoolean(p.getProperty("language." + lang + ".disabledCompletely", "false"))) {
            inactiveLanguages.add(lang);
            languages.remove(lang);
        }
        if (Boolean.parseBoolean(p.getProperty("language." + lang + ".mandatory", "false"))) {
            mandatoryLanguages.add(lang);
        }
    }

    private List<String[]> importCategoriesAndGetUuidProps(InputStream is, CategoriesImportHandler importHandler) {
        this.handleImport(is, importHandler, null);
        return importHandler.getUuidProps();
    }

    @Override
    public void importCategories(Category rootCategory, InputStream is) {
        CategoriesImportHandler importHandler = new CategoriesImportHandler();
        importHandler.setRootCategory(rootCategory);
        this.importCategoriesAndGetUuidProps(is, importHandler);
    }

    @Override
    public List<String[]> importUsers(final File file) throws IOException, RepositoryException {
        try (final BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            List<String[]> list = JCRTemplate.getInstance().doExecuteWithLongSystemSession(new JCRCallback<List<String[]>>(){

                @Override
                public List<String[]> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    List<String[]> l = ImportExportBaseService.this.importUsers(is, new UsersImportHandler(session), file.getName());
                    session.save();
                    return l;
                }
            });
            return list;
        }
    }

    private List<String[]> importUsers(InputStream is, UsersImportHandler importHandler, String fileName) {
        long timer = System.currentTimeMillis();
        logger.info("Start importing users");
        this.handleImport(is, importHandler, fileName);
        logger.info("Done importing users in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
        return importHandler.getUuidProps();
    }

    private void handleImport(InputStream is, DefaultHandler h, String fileName) {
        try {
            DocumentViewImportHandler dh;
            SAXParser parser = JahiaSAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, h);
            if (h instanceof DocumentViewImportHandler && !(dh = (DocumentViewImportHandler)h).getMissingDependencies().isEmpty()) {
                for (String s : dh.getMissingDependencies()) {
                    logger.error("Dependency not declared : {} (set debug on DocumentViewImportHandler for more details)", (Object)s);
                }
            }
        }
        catch (SAXParseException e) {
            logger.error("Cannot import - File contains invalid XML", (Throwable)e);
            throw new RuntimeException("Cannot import " + (fileName != null ? fileName : "") + " file as it contains invalid XML", e);
        }
        catch (Exception e) {
            logger.error("Cannot import", (Throwable)e);
            throw new RuntimeException("Cannot import " + (fileName != null ? fileName : "") + " file", e);
        }
    }

    public int detectXmlFormat(InputStream is) {
        XMLFormatDetectionHandler handler = new XMLFormatDetectionHandler();
        try {
            SAXParser parser = JahiaSAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler.getType();
    }

    @Override
    public void importXML(String parentNodePath, InputStream content, int rootBehavior) throws IOException, RepositoryException, JahiaException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importXML(parentNodePath, content, rootBehavior);
            return;
        }
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession().disableSessionCache();
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        this.importXML(parentNodePath, content, rootBehavior, references, session);
        ReferencesHelper.resolveCrossReferences(session, references);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importXML(String parentNodePath, InputStream content, int rootBehavior, Map<String, List<String>> references, JCRSessionWrapper session) throws IOException, RepositoryException, JahiaException {
        File tempFile = null;
        try {
            int format;
            tempFile = File.createTempFile("import-xml-", ".xml");
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)content, (OutputStream)fileOutputStream);
            }
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(tempFile));){
                format = this.detectXmlFormat(inputStream);
            }
            switch (format) {
                case 2: {
                    try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(tempFile));){
                        session.importXML(parentNodePath, is, 0, rootBehavior, null, references);
                        session.save(13);
                        return;
                    }
                    catch (IOException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                }
                case 4: {
                    this.importUsers(tempFile);
                    return;
                }
                case 5: {
                    Category cat = this.categoryService.getCategoryByPath(parentNodePath);
                    try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(tempFile));){
                        this.importCategories(cat, is);
                        return;
                    }
                }
            }
            return;
        }
        finally {
            if (tempFile != null) {
                Files.delete(tempFile.toPath());
            }
        }
    }

    @Override
    public void importZip(String parentNodePath, Resource file, int rootBehavior) throws IOException, RepositoryException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importZip(parentNodePath, file, rootBehavior);
            return;
        }
        JCRSessionWrapper session = this.jcrStoreService.getSessionFactory().getCurrentUserSession().disableSessionCache();
        this.importZip(parentNodePath, file, rootBehavior, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidationResults validateImportFile(JCRSessionWrapper session, InputStream is, String contentType, List<String> installedModules) {
        ImportExportService override = this.getOSGIService();
        if (override != null) {
            return override.validateImportFile(session, is, contentType, installedModules);
        }
        DocumentViewValidationHandler documentViewValidationHandler = (DocumentViewValidationHandler)SpringContextSingleton.getBean("DocumentViewValidationHandler");
        if (installedModules != null && !installedModules.isEmpty()) {
            documentViewValidationHandler.initDependencies(installedModules.get(0), installedModules.size() > 1 ? installedModules.subList(1, installedModules.size()) : null);
        }
        documentViewValidationHandler.setSession(session);
        if (contentType.equals(APPLICATION_ZIP)) {
            this.validateImportZip(is, documentViewValidationHandler);
        } else {
            try {
                this.handleImport(is, documentViewValidationHandler, null);
            }
            catch (Exception e) {
                ValidationResults results = new ValidationResults();
                results.addResult(new ValidationResult.FailedValidationResult(e));
                ValidationResults validationResults = results;
                return validationResults;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return documentViewValidationHandler.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateImportZip(InputStream is, DocumentViewValidationHandler documentViewValidationHandler) {
        long maxSize = SettingsBean.getInstance().getLong("zipFile.maxSize", 0x6400000L);
        int maxEntries = SettingsBean.getInstance().getInt("zipFile.maxEntriesCount", 1024);
        int BUFFER = 4096;
        File tempFile = null;
        ZipFile zipFile = null;
        try {
            tempFile = File.createTempFile("import", ".zip");
            FileUtils.copyToFile((InputStream)is, (File)tempFile);
            zipFile = new ZipFile(tempFile);
            int entries = 0;
            long totalSize = 0L;
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                if (entries++ > maxEntries) {
                    throw new IllegalStateException("Too many files/directories to unzip.");
                }
                ZipArchiveEntry entry = (ZipArchiveEntry)e.nextElement();
                String name = this.validateZipName(entry.getName());
                if (entry.isDirectory()) continue;
                try (InputStream eis = zipFile.getInputStream(entry);){
                    byte[] data = new byte[4096];
                    int size = 0;
                    while ((size = eis.read(data, 0, 4096)) != -1) {
                        if ((totalSize += (long)size) <= maxSize) continue;
                        throw new IllegalStateException("Zip file being extracted is too big.");
                    }
                }
                if (!name.endsWith("xml")) continue;
                InputStream zis = zipFile.getInputStream(entry);
                try {
                    this.handleImport(zis, documentViewValidationHandler, name);
                }
                finally {
                    if (zis == null) continue;
                    zis.close();
                }
            }
        }
        catch (IOException e) {
            try {
                logger.error("Cannot import", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly((File)tempFile);
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
            FileUtils.deleteQuietly((File)tempFile);
            IOUtils.closeQuietly((Closeable)zipFile);
        }
        FileUtils.deleteQuietly((File)tempFile);
        IOUtils.closeQuietly((Closeable)zipFile);
    }

    private String validateZipName(String filename) throws IOException {
        String canonicalID;
        String canonicalPath = new File(filename).getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID = new File(".").getCanonicalPath()) && canonicalPath.length() > canonicalID.length()) {
            return canonicalPath.substring(canonicalID.length() + 1);
        }
        throw new IllegalStateException("File is outside extraction target directory.");
    }

    @Override
    public void importZip(String parentNodePath, Resource file, int rootBehaviour, JCRSessionWrapper session) throws IOException, RepositoryException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importZip(parentNodePath, file, rootBehaviour, session);
            return;
        }
        this.importZip(parentNodePath, file, rootBehaviour, session, null, true);
    }

    @Override
    public void importZip(String parentNodePath, Resource file, int rootBehaviour, JCRSessionWrapper session, Set<String> filesToIgnore, boolean useReferenceKeeper) throws IOException, RepositoryException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importZip(parentNodePath, file, rootBehaviour, session, filesToIgnore, useReferenceKeeper);
            return;
        }
        try (ImportZipContext importZipContext = this.initImportZipContext(file);){
            this.importZip(parentNodePath, importZipContext, rootBehaviour, session, filesToIgnore, useReferenceKeeper);
        }
    }

    @Override
    public void importZip(String parentNodePath, ImportZipContext importZipContext, int rootBehaviour, JCRSessionWrapper session, Set<String> filesToIgnore, boolean useReferenceKeeper) throws IOException, RepositoryException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            overrideService.importZip(parentNodePath, importZipContext, rootBehaviour, session, filesToIgnore, useReferenceKeeper);
            return;
        }
        long timer = System.currentTimeMillis();
        if (filesToIgnore == null) {
            filesToIgnore = Collections.emptySet();
        }
        logger.info("Start importing file {} into path {} ", (Object)importZipContext.getArchive(), (Object)(parentNodePath != null ? parentNodePath : "/"));
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        Map<String, String> pathMapping = this.getRegisteredModulesPathMapping(session);
        boolean importLive = !filesToIgnore.contains(LIVE_REPOSITORY_XML) && importZipContext.getLoadedImportDescriptorNames().contains(LIVE_REPOSITORY_XML);
        List liveUuids = null;
        if (importLive) {
            int finalRootBehaviour = rootBehaviour;
            liveUuids = importZipContext.executeWithImportDescriptors(Collections.singleton(LIVE_REPOSITORY_XML), (inputStream, name, previousDescriptorResult) -> {
                long timerLive = System.currentTimeMillis();
                logger.info("Start importing live-repository.xml");
                final List<String> importedLiveUUIDs = this.importLiveRepository(parentNodePath, importZipContext, finalRootBehaviour, session, references, inputStream);
                logger.debug("Resolving cross-references for live-repository.xml");
                ReferencesHelper.resolveCrossReferences(session, references, useReferenceKeeper, true);
                logger.debug("Saving JCR session for live-repository.xml");
                session.save(13);
                logger.debug("Publishing...");
                final JCRPublicationService publicationService = ServicesRegistry.getInstance().getJCRPublicationService();
                JCRObservationManager.doWithOperationType(null, 13, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        publicationService.publish(importedLiveUUIDs, "default", "live", false, false, null);
                        return null;
                    }
                });
                logger.debug("publishing done, adding version labels...");
                String label = "published_at_" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss").format(Calendar.getInstance().getTime());
                JCRVersionService.getInstance().addVersionLabel(importedLiveUUIDs, label, "live");
                logger.info("Done importing live-repository.xml in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerLive));
                return importedLiveUUIDs;
            });
            if (rootBehaviour == 2) {
                rootBehaviour = 1;
            }
        }
        this.importDefaultRepository(parentNodePath, importZipContext, rootBehaviour, session, filesToIgnore, references, importLive, liveUuids);
        this.resolveReferences(session, useReferenceKeeper, references);
        if (importLive) {
            this.importUserGeneratedContent(parentNodePath, importZipContext, rootBehaviour, pathMapping);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Done importing file {} in {}", (Object)importZipContext.getArchive(), (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
        }
    }

    private void importUserGeneratedContent(String parentNodePath, ImportZipContext importZipContext, int rootBehaviour, Map<String, String> pathMapping) throws IOException, RepositoryException {
        if (this.jcrStoreService.getSessionFactory().getCurrentUser() == null) {
            return;
        }
        importZipContext.executeWithImportDescriptors(Collections.singleton(LIVE_REPOSITORY_XML), (inputStream, name, previousDescriptorResult) -> {
            long timerUGC = System.currentTimeMillis();
            logger.info("Start importing user generated content");
            JCRSessionWrapper liveSession = this.jcrStoreService.getSessionFactory().getCurrentUserSession("live").disableSessionCache();
            DocumentViewImportHandler documentViewImportHandler = new DocumentViewImportHandler(liveSession, parentNodePath, importZipContext.getArchive(), importZipContext.getLoadedContentFilePaths());
            documentViewImportHandler.setImportUserGeneratedContent(true);
            documentViewImportHandler.setRootBehavior(rootBehaviour);
            documentViewImportHandler.setBaseFilesPath("/live-content");
            documentViewImportHandler.setAttributeProcessors(this.attributeProcessors);
            liveSession.getPathMapping().putAll(pathMapping);
            this.handleImport(inputStream, documentViewImportHandler, LIVE_REPOSITORY_XML);
            logger.debug("Saving JCR session for UGC");
            liveSession.save(13);
            if (logger.isInfoEnabled()) {
                logger.info("Done importing user generated content in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerUGC));
            }
            return null;
        });
    }

    private void importDefaultRepository(String parentNodePath, ImportZipContext importZipContext, int rootBehaviour, JCRSessionWrapper session, Set<String> filesToIgnore, Map<String, List<String>> references, boolean livePreviouslyImported, List<String> liveUuids) throws IOException, RepositoryException {
        importZipContext.executeWithImportDescriptors(importZipContext.getLoadedImportDescriptorNames(), (inputStream, name, previousDescriptorResult) -> {
            if (name.equals(REPOSITORY_XML) && !filesToIgnore.contains(name)) {
                long timerDefault = System.currentTimeMillis();
                logger.info("Start importing repository.xml");
                DocumentViewImportHandler documentViewImportHandler = new DocumentViewImportHandler(session, parentNodePath, importZipContext.getArchive(), importZipContext.getLoadedContentFilePaths());
                if (livePreviouslyImported) {
                    documentViewImportHandler.cleanPreviousLiveImport();
                }
                documentViewImportHandler.setReferences(references);
                documentViewImportHandler.setRootBehavior(rootBehaviour);
                documentViewImportHandler.setAttributeProcessors(this.attributeProcessors);
                this.handleImport(inputStream, documentViewImportHandler, REPOSITORY_XML);
                if (livePreviouslyImported && liveUuids != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Removing %s uuids from %s uuids", documentViewImportHandler.getUuidsSet().size(), liveUuids.size()));
                    }
                    liveUuids.removeAll(documentViewImportHandler.getUuidsSet());
                    for (int i = liveUuids.size() - 1; i >= 0; --i) {
                        block12: {
                            String uuid = (String)liveUuids.get(i);
                            try {
                                JCRNodeWrapper nodeToRemove = session.getNodeByIdentifier(uuid);
                                nodeToRemove.remove();
                            }
                            catch (InvalidItemStateException | ItemNotFoundException ex) {
                                if (!logger.isDebugEnabled()) break block12;
                                logger.debug("Node to remove has already been removed", ex);
                            }
                        }
                        if (i % this.maxBatch != 0) continue;
                        session.save(13);
                        session.refresh(false);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Saving JCR session for {}", (Object)REPOSITORY_XML);
                }
                session.save(13);
                session.refresh(false);
                if (logger.isInfoEnabled()) {
                    logger.info("Done importing {} in {}", (Object)REPOSITORY_XML, (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerDefault));
                }
            } else if (name.endsWith(".xml") && !name.equals(REPOSITORY_XML) && !name.equals(LIVE_REPOSITORY_XML) && !filesToIgnore.contains(name)) {
                long timerOther = System.currentTimeMillis();
                logger.info("Start importing {}", (Object)name);
                String thisPath = (parentNodePath != null ? this.getParentNodePath(parentNodePath) : "") + StringUtils.substringBefore((String)name, (String)".xml");
                this.importXML(thisPath, inputStream, rootBehaviour, references, session);
                logger.debug("Saving JCR session for {}", (Object)name);
                session.save(13);
                session.refresh(false);
                if (logger.isInfoEnabled()) {
                    logger.info("Done importing {} in {}", (Object)name, (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timerOther));
                }
            }
            return null;
        });
    }

    private void resolveReferences(JCRSessionWrapper session, boolean useReferenceKeeper, Map<String, List<String>> references) throws RepositoryException {
        RenderContext r = TemplateModuleInterceptor.renderContextThreadLocal.get();
        TemplateModuleInterceptor.renderContextThreadLocal.remove();
        ReferencesHelper.resolveCrossReferences(session, references, useReferenceKeeper);
        TemplateModuleInterceptor.renderContextThreadLocal.set(r);
        session.save(13);
    }

    private List<String> importLiveRepository(String parentNodePath, ImportZipContext importZipContext, int rootBehaviour, JCRSessionWrapper session, Map<String, List<String>> references, InputStream is) throws IOException, RepositoryException {
        DocumentViewImportHandler documentViewImportHandler = new DocumentViewImportHandler(session, parentNodePath, importZipContext.getArchive(), importZipContext.getLoadedContentFilePaths());
        documentViewImportHandler.setReferences(references);
        documentViewImportHandler.setRootBehavior(rootBehaviour);
        documentViewImportHandler.setBaseFilesPath("/live-content");
        documentViewImportHandler.setAttributeProcessors(this.attributeProcessors);
        documentViewImportHandler.configureToRestorePublicationStatuses();
        this.handleImport(is, documentViewImportHandler, LIVE_REPOSITORY_XML);
        logger.debug("Saving JCR session for live-repository.xml");
        session.save(13);
        return documentViewImportHandler.getUuids();
    }

    private String getParentNodePath(String parentNodePath) {
        return parentNodePath + (parentNodePath.endsWith("/") ? "" : "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="8.2.1.0", forRemoval=true)
    public File getFileList(Resource file, Map<String, Long> sizes, List<String> fileList, boolean forceClean) throws IOException {
        File newlyExpandedFolder = null;
        if (this.settingsBean.isExpandImportedFilesOnDisk()) {
            File expandFolder = ImportExportBaseService.getExpandFolder(file, this.settingsBean.getExpandImportedFilesOnDiskPath());
            if (forceClean) {
                FileUtils.deleteDirectory((File)expandFolder);
            }
            if (!expandFolder.exists()) {
                FileUtils.forceMkdir((File)expandFolder);
                newlyExpandedFolder = expandFolder;
            }
        }
        ZipInputStream zis = ImportExportBaseService.getZipInputStream(file);
        try {
            ZipEntry zipentry;
            while ((zipentry = zis.getNextEntry()) != null) {
                String name = zipentry.getName().replace('\\', '/');
                if (newlyExpandedFolder != null) {
                    ImportExportBaseService.expandZipEntryInExpandedFolderTarget(newlyExpandedFolder, zis, zipentry, name);
                }
                if (name.endsWith(".xml")) {
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(zis));){
                        long i = 0L;
                        while (br.readLine() != null) {
                            ++i;
                        }
                        sizes.put(name, i);
                    }
                } else {
                    sizes.put(name, zipentry.getSize());
                }
                if (name.contains("/")) {
                    fileList.add("/" + name);
                }
                zis.closeEntry();
            }
        }
        finally {
            ImportExportBaseService.closeInputStream(zis);
        }
        return newlyExpandedFolder;
    }

    private static void expandZipEntryInExpandedFolderTarget(File expandedFolder, ZipInputStream zis, ZipEntry zipentry, String name) throws IOException {
        File importedFile = new File(expandedFolder + File.separator + name);
        if (!importedFile.getCanonicalPath().startsWith(expandedFolder.getCanonicalPath() + File.separator)) {
            throw new IOException("Zip entry is outside of the 'expandedFolder' directory. Potential Zip file attack averted.");
        }
        if (zipentry.isDirectory()) {
            FileUtils.forceMkdir((File)importedFile);
        } else {
            long timer = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Expanding {} into {}", (Object)zipentry.getName(), (Object)importedFile);
            }
            FileUtils.forceMkdir((File)importedFile.getParentFile());
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(importedFile), 65536);){
                IOUtils.copyLarge((InputStream)zis, (OutputStream)output);
                if (logger.isDebugEnabled()) {
                    logger.debug("Expanded {} in {}", (Object)zipentry.getName(), (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
                }
            }
        }
    }

    public static File getExpandFolder(Resource file, String expandImportedFilesOnDiskPath) throws IOException {
        return new File(expandImportedFilesOnDiskPath + File.separator + "import-" + Base64.getEncoder().encodeToString(file.getURL().toString().getBytes(StandardCharsets.UTF_8)));
    }

    private static void closeInputStream(ZipInputStream zis) throws IOException {
        if (zis instanceof NoCloseZipInputStream) {
            ((NoCloseZipInputStream)zis).reallyClose();
        } else {
            zis.close();
        }
    }

    private static ZipInputStream getZipInputStream(Resource file) throws IOException {
        ZipInputStream zis = !file.isReadable() && file instanceof FileSystemResource ? new DirectoryZipInputStream(file.getFile()) : new NoCloseZipInputStream(new BufferedInputStream(file.getInputStream()));
        return zis;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public void setXmlContentTransformers(List<XMLContentTransformer> xmlContentTransformers) {
        this.xmlContentTransformers = xmlContentTransformers;
    }

    public void setLegacyPidMappingTool(LegacyPidMappingTool legacyPidMappingTool) {
        this.legacyPidMappingTool = legacyPidMappingTool;
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public void setPostImportPatcher(Object postImportPatcher) {
    }

    public void setTemplatePackageRegistry(TemplatePackageRegistry templatePackageRegistry) {
        this.templatePackageRegistry = templatePackageRegistry;
    }

    private String getDuration(long start) {
        return DateUtils.formatDurationWords(System.currentTimeMillis() - start);
    }

    @Override
    public ImportZipContext initImportZipContext(Resource file) throws IOException {
        ImportExportService overrideService = this.getOSGIService();
        if (overrideService != null) {
            return overrideService.initImportZipContext(file);
        }
        return new ImportZipContextImpl(file);
    }

    static {
        Path exportsPath = null;
        try {
            exportsPath = new File(SettingsBean.getInstance().getJahiaExportsDiskPath()).getCanonicalFile().toPath();
        }
        catch (Exception e) {
            logger.error("Invalid server directory of configured jahiaExportsDiskPath {}. Configuration or environment is broken leading to exceptions during content export.", (Object)SettingsBean.getInstance().getJahiaExportsDiskPath());
        }
        finally {
            EXPORT_PATH = exportsPath;
        }
    }

    private static class ImportZipContextImpl
    implements ImportZipContext {
        private final List<String> loadedContentFilePaths = new ArrayList<String>();
        private final List<String> loadedImportDescriptorNames = new ArrayList<String>();
        private File expandedFolder = null;
        private final Resource archive;

        public ImportZipContextImpl(Resource archive) throws IOException {
            this.archive = archive;
            logger.info("Building import context, by analyzing file {}", (Object)archive);
            long timer = System.currentTimeMillis();
            this.init();
            if (logger.isInfoEnabled()) {
                logger.info("Done building and analyzing import file {} in {}", (Object)archive, (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() throws IOException {
            if (SettingsBean.getInstance().isExpandImportedFilesOnDisk()) {
                this.expandedFolder = ImportExportBaseService.getExpandFolder(this.archive, SettingsBean.getInstance().getExpandImportedFilesOnDiskPath());
                FileUtils.deleteDirectory((File)this.expandedFolder);
                FileUtils.forceMkdir((File)this.expandedFolder);
                logger.info("Expanding zip to file system folder: {}", (Object)this.expandedFolder);
            }
            ZipInputStream zis = ImportExportBaseService.getZipInputStream(this.archive);
            try {
                ZipEntry zipentry;
                while ((zipentry = zis.getNextEntry()) != null) {
                    String name = zipentry.getName().replace('\\', '/');
                    if (this.expandedFolder != null) {
                        ImportExportBaseService.expandZipEntryInExpandedFolderTarget(this.expandedFolder, zis, zipentry, name);
                    }
                    if (name.contains("/")) {
                        this.loadedContentFilePaths.add("/" + name);
                    } else {
                        this.loadedImportDescriptorNames.add(name);
                    }
                    zis.closeEntry();
                }
            }
            finally {
                ImportExportBaseService.closeInputStream(zis);
            }
        }

        @Override
        public List<String> getLoadedContentFilePaths() {
            return this.loadedContentFilePaths;
        }

        @Override
        public List<String> getLoadedImportDescriptorNames() {
            return this.loadedImportDescriptorNames;
        }

        @Override
        public Resource getArchive() {
            return this.archive;
        }

        @Override
        public void close() {
            if (this.expandedFolder != null) {
                long timer = System.currentTimeMillis();
                logger.info("Start cleaning files expanded to {}", (Object)this.expandedFolder);
                try {
                    FileUtils.deleteDirectory((File)this.expandedFolder);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                if (logger.isInfoEnabled()) {
                    logger.info("Done file cleanup in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - timer));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <X> X executeWithImportDescriptors(Collection<String> descriptors, ImportZipContext.ImportDescriptorCallback<X> callback) throws RepositoryException, IOException {
            block23: {
                block22: {
                    if (descriptors == null || descriptors.isEmpty() || callback == null) break block22;
                    if (!descriptors.stream().noneMatch(this.loadedImportDescriptorNames::contains)) break block23;
                }
                return null;
            }
            Object result = null;
            if (this.expandedFolder != null) {
                for (String descriptor : descriptors) {
                    if (!this.loadedImportDescriptorNames.contains(descriptor)) continue;
                    try {
                        FileInputStream is = FileUtils.openInputStream((File)new File(this.expandedFolder.getPath() + File.separator + descriptor));
                        try {
                            result = callback.doWithDescriptor(is, descriptor, result);
                        }
                        finally {
                            if (is == null) continue;
                            ((InputStream)is).close();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error while trying to process resource: " + descriptor + ", from expanded file system", (Throwable)e);
                    }
                }
            } else {
                ZipInputStream zis = ImportExportBaseService.getZipInputStream(this.archive);
                try {
                    ZipEntry zipentry;
                    while ((zipentry = zis.getNextEntry()) != null) {
                        String name = zipentry.getName();
                        if (descriptors.contains(name)) {
                            result = callback.doWithDescriptor(zis, name, result);
                        }
                        zis.closeEntry();
                    }
                }
                catch (RepositoryException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error("Error while trying to process resources: " + StringUtils.join(descriptors, (String)", ") + ", from zip input stream", (Throwable)e);
                }
                finally {
                    ImportExportBaseService.closeInputStream(zis);
                }
            }
            return result;
        }
    }

    private static class OrderedProperties
    extends Properties {
        private static final long serialVersionUID = -2418536708883832686L;
        private final List<Object> keys = new ArrayList<Object>();

        private OrderedProperties() {
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public synchronized boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OrderedProperties that = (OrderedProperties)o;
            return this.keys.equals(that.keys);
        }

        @Override
        public synchronized int hashCode() {
            return Objects.hash(super.hashCode(), this.keys);
        }
    }

    class ImportFileObserver
    implements Observer {
        public ImportFileObserver(String path, boolean checkDate, long interval, boolean fileOnly) throws JahiaException {
            if (ImportExportBaseService.this.fileWatcherService != null) {
                try {
                    ImportExportBaseService.this.fileWatcherService.addFileWatcher(path, path, checkDate, interval, fileOnly);
                    ImportExportBaseService.this.fileWatcherService.registerObserver(path, this);
                    ImportExportBaseService.this.fileWatcherService.startFileWatcher(path);
                }
                catch (JahiaException e) {
                    throw new JahiaInitializationException("ImportObserver::init failed ", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(Observable observable, Object args) {
            Object object = args;
            synchronized (object) {
                final List files = (List)args;
                if (!files.isEmpty()) {
                    JahiaUser user = JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser();
                    if (SettingsBean.getInstance().isProcessingServer()) {
                        for (File file : files) {
                            if (!file.isFile()) continue;
                            try {
                                logger.info("Detected new file to import: [{}]", (Object)file.toPath());
                                Path target = Paths.get(SettingsBean.getInstance().getTmpContentDiskPath(), new String[0]).resolve(file.getName());
                                Files.move(file.toPath(), target, StandardCopyOption.REPLACE_EXISTING);
                                JobDetail jobDetail = BackgroundJob.createJahiaJob("Import dropped site zip file job", SiteImportJob.class);
                                logger.info("Import file moved to: [{}]", (Object)target);
                                logger.info("Scheduling import job for file: [{}] (This file will be definitely remove at the end of the job execution)", (Object)target);
                                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                                jobDataMap.put("userkey", user.getUserKey());
                                jobDataMap.put("filePath", target.toString());
                                jobDataMap.put("deleteFile", true);
                                ImportExportBaseService.this.schedulerService.scheduleJobNow(jobDetail);
                            }
                            catch (IOException | SchedulerException e) {
                                logger.error("Cannot import file for " + file.getPath(), e);
                            }
                        }
                    } else {
                        try {
                            JCRSessionFactory.getInstance().setCurrentUser(user);
                            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(user, null, null, new JCRCallback<Object>(){

                                @Override
                                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                                    JCRNodeWrapper dest = session.getNode("/imports");
                                    for (File file : files) {
                                        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                                            dest.uploadFile(file.getName(), is, JCRContentUtils.getMimeType(file.getName()));
                                        }
                                        catch (Exception t) {
                                            logger.error("file observer error : ", (Throwable)t);
                                        }
                                    }
                                    session.save();
                                    return null;
                                }
                            });
                        }
                        catch (RepositoryException e) {
                            logger.error("error", (Throwable)e);
                        }
                        finally {
                            JCRSessionFactory.getInstance().setCurrentUser(null);
                        }
                        for (File file : files) {
                            file.delete();
                        }
                    }
                }
            }
        }
    }

    private static class Holder {
        static final ImportExportBaseService INSTANCE = new ImportExportBaseService();

        private Holder() {
        }
    }
}

