/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated(since="8.2.1.0", forRemoval=true)
public class UsersImportHandler
extends DefaultHandler {
    private static Logger LOG = LoggerFactory.getLogger(UsersImportHandler.class);
    private JahiaUserManagerService u;
    private JahiaGroupManagerService g;
    private JahiaSite site;
    private List<String[]> uuidProps = new ArrayList<String[]>();
    private JCRGroupNode currentGroup = null;
    private boolean member = false;
    private JCRSessionWrapper session;

    public UsersImportHandler(JahiaSite site, JCRSessionWrapper session) {
        this.site = site;
        this.session = session;
        this.u = ServicesRegistry.getInstance().getJahiaUserManagerService();
        this.g = ServicesRegistry.getInstance().getJahiaGroupManagerService();
    }

    public UsersImportHandler(JCRSessionWrapper session) {
        this.session = session;
        this.u = ServicesRegistry.getInstance().getJahiaUserManagerService();
        this.g = ServicesRegistry.getInstance().getJahiaGroupManagerService();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.currentGroup == null) {
            if (localName.equals("user")) {
                String name = attributes.getValue("http://www.jahia.org/", "name");
                String pass = null;
                Properties p = new Properties();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String k = attributes.getLocalName(i);
                    String v = attributes.getValue(i);
                    if (k.equals("name")) continue;
                    if (k.equals("password")) {
                        pass = v;
                        continue;
                    }
                    if (k.equals("user_homepage")) {
                        this.uuidProps.add(new String[]{name, k, v});
                        continue;
                    }
                    p.put(k, v);
                }
                if (name != null && pass != null && !this.u.userExists(name)) {
                    this.u.createUser(name, pass, p, this.session);
                    LOG.debug("Created user {}", (Object)name);
                }
            } else if (localName.equals("group")) {
                String name = attributes.getValue("http://www.jahia.org/", "name");
                Properties p = new Properties();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String k = attributes.getLocalName(i);
                    String v = attributes.getValue(i);
                    if (k.equals("name")) continue;
                    if (k.equals("group_homepage")) {
                        this.uuidProps.add(new String[]{name, k, v});
                        continue;
                    }
                    p.put(k, v);
                }
                if (name != null) {
                    String siteKey = this.site.getSiteKey();
                    this.currentGroup = this.g.lookupGroup(siteKey, name, this.session);
                    if (this.currentGroup == null) {
                        this.currentGroup = this.g.createGroup(siteKey, name, p, false, this.session);
                        LOG.debug("Created group {} for site {}", (Object)name, (Object)siteKey);
                    }
                }
            }
        } else {
            this.member = true;
            JCRNodeDecorator p = null;
            String name = attributes.getValue("http://www.jahia.org/", "name");
            if (localName.equals("user")) {
                p = this.u.lookupUser(name);
            } else if (localName.equals("group")) {
                p = this.g.lookupGroup(this.site.getSiteKey(), name, this.session);
            }
            if (p != null && !this.currentGroup.getMembers().contains(p)) {
                this.currentGroup.addMember(p);
                LOG.debug("Added member {} for group {}", (Object)name, (Object)this.currentGroup.getName());
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.member) {
            this.member = false;
        } else if (localName.equals("group")) {
            this.currentGroup = null;
        }
    }

    public List<String[]> getUuidProps() {
        return this.uuidProps;
    }

    public void setUuidProps(List<String[]> p) {
        if (p == null) {
            return;
        }
    }
}

