/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.MissingModulesValidationResult;
import org.jahia.services.importexport.validation.ModuleDependencyAware;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.xml.sax.Attributes;

public class MissingModulesValidator
implements ImportValidator,
ModuleDependencyAware {
    private boolean done;
    private Set<String> missingModules = new TreeSet<String>();
    private List<String> modules = Collections.emptyList();
    private String targetTemplateSet;
    private boolean targetTemplateSetPresent = true;
    private JahiaTemplateManagerService templateManagerService;

    @Override
    public ValidationResult getResult() {
        return new MissingModulesValidationResult(this.missingModules, this.targetTemplateSet, this.targetTemplateSetPresent);
    }

    @Override
    public void initDependencies(String templateSetName, List<String> modules) {
        this.targetTemplateSet = templateSetName;
        this.modules = modules;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    @Override
    public void validate(String decodedLocalName, String decodedQName, String currentPath, Attributes atts) {
        if (this.done) {
            return;
        }
        if ("jnt:virtualsite".equals(StringUtils.defaultString((String)atts.getValue("jcr:primaryType")))) {
            boolean bl = this.targetTemplateSetPresent = this.templateManagerService.getTemplatePackageById(this.targetTemplateSet) != null;
            if (this.modules != null) {
                for (String module : this.modules) {
                    if (this.templateManagerService.getTemplatePackageById(module) != null) continue;
                    this.missingModules.add(module);
                }
            }
            this.done = true;
        } else {
            this.targetTemplateSetPresent = true;
            this.missingModules.clear();
        }
    }
}

