/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.mail;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSettings
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(MailSettings.class);
    private static final long serialVersionUID = -3891985143146442266L;
    private static final FastHashMap MAIL_NOTIFICATION_LEVELS = new FastHashMap(4);
    private boolean configurationValid;
    private String from;
    private String uri;
    private String notificationLevel;
    private int notificationSeverity;
    private boolean serviceActivated;
    private String to;
    private boolean workflowNotificationsDisabled;

    public MailSettings() {
        this.setNotificationLevel("Disabled");
    }

    public MailSettings(boolean serviceEnabled, String uri, String from, String to, String notificationLevel) {
        this.serviceActivated = serviceEnabled;
        this.uri = uri;
        this.from = from;
        this.to = to;
        this.setNotificationLevel(notificationLevel);
    }

    public String getFrom() {
        return this.from;
    }

    public String getNotificationLevel() {
        return this.notificationLevel;
    }

    public int getNotificationSeverity() {
        return this.notificationSeverity;
    }

    public String getTo() {
        return this.to;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isConfigurationValid() {
        return this.configurationValid;
    }

    public boolean isServiceActivated() {
        return this.serviceActivated;
    }

    public void setConfigurationValid(boolean configugationValid) {
        this.configurationValid = configugationValid;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setNotificationLevel(String notificationLevel) {
        this.notificationLevel = notificationLevel;
        this.notificationSeverity = (Integer)MAIL_NOTIFICATION_LEVELS.get((Object)notificationLevel);
    }

    public void setServiceActivated(boolean serviceActivated) {
        this.serviceActivated = serviceActivated;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getUser() {
        String uri = this.getUri();
        String user = null;
        if (uri.contains("@")) {
            String authPart = StringUtils.substringBeforeLast((String)uri, (String)"@");
            user = authPart.contains(":") ? StringUtils.substringBefore((String)authPart, (String)":") : authPart;
        }
        return user;
    }

    public String getPassword() {
        String authPart;
        String uri = this.getUri();
        String pwd = null;
        if (uri.contains("@") && (authPart = StringUtils.substringBeforeLast((String)uri, (String)"@")).contains(":")) {
            pwd = StringUtils.substringAfter((String)authPart, (String)":");
        }
        return pwd;
    }

    public int getPort() {
        String uri = this.getUri();
        int port = 0;
        try {
            URI parsedUri = new URI(uri);
            if (parsedUri.getPort() != -1) {
                port = parsedUri.getPort();
            }
        }
        catch (URISyntaxException e) {
            logger.error("Invalid uri", (Throwable)e);
        }
        return port;
    }

    public String getSmtpHost() {
        String uri = this.getUri();
        String smtpHost = "";
        try {
            URI parsedUri = new URI(uri);
            smtpHost = parsedUri.getHost();
        }
        catch (URISyntaxException e) {
            logger.error("Invalid uri", (Throwable)e);
        }
        return smtpHost;
    }

    public Map<String, String> getOptions() {
        String uri = this.getUri();
        HashMap<String, String> options = new HashMap<String, String>();
        try {
            URI parsedUri = new URI(uri);
            String query = parsedUri.getQuery();
            if (query != null) {
                List params = URLEncodedUtils.parse((String)query, (Charset)Charset.forName("UTF-8"));
                for (NameValuePair param : params) {
                    options.put(param.getName(), param.getValue());
                }
            }
        }
        catch (URISyntaxException e) {
            logger.error("Invalid uri", (Throwable)e);
        }
        if (this.getUser() != null) {
            options.put("mail.smtp.auth", "true");
        }
        return options;
    }

    public boolean isWorkflowNotificationsDisabled() {
        return this.workflowNotificationsDisabled;
    }

    public void setWorkflowNotificationsDisabled(boolean workflowNotificationsDisabled) {
        this.workflowNotificationsDisabled = workflowNotificationsDisabled;
    }

    static {
        MAIL_NOTIFICATION_LEVELS.put((Object)"Disabled", (Object)new Integer(0));
        MAIL_NOTIFICATION_LEVELS.put((Object)"Standard", (Object)new Integer(3));
        MAIL_NOTIFICATION_LEVELS.put((Object)"Wary", (Object)new Integer(2));
        MAIL_NOTIFICATION_LEVELS.put((Object)"Paranoid", (Object)new Integer(1));
        MAIL_NOTIFICATION_LEVELS.setFast(true);
    }
}

