/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.osgi.BundleResource;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.JahiaCndReader;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.modulemanager.impl.DefinitionsBundleChecker;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.settings.SettingsBean;
import org.ops4j.pax.swissbox.extender.BundleURLScanner;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionsManagerService {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionsManagerService.class);
    private static final BundleURLScanner CND_SCANNER = new BundleURLScanner("META-INF", "*.cnd", false);
    private JahiaTemplateManagerService templateManagerService;
    private JCRStoreService jcrStoreService;
    public static final String SKIP_VALIDATION_PROP_KEY = "moduleManager.skipModuleDefinitionValidation";

    public CND_STATUS checkDefinition(String moduleId) throws IOException, RepositoryException {
        JahiaTemplatesPackage module = this.templateManagerService.getTemplatePackageRegistry().lookupById(moduleId);
        if (module == null) {
            throw new RepositoryException(moduleId + " module not found");
        }
        Bundle bundle = module.getBundle();
        List urls = CND_SCANNER.scan(bundle);
        for (URL url : urls) {
            JahiaCndReader parser = this.parse(url, bundle);
            for (ExtendedNodeType newNt : parser.getNodeTypesList()) {
                CND_STATUS status = this.checkNodeTypeDefinition(newNt);
                if (status == CND_STATUS.OK) continue;
                return status;
            }
        }
        return CND_STATUS.OK;
    }

    private JahiaCndReader parse(URL url, Bundle bundle) throws IOException {
        BundleResource resource = new BundleResource(url, bundle);
        String systemId = bundle.getSymbolicName();
        try (InputStreamReader resourceReader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            JahiaCndReader r = new JahiaCndReader(resourceReader, ((Object)((Object)resource)).toString(), systemId, NodeTypeRegistry.getInstance());
            r.setDoCheckConsistency(false);
            try {
                r.parse();
            }
            catch (ParseException e) {
                logger.error("Error", (Throwable)e);
            }
            JahiaCndReader jahiaCndReader = r;
            return jahiaCndReader;
        }
    }

    private CND_STATUS checkNodeTypeDefinition(ExtendedNodeType newNt) throws NoSuchNodeTypeException {
        NodeTypeRegistry registry = NodeTypeRegistry.getInstance();
        if (registry.hasNodeType(newNt.getName())) {
            ExtendedNodeType regNt = registry.getNodeType(newNt.getName());
            if (!regNt.getSystemId().equals(newNt.getSystemId())) {
                logger.debug("Definition {} was already deployed in {}", (Object)newNt.getName(), (Object)regNt.getSystemId());
                return CND_STATUS.MODIFIED;
            }
            DefinitionsBundleChecker.NodeTypeDefDiff diff = DefinitionsBundleChecker.NodeTypeDefDiff.create(regNt, newNt);
            if (diff.isModified()) {
                logger.debug("CND changes detected: {}", (Object)diff);
                return CND_STATUS.MODIFIED;
            }
        }
        return CND_STATUS.OK;
    }

    public boolean skipDefinitionValidation() {
        return SettingsBean.getInstance().getBoolean(SKIP_VALIDATION_PROP_KEY, false);
    }

    public boolean isLatest(String moduleId) throws RepositoryException {
        JahiaTemplatesPackage module = this.templateManagerService.getTemplatePackageRegistry().lookupById(moduleId);
        if (module == null) {
            throw new RepositoryException(moduleId + " module not found");
        }
        String systemId = module.getBundle().getSymbolicName();
        String latestVersion = this.jcrStoreService.getDefinitionVersion(systemId);
        if (latestVersion == null) {
            return true;
        }
        ModuleVersion latestDeployedVersion = new ModuleVersion(latestVersion);
        if (module.getVersion().compareTo(latestDeployedVersion) != 0) {
            return false;
        }
        long lastModified = this.getDefLastModified(module);
        return lastModified == Long.parseLong(this.jcrStoreService.getDefinitionLastModified(systemId));
    }

    private long getDefLastModified(JahiaTemplatesPackage module) {
        long lastModified = 0L;
        Bundle bundle = module.getBundle();
        List urls = CND_SCANNER.scan(bundle);
        for (URL url : urls) {
            BundleResource bundleResource = new BundleResource(url, bundle);
            try {
                long l = bundleResource.lastModified();
                if (l <= lastModified) continue;
                lastModified = l;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return lastModified;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    public void setJcrStoreService(JCRStoreService jcrStoreService) {
        this.jcrStoreService = jcrStoreService;
    }

    public static enum CND_STATUS {
        OK,
        MODIFIED;

    }
}

