/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.persistence.jcr;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Date;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.persistence.BundlePersister;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.jahia.services.modulemanager.persistence.PersistentBundleInfoBuilder;
import org.jahia.services.modulemanager.persistence.jcr.BundleInfoJcrHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class JCRBundlePersister
implements BundlePersister {
    private static final Logger logger = LoggerFactory.getLogger(JCRBundlePersister.class);

    @Override
    public boolean delete(final String bundleKey) throws ModuleManagementException {
        try {
            return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    return JCRBundlePersister.this.delete(bundleKey, session);
                }
            });
        }
        catch (RepositoryException e) {
            throw new ModuleManagementException("Unable to delete information for bundle " + bundleKey, e);
        }
    }

    protected boolean delete(String bundleKey, JCRSessionWrapper session) throws RepositoryException {
        boolean removed = false;
        String path = BundleInfoJcrHelper.getJcrPath(bundleKey);
        try {
            JCRNodeWrapper target = session.getNode(path);
            JCRNodeWrapper folder = target.getParent();
            target.remove();
            removed = true;
            while (!folder.getPath().equals("/module-management/bundles") && !folder.hasNodes()) {
                JCRNodeWrapper parent = folder.getParent();
                folder.remove();
                folder = parent;
            }
            session.save();
            logger.debug("Node at {} deleted for bundle key {}", (Object)path, (Object)bundleKey);
        }
        catch (PathNotFoundException e) {
            logger.debug("Bundle info does not exist for key {}. Skip deleting it.", (Object)bundleKey);
        }
        return removed;
    }

    @Override
    public PersistentBundle find(final String bundleKey) {
        PersistentBundle found = null;
        try {
            found = JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<PersistentBundle>(){

                @Override
                public PersistentBundle doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    return JCRBundlePersister.this.find(bundleKey, session);
                }
            });
        }
        catch (RepositoryException e) {
            throw new ModuleManagementException("Unable to find information for bundle " + bundleKey, e);
        }
        return found;
    }

    protected PersistentBundle find(String bundleKey, JCRSessionWrapper session) throws RepositoryException {
        PersistentBundle info = null;
        JCRNodeWrapper node = BundleInfoJcrHelper.findTargetNode(bundleKey, session);
        if (node != null) {
            info = new PersistentBundle(node.getPropertyAsString("j:groupId"), node.getPropertyAsString("j:symbolicName"), node.getPropertyAsString("j:version"));
            info.setChecksum(node.getPropertyAsString("j:checksum"));
            info.setDisplayName(node.getPropertyAsString("j:displayName"));
            Date lastModified = node.getLastModifiedAsDate();
            if (lastModified != null) {
                info.setLastModified(lastModified.getTime());
            }
            info.setTransformationRequired(node.hasProperty("j:transformationRequired") && node.getProperty("j:transformationRequired").getBoolean());
            info.setResource((Resource)new InputStreamResource(node.getFileContent().downloadFile()));
        }
        return info;
    }

    @Override
    public void store(final PersistentBundle bundleInfo) throws ModuleManagementException {
        long startTime = System.currentTimeMillis();
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        return JCRBundlePersister.this.store(bundleInfo, session);
                    }
                    catch (IOException e) {
                        throw new ModuleManagementException("Unable to store information for bundle " + bundleInfo, e);
                    }
                }
            });
        }
        catch (RepositoryException e) {
            throw new ModuleManagementException("Unable to store information for bundle " + bundleInfo, e);
        }
        logger.debug("Stored bundle info {} in {} ms", (Object)bundleInfo, (Object)(System.currentTimeMillis() - startTime));
    }

    protected boolean store(PersistentBundle bundleInfo, JCRSessionWrapper session) throws RepositoryException, IOException {
        String path = BundleInfoJcrHelper.getJcrPath(bundleInfo);
        JCRNodeWrapper bundleNode = null;
        try {
            bundleNode = session.getNode(path);
            if (bundleNode.hasProperty("j:checksum") && bundleInfo.getChecksum().equals(bundleNode.getProperty("j:checksum").getString())) {
                logger.debug("Resource {} represents same bundle as alreday stored under {}. Skip storing it again.", (Object)bundleInfo, (Object)path);
                return false;
            }
        }
        catch (PathNotFoundException e) {
            bundleNode = BundleInfoJcrHelper.getOrCreateTargetNode(bundleInfo, session);
        }
        bundleNode.setProperty("j:groupId", bundleInfo.getGroupId());
        bundleNode.setProperty("j:symbolicName", bundleInfo.getSymbolicName());
        bundleNode.setProperty("j:version", bundleInfo.getVersion());
        bundleNode.setProperty("j:checksum", bundleInfo.getChecksum());
        bundleNode.setProperty("j:displayName", bundleInfo.getDisplayName());
        bundleNode.setProperty("j:transformationRequired", bundleInfo.isTransformationRequired());
        try (BufferedInputStream is = new BufferedInputStream(bundleInfo.getResource().getInputStream());){
            bundleNode.getFileContent().uploadFile(is, "application/java-archive");
        }
        session.save();
        logger.debug("Stored bundle info {} under {}.", (Object)bundleInfo, (Object)path);
        return true;
    }

    @Override
    public PersistentBundle store(Resource resource) throws ModuleManagementException {
        PersistentBundle bundleInfo;
        long startTime = System.currentTimeMillis();
        try {
            bundleInfo = PersistentBundleInfoBuilder.build(resource);
            if (bundleInfo == null) {
                throw new ModuleManagementException("Invalid resource for bundle: " + resource);
            }
        }
        catch (IOException e) {
            throw new ModuleManagementException("Unable to read bundle resource", e);
        }
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        return JCRBundlePersister.this.store(bundleInfo, session);
                    }
                    catch (IOException e) {
                        throw new ModuleManagementException("Unable to store information for bundle " + bundleInfo, e);
                    }
                }
            });
        }
        catch (RepositoryException e) {
            throw new ModuleManagementException("Unable to store information for bundle " + bundleInfo, e);
        }
        logger.debug("Stored bundle info {} from resource {} in {} ms", new Object[]{bundleInfo, resource, System.currentTimeMillis() - startTime});
        return bundleInfo;
    }
}

