/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.modulemanager.Constants;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.ModuleManager;
import org.jahia.services.modulemanager.models.JahiaDepends;
import org.jahia.services.modulemanager.persistence.BundlePersister;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ModuleUtils {
    private static final Logger logger = LoggerFactory.getLogger(ModuleUtils.class);
    protected static final Collection<String> DEPENDENCIES_TO_REMOVE = Arrays.asList("jaxrs-osgi-extender");

    private ModuleUtils() {
    }

    static boolean addCapabilities(Attributes atts) {
        if (!ModuleUtils.requiresTransformation(atts)) {
            return false;
        }
        String moduleId = atts.getValue(Constants.ATTR_NAME_BUNDLE_SYMBOLIC_NAME);
        ModuleUtils.cleanupJahiaDepends(atts);
        ModuleUtils.populateProvideCapabilities(moduleId, atts);
        ModuleUtils.populateRequireCapabilities(moduleId, atts);
        return true;
    }

    private static void cleanupJahiaDepends(Attributes atts) {
        if (atts.getValue(Constants.ATTR_NAME_JAHIA_DEPENDS) != null) {
            String[] split = StringUtils.split((String)atts.getValue(Constants.ATTR_NAME_JAHIA_DEPENDS), (String)",");
            if (Arrays.stream(split).anyMatch(DEPENDENCIES_TO_REMOVE::contains)) {
                atts.putValue(Constants.ATTR_NAME_JAHIA_DEPENDS.toString(), Arrays.stream(split).filter(s -> !DEPENDENCIES_TO_REMOVE.contains(s)).collect(Collectors.joining(",")));
            }
        }
    }

    public static InputStream addModuleDependencies(InputStream sourceStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ZipInputStream zis = new ZipInputStream(sourceStream);
             ZipOutputStream zos = new ZipOutputStream(out);){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                zos.putNextEntry(new ZipEntry(zipEntry.getName()));
                if ("META-INF/MANIFEST.MF".equals(zipEntry.getName())) {
                    Manifest mf = new Manifest();
                    mf.read(zis);
                    ModuleUtils.addCapabilities(mf.getMainAttributes());
                    mf.write(zos);
                } else {
                    IOUtils.copy((InputStream)zis, (OutputStream)zos);
                }
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    static String buildClauseProvideCapability(String dependency, String version) {
        String prefix = String.format("%s;%s=\"", "com.jahia.modules.dependencies", "moduleIdentifier");
        StringBuilder strBuilder = new StringBuilder(prefix).append(dependency).append('\"');
        if (StringUtils.isNotEmpty((String)version)) {
            strBuilder.append(';').append("moduleVersion").append(":Version=").append(version);
        }
        return strBuilder.toString();
    }

    static String buildClauseRequireCapability(String dependency) {
        JahiaDepends depends = new JahiaDepends(dependency);
        StringBuilder sb = new StringBuilder("com.jahia.modules.dependencies").append(";filter:=\"").append(depends.toFilterString()).append("\"");
        if (depends.isOptional()) {
            sb.append(";resolution:=\"optional\"");
        }
        return sb.toString();
    }

    private static File getBundleFile(Bundle bundle) {
        try {
            Method m = bundle.getClass().getDeclaredMethod("getArchive", new Class[0]);
            m.setAccessible(true);
            return (File)BeanUtilsBean.getInstance().getPropertyUtils().getProperty(m.invoke((Object)bundle, new Object[0]), "currentRevision.content.file");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("Unable to detect the file for the deployed bundle " + bundle + ". Cause: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static BundlePersister getBundlePersister() {
        return (BundlePersister)SpringContextSingleton.getBean("org.jahia.services.modulemanager.persistence.BundlePersister");
    }

    public static ModuleManager getModuleManager() {
        return (ModuleManager)SpringContextSingleton.getBean("ModuleManager");
    }

    private static List<String> getRequireCapabilities(String moduleId, String requiredJahiaVersion, String dependencies) {
        LinkedList<String> capabilities = new LinkedList<String>();
        LinkedHashSet<String> dependsList = new LinkedHashSet<String>();
        if (requiredJahiaVersion != null) {
            Version v = new Version(requiredJahiaVersion);
            String string = v.getMajor() + "." + v.getMinor();
            String upperBound = Integer.toString(v.getMajor() + 1);
            capabilities.add("com.jahia.server;filter:=\"(&(version>=" + string + ")(!(version>=" + upperBound + ")))\"");
        }
        if (StringUtils.isNotBlank((String)dependencies)) {
            String[] depList;
            for (String dependency : depList = ModuleUtils.toDependsArray(dependencies)) {
                dependsList.add(dependency.trim());
            }
        }
        for (String string : dependsList) {
            capabilities.add(ModuleUtils.buildClauseRequireCapability(string));
        }
        return capabilities;
    }

    public static String replaceDependsDelimiter(String dependsValue) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(dependsValue, ",");
        String nextToken = null;
        while (nextToken != null || tokens.hasMoreTokens()) {
            String token = nextToken != null ? nextToken : tokens.nextToken();
            String string = nextToken = tokens.hasMoreTokens() ? tokens.nextToken() : null;
            if (!token.contains("=")) {
                result.add(token);
                continue;
            }
            String dependency = token;
            String[] deps = token.split("=");
            if (JahiaDepends.isOpenClause(deps[1].replace("optional;", ""))) {
                String nextTokenStr = nextToken != null ? nextToken : "";
                dependency = String.format("%s,%s", token, nextTokenStr);
                nextToken = null;
            }
            JahiaDepends.parse(dependency);
            result.add(dependency);
        }
        return String.join((CharSequence)"#", result);
    }

    public static String[] toDependsArray(String dependsValue) {
        dependsValue = ModuleUtils.replaceDependsDelimiter(dependsValue);
        return dependsValue.split("#");
    }

    public static Resource loadBundleResource(Bundle bundle) throws MalformedURLException {
        try {
            Object bundleResource = null;
            File bundleFile = ModuleUtils.getBundleFile(bundle);
            bundleResource = bundleFile != null ? new FileSystemResource(bundleFile) : new UrlResource(bundle.getLocation());
            return bundleResource;
        }
        catch (Exception e) {
            if (e instanceof ModuleManagementException) {
                throw (ModuleManagementException)e;
            }
            String msg = "Unable to load bundle resource using location " + bundle.getLocation() + ". Cause: " + e.getMessage();
            logger.error(msg, (Throwable)e);
            throw new ModuleManagementException(msg, e);
        }
    }

    public static PersistentBundle loadPersistentBundle(String bundleKey) throws ModuleManagementException {
        try {
            return ModuleUtils.getBundlePersister().find(bundleKey);
        }
        catch (Exception e) {
            if (e instanceof ModuleManagementException) {
                throw e;
            }
            throw new ModuleManagementException("Unable to load persistent bundle for key " + bundleKey + ". Cause: " + e.getMessage(), e);
        }
    }

    public static PersistentBundle persist(Bundle bundle) throws ModuleManagementException {
        try {
            return ModuleUtils.persist(ModuleUtils.loadBundleResource(bundle));
        }
        catch (Exception e) {
            if (e instanceof ModuleManagementException) {
                throw (ModuleManagementException)e;
            }
            String msg = "Unable to persist bundle " + bundle + ". Cause: " + e.getMessage();
            logger.error(msg, (Throwable)e);
            throw new ModuleManagementException(msg, e);
        }
    }

    public static PersistentBundle persist(Resource bundleResource) throws ModuleManagementException {
        long startTime = System.currentTimeMillis();
        try {
            logger.debug("Persisting from resource {}", (Object)bundleResource);
            PersistentBundle persistedBundle = ModuleUtils.getBundlePersister().store(bundleResource);
            logger.debug("Bundle resource has been successfully persisted under {} in {} ms", (Object)persistedBundle.getLocation(), (Object)(System.currentTimeMillis() - startTime));
            return persistedBundle;
        }
        catch (Exception e) {
            String msg = "Unable to persist bundle from resource " + bundleResource + ". Cause: " + e.getMessage();
            logger.error(msg, (Throwable)e);
            throw new ModuleManagementException(msg, e);
        }
    }

    private static void populateProvideCapabilities(String moduleId, Attributes atts) {
        StringBuilder provide = new StringBuilder();
        String existingProvideValue = atts.getValue(Constants.ATTR_NAME_PROVIDE_CAPABILITY);
        if (StringUtils.isNotEmpty((String)existingProvideValue)) {
            provide.append(existingProvideValue).append(",");
        }
        String bundleVersion = atts.getValue(Constants.ATTR_NAME_BUNDLE_VERSION);
        provide.append(ModuleUtils.buildClauseProvideCapability(moduleId, bundleVersion));
        String bundleName = atts.getValue(Constants.ATTR_NAME_BUNDLE_NAME);
        if (StringUtils.isNotEmpty((String)bundleName)) {
            provide.append(",").append(ModuleUtils.buildClauseProvideCapability(bundleName, bundleVersion));
        }
        atts.put(Constants.ATTR_NAME_PROVIDE_CAPABILITY, provide.toString());
    }

    private static void populateRequireCapabilities(String moduleId, Attributes atts) {
        List<String> caps = ModuleUtils.getRequireCapabilities(moduleId, atts.getValue(Constants.ATTR_NAME_JAHIA_REQUIRED_VERSION), atts.getValue(Constants.ATTR_NAME_JAHIA_DEPENDS));
        if (!caps.isEmpty()) {
            StringBuilder require = new StringBuilder();
            String existingRequireValue = atts.getValue(Constants.ATTR_NAME_REQUIRE_CAPABILITY);
            if (StringUtils.isNotEmpty((String)existingRequireValue)) {
                require.append(existingRequireValue);
            }
            for (String cap : caps) {
                if (require.length() > 0) {
                    require.append(",");
                }
                require.append(cap);
            }
            atts.put(Constants.ATTR_NAME_REQUIRE_CAPABILITY, require.toString());
        }
    }

    public static boolean requiresTransformation(Attributes atts) {
        return (!StringUtils.contains((String)atts.getValue(Constants.ATTR_NAME_PROVIDE_CAPABILITY), (String)"com.jahia.modules.dependencies") || !StringUtils.contains((String)atts.getValue(Constants.ATTR_NAME_PROVIDE_CAPABILITY), (String)"com.jahia.server")) && !atts.containsKey(Constants.ATTR_NAME_FRAGMENT_HOST);
    }

    public static void updateBundleLocation(Bundle bundle, String updatedLocation) {
        try {
            Method m = bundle.getClass().getDeclaredMethod("getArchive", new Class[0]);
            m.setAccessible(true);
            Object archive = m.invoke((Object)bundle, new Object[0]);
            Field locationField = archive.getClass().getDeclaredField("m_originalLocation");
            locationField.setAccessible(true);
            locationField.set(archive, updatedLocation);
            archive.getClass().getDeclaredMethod("setLastModified", Long.TYPE).invoke(archive, System.currentTimeMillis());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("Unable update the location for bundle " + bundle + ". Cause: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Unable update the location for bundle " + bundle + ". Cause: " + e.getMessage(), e);
        }
    }
}

