/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class CamelNotificationService
implements CamelContextAware,
DisposableBean,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CamelNotificationService.class);
    private CamelContext camelContext;
    private ProducerTemplate template;
    private Thread queueProcessor;
    private String queueProcessorThreadName = "notificationQueueProcessor";
    private long queueProcessorFrequency = 5000L;
    private ConcurrentLinkedQueue<CamelMessage> queue = new ConcurrentLinkedQueue();
    private AtomicBoolean queueProcessorRunning = new AtomicBoolean(true);

    public void setQueueProcessorThreadName(String queueProcessorThreadName) {
        this.queueProcessorThreadName = queueProcessorThreadName;
    }

    public void setQueueProcessorFrequency(long queueProcessorFrequency) {
        this.queueProcessorFrequency = queueProcessorFrequency;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.template = camelContext.createProducerTemplate();
        this.queueProcessor = new Thread((Runnable)this, this.queueProcessorThreadName);
        this.queueProcessor.setDaemon(true);
        this.queueProcessor.start();
    }

    public void sendMessagesWithBodyAndHeaders(String target, Object body, Map<String, Object> headers) {
        if (!this.camelContext.getStatus().isStarted()) {
            return;
        }
        if (headers != null) {
            this.template.sendBodyAndHeaders(target, body, headers);
        } else {
            this.template.sendBody(target, body);
        }
    }

    public void queueMessagesWithBodyAndHeaders(String target, Object body, Map<String, Object> headers) {
        this.queue.add(new CamelMessage(target, body, headers));
    }

    public void registerRoute(RoutesBuilder routesBuilder) throws Exception {
        this.camelContext.addRoutes(routesBuilder);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void destroy() throws Exception {
        if (this.template != null) {
            this.template.stop();
        }
        if (this.queueProcessor != null) {
            this.queueProcessorRunning.set(false);
        }
    }

    @Override
    public void run() {
        try {
            while (this.queueProcessorRunning.get()) {
                CamelMessage message;
                int size = this.queue.size();
                for (int i = 0; i < size && (message = this.queue.poll()) != null; ++i) {
                    this.sendMessagesWithBodyAndHeaders(message.getTarget(), message.getBody(), message.getHeaders());
                }
                Thread.sleep(this.queueProcessorFrequency);
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public class CamelMessage {
        private String target;
        private Object body;
        private Map<String, Object> headers;

        public CamelMessage(String target, Object body, Map<String, Object> headers) {
            this.target = target;
            this.body = body;
            this.headers = headers;
        }

        public String getTarget() {
            return this.target;
        }

        public Object getBody() {
            return this.body;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }
    }
}

