/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.pwd;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.pwd.PasswordDigester;
import org.jahia.utils.EncryptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordService {
    private static final PasswordService instance = new PasswordService();
    private static final Logger logger = LoggerFactory.getLogger(PasswordService.class);
    private PasswordDigester defaultDigester;
    private Map<String, PasswordDigester> digesters = new ConcurrentHashMap<String, PasswordDigester>();
    private PasswordDigester enforcedDigester;
    private PasswordDigester strongDigester;

    public static PasswordService getInstance() {
        return instance;
    }

    public String digest(String password) {
        return this.digest(password, false);
    }

    public String digest(String password, boolean strong) {
        PasswordDigester digester;
        if (StringUtils.isEmpty((String)password)) {
            return null;
        }
        PasswordDigester passwordDigester = digester = strong && this.strongDigester != null ? this.strongDigester : this.getDefaultDigester();
        if (digester == null) {
            return EncryptionUtils.sha1DigestLegacy(password);
        }
        return digester.getId().length() > 0 ? digester.getId() + ":" + digester.digest(password) : digester.digest(password);
    }

    protected PasswordDigester getDefaultDigester() {
        return this.enforcedDigester != null ? this.enforcedDigester : this.defaultDigester;
    }

    public boolean matches(String password, String prefixedDigest) {
        if (password == null || prefixedDigest == null) {
            return false;
        }
        int pos = prefixedDigest.indexOf(58);
        if (pos == -1) {
            return prefixedDigest.equals(EncryptionUtils.sha1DigestLegacy(password));
        }
        String digesterId = prefixedDigest.substring(0, pos);
        PasswordDigester digester = this.digesters.get(digesterId);
        if (null == digester) {
            logger.warn("Unable to find registered password digester for ID {}. Skipping password match check.", (Object)digesterId);
            return false;
        }
        return digester.matches(password, prefixedDigest.substring(pos + 1));
    }

    public void registerDigester(PasswordDigester digester) {
        this.digesters.put(digester.getId(), digester);
        logger.info("Registered password digester {}", (Object)digester.getId());
        if (digester.isDefault() && this.enforcedDigester != null) {
            logger.warn("Multiple default password digesters registered. The digester {} is overridden by the {}.", (Object)this.enforcedDigester.getId(), (Object)digester.getId());
            this.enforcedDigester = digester;
        }
    }

    public void setDefaultDigester(PasswordDigester defaultDigester) {
        this.defaultDigester = defaultDigester;
        if (defaultDigester != null) {
            this.registerDigester(defaultDigester);
        }
    }

    public void setDigesters(List<PasswordDigester> digesters) {
        this.digesters = new ConcurrentHashMap<String, PasswordDigester>();
        if (digesters != null) {
            for (PasswordDigester pwd : digesters) {
                this.registerDigester(pwd);
            }
        }
    }

    public void setStrongDigester(PasswordDigester strongDigester) {
        this.strongDigester = strongDigester;
    }

    public void unregisterDigester(String digesterId) {
        logger.info("Unregistered password digester {}", (Object)digesterId);
        this.digesters.remove(digesterId);
        if (this.enforcedDigester != null && this.enforcedDigester.getId().equals(digesterId)) {
            this.enforcedDigester = null;
        }
    }
}

