/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.query.QueryWrapper;

public class QueryManagerImpl
implements QueryManagerWrapper {
    private JCRSessionWrapper session;
    private JCRSessionFactory sessionFactory;

    public QueryManagerImpl(JCRSessionWrapper session, JCRSessionFactory sessionFactory) {
        this.session = session;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public QueryWrapper createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        QueryWrapper queryWrapper = new QueryWrapper(statement, language, this.session, this.sessionFactory);
        if (queryWrapper.getQueries().isEmpty()) {
            throw new InvalidQueryException((String)(this.sessionFactory.getProviders().isEmpty() ? "Query could not be created. Store provider is not initialized yet" : "No query could be created for the unknown query language '" + language + "'"));
        }
        return queryWrapper;
    }

    @Override
    public QueryWrapper createDualQuery(String statement, String language, String sqlFallbackStatement) throws InvalidQueryException, RepositoryException {
        QueryWrapper queryWrapper = new QueryWrapper(statement, language, sqlFallbackStatement, this.session, this.sessionFactory);
        if (queryWrapper.getQueries().isEmpty()) {
            throw new InvalidQueryException((String)(this.sessionFactory.getProviders().isEmpty() ? "Query could not be created. Store provider is not initialized yet" : "No query could be created for the unknown query language '" + language + "'"));
        }
        return queryWrapper;
    }

    @Override
    public QueryObjectModelFactory getQOMFactory() {
        try {
            JCRStoreProvider provider = this.sessionFactory.getProvider("/");
            QueryObjectModelFactory qomFactory = provider.getQueryManager(this.session).getQOMFactory();
            return (QueryObjectModelFactory)Proxy.newProxyInstance(qomFactory.getClass().getClassLoader(), new Class[]{QueryObjectModelFactory.class}, (InvocationHandler)new QOMFactoryInvocationHandler(qomFactory));
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryWrapper getQuery(Node node) throws InvalidQueryException, RepositoryException {
        try {
            return new QueryWrapper(node, this.session, this.sessionFactory);
        }
        catch (PathNotFoundException e) {
            throw new InvalidQueryException("Node is not of type nt:query");
        }
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        HashSet<String> res = new HashSet<String>();
        for (JCRStoreProvider jcrStoreProvider : this.sessionFactory.getProviders().values()) {
            QueryManager qm = jcrStoreProvider.getQueryManager(this.session);
            if (qm == null) continue;
            for (String lang : qm.getSupportedQueryLanguages()) {
                res.add(lang);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    private class QOMInvocationHandler
    implements InvocationHandler {
        private final QueryObjectModel underlying;
        private long limit = -1L;
        private long offset = 0L;

        QOMInvocationHandler(QueryObjectModel underlying) {
            this.underlying = underlying;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            try {
                if ("execute".equals(method.getName())) {
                    QueryWrapper queryWrapper = new QueryWrapper(this.underlying, QueryManagerImpl.this.session, QueryManagerImpl.this.sessionFactory);
                    queryWrapper.setOffset(this.offset);
                    queryWrapper.setLimit(this.limit);
                    return queryWrapper.execute();
                }
                if ("setLimit".equals(method.getName())) {
                    this.limit = (Long)args[0];
                } else if ("setOffset".equals(method.getName())) {
                    this.offset = (Long)args[0];
                }
                return method.invoke((Object)this.underlying, args);
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof Exception) {
                    Exception exception = (Exception)throwable;
                    throw exception;
                }
                Error error = (Error)throwable;
                throw error;
            }
        }
    }

    private class QOMFactoryInvocationHandler
    implements InvocationHandler {
        private final QueryObjectModelFactory underlying;

        QOMFactoryInvocationHandler(QueryObjectModelFactory underlying) {
            this.underlying = underlying;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            if ("createQuery".equals(method.getName())) {
                QueryObjectModel qom = ServicesRegistry.getInstance().getQueryService().modifyAndOptimizeQuery((Source)args[0], (Constraint)args[1], (Ordering[])args[2], (Column[])args[3], this.underlying, QueryManagerImpl.this.session);
                return Proxy.newProxyInstance(qom.getClass().getClassLoader(), new Class[]{QueryObjectModel.class}, (InvocationHandler)new QOMInvocationHandler(qom));
            }
            try {
                return method.invoke((Object)this.underlying, args);
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof Exception) {
                    Exception exception = (Exception)throwable;
                    throw exception;
                }
                Error error = (Error)throwable;
                throw error;
            }
        }
    }
}

