/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.TemplateResolver;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import pl.touk.throwing.ThrowingFunction;
import pl.touk.throwing.ThrowingPredicate;

public class JCRTemplateResolver
implements TemplateResolver,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(JCRTemplateResolver.class);
    private static final Comparator<Template> TEMPLATE_PRIORITY_COMPARATOR = new TemplatePriorityComparator();
    private static final Comparator<JCRNodeWrapper> TEMPLATE_NODE_PRIORITY_COMPARATOR = new TemplateNodePriorityComparator();
    private JahiaTemplateManagerService templateManagerService;
    private Cache templatesCache;
    private ConcurrentMap<String, ReentrantReadWriteLock> templatesCacheLockAccess = new ConcurrentHashMap<String, ReentrantReadWriteLock>();
    private long templatesCacheLockTimeout;
    private List<String> nodeTypesWithTheme;
    private ChannelService channelService;
    private JahiaUserManagerService userManagerService;
    private String settingsPanelTheme;

    public List<String> getNodeTypesWithTheme() {
        return this.nodeTypesWithTheme;
    }

    public void setNodeTypesWithTheme(List<String> nodeTypesWithTheme) {
        this.nodeTypesWithTheme = nodeTypesWithTheme;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    @Override
    public boolean hasTemplate(String templateName, ExtendedNodeType nodeType, Set<String> templatePackages) throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            String templateType = "jnt:contentTemplate";
            if (nodeType.isNodeType("jnt:page")) {
                templateType = "jnt:pageTemplate";
            }
            for (String templatePackage : templatePackages) {
                JahiaTemplatesPackage pack = this.templateManagerService.getTemplatePackageById(templatePackage);
                if (pack == null) continue;
                List<JCRNodeWrapper> templateNodes = this.getTemplateNodes(templateName, "/modules/" + templatePackage + "/" + pack.getVersion(), templateType, false, session);
                for (JCRNodeWrapper templateNode : templateNodes) {
                    if (!this.checkJApplyOn(templateNode, null, nodeType)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    @Override
    public Template resolveTemplate(Resource resource, RenderContext renderContext) throws RepositoryException {
        JCRNodeWrapper node = resource.getNode();
        String templateName = resource.getTemplate();
        if ("default".equals(templateName)) {
            templateName = null;
        }
        Template template = null;
        JCRSiteNode site = renderContext.getSite();
        if (site == null) {
            site = node.getResolveSite();
        }
        if (node.isNodeType("jnt:template")) {
            if (!node.hasProperty("j:view") || "default".equals(node.getProperty("j:view").getString())) {
                JCRNodeWrapper parent = node.getParent();
                while (!parent.isNodeType("jnt:templatesFolder")) {
                    template = new Template(parent.hasProperty("j:view") ? parent.getProperty("j:view").getString() : templateName, parent.getIdentifier(), template, parent.getName());
                    parent = parent.getParent();
                }
                String packageName = "templates-system";
                if (parent.hasProperty("j:templateSetContext")) {
                    renderContext.setSite((JCRSiteNode)parent.getProperty("j:templateSetContext").getNode());
                    packageName = parent.getProperty("j:templateSetContext").getNode().getName();
                }
                LinkedHashSet<String> installed = new LinkedHashSet<String>();
                installed.add(packageName);
                for (JahiaTemplatesPackage aPackage : this.templateManagerService.getTemplatePackageById(packageName).getDependencies()) {
                    installed.add(aPackage.getId());
                }
                template = this.addContextualTemplates(resource, renderContext, template, parent, installed);
            }
        } else {
            String theme;
            if (resource.getTemplate().equals("default") && node.hasProperty("j:templateName")) {
                templateName = node.getProperty("j:templateName").getString();
            }
            LinkedHashSet<String> installedModules = new LinkedHashSet<String>(site.getInstalledModulesWithAllDependencies());
            installedModules.add("templates-system");
            String type = "jnt:contentTemplate";
            if (resource.getNode().isNodeType("jnt:page")) {
                type = "jnt:pageTemplate";
            }
            if ((theme = this.getSettingsPanelsTheme(renderContext)) != null && JCRContentUtils.isNodeType(resource.getNode(), this.nodeTypesWithTheme)) {
                template = this.addTemplate(resource, renderContext, templateName + "-" + theme, installedModules, type);
            }
            if (template == null) {
                template = this.addTemplate(resource, renderContext, templateName, installedModules, type);
            }
            if (template != null) {
                JCRNodeWrapper templateNode = resource.getNode().getSession().getNodeByIdentifier(template.getNode()).getParent();
                while (!templateNode.isNodeType("jnt:templatesFolder")) {
                    template = new Template(templateNode.hasProperty("j:view") ? templateNode.getProperty("j:view").getString() : null, templateNode.getIdentifier(), template, templateNode.getName());
                    templateNode = templateNode.getParent();
                }
                template = this.addContextualTemplates(resource, renderContext, template, templateNode, installedModules);
            } else {
                return null;
            }
        }
        if (template != null) {
            Template currentTemplate = template;
            do {
                if (currentTemplate.getView().equals("default")) continue;
                template = currentTemplate;
            } while ((currentTemplate = currentTemplate.getNext()) != null);
        } else {
            template = new Template(null, null, null, null);
        }
        return template;
    }

    private Template addContextualTemplates(Resource resource, RenderContext renderContext, Template template, JCRNodeWrapper parent, Set<String> modules) throws RepositoryException {
        if (parent.isNodeType("jnt:templatesFolder") && parent.hasProperty("j:rootTemplatePath")) {
            Template t;
            String rootTemplatePath = parent.getProperty("j:rootTemplatePath").getString();
            if (rootTemplatePath.contains("/")) {
                rootTemplatePath = StringUtils.substringAfterLast((String)rootTemplatePath, (String)"/");
            }
            if (!StringUtils.isEmpty((String)rootTemplatePath) && (t = this.addTemplate(resource, renderContext, rootTemplatePath, modules, "jnt:template")) != null) {
                t.setNext(template);
                return t;
            }
        }
        return template;
    }

    private Template addTemplate(Resource resource, RenderContext renderContext, String templateName, Set<String> installedModules, String type) throws RepositoryException {
        TreeSet<Template> templates = new TreeSet<Template>(TEMPLATE_PRIORITY_COMPARATOR);
        for (String s : installedModules) {
            JahiaTemplatesPackage pack = this.templateManagerService.getTemplatePackageById(s);
            if (pack == null) continue;
            JCRNodeWrapper templateNode = resource.getNode().getSession().getNode("/modules/" + s + "/" + pack.getVersion());
            templates.addAll(this.addTemplates(resource, renderContext, templateName, templateNode, type));
        }
        return templates.isEmpty() ? null : (Template)templates.last();
    }

    private SortedSet<Template> addTemplates(Resource resource, RenderContext renderContext, String templateName, JCRNodeWrapper templateNode, String type) throws RepositoryException {
        List<JCRNodeWrapper> nodes = this.getTemplateNodes(templateName, templateNode.getPath(), type, templateName == null, templateNode.getSession());
        TreeSet<Template> templates = new TreeSet<Template>(TEMPLATE_PRIORITY_COMPARATOR);
        for (JCRNodeWrapper contentTemplateNode : nodes) {
            this.addTemplate(resource, renderContext, contentTemplateNode, templates);
        }
        return templates;
    }

    public List<JCRNodeWrapper> getTemplateNodes(String templateName, String path, String type, boolean defaultOnly, JCRSessionWrapper session) throws RepositoryException {
        String key = path + type + defaultOnly + (templateName != null ? templateName : "*all*");
        return this.doExecuteWithTemplatesCacheLock(path, false, () -> {
            List nodeIds;
            List<Object> nodes = new ArrayList<JCRNodeWrapper>();
            Element nodeIdsElement = this.templatesCache.get((Serializable)((Object)key));
            List list = nodeIds = nodeIdsElement != null ? (List)nodeIdsElement.getObjectValue() : null;
            if (nodeIds != null) {
                for (String nodeId : nodeIds) {
                    JCRNodeWrapper node2 = session.getNodeByIdentifier(nodeId);
                    nodes.add(node2);
                }
            } else {
                long startTime = System.currentTimeMillis();
                List<JCRNodeWrapper> results = this.getDescendantNodesOfType(session.getNode(path + "/templates"), type);
                Stream stream = results.stream();
                nodes = stream.filter(ThrowingPredicate.unchecked(node -> (StringUtils.isBlank((String)templateName) || node.getName().equals(templateName)) && (!defaultOnly || node.hasProperty("j:defaultTemplate") && node.getProperty("j:defaultTemplate").getBoolean()))).sorted(TEMPLATE_NODE_PRIORITY_COMPARATOR).collect(Collectors.toList());
                nodeIds = nodes.stream().map(ThrowingFunction.unchecked(Node::getIdentifier)).collect(Collectors.toList());
                this.templatesCache.put(new Element((Object)key, nodeIds));
                if (logger.isDebugEnabled()) {
                    logger.debug("Generated cache entry for key {} with {} node IDs in {} ms", new Object[]{key, nodeIds.size(), System.currentTimeMillis() - startTime});
                }
            }
            return nodes;
        });
    }

    private List<JCRNodeWrapper> getDescendantNodesOfType(JCRNodeWrapper node, String type) {
        List<JCRNodeWrapper> nodesToIterate = JCRContentUtils.getNodes(node, "jnt:template");
        List<JCRNodeWrapper> nodesToAdd = JCRContentUtils.getNodes(node, type);
        ArrayList<JCRNodeWrapper> results = new ArrayList<JCRNodeWrapper>(nodesToAdd);
        for (JCRNodeWrapper childNode : nodesToIterate) {
            results.addAll(this.getDescendantNodesOfType(childNode, type));
        }
        return results;
    }

    private void addTemplate(Resource resource, RenderContext renderContext, JCRNodeWrapper templateNode, SortedSet<Template> templates) throws RepositoryException {
        if (!this.checkJApplyOn(templateNode, resource.getNode(), null)) {
            return;
        }
        if (!this.checkChannel(renderContext, templateNode)) {
            return;
        }
        if (!this.checkTemplatePermission(resource, renderContext, templateNode)) {
            return;
        }
        templates.add(new Template(templateNode.hasProperty("j:view") ? templateNode.getProperty("j:view").getString() : null, templateNode.getIdentifier(), null, templateNode.getName(), templateNode.hasProperty("j:priority") ? (int)templateNode.getProperty("j:priority").getLong() : 0));
    }

    private boolean checkJApplyOn(JCRNodeWrapper templateNode, JCRNodeWrapper currentNode, ExtendedNodeType currentNodeType) throws RepositoryException {
        boolean ok = true;
        if (templateNode.hasProperty("j:applyOn")) {
            JCRValueWrapper[] values;
            ok = false;
            for (JCRValueWrapper value : values = templateNode.getProperty("j:applyOn").getValues()) {
                if (currentNode != null && currentNode.isNodeType(value.getString())) {
                    ok = true;
                    break;
                }
                if (currentNodeType == null || !currentNodeType.isNodeType(value.getString())) continue;
                ok = true;
                break;
            }
            if (values.length == 0) {
                ok = true;
            }
        }
        return ok;
    }

    private boolean checkChannel(RenderContext renderContext, JCRNodeWrapper templateNode) throws RepositoryException {
        if (templateNode.isNodeType("jmix:channelSelection") && templateNode.hasProperty("j:channelSelection")) {
            JCRPropertyWrapper channelExclusionProperty = templateNode.getProperty("j:channelSelection");
            String includeOrExclude = templateNode.hasProperty("j:channelIncludeOrExclude") ? templateNode.getProperty("j:channelIncludeOrExclude").getString() : "exclude";
            Value[] channelExclusionValues = channelExclusionProperty.getValues();
            Channel currentChannel = renderContext.getChannel();
            for (Value channelExclusionValue : channelExclusionValues) {
                if (channelExclusionValue.getString() == null) continue;
                boolean inList = this.channelService.matchChannel(channelExclusionValue.getString(), currentChannel);
                if (inList && includeOrExclude.equals("exclude")) {
                    return renderContext.isEditMode() && (renderContext.getChannel() == null || renderContext.getChannel().getIdentifier().equals("generic"));
                }
                if (!inList || !includeOrExclude.equals("include")) continue;
                return true;
            }
            if (includeOrExclude.equals("include")) {
                return renderContext.isEditMode() && (renderContext.getChannel() == null || renderContext.getChannel().getIdentifier().equals("generic"));
            }
        }
        return true;
    }

    private boolean checkTemplatePermission(Resource resource, RenderContext renderContext, JCRNodeWrapper templateNode) throws RepositoryException {
        JCRUserNode userNode;
        boolean invert;
        boolean bl = invert = templateNode.hasProperty("j:invertCondition") && templateNode.getProperty("j:invertCondition").getBoolean();
        if (templateNode.hasProperty("j:requiredMode") && renderContext.getMode() != null) {
            String req = templateNode.getProperty("j:requiredMode").getString();
            if (!renderContext.getMode().equals(req)) {
                return invert;
            }
        }
        if (templateNode.hasProperty("j:requiredPermissionNames") || templateNode.hasProperty("j:requiredPermissions")) {
            String contextPath;
            Value[] values;
            ArrayList<String> perms = new ArrayList<String>();
            if (templateNode.hasProperty("j:requiredPermissions") && !templateNode.hasProperty("j:requiredPermissionNames")) {
                values = templateNode.getProperty("j:requiredPermissions").getValues();
                perms.addAll((Collection)JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<List<String>>(){

                    @Override
                    public List<String> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        ArrayList<String> permissionNames = new ArrayList<String>();
                        for (Value value : values) {
                            permissionNames.add(session.getNodeByUUID(value.getString()).getName());
                        }
                        return permissionNames;
                    }
                }));
            } else {
                values = templateNode.getProperty("j:requiredPermissionNames").getValues();
                for (Value value : values) {
                    perms.add(value.getString());
                }
            }
            JCRNodeWrapper contextNode = resource.getNode();
            if (templateNode.hasProperty("j:contextNodePath") && !StringUtils.isEmpty((String)(contextPath = templateNode.getProperty("j:contextNodePath").getString()))) {
                contextNode = contextPath.startsWith("/") ? contextNode.getSession().getNode(contextPath) : contextNode.getNode(contextPath);
            }
            for (String perm : perms) {
                if (contextNode.hasPermission(perm)) continue;
                return invert;
            }
        }
        if (templateNode.hasProperty("j:requireLoggedUser") && templateNode.getProperty("j:requireLoggedUser").getBoolean() && !renderContext.isLoggedIn()) {
            return invert;
        }
        if (templateNode.hasProperty("j:requirePrivilegedUser") && templateNode.getProperty("j:requirePrivilegedUser").getBoolean() && (userNode = this.userManagerService.lookupUserByPath(renderContext.getUser().getLocalPath())) != null && !userNode.isMemberOfGroup(null, "privileged")) {
            return invert;
        }
        return !invert;
    }

    @Override
    public void flushCache(String modulePath) {
        try {
            this.doExecuteWithTemplatesCacheLock(modulePath, true, () -> {
                HashSet keys = new HashSet(this.templatesCache.getKeys());
                for (String key : keys) {
                    if (!key.startsWith(modulePath)) continue;
                    this.templatesCache.remove((Serializable)((Object)key));
                }
                return null;
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <X> X doExecuteWithTemplatesCacheLock(String modulePath, boolean write, LockedExecutionCallback<X> lockedExecutionCallback) throws RepositoryException {
        Lock lock;
        if (this.templatesCacheLockTimeout == 0L) {
            return lockedExecutionCallback.doExecuteWithLock();
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.templatesCacheLockAccess.computeIfAbsent(modulePath, k -> new ReentrantReadWriteLock());
        Lock lock2 = lock = write ? reentrantReadWriteLock.writeLock() : reentrantReadWriteLock.readLock();
        if (this.templatesCacheLockTimeout > 0L) {
            try {
                if (lock.tryLock(this.templatesCacheLockTimeout, TimeUnit.MILLISECONDS)) {
                    try {
                        X x = lockedExecutionCallback.doExecuteWithLock();
                        return x;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                throw new RuntimeException(String.format("Timeout [%d] reached: fail to acquire [%s] lock on templates cache for [%s]", this.templatesCacheLockTimeout, write ? "WRITE" : "READ", modulePath));
            }
            catch (InterruptedException e) {
                throw new CancellationException(String.format("Thread interrupted: fail to acquire [%s] lock on templates cache for [%s]", write ? "WRITE" : "READ", modulePath));
            }
        }
        lock.lock();
        try {
            X x = lockedExecutionCallback.doExecuteWithLock();
            return x;
        }
        finally {
            lock.unlock();
        }
    }

    public void setCacheProvider(EhCacheProvider cacheProvider) {
        CacheManager cacheManager = cacheProvider.getCacheManager();
        this.templatesCache = cacheManager.getCache("RenderService.TemplatesCache");
        if (this.templatesCache == null) {
            cacheManager.addCache("RenderService.TemplatesCache");
            this.templatesCache = cacheManager.getCache("RenderService.TemplatesCache");
        }
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsPanelTheme = settingsBean.getString("jahia.ui.settingsPanels.theme", null);
    }

    private String getSettingsPanelsTheme(RenderContext renderContext) {
        String mode = renderContext.getMode();
        if (mode != null && ("studio".equals(mode) || "studiovisual".equals(mode))) {
            return null;
        }
        String theme = null;
        if (this.settingsPanelTheme != null) {
            theme = this.settingsPanelTheme.equals("default") ? null : this.settingsPanelTheme;
        } else if (renderContext.getRequest() != null) {
            theme = WebUtils.getUITheme(renderContext.getRequest());
        }
        return theme;
    }

    public void setTemplatesCacheLockTimeout(long templatesCacheLockTimeout) {
        this.templatesCacheLockTimeout = templatesCacheLockTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.templatesCacheLockTimeout != 0L) {
            logger.info("Will be using extra locking on write operations into cache RenderService.TemplatesCache with a timeout of {} ms", (Object)this.templatesCacheLockTimeout);
        } else {
            logger.info("No extra locking will be used on write operations into cache RenderService.TemplatesCache");
        }
    }

    private static interface LockedExecutionCallback<T> {
        public T doExecuteWithLock() throws RepositoryException;
    }

    private static class TemplateNodePriorityComparator
    implements Comparator<JCRNodeWrapper>,
    Serializable {
        private static final long serialVersionUID = 5584826951926361906L;

        private TemplateNodePriorityComparator() {
        }

        @Override
        public int compare(JCRNodeWrapper node1, JCRNodeWrapper node2) {
            long node1Priority = 0L;
            long node2Priority = 0L;
            try {
                if (node1.hasProperty("j:priority")) {
                    node1Priority = node1.getProperty("j:priority").getLong();
                }
                if (node2.hasProperty("j:priority")) {
                    node2Priority = node2.getProperty("j:priority").getLong();
                }
            }
            catch (RepositoryException e) {
                logger.error("Could not read property j:priority", (Throwable)e);
            }
            return -Long.compare(node1Priority, node2Priority);
        }
    }

    private static class TemplatePriorityComparator
    implements Comparator<Template>,
    Serializable {
        private static final long serialVersionUID = 3462731866743025112L;

        private TemplatePriorityComparator() {
        }

        @Override
        public int compare(Template o1, Template o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }
}

