/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.services.channels.Channel;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.render.Resource;
import org.jahia.services.render.SiteInfo;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.render.filter.cache.ClientCachePolicy;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.settings.readonlymode.ReadOnlyModeController;
import org.jahia.utils.LanguageCodeConverters;

public class RenderContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Resource mainResource;
    private JahiaUser user;
    private JCRSiteNode site;
    private URLGenerator URLGenerator;
    private Locale uiLocale;
    private Stack<Resource> resourcesStack = new Stack();
    private Set<String> renderedPaths = new HashSet<String>();
    private boolean isContributionMode = false;
    private boolean isEditMode = false;
    private EditConfiguration editModeConfig;
    private String servletPath;
    private String workspace = "default";
    private Set<String> displayedModules = new HashSet<String>();
    private String redirect;
    private String contentType;
    private Map<String, Map<String, Integer>> templatesCacheExpiration = new HashMap<String, Map<String, Integer>>();
    private boolean ajaxRequest = false;
    private Resource ajaxResource = null;
    private Channel channel = null;
    private String mode;
    private SiteInfo siteInfo;
    private boolean forceUILocaleForJCRSession;
    private boolean ugcEnabled = true;
    private ClientCachePolicy clientCachePolicy;

    public RenderContext(HttpServletRequest request, HttpServletResponse response, JahiaUser user) {
        this.request = request;
        this.response = response;
        this.user = user;
        this.clientCachePolicy = ClientCachePolicy.DEFAULT;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public JahiaUser getUser() {
        return this.user;
    }

    public JCRSiteNode getSite() {
        return this.site;
    }

    public void setSite(JCRSiteNode site) {
        this.site = site;
    }

    public URLGenerator getURLGenerator() {
        return this.URLGenerator;
    }

    public void setURLGenerator(URLGenerator URLGenerator2) {
        this.URLGenerator = URLGenerator2;
    }

    public Set<String> getDisplayedModules() {
        return this.displayedModules;
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean editMode) {
        this.isEditMode = editMode;
    }

    public String getMode() {
        if (this.mode == null && this.servletPath != null) {
            this.mode = StringUtils.substringAfterLast((String)this.servletPath, (String)"/");
            if (this.mode.endsWith("frame")) {
                this.mode = StringUtils.substringBefore((String)this.mode, (String)"frame");
            }
            if ("render".equals(this.mode)) {
                this.mode = this.workspace.equals("live") ? "live" : "preview";
            }
        }
        return this.mode;
    }

    public String getEditModeConfigName() {
        return this.editModeConfig != null ? this.editModeConfig.getName() : null;
    }

    public EditConfiguration getEditModeConfig() {
        return this.editModeConfig;
    }

    public void setEditModeConfig(EditConfiguration editModeConfig) {
        this.editModeConfig = editModeConfig;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
        JCRSessionFactory.getInstance().setCurrentServletPath(servletPath);
        this.mode = null;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
        this.mode = null;
    }

    public boolean isContributionMode() {
        return this.isContributionMode;
    }

    public void setContributionMode(boolean contributionMode) {
        this.isContributionMode = contributionMode;
    }

    public boolean isLoggedIn() {
        return !JahiaUserManagerService.isGuest(this.getUser());
    }

    public Map<String, Map<String, Integer>> getTemplatesCacheExpiration() {
        return this.templatesCacheExpiration;
    }

    public void setMainResource(Resource mainResource) {
        this.mainResource = mainResource;
    }

    public Resource getMainResource() {
        return this.mainResource;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Set<String> getRenderedPaths() {
        return this.renderedPaths;
    }

    public Stack<Resource> getResourcesStack() {
        return this.resourcesStack;
    }

    public Locale getMainResourceLocale() {
        return this.getMainResource().getLocale();
    }

    public Locale getUILocale() {
        if (this.uiLocale == null) {
            Locale locale = null;
            if (!JahiaUserManagerService.isGuest(this.getUser())) {
                JCRUserNode userNode = JahiaUserManagerService.getInstance().lookupUserByPath(this.getUser().getLocalPath());
                locale = UserPreferencesHelper.getPreferredLocale(userNode, LanguageCodeConverters.resolveLocaleForGuest(this.request));
            }
            if (locale == null && this.mainResource != null) {
                locale = this.getMainResourceLocale();
            }
            this.uiLocale = locale;
            if (this.uiLocale != null) {
                this.request.getSession().setAttribute("org.jahia.services.multilang.uilocale", (Object)this.uiLocale);
            }
        }
        return this.uiLocale;
    }

    public Locale getFallbackLocale() {
        if (this.site != null) {
            return this.site.isMixLanguagesActive() ? LanguageCodeConverters.languageCodeToLocale(this.site.getDefaultLanguage()) : null;
        }
        return null;
    }

    public boolean isLiveMode() {
        return this.getMode().equals("live");
    }

    public boolean isPreviewMode() {
        return this.getMode().equals("preview");
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    public void setAjaxResource(Resource ajaxResource) {
        this.ajaxResource = ajaxResource;
    }

    public Resource getAjaxResource() {
        return this.ajaxResource;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public boolean isEnterpriseEdition() {
        return Jahia.isEnterpriseEdition();
    }

    public SettingsBean getSettings() {
        return SettingsBean.getInstance();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public boolean isVisible(JCRNodeWrapper node) throws RepositoryException {
        if (this.editModeConfig != null) {
            if (this.editModeConfig.getBypassModeForTypes() != null && !this.editModeConfig.getBypassModeForTypes().isEmpty() && this.isNodeOfType(this.mainResource.getNode(), this.editModeConfig.getBypassModeForTypes())) {
                return true;
            }
            if (this.editModeConfig.getNonVisibleTypes() != null && !this.editModeConfig.getNonVisibleTypes().isEmpty() && this.isNodeOfType(node, this.editModeConfig.getNonVisibleTypes())) {
                return false;
            }
            if (this.editModeConfig.getVisibleTypes() != null && !this.editModeConfig.getVisibleTypes().isEmpty() && !this.isNodeOfType(node, this.editModeConfig.getVisibleTypes())) {
                return false;
            }
        }
        return true;
    }

    public boolean isEditable(JCRNodeWrapper node) throws RepositoryException {
        if (this.editModeConfig != null) {
            if (this.editModeConfig.getBypassModeForTypes() != null && !this.editModeConfig.getBypassModeForTypes().isEmpty() && this.isNodeOfType(this.mainResource.getNode(), this.editModeConfig.getBypassModeForTypes())) {
                return false;
            }
            if (this.editModeConfig.getNonEditableTypes() != null && !this.editModeConfig.getNonEditableTypes().isEmpty() && this.isNodeOfType(node, this.editModeConfig.getNonEditableTypes())) {
                return false;
            }
            return this.editModeConfig.getEditableTypes() == null || this.editModeConfig.getEditableTypes().isEmpty() || this.isNodeOfType(node, this.editModeConfig.getEditableTypes());
        }
        return false;
    }

    private boolean isNodeOfType(JCRNodeWrapper node, Set<String> types) throws RepositoryException {
        if (types != null && node != null) {
            for (String s : types) {
                if (!node.isNodeType(s)) continue;
                return true;
            }
        }
        return false;
    }

    public void setSiteInfo(SiteInfo siteInfo) {
        this.siteInfo = siteInfo;
    }

    public SiteInfo getSiteInfo() {
        return this.siteInfo;
    }

    public void setForceUILocaleForJCRSession(boolean forceUILocaleForJCRSession) {
        this.forceUILocaleForJCRSession = forceUILocaleForJCRSession;
    }

    public boolean isForceUILocaleForJCRSession() {
        return this.forceUILocaleForJCRSession;
    }

    public boolean isUgcEnabled() {
        return this.isLiveMode() && this.ugcEnabled;
    }

    public void setUgcEnabled(boolean ugcEnabled) {
        this.ugcEnabled = ugcEnabled;
    }

    public ReadOnlyModeController.ReadOnlyModeStatus getReadOnlyStatus() {
        return ReadOnlyModeController.getInstance().getReadOnlyStatus();
    }

    public boolean isReadOnly() {
        SettingsBean settings = SettingsBean.getInstance();
        return settings.isReadOnlyMode() || settings.isMaintenanceMode() || settings.isFullReadOnlyMode();
    }

    public synchronized void computeClientCachePolicy(ClientCachePolicy policy) {
        if (policy.isStronger(this.clientCachePolicy)) {
            this.clientCachePolicy = policy;
        }
    }

    public ClientCachePolicy getClientCachePolicy() {
        return this.clientCachePolicy;
    }
}

