/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.RenderTimeMonitor;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.TemplateResolver;
import org.jahia.services.render.View;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.render.filter.RenderServiceAware;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.render.scripting.ScriptResolver;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RenderService {
    public static final String RENDER_SERVICE_TEMPLATES_CACHE = "RenderService.TemplatesCache";
    private static final Logger logger = LoggerFactory.getLogger(RenderService.class);
    private static volatile RenderService instance;
    private RenderTimeMonitor renderTimeMonitor;
    private Collection<TemplateResolver> templateResolvers = new ArrayList<TemplateResolver>();
    private JahiaTemplateManagerService templateManagerService;
    private Collection<ScriptResolver> scriptResolvers;
    private List<RenderFilter> filters = new LinkedList<RenderFilter>();

    private void addFilter(RenderFilter renderFilter) {
        if (this.filters.contains(renderFilter)) {
            this.filters.remove(renderFilter);
        }
        this.filters.add(renderFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RenderService getInstance() {
        if (instance != null) return instance;
        Class<RenderService> clazz = RenderService.class;
        synchronized (RenderService.class) {
            if (instance != null) return instance;
            instance = new RenderService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setScriptResolvers(Collection<ScriptResolver> scriptResolvers) {
        this.scriptResolvers = scriptResolvers;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    public Collection<ScriptResolver> getScriptResolvers() {
        return this.scriptResolvers;
    }

    public Collection<TemplateResolver> getTemplateResolvers() {
        return this.templateResolvers;
    }

    public void setTemplateResolvers(Collection<TemplateResolver> templateResolvers) {
        this.templateResolvers = templateResolvers;
    }

    public void start() throws JahiaInitializationException {
    }

    public void stop() throws JahiaException {
    }

    public String render(Resource resource, RenderContext context) throws RenderException {
        if (context.getResourcesStack().contains(resource)) {
            String resourceMessage = Messages.getInternal("label.render.loop", context.getUILocale());
            String formattedMessage = MessageFormat.format(resourceMessage, resource.getPath());
            logger.warn("Loop detected while rendering resource {}. Please check your content structure and references.", (Object)resource.getPath());
            return formattedMessage;
        }
        if (this.renderTimeMonitor != null) {
            this.renderTimeMonitor.track(context.getRequest());
        }
        String output = this.getRenderChainInstance().doFilter(context, resource);
        if (this.renderTimeMonitor != null) {
            this.renderTimeMonitor.monitor(resource, context);
        }
        return output;
    }

    public Script resolveScript(Resource resource, RenderContext context) throws RepositoryException, TemplateNotFoundException {
        for (ScriptResolver scriptResolver : this.scriptResolvers) {
            try {
                Script s = scriptResolver.resolveScript(resource, context);
                if (s == null) continue;
                return s;
            }
            catch (TemplateNotFoundException templateNotFoundException) {
            }
        }
        throw new TemplateNotFoundException("Unable to find the template for resource " + resource);
    }

    public boolean hasView(JCRNodeWrapper node, String key, String templateType, RenderContext renderContext) {
        try {
            if (this.hasView(node.getPrimaryNodeType(), key, renderContext.getSite(), templateType, renderContext)) {
                return true;
            }
            for (ExtendedNodeType type : node.getMixinNodeTypes()) {
                if (!this.hasView(type, key, renderContext.getSite(), templateType, renderContext)) continue;
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean hasView(ExtendedNodeType nt, String key, JCRSiteNode site, String templateType, RenderContext renderContext) {
        for (ScriptResolver scriptResolver : this.scriptResolvers) {
            if (!scriptResolver.hasView(nt, key, site, templateType)) continue;
            return true;
        }
        return false;
    }

    public RenderChain getRenderChainInstance() {
        return new RenderChain(this.filters, this.templateManagerService.getRenderFilters());
    }

    public SortedSet<View> getViewsSet(ExtendedNodeType nt, JCRSiteNode site, String templateType) {
        TreeSet<View> set = new TreeSet<View>();
        for (ScriptResolver scriptResolver : this.scriptResolvers) {
            set.addAll(scriptResolver.getViewsSet(nt, site, templateType));
        }
        return set;
    }

    public boolean hasTemplate(String templateName, ExtendedNodeType nodeType, Set<String> templatePackages) throws RepositoryException {
        if (nodeType == null) {
            throw new IllegalArgumentException("Node type is null");
        }
        if (StringUtils.isEmpty((String)templateName)) {
            throw new IllegalArgumentException("Template path is either null or empty");
        }
        if (templatePackages == null || templatePackages.isEmpty()) {
            throw new IllegalArgumentException("The template/module set to check is empty");
        }
        for (TemplateResolver templateResolver : this.templateResolvers) {
            if (!templateResolver.hasTemplate(templateName, nodeType, templatePackages)) continue;
            return true;
        }
        return false;
    }

    public Template resolveTemplate(Resource resource, RenderContext renderContext) throws RepositoryException {
        Template template = null;
        for (TemplateResolver templateResolver : this.templateResolvers) {
            template = templateResolver.resolveTemplate(resource, renderContext);
            if (template == null) continue;
            return template;
        }
        return template;
    }

    public void flushCache(String modulePath) {
        for (TemplateResolver templateResolver : this.templateResolvers) {
            templateResolver.flushCache(modulePath);
        }
    }

    public void setRenderTimeMonitor(RenderTimeMonitor renderChainMonitor) {
        this.renderTimeMonitor = renderChainMonitor;
    }

    public static class RenderServiceBeanPostProcessor
    implements BeanPostProcessor {
        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof RenderServiceAware) {
                ((RenderServiceAware)bean).setRenderService(RenderService.getInstance());
            }
            if (bean instanceof RenderFilter) {
                logger.debug("Registering render filter {}", (Object)bean.getClass().getName());
                RenderService.getInstance().addFilter((RenderFilter)bean);
            }
            return bean;
        }
    }
}

