/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jahia.utils.Patterns;

public class Template
implements Serializable {
    private static final long serialVersionUID = -1700784569502723022L;
    public String name;
    public Template next;
    public String node;
    public int priority;
    public String view;
    private boolean external = false;

    public Template(String serialized) {
        String[] s = Patterns.SLASH.split(StringUtils.substringBefore((String)serialized, (String)"|"));
        this.view = s[0].equals("null") ? null : s[0];
        this.node = s[1];
        this.name = s[2].equals("null") ? null : s[2];
        String n = StringUtils.substringAfter((String)serialized, (String)"|");
        if (!StringUtils.isEmpty((String)n)) {
            this.next = new Template(n);
        }
    }

    public Template(String view, String node, Template next, String name) {
        this(view, node, next, name, 0);
    }

    public Template(String view, String node, Template next, String name, int priority) {
        this.view = view;
        this.node = node;
        this.name = name;
        this.next = next;
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public Template getNext() {
        return this.next;
    }

    public List<Template> getNextTemplates() {
        List<Object> t = this.next == null ? new ArrayList() : this.next.getNextTemplates();
        t.add(this);
        return t;
    }

    public String getNode() {
        return this.node;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getView() {
        return this.view != null ? this.view : "default";
    }

    public String serialize() {
        return this.serialize(new StringBuilder(64)).toString();
    }

    protected StringBuilder serialize(StringBuilder buffer) {
        buffer.append(this.view).append("/").append(this.node).append("/").append(this.name);
        if (this.next != null) {
            buffer.append("|");
            this.next.serialize(buffer);
        }
        return buffer;
    }

    void setNext(Template next) {
        this.next = next;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public String toString() {
        return "template " + this.name + " with view " + this.view + " for node " + this.node;
    }
}

