/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import javax.servlet.http.HttpServletRequest;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.scripting.Script;

public class NodeAttributesFilter
extends AbstractFilter {
    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        JCRNodeWrapper node = resource.getNode();
        HttpServletRequest request = renderContext.getRequest();
        chain.pushAttribute(request, "workspace", node.getSession().getWorkspace().getName());
        chain.pushAttribute(request, "currentWorkspace", node.getSession().getWorkspace().getName());
        Script script = resource.getScript(renderContext);
        if (script != null) {
            chain.pushAttribute(request, "script", script);
            chain.pushAttribute(request, "scriptInfo", script.getView().getInfo());
        } else {
            chain.pushAttribute(request, "script", null);
            chain.pushAttribute(request, "scriptInfo", null);
        }
        if (!"include".equals(resource.getContextConfiguration())) {
            chain.pushAttribute(request, "currentNode", node);
        }
        return null;
    }
}

