/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Stack;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.errors.ErrorFileDumper;
import org.jahia.bin.errors.StackTraceFilter;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.View;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.AggregateFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.scripting.Script;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;
import org.springframework.util.StopWatch;

public class TemplateScriptFilter
extends AbstractFilter {
    private static Logger logger = LoggerFactory.getLogger(TemplateScriptFilter.class);
    private static final String RENDERING_FAILURE_VIEW_KEY = "jahiaTemplateScriptFilterRenderingFailure";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        Profiler profiler = (Profiler)renderContext.getRequest().getAttribute("profiler");
        if (profiler != null) {
            profiler.start("render template " + resource.getResolvedTemplate());
        }
        HttpServletRequest request = renderContext.getRequest();
        Script script = (Script)request.getAttribute("script");
        renderContext.getResourcesStack().push(resource);
        StringBuilder output = null;
        String outputString = null;
        Stack<StopWatch> stopWatchStack = null;
        try {
            boolean moduleInfo;
            if (logger.isDebugEnabled()) {
                logger.debug("Render " + script.getView().getPath() + " for resource: " + resource);
                if (renderContext.getRequest().getAttribute("previousTemplate") != null) {
                    logger.debug("previousTemplate object for rendering before script: " + ((Template)renderContext.getRequest().getAttribute("previousTemplate")).serialize());
                } else {
                    logger.debug("previousTemplate object for rendering before script is null.");
                }
                if (renderContext.getRequest().getAttribute("usedTemplate") != null) {
                    logger.debug("usedTemplate object for rendering before script: " + ((Template)renderContext.getRequest().getAttribute("usedTemplate")).serialize());
                } else {
                    logger.debug("usedTemplate object for rendering before script is null.");
                }
            }
            long start = 0L;
            StopWatch stopWatch = null;
            boolean bl = moduleInfo = SettingsBean.getInstance().isDevelopmentMode() && Boolean.valueOf(renderContext.getRequest().getParameter("moduleinfo")) != false && !resource.getNode().isNodeType("jnt:template");
            if (moduleInfo) {
                output = new StringBuilder();
                output.append("\n<fieldset class=\"moduleinfo\"> ");
                start = System.currentTimeMillis();
                stopWatchStack = (Stack)renderContext.getRequest().getAttribute("stopWatchStack");
                if (stopWatchStack == null) {
                    stopWatchStack = new Stack<StopWatch>();
                    renderContext.getRequest().setAttribute("stopWatchStack", stopWatchStack);
                }
                if (!stopWatchStack.isEmpty()) {
                    ((StopWatch)stopWatchStack.peek()).stop();
                }
                stopWatch = new StopWatch();
                stopWatchStack.push(stopWatch);
                stopWatch.start();
            }
            boolean skipAggregation = false;
            if (!AggregateFilter.skipAggregation((ServletRequest)request) && Boolean.valueOf(script.getView().getProperties().getProperty("skip.aggregation")).booleanValue()) {
                skipAggregation = true;
                request.setAttribute("aggregateFilter.skip", (Object)true);
                resource.getRegexpDependencies().add(resource.getNodePath() + "/.*");
            }
            outputString = script.execute(resource, renderContext);
            if (skipAggregation) {
                request.removeAttribute("aggregateFilter.skip");
            }
            if (logger.isDebugEnabled()) {
                if (renderContext.getRequest().getAttribute("previousTemplate") != null) {
                    logger.debug("Current previousTemplate object for rendering after script: " + ((Template)renderContext.getRequest().getAttribute("previousTemplate")).serialize());
                } else {
                    logger.debug("previousTemplate object for rendering after script is null.");
                }
                if (renderContext.getRequest().getAttribute("usedTemplate") != null) {
                    logger.debug("Current usedTemplate object for rendering after script: " + ((Template)renderContext.getRequest().getAttribute("usedTemplate")).serialize());
                } else {
                    logger.debug("usedTemplate object for rendering after script is null.");
                }
            }
            if (moduleInfo) {
                output.append(outputString);
                stopWatch.stop();
                View view = script.getView();
                output.append("<legend>").append("<img src=\"").append(renderContext.getURLGenerator().getContext()).append("/modules/default/images/icons/information.png").append("\" title=\"Module: ").append(view.getModule().getId()).append("-").append(view.getModuleVersion()).append(" ").append(view.getInfo()).append(" node : ").append(resource.getNode().getPath()).append(" in total: ").append(System.currentTimeMillis() - start).append("ms").append(" , own time: ").append(stopWatch.getTotalTimeMillis()).append("ms").append("\"/></legend>");
                output.append("</fieldset>");
                outputString = output.toString();
            }
        }
        finally {
            renderContext.getResourcesStack().pop();
            if (stopWatchStack != null) {
                stopWatchStack.pop();
                if (!stopWatchStack.isEmpty()) {
                    ((StopWatch)stopWatchStack.peek()).start();
                }
            }
        }
        return outputString.trim();
    }

    @Override
    public String getContentForError(RenderContext renderContext, Resource resource, RenderChain renderChain, Exception e) {
        if (renderContext.isEditMode()) {
            View originalView;
            if (!ErrorFileDumper.isShutdown()) {
                try {
                    ErrorFileDumper.dumpToFile(e, renderContext.getRequest());
                }
                catch (IOException errorDumpingException) {
                    logger.error("Cannot dump error correctly", (Throwable)errorDumpingException);
                }
            }
            String printedError = this.getExceptionDetails(e);
            Script originalScript = (Script)renderContext.getRequest().getAttribute("script");
            String originalViewPath = null;
            String originalViewKey = null;
            View view = originalView = originalScript != null ? originalScript.getView() : null;
            if (originalView != null) {
                originalViewPath = originalView.getPath();
                originalViewKey = originalView.getKey();
                if (RENDERING_FAILURE_VIEW_KEY.equals(originalViewKey)) {
                    return printedError;
                }
            }
            Resource errorResource = new Resource(resource.getNode(), "html", RENDERING_FAILURE_VIEW_KEY, "module");
            try {
                View errorView;
                Script errorScript = errorResource.getScript(renderContext);
                View view2 = errorView = errorScript != null ? errorScript.getView() : null;
                if (errorView != null && RENDERING_FAILURE_VIEW_KEY.equals(errorView.getKey())) {
                    if (SettingsBean.getInstance().isDevelopmentMode()) {
                        errorResource.getModuleParams().put("error", e);
                        errorResource.getModuleParams().put("errorId", UUID.randomUUID());
                        errorResource.getModuleParams().put("printedError", (Serializable)((Object)printedError));
                    }
                    errorResource.getModuleParams().put("originalViewPath", (Serializable)((Object)originalViewPath));
                    errorResource.getModuleParams().put("originalViewKey", (Serializable)((Object)originalViewKey));
                    return this.service.render(errorResource, renderContext);
                }
            }
            catch (Exception errorRenderingException) {
                logger.debug("Cannot render error correctly, original StackTrace will be rendered", (Throwable)errorRenderingException);
                return printedError;
            }
            return printedError;
        }
        return super.getContentForError(renderContext, resource, renderChain, e);
    }

    private String getExceptionDetails(Throwable ex) {
        StringWriter out = new StringWriter();
        out.append(ex.getMessage()).append("\n");
        out.append(StackTraceFilter.printStackTrace(ex));
        out.append("\n");
        return "<pre>" + out + "</pre>";
    }
}

