/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.ClientCachePolicy;
import org.jahia.services.render.filter.cache.PrincipalAcl;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class AclCacheKeyPartGenerator
implements CacheKeyPartGenerator,
InitializingBean {
    public static final String PER_USER = "_perUser_";
    public static final String MR_ACL = "_mraclmr_";
    public static final String PER_USER_MR_ACL = "_perUser_,_mraclmr_";
    public static final String LOGGED_USER = "_logged_";
    public static final String GROUPS_SIGNATURE = "_groupsSignature_";
    public static final Pattern P_PATTERN = Pattern.compile("_p_");
    public static final Pattern DEP_ACLS_PATTERN = Pattern.compile("_depacl_");
    public static final Pattern ACLS_PATH_PATTERN = Pattern.compile("_p_");
    private static final String[] SUBSTITUTION_STR = new String[]{"%0", "%1", "%2"};
    private static final String[] SPECIFIC_STR = new String[]{"@@", ",", "%"};
    private static final Logger logger = LoggerFactory.getLogger(AclCacheKeyPartGenerator.class);
    private static final String CACHE_NAME = "HTMLNodeUsersACLs";
    private static final String CACHE_ALL_PRINCIPALS_ENTRY_KEY = "all principals";
    private static final String PROPERTY_CACHE_NAME = "HTMLRequiredPermissionsCache";
    private final Object objForSync = new Object();
    private final ConcurrentMap<String, Semaphore> processings = new ConcurrentHashMap<String, Semaphore>();
    private EhCacheProvider cacheProvider;
    private Cache cache;
    private JahiaGroupManagerService groupManagerService;
    private Cache permissionCache;
    private JCRTemplate template;
    private boolean usePerUser = false;
    private boolean useGroupsSignature = false;
    private Set<String> groupsSignatureAclPathsToQuery;
    private String allPrincipalsWithAclQuery;

    private static boolean isUnderUsersNode(String path) {
        if (path.startsWith("/users/")) {
            return true;
        }
        if (path.startsWith("/sites/") && path.contains("/users/")) {
            String siteKey = JCRContentUtils.getSiteKey(path);
            return siteKey != null && path.startsWith("/sites/" + siteKey + "/users/");
        }
        return false;
    }

    public void setGroupManagerService(JahiaGroupManagerService groupManagerService) {
        this.groupManagerService = groupManagerService;
    }

    public void setCacheProvider(EhCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setTemplate(JCRTemplate template) {
        this.template = template;
    }

    public void setUsePerUser(boolean usePerUser) {
        this.usePerUser = usePerUser;
    }

    public void setUseGroupsSignature(boolean useGroupsSignature) {
        this.useGroupsSignature = useGroupsSignature;
    }

    public void afterPropertiesSet() throws Exception {
        CacheManager cacheManager = this.cacheProvider.getCacheManager();
        this.cache = cacheManager.getCache(CACHE_NAME);
        if (this.cache == null) {
            cacheManager.addCache(CACHE_NAME);
            this.cache = cacheManager.getCache(CACHE_NAME);
        }
        this.permissionCache = cacheManager.getCache(PROPERTY_CACHE_NAME);
        if (this.permissionCache == null) {
            cacheManager.addCache(PROPERTY_CACHE_NAME);
            this.permissionCache = cacheManager.getCache(PROPERTY_CACHE_NAME);
        }
    }

    @Override
    public String getKey() {
        return "acls";
    }

    @Override
    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        try {
            Boolean[] values;
            Element element;
            String ref;
            TreeSet<String> aclsKeys = new TreeSet<String>();
            if (this.usePerUser || "true".equals(properties.get("cache.perUser"))) {
                return PER_USER;
            }
            if (this.useGroupsSignature || "true".equals(properties.get("cache.useGroupSignature"))) {
                return GROUPS_SIGNATURE;
            }
            JCRNodeWrapper node = resource.getNode();
            String nodePath = node.getPath();
            aclsKeys.add(this.encodeSpecificChars(nodePath));
            String s = (String)properties.get("cache.dependsOnVisibilityOf");
            if (s != null) {
                String[] dependencies = s.split(",");
                for (int i = 0; i < dependencies.length; ++i) {
                    String dep = dependencies[i];
                    dep = dep.replace("$currentNode", nodePath);
                    dep = dep.replace("$currentSite", renderContext.getSite().getPath());
                    dep = dep.replace("$mainResource", renderContext.getMainResource().getNode().getPath());
                    aclsKeys.add("*" + this.encodeSpecificChars(dep));
                }
            }
            if ((ref = (String)properties.get("cache.dependsOnReference")) != null && ref.length() > 0) {
                String[] refProperties = ref.split(",");
                for (int i = 0; i < refProperties.length; ++i) {
                    String refPropertyName = refProperties[i];
                    if (node.hasProperty(refPropertyName)) {
                        int propertyRequiredType;
                        JCRPropertyWrapper refProperty = node.getProperty(refPropertyName);
                        JCRSessionWrapper systemSession = JCRSessionFactory.getInstance().getCurrentSystemSession(node.getSession().getWorkspace().getName(), node.getSession().getLocale(), null);
                        if (refProperty == null || (propertyRequiredType = refProperty.getDefinition().getRequiredType()) != 9 && propertyRequiredType != 10) continue;
                        if (refProperty.isMultiple() && refProperty.getValues().length > 0) {
                            for (JCRValueWrapper value : refProperty.getValues()) {
                                this.addReferenceDependency(value.getString(), aclsKeys, systemSession);
                            }
                            continue;
                        }
                        this.addReferenceDependency(refProperty.getString(), aclsKeys, systemSession);
                        continue;
                    }
                    logger.debug("Trying to add cache dependency for reference but property '{}' not found on node '{}'", (Object)refPropertyName, (Object)nodePath);
                }
            }
            if ((element = this.permissionCache.get((Serializable)((Object)node.getPath()))) != null && element.getObjectValue() != null) {
                values = (Boolean[])element.getObjectValue();
            } else {
                values = new Boolean[]{node.hasProperty("j:requiredPermissionNames") || node.hasProperty("j:requiredPermissions"), node.hasProperty("j:requirePrivilegedUser") && node.getProperty("j:requirePrivilegedUser").getBoolean(), node.hasProperty("j:requireLoggedUser") && node.getProperty("j:requireLoggedUser").getBoolean()};
                this.permissionCache.put(new Element((Serializable)((Object)node.getPath()), (Serializable)values));
            }
            if ("true".equals(properties.get("cache.mainResource"))) {
                aclsKeys.add(MR_ACL);
            } else if (values[0].booleanValue()) {
                aclsKeys.add(MR_ACL);
            }
            if (values[1].booleanValue()) {
                aclsKeys.add(renderContext.getSite().getPath());
            }
            if (values[2].booleanValue() || "true".equals(properties.get("cache.useLoggedInState"))) {
                aclsKeys.add(LOGGED_USER);
            }
            return StringUtils.join(aclsKeys, (String)",");
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private void addReferenceDependency(String identifier, Set<String> aclsKeys, JCRSessionWrapper systemSession) throws RepositoryException {
        try {
            JCRNodeWrapper refNode = systemSession.getNodeByIdentifier(identifier);
            aclsKeys.add(this.encodeSpecificChars(refNode.getPath()));
        }
        catch (ItemNotFoundException e) {
            logger.debug("Trying to add cache dependency for reference but reference node '{}' not found", (Object)identifier);
        }
    }

    @Override
    public String replacePlaceholders(RenderContext renderContext, String keyPart) {
        String[] paths = keyPart.split(",");
        TreeMap<String, Set<String>> rolesForPath = new TreeMap<String, Set<String>>();
        StringBuilder r = new StringBuilder();
        try {
            List<PrincipalAcl> principalAclList = null;
            for (String s : paths) {
                if (s.equals(PER_USER)) {
                    if (r.length() > 0) {
                        r.append("|");
                    }
                    r.append(renderContext.getUser().getUserKey());
                    continue;
                }
                if (s.equals(LOGGED_USER)) {
                    if (r.length() > 0) {
                        r.append("|");
                    }
                    r.append(Boolean.toString(renderContext.getUser().getName().equals("guest")));
                    continue;
                }
                if (s.equals(GROUPS_SIGNATURE)) {
                    r.append(this.getGroupsSignature(renderContext.getUser()));
                    continue;
                }
                if (principalAclList == null) {
                    principalAclList = this.getUserAcl(renderContext.getUser());
                }
                if (s.equals(MR_ACL)) {
                    this.populateRolesForPath(renderContext.getMainResource().getNode().getPath(), principalAclList, rolesForPath);
                    continue;
                }
                if (s.startsWith("*")) {
                    String decodedNodePath = this.decodeSpecificChars(s.substring(1));
                    this.populateRolesForPathPattern(Pattern.compile(decodedNodePath), principalAclList, rolesForPath);
                    continue;
                }
                this.populateRolesForPath(this.decodeSpecificChars(s), principalAclList, rolesForPath);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        for (Map.Entry entry : rolesForPath.entrySet()) {
            if (r.length() > 0) {
                r.append("|");
            }
            r.append(StringUtils.join((Collection)((Collection)entry.getValue()), (String)",")).append(":").append((String)entry.getKey());
        }
        String replacedKeyPart = StringUtils.replace((String)r.toString(), (String)"@@", (String)"%0");
        logger.debug("ACL keypart : {} = {}", (Object)keyPart, (Object)replacedKeyPart);
        return replacedKeyPart;
    }

    @Override
    public ClientCachePolicy getClientCachePolicy(Resource resource, RenderContext renderContext, Properties properties, String key) {
        return renderContext.isLoggedIn() ? ClientCachePolicy.PRIVATE : ClientCachePolicy.DEFAULT;
    }

    private void populateRolesForPath(String nodePath, List<PrincipalAcl> principalAcls, Map<String, Set<String>> rolesForPath) {
        for (PrincipalAcl principalAcl : principalAcls) {
            principalAcl.fillRolesForPath(nodePath, rolesForPath);
        }
    }

    private void populateRolesForPathPattern(Pattern pattern, List<PrincipalAcl> principalAcls, Map<String, Set<String>> rolesForPath) {
        HashSet<String> paths = new HashSet<String>();
        for (PrincipalAcl principalAcl : principalAcls) {
            principalAcl.fillMatchingPaths(pattern, paths);
        }
        for (String path : paths) {
            this.populateRolesForPath(path, principalAcls, rolesForPath);
        }
    }

    private String getGroupsSignature(JahiaUser principal) throws RepositoryException {
        if (principal.isRoot()) {
            return "u:" + principal.getName();
        }
        TreeSet<String> principals = new TreeSet<String>();
        Set<String> all = this.getAllPrincipalsWithAcl();
        this.addPrincipalIfAcl(principals, all, "u:" + principal.getName());
        List<String> groups = this.groupManagerService.getMembershipByPath(principal.getLocalPath());
        for (String group : groups) {
            this.addPrincipalIfAcl(principals, all, "g:" + StringUtils.substringAfterLast((String)group, (String)"/"));
        }
        return Integer.toString(all.hashCode()) + principals;
    }

    private void addPrincipalIfAcl(Collection<String> principalAcl, Collection<String> all, String principal) {
        if (all.contains(principal)) {
            principalAcl.add(principal);
        }
    }

    private List<PrincipalAcl> getUserAcl(JahiaUser principal) throws RepositoryException {
        ArrayList<PrincipalAcl> principalAcl = new ArrayList<PrincipalAcl>();
        principalAcl.add(this.getPrincipalAcl("u:" + principal.getName(), principal.getRealm()));
        List<String> groups = this.groupManagerService.getMembershipByPath(principal.getLocalPath());
        for (String group : groups) {
            principalAcl.add(this.getPrincipalAcl("g:" + StringUtils.substringAfterLast((String)group, (String)"/"), JCRContentUtils.getSiteKey(group)));
        }
        return principalAcl;
    }

    private PrincipalAcl getPrincipalAcl(final String principallKey, final String siteKey) throws RepositoryException {
        Object cacheKey = siteKey != null ? principallKey + ":" + siteKey : principallKey;
        Element element = this.cache.get((Serializable)cacheKey);
        if (element == null) {
            element = this.generateCacheEntry((String)cacheKey, new CacheEntryNotFoundCallback(){

                @Override
                public Object generateCacheEntry() throws RepositoryException {
                    return AclCacheKeyPartGenerator.this.template.doExecuteWithSystemSessionAsUser(null, "live", null, new JCRCallback<PrincipalAcl>(){

                        @Override
                        public PrincipalAcl doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            QueryWrapper query = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:ace] as ace where ace.[j:principal] = '" + JCRContentUtils.sqlEncode(principallKey) + "'", "JCR-SQL2");
                            QueryResult queryResult = query.execute();
                            NodeIterator rowIterator = queryResult.getNodes();
                            LinkedHashMap<String, Set<String>> mapGranted = new LinkedHashMap<String, Set<String>>();
                            LinkedHashMap<String, Set<String>> mapDenied = new LinkedHashMap<String, Set<String>>();
                            while (rowIterator.hasNext()) {
                                JCRValueWrapper[] roles;
                                JCRNodeWrapper node = (JCRNodeWrapper)rowIterator.next();
                                if (siteKey != null && !node.getResolveSite().getName().equals(siteKey)) continue;
                                String path = node.getParent().getParent().getPath();
                                HashSet<String> foundRoles = new HashSet<String>();
                                boolean granted = "GRANT".equals(node.getProperty("j:aceType").getString());
                                for (JCRValueWrapper r : roles = node.getProperty("j:roles").getValues()) {
                                    String role = r.getString();
                                    if (foundRoles.contains(role)) continue;
                                    foundRoles.add(role);
                                }
                                if ("/".equals(path)) {
                                    path = "";
                                }
                                if (granted) {
                                    mapGranted.put(path, foundRoles);
                                    continue;
                                }
                                mapDenied.put(path, foundRoles);
                            }
                            return new PrincipalAcl(mapGranted, mapDenied);
                        }
                    });
                }
            });
        }
        return (PrincipalAcl)element.getObjectValue();
    }

    public Set<String> getAllPrincipalsWithAcl() throws RepositoryException {
        Element element = this.cache.get((Serializable)((Object)CACHE_ALL_PRINCIPALS_ENTRY_KEY));
        if (element == null) {
            element = this.generateCacheEntry(CACHE_ALL_PRINCIPALS_ENTRY_KEY, new CacheEntryNotFoundCallback(){

                @Override
                public Object generateCacheEntry() throws RepositoryException {
                    return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, new JCRCallback<Set<String>>(){

                        @Override
                        public Set<String> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            long startTime = System.currentTimeMillis();
                            HashSet<String> results = new HashSet<String>();
                            String queryStatement = AclCacheKeyPartGenerator.this.getAllPrincipalsWithAclQuery();
                            QueryWrapper query = session.getWorkspace().getQueryManager().createQuery(queryStatement, "JCR-SQL2");
                            RowIterator ri = query.execute().getRows();
                            while (ri.hasNext()) {
                                String principal;
                                Row row = ri.nextRow();
                                String path = row.getValue("jcr:path").getString();
                                if (AclCacheKeyPartGenerator.isUnderUsersNode(path)) continue;
                                Value v = row.getValue("j:principal");
                                String string = principal = v != null ? v.getString() : null;
                                if (StringUtils.isEmpty((String)principal)) continue;
                                results.add(principal);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("getAllPrincipalsWithAcl query ({}) brought {} nodes back; collected {} principals; finished in {} ms", new Object[]{queryStatement, ri.getSize(), results.size(), System.currentTimeMillis() - startTime});
                            }
                            return results;
                        }
                    });
                }
            });
        }
        return (Set)element.getObjectValue();
    }

    public boolean isRelevantForAllPrincipalsCacheEntry(String path) {
        if (this.groupsSignatureAclPathsToQuery != null) {
            boolean relevant = false;
            for (String testPath : this.groupsSignatureAclPathsToQuery) {
                if (!path.startsWith(testPath)) continue;
                relevant = true;
                break;
            }
            return relevant && !AclCacheKeyPartGenerator.isUnderUsersNode(path);
        }
        return true;
    }

    private String getAllPrincipalsWithAclQuery() {
        if (this.allPrincipalsWithAclQuery == null) {
            String queryBase = "SELECT [jcr:path],[j:principal] FROM [jnt:ace]";
            if (this.groupsSignatureAclPathsToQuery == null) {
                this.allPrincipalsWithAclQuery = "SELECT [jcr:path],[j:principal] FROM [jnt:ace]";
            } else {
                StringBuilder q = new StringBuilder(128);
                q.append("SELECT [jcr:path],[j:principal] FROM [jnt:ace]").append(" WHERE");
                boolean first = true;
                for (String path : this.groupsSignatureAclPathsToQuery) {
                    if (!first) {
                        q.append(" OR");
                    } else {
                        first = false;
                    }
                    q.append(" ISDESCENDANTNODE('").append(JCRContentUtils.sqlEncode(path)).append("')");
                }
                this.allPrincipalsWithAclQuery = q.toString();
            }
        }
        return this.allPrincipalsWithAclQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element generateCacheEntry(String cacheKey, CacheEntryNotFoundCallback callback) throws RepositoryException {
        Element element = null;
        Semaphore semaphore = (Semaphore)this.processings.get(cacheKey);
        if (semaphore == null) {
            semaphore = new Semaphore(1);
            this.processings.putIfAbsent(cacheKey, semaphore);
        }
        try {
            semaphore.acquire();
            element = this.cache.get((Serializable)((Object)cacheKey));
            if (element != null) {
                Element element2 = element;
                return element2;
            }
            logger.debug("Getting ACL for {}", (Object)cacheKey);
            long l = System.currentTimeMillis();
            element = new Element((Object)cacheKey, callback.generateCacheEntry());
            element.setEternal(true);
            this.cache.put(element);
            logger.debug("Getting ACL for {} took {} ms", (Object)cacheKey, (Object)(System.currentTimeMillis() - l));
        }
        catch (InterruptedException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            semaphore.release();
        }
        return element;
    }

    public void flushUsersGroupsKey() {
        this.flushUsersGroupsKey(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushUsersGroupsKey(boolean propageToOtherClusterNodes) {
        Object object = this.objForSync;
        synchronized (object) {
            this.cache.removeAll(!propageToOtherClusterNodes);
            this.cache.flush();
            logger.debug("Flushed HTMLNodeUsersACLs cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushUsersGroupsKey(String key, boolean propagateToOtherClusterNodes) {
        Object object = this.objForSync;
        synchronized (object) {
            this.cache.remove((Serializable)((Object)key), !propagateToOtherClusterNodes);
            logger.debug("Flushed entry {} from HTMLNodeUsersACLs cache", (Object)key);
            Element element = this.cache.get((Serializable)((Object)CACHE_ALL_PRINCIPALS_ENTRY_KEY));
            if (element != null) {
                Set allPrincipalsWithAcl = (Set)element.getObjectValue();
                if (key.lastIndexOf(58) == 1 && !allPrincipalsWithAcl.contains(key)) {
                    this.cache.remove((Serializable)((Object)CACHE_ALL_PRINCIPALS_ENTRY_KEY), !propagateToOtherClusterNodes);
                    logger.debug("Flushed entry all principals from HTMLNodeUsersACLs cache");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushUsersGroupsKeys(Collection<String> keys, Collection<String> keysRelevantForGroupSignature, boolean propagateToOtherClusterNodes) {
        boolean keysEmpty = CollectionUtils.isEmpty(keys);
        boolean keysRelevantForGroupSignatureEmpty = CollectionUtils.isEmpty(keysRelevantForGroupSignature);
        if (keysEmpty && keysRelevantForGroupSignatureEmpty) {
            return;
        }
        Object object = this.objForSync;
        synchronized (object) {
            Element element;
            if (!keysEmpty) {
                this.cache.removeAll(keys, !propagateToOtherClusterNodes);
                logger.debug("Flushed entries {} from HTMLNodeUsersACLs cache", keys);
            }
            if (!keysRelevantForGroupSignatureEmpty && (element = this.cache.get((Serializable)((Object)CACHE_ALL_PRINCIPALS_ENTRY_KEY))) != null) {
                Set allPrincipalsWithAcl = (Set)element.getObjectValue();
                for (String key : keysRelevantForGroupSignature) {
                    if (key.lastIndexOf(58) != 1 || allPrincipalsWithAcl.contains(key)) continue;
                    allPrincipalsWithAcl.add(key);
                    logger.debug("Added key {} to the entry all principals in HTMLNodeUsersACLs cache", (Object)key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPermissionCacheEntry(String path, boolean propagateToOtherClusterNodes) {
        Object object = this.objForSync;
        synchronized (object) {
            this.permissionCache.remove((Serializable)((Object)path), !propagateToOtherClusterNodes);
        }
    }

    private String encodeSpecificChars(String toEncode) {
        return StringUtils.replaceEach((String)toEncode, (String[])SPECIFIC_STR, (String[])SUBSTITUTION_STR);
    }

    private String decodeSpecificChars(String toDecode) {
        return StringUtils.replaceEach((String)toDecode, (String[])SUBSTITUTION_STR, (String[])SPECIFIC_STR);
    }

    public void setGroupsSignatureAclPathsToQuery(String paths) {
        this.groupsSignatureAclPathsToQuery = null;
        this.allPrincipalsWithAclQuery = null;
        if (StringUtils.isNotBlank((String)paths)) {
            this.groupsSignatureAclPathsToQuery = new LinkedHashSet<String>(Arrays.asList(StringUtils.split((String)paths, (String)", ")));
        }
    }

    private static interface CacheEntryNotFoundCallback {
        public Object generateCacheEntry() throws RepositoryException;
    }
}

