/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import org.jahia.services.cache.CacheEntry;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.render.filter.cache.ModuleGeneratorQueue;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="8.2.1.0", forRemoval=true)
public class CacheFilter
extends AbstractFilter {
    private static final String FLAG_VERSION = "v";
    private static final String FLAG_RANDOM = "ec";
    private static final String FLAG_ALL = "ALL";
    private static final Set<String> FLAGS_ALL_SET = Collections.singleton("ALL");
    private static final String RENDERING_TIMER = "cacheFilter.rendering.timer";
    private static final String FRAGMENT_SERVED_FROM_CACHE = "cacheFilter.fragment.servedFromCache";
    private static final Logger logger = LoggerFactory.getLogger(CacheFilter.class);
    protected ModuleCacheProvider cacheProvider;
    protected boolean cascadeFragmentErrors = false;
    protected int errorCacheExpiration = 5;
    protected int dependenciesLimit = 1000;
    private ModuleGeneratorQueue generatorQueue;

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        Map moduleMap = (Map)renderContext.getRequest().getAttribute("moduleMap");
        if (!this.isCacheFilterEnabled(moduleMap)) {
            this.generatorQueue.getFragmentsGenerationPermit(resource.toString(), renderContext.getRequest());
            return null;
        }
        moduleMap.put(RENDERING_TIMER, System.currentTimeMillis());
        String path = resource.getNodePath();
        String key = (String)moduleMap.get("aggregateFilter.rendering.key");
        String finalKey = (String)moduleMap.get("aggregateFilter.rendering.final.key");
        Element element = null;
        Cache cache = this.cacheProvider.getCache();
        try {
            logger.debug("Try to get fragment from cache with final key: {}", (Object)finalKey);
            element = cache.get((Serializable)((Object)finalKey));
        }
        catch (LockTimeoutException e) {
            logger.warn("Error while rendering " + renderContext.getMainResource() + e.getMessage(), (Throwable)e);
        }
        if (element != null && element.getObjectValue() != null) {
            logger.debug("Fragment found in cache: {} ", (Object)path);
            return this.returnFromCache(renderContext, key, finalKey, element, moduleMap);
        }
        logger.debug("Fragment not found in cache: {} ", (Object)path);
        resource.safeLoadNode();
        if (this.isCacheable(renderContext, key, resource, this.cacheProvider.getKeyGenerator().getAttributesForKey(renderContext, resource))) {
            if (!this.bypassCache(renderContext, resource)) {
                logger.debug("Use latch to decide between generate or waiting fragment: {}", (Object)path);
                if (this.generatorQueue.getLatch(renderContext, finalKey)) {
                    element = cache.get((Serializable)((Object)finalKey));
                    if (element != null && element.getObjectValue() != null) {
                        logger.debug("Latch released for fragment: {} and fragment found in cache", (Object)path);
                        return this.returnFromCache(renderContext, key, finalKey, element, moduleMap);
                    }
                    logger.debug("Latch released for fragment: {} but fragment not found in cache, generate it", (Object)path);
                }
                return null;
            }
        } else {
            this.cacheProvider.addNonCacheableFragment(key);
        }
        this.generatorQueue.getFragmentsGenerationPermit(finalKey, renderContext.getRequest());
        return null;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        return this.execute(previousOut, renderContext, resource, false);
    }

    private String execute(String previousOut, RenderContext renderContext, Resource resource, boolean isAnError) throws RepositoryException {
        boolean displayCacheInfo;
        HttpServletRequest request = renderContext.getRequest();
        Map moduleMap = (Map)request.getAttribute("moduleMap");
        if (!this.isCacheFilterEnabled(moduleMap)) {
            return previousOut;
        }
        String key = (String)moduleMap.get("aggregateFilter.rendering.key");
        if (moduleMap.get(FRAGMENT_SERVED_FROM_CACHE) == null) {
            Properties fragmentProperties = this.cacheProvider.getKeyGenerator().getAttributesForKey(renderContext, resource);
            String finalKey = (String)moduleMap.get("aggregateFilter.rendering.final.key");
            if (this.isCacheable(renderContext, key, resource, fragmentProperties)) {
                if (!this.bypassCache(renderContext, resource)) {
                    String generatedKey = this.cacheProvider.getKeyGenerator().generate(resource, renderContext, fragmentProperties);
                    if (!generatedKey.equals(key)) {
                        logger.warn("Key generation does not give the same result after execution: was '{}', now is '{}'", (Object)key, (Object)generatedKey);
                    }
                    if (!isAnError) {
                        resource.getDependencies().add(resource.getNode().getCanonicalPath());
                        if ("true".equals(fragmentProperties.getProperty("cache.mainResource"))) {
                            resource.getDependencies().add(renderContext.getMainResource().getNode().getCanonicalPath());
                        }
                    }
                    logger.debug("Caching fragment {} for final key: {}", (Object)resource.getPath(), (Object)finalKey);
                    this.doCache(previousOut, renderContext, resource, isAnError ? (long)this.errorCacheExpiration : Long.parseLong(fragmentProperties.getProperty("cache.expiration")), this.cacheProvider.getCache(), finalKey, isAnError);
                    this.generatorQueue.releaseLatch(finalKey);
                }
            } else {
                this.cacheProvider.addNonCacheableFragment(key);
            }
        }
        String result = previousOut;
        boolean bl = displayCacheInfo = SettingsBean.getInstance().isDevelopmentMode() && Boolean.valueOf(request.getParameter("cacheinfo")) != false;
        if (displayCacheInfo && !result.contains("<body") && result.trim().length() > 0) {
            result = this.appendDebugInformation(moduleMap, result);
        }
        this.logCacheFilterRenderingTime(resource, moduleMap);
        return result;
    }

    private void logCacheFilterRenderingTime(Resource resource, Map<String, Object> moduleMap) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Object servedFromCacheAttribute = moduleMap.get(FRAGMENT_SERVED_FROM_CACHE);
        Boolean isServerFromCache = servedFromCacheAttribute != null && (Boolean)servedFromCacheAttribute != false;
        String cacheLogMsg = isServerFromCache != false ? "Served fragment {} from cache in {} ms" : "Generated fragment {} in {} ms";
        long start = (Long)moduleMap.get(RENDERING_TIMER);
        logger.debug(cacheLogMsg, (Object)resource.getPath(), (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public void finalize(RenderContext renderContext, Resource resource, RenderChain chain) {
        Map moduleMap;
        if (renderContext.getRequest().getAttribute("aggregateFilter.resourcesStack") == null) {
            this.generatorQueue.releaseFragmentsGenerationPermit(renderContext.getRequest());
        }
        if (this.isCacheFilterEnabled(moduleMap = (Map)renderContext.getRequest().getAttribute("moduleMap"))) {
            this.generatorQueue.releaseLatch((String)moduleMap.get("aggregateFilter.rendering.final.key"));
        }
    }

    @Override
    public String getContentForError(RenderContext renderContext, Resource resource, RenderChain chain, Exception e) {
        super.getContentForError(renderContext, resource, chain, e);
        HttpServletRequest request = renderContext.getRequest();
        Map moduleMap = (Map)request.getAttribute("moduleMap");
        if (!this.isCacheFilterEnabled(moduleMap) || this.cascadeFragmentErrors || "page".equals(resource.getContextConfiguration())) {
            return null;
        }
        try {
            return this.execute(this.getErrorComment(e), renderContext, resource, true);
        }
        catch (Exception e1) {
            return null;
        }
    }

    private boolean isCacheFilterEnabled(Map<String, Object> moduleMap) {
        return moduleMap.get("aggregateFilter.rendering.key") != null && moduleMap.get("aggregateFilter.rendering.final.key") != null;
    }

    protected void doCache(String previousOut, RenderContext renderContext, Resource resource, Long expiration, Cache cache, String finalKey, boolean bypassDependencies) {
        Set<String> depNodeWrappers = Collections.emptySet();
        CacheEntry<String> cacheEntry = new CacheEntry<String>(previousOut);
        this.addPropertiesToCacheEntry(cacheEntry, renderContext);
        Element cachedElement = new Element((Serializable)((Object)finalKey), cacheEntry);
        if (expiration > 0L) {
            cachedElement.setTimeToLive(expiration.intValue());
        }
        if (!bypassDependencies) {
            this.storeDependencies(renderContext, resource, finalKey, depNodeWrappers);
        }
        cache.put(cachedElement);
        if (logger.isDebugEnabled()) {
            logger.debug("Store in cache content of fragment with key: {}", (Object)finalKey);
            StringBuilder stringBuilder = new StringBuilder();
            for (String path : depNodeWrappers) {
                stringBuilder.append(path).append("\n");
            }
            logger.debug("Dependencies of {}: {}", (Object)finalKey, (Object)stringBuilder);
        }
    }

    private void storeDependencies(RenderContext renderContext, Resource resource, String finalKey, Set<String> depNodeWrappers) {
        if (this.useDependencies()) {
            Cache dependenciesCache = this.cacheProvider.getDependenciesCache();
            depNodeWrappers = resource.getDependencies();
            for (String path : depNodeWrappers) {
                Element element1;
                Set<String> dependencies;
                if (path.startsWith("/modules") || (dependencies = (element1 = dependenciesCache.get((Serializable)((Object)path))) != null ? (Set<String>)element1.getObjectValue() : Collections.newSetFromMap(new ConcurrentHashMap())).contains(FLAG_ALL)) continue;
                if (dependencies.size() + 1 > this.dependenciesLimit) {
                    Element element = new Element((Object)path, FLAGS_ALL_SET);
                    element.setEternal(true);
                    dependenciesCache.put(element);
                    continue;
                }
                this.addDependencies(renderContext, finalKey, dependenciesCache, path, dependencies);
            }
            Cache regexpDependenciesCache = this.cacheProvider.getRegexpDependenciesCache();
            Set<String> regexpDepNodeWrappers = resource.getRegexpDependencies();
            for (String regexp : regexpDepNodeWrappers) {
                Element element1 = regexpDependenciesCache.get((Serializable)((Object)regexp));
                Set<String> dependencies = element1 != null ? (Set<String>)element1.getObjectValue() : Collections.newSetFromMap(new ConcurrentHashMap());
                this.addDependencies(renderContext, finalKey, regexpDependenciesCache, regexp, dependencies);
            }
        }
        resource.getDependencies().clear();
        resource.getRegexpDependencies().clear();
    }

    protected boolean useDependencies() {
        return true;
    }

    protected void addDependencies(RenderContext renderContext, String finalKey, Cache cache, String value, Set<String> newDependencies) {
        if (newDependencies.add(finalKey)) {
            cache.put(new Element((Object)value, newDependencies));
        }
    }

    private void addPropertiesToCacheEntry(CacheEntry<String> cacheEntry, RenderContext renderContext) {
        Map moduleMap = (Map)renderContext.getRequest().getAttribute("moduleMap");
        if (moduleMap != null && moduleMap.containsKey("requestAttributesToCache")) {
            HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
            Collection requestAttributesToCache = (Collection)moduleMap.get("requestAttributesToCache");
            for (String attributesToCache : requestAttributesToCache) {
                if (!(renderContext.getRequest().getAttribute(attributesToCache) instanceof Serializable)) continue;
                attributes.put(attributesToCache, (Serializable)renderContext.getRequest().getAttribute(attributesToCache));
            }
            cacheEntry.setProperty("requestAttributes", attributes);
        }
    }

    private void restorePropertiesFromCacheEntry(CacheEntry<?> cacheEntry, RenderContext renderContext) {
        if (cacheEntry.getProperty("requestAttributes") != null) {
            Map requestAttributesToCache = (Map)cacheEntry.getProperty("requestAttributes");
            for (Map.Entry entry : requestAttributesToCache.entrySet()) {
                renderContext.getRequest().setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
    }

    protected boolean isCacheable(RenderContext renderContext, String key, Resource resource, Properties fragmentProperties) throws RepositoryException {
        if (this.cacheProvider.isNonCacheableFragment(key)) {
            return false;
        }
        String cacheExpiration = fragmentProperties.getProperty("cache.expiration");
        Long expiration = cacheExpiration != null ? Long.parseLong(cacheExpiration) : -1L;
        return expiration != 0L;
    }

    private boolean bypassCache(RenderContext renderContext, Resource resource) throws RepositoryException {
        if (renderContext.getRequest().getParameter(FLAG_VERSION) != null && renderContext.isLoggedIn()) {
            return true;
        }
        String ecParameter = renderContext.getRequest().getParameter(FLAG_RANDOM);
        if (ecParameter != null) {
            if (ecParameter.equals(resource.getNode().getIdentifier())) {
                return true;
            }
            for (Resource parent : renderContext.getResourcesStack()) {
                if (!ecParameter.equals(parent.getNode().getIdentifier())) continue;
                return true;
            }
        }
        return false;
    }

    protected String returnFromCache(RenderContext renderContext, String key, String finalKey, Element element, Map<String, Object> moduleMap) {
        logger.debug("Content retrieved from cache for node with key: {}", (Object)finalKey);
        CacheEntry cacheEntry = (CacheEntry)element.getObjectValue();
        String cachedContent = (String)cacheEntry.getObject();
        this.restorePropertiesFromCacheEntry(cacheEntry, renderContext);
        moduleMap.put(FRAGMENT_SERVED_FROM_CACHE, Boolean.TRUE);
        return cachedContent;
    }

    protected String appendDebugInformation(Map<String, Object> moduleMap, String renderContent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class=\"cacheDebugInfo\">");
        stringBuilder.append("<span class=\"cacheDebugInfoLabel\">Expiration: </span><span>");
        if (Boolean.TRUE.equals(moduleMap.get(FRAGMENT_SERVED_FROM_CACHE))) {
            stringBuilder.append(SimpleDateFormat.getDateTimeInstance().format(new Date(this.cacheProvider.getCache().get(moduleMap.get("aggregateFilter.rendering.final.key")).getExpirationTime())));
        } else {
            stringBuilder.append("Not cached fragment ").append(SimpleDateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()));
        }
        stringBuilder.append("</span><br/>");
        stringBuilder.append("</div>");
        stringBuilder.append(renderContent);
        return stringBuilder.toString();
    }

    public void setCacheProvider(ModuleCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setCascadeFragmentErrors(boolean cascadeFragmentErrors) {
        this.cascadeFragmentErrors = cascadeFragmentErrors;
    }

    public void setErrorCacheExpiration(int errorCacheExpiration) {
        this.errorCacheExpiration = errorCacheExpiration;
    }

    public void setDependenciesLimit(int dependenciesLimit) {
        this.dependenciesLimit = dependenciesLimit;
    }

    public void setGeneratorQueue(ModuleGeneratorQueue generatorQueue) {
        this.generatorQueue = generatorQueue;
    }
}

