/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class ClientCachePolicy
implements Serializable {
    public static final String CLIENT_CACHE_FRAGMENT_POLICY_PROPERTY_NAME = "clientCacheFragmentPolicy";
    public static final ClientCachePolicy PRIVATE = new ClientCachePolicy(Level.PRIVATE);
    public static final ClientCachePolicy PUBLIC;
    public static final ClientCachePolicy DEFAULT;
    private static final long serialVersionUID = 1L;
    private final Level level;
    private final int ttl;

    public ClientCachePolicy(Level level, int ttl) {
        this.level = level;
        this.ttl = ttl;
    }

    public ClientCachePolicy(Level policy) {
        this(policy, 0);
    }

    public Level getLevel() {
        return this.level;
    }

    public int getTtl() {
        return this.ttl;
    }

    public boolean isStronger(ClientCachePolicy policy) {
        return this.getLevel().getIndex() < policy.getLevel().getIndex() || this.getLevel().getIndex() == policy.getLevel().getIndex() && policy.getTtl() > this.ttl;
    }

    public static ClientCachePolicy strongest(ClientCachePolicy a, ClientCachePolicy b) {
        return a.isStronger(b) ? a : b;
    }

    public static ClientCachePolicy strongest(List<ClientCachePolicy> policies) {
        return policies.stream().reduce(ClientCachePolicy::strongest).orElse(null);
    }

    public String toString() {
        return "ClientCachePolicy{level=" + this.level + ", ttl=" + this.ttl + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCachePolicy that = (ClientCachePolicy)o;
        return this.ttl == that.ttl && this.level == that.level;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.ttl});
    }

    static {
        DEFAULT = PUBLIC = new ClientCachePolicy(Level.PUBLIC);
    }

    public static enum Level {
        PRIVATE("private", 0),
        CUSTOM("custom", 10),
        PUBLIC("public", 20),
        IMMUTABLE("immutable", 50);

        private final String value;
        private final int index;

        private Level(String value, int index) {
            this.value = value;
            this.index = index;
        }

        public String getValue() {
            return this.value;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "Level{value='" + this.value + "', index=" + this.index + "}";
        }
    }
}

