/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.RenderContextTuner;
import org.jahia.services.render.scripting.Script;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheKeyGenerator
implements CacheKeyGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCacheKeyGenerator.class);
    private static final String KEY_PART_DELIMITER = "@@";
    private static final String KEY_PART_DELIMITER_ESCAPE = "&dblAt;";
    private static final String AMPERSAND_ESCAPE = "&amp;";
    private Map<String, CacheKeyPartGenerator> partGeneratorsByKey = new LinkedHashMap<String, CacheKeyPartGenerator>();

    public void registerPartGenerator(CacheKeyPartGenerator partGenerator) {
        this.partGeneratorsByKey.put(partGenerator.getKey(), partGenerator);
    }

    public void unregisterPartGenerator(CacheKeyPartGenerator partGenerator) {
        this.partGeneratorsByKey.remove(partGenerator.getKey());
    }

    @Override
    public String generate(Resource resource, RenderContext renderContext, Properties properties) {
        LinkedList<String> args = new LinkedList<String>();
        for (CacheKeyPartGenerator generator : this.partGeneratorsByKey.values()) {
            String value = generator.getValue(resource, renderContext, properties);
            args.add(DefaultCacheKeyGenerator.encodeKeyPart(value));
        }
        return StringUtils.join(args, (String)KEY_PART_DELIMITER);
    }

    @Override
    public Map<String, String> parse(String key) {
        String[] values = this.getSplit(key);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.partGeneratorsByKey.size());
        int index = 0;
        for (String partGeneratorKey : this.partGeneratorsByKey.keySet()) {
            result.put(partGeneratorKey, values[index] == null || values[index].equals("null") ? null : values[index]);
            ++index;
        }
        return result;
    }

    @Override
    @Deprecated(since="7.2.0.0", forRemoval=true)
    public String replaceField(String key, String fieldName, String newValue) {
        Object[] args = this.getSplit(key);
        Integer index = null;
        int i = 0;
        for (String partGeneratorKey : this.partGeneratorsByKey.keySet()) {
            if (partGeneratorKey.equals(fieldName)) {
                index = i;
                break;
            }
            ++i;
        }
        args[index.intValue()] = DefaultCacheKeyGenerator.encodeKeyPart(newValue);
        return StringUtils.join((Object[])args, (String)KEY_PART_DELIMITER);
    }

    @Override
    public CacheKeyPartGenerator getPartGenerator(String field) {
        return this.partGeneratorsByKey.get(field);
    }

    @Override
    public String replacePlaceholdersInCacheKey(RenderContext renderContext, String key) {
        String[] args = this.getSplit(key);
        Object[] newArgs = new String[args.length];
        int index = 0;
        for (CacheKeyPartGenerator keyPartGenerator : this.partGeneratorsByKey.values()) {
            String value = keyPartGenerator.replacePlaceholders(renderContext, args[index]);
            newArgs[index] = DefaultCacheKeyGenerator.encodeKeyPart(value);
            ++index;
        }
        return StringUtils.join((Object[])newArgs, (String)KEY_PART_DELIMITER);
    }

    private String[] getSplit(String key) {
        int end;
        String[] res = new String[this.partGeneratorsByKey.size()];
        int index = 0;
        int start = 0;
        while ((end = key.indexOf(KEY_PART_DELIMITER, start)) > -1) {
            String value = key.substring(start, end);
            res[index++] = DefaultCacheKeyGenerator.decodeKeyPart(value);
            start = end + KEY_PART_DELIMITER.length();
        }
        res[index++] = key.substring(start);
        while (index < res.length) {
            res[index++] = "";
        }
        return res;
    }

    @Override
    @Deprecated(since="8.2.1.0", forRemoval=true)
    public Map<String, Object> prepareContextForContentGeneration(Map<String, String> keyParts, Resource resource, RenderContext renderContext) {
        HashMap<String, Object> original = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : keyParts.entrySet()) {
            CacheKeyPartGenerator partGenerator = this.partGeneratorsByKey.get(entry.getKey());
            if (!(partGenerator instanceof RenderContextTuner)) continue;
            original.put(entry.getKey(), ((RenderContextTuner)((Object)partGenerator)).prepareContextForContentGeneration(entry.getValue(), resource, renderContext));
        }
        return original;
    }

    @Override
    @Deprecated(since="8.2.1.0", forRemoval=true)
    public void restoreContextAfterContentGeneration(Map<String, String> keyParts, Resource resource, RenderContext renderContext, Map<String, Object> original) {
        for (Map.Entry<String, String> entry : keyParts.entrySet()) {
            CacheKeyPartGenerator partGenerator = this.partGeneratorsByKey.get(entry.getKey());
            if (!(partGenerator instanceof RenderContextTuner)) continue;
            ((RenderContextTuner)((Object)partGenerator)).restoreContextAfterContentGeneration(entry.getValue(), resource, renderContext, original.get(entry.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated(since="8.2.1.0", forRemoval=true)
    public Properties getAttributesForKey(RenderContext renderContext, Resource resource) throws RepositoryException {
        String requestParameters;
        HttpServletRequest request = renderContext.getRequest();
        Script script = resource.getScript(renderContext);
        JCRNodeWrapper node = resource.safeLoadNode();
        boolean isBound = node.isNodeType("jmix:bindedComponent");
        boolean isList = node.isNodeType("jmix:list");
        Properties properties = new Properties();
        if (script != null) {
            properties.putAll((Map<?, ?>)script.getView().getDefaultProperties());
            properties.putAll((Map<?, ?>)script.getView().getProperties());
        }
        if (isList) {
            Resource listLoader = new Resource(node, resource.getTemplateType(), "hidden.load", "include");
            try {
                Script listScript = RenderService.getInstance().resolveScript(listLoader, renderContext);
                properties.putAll((Map<?, ?>)listScript.getView().getProperties());
            }
            catch (TemplateNotFoundException e) {
                logger.error("Cannot find loader script for list " + node.getPath(), (Throwable)e);
            }
        }
        if (node.hasProperty("j:perUser")) {
            properties.put("cache.perUser", node.getProperty("j:perUser").getString());
        }
        if (isBound) {
            properties.put("cache.mainResource", "true");
        }
        StringBuilder updatedRequestParameters = !StringUtils.isEmpty((String)(requestParameters = properties.getProperty("cache.requestParameters"))) ? new StringBuilder(requestParameters + ",ec,v") : new StringBuilder("ec,v");
        if (SettingsBean.getInstance().isDevelopmentMode()) {
            updatedRequestParameters.append(",moduleinfo");
        }
        properties.put("cache.requestParameters", updatedRequestParameters.toString());
        String viewExpiration = properties.getProperty("cache.expiration");
        Object requestExpiration = request.getAttribute("expiration");
        if (requestExpiration != null) {
            properties.put("cache.expiration", requestExpiration);
        } else if (node.hasProperty("j:expiration")) {
            properties.put("cache.expiration", node.getProperty("j:expiration").getString());
        } else if (viewExpiration != null) {
            properties.put("cache.expiration", viewExpiration);
        } else {
            properties.put("cache.expiration", "-1");
        }
        String propertiesScript = properties.getProperty("cache.propertiesScript");
        if (propertiesScript != null) {
            Resource propsResource = new Resource(node, resource.getTemplateType(), propertiesScript, "include");
            try {
                Script propsScript = RenderService.getInstance().resolveScript(propsResource, renderContext);
                try {
                    request.setAttribute("cacheProperties", (Object)properties);
                    propsScript.execute(propsResource, renderContext);
                }
                catch (RenderException e) {
                    logger.error("Cannot execute script", (Throwable)e);
                }
                finally {
                    request.removeAttribute("cacheProperties");
                }
            }
            catch (TemplateNotFoundException e) {
                logger.error("Cannot find cache properties script " + propertiesScript + " for the node " + node.getPath(), (Throwable)e);
            }
        }
        return properties;
    }

    public void setPartGenerators(List<CacheKeyPartGenerator> partGenerators) {
        for (CacheKeyPartGenerator partGenerator : partGenerators) {
            this.registerPartGenerator(partGenerator);
        }
    }

    private static String encodeKeyPart(String keyPart) {
        if (keyPart == null) {
            return null;
        }
        return StringUtils.replace((String)StringUtils.replace((String)keyPart, (String)"&", (String)AMPERSAND_ESCAPE), (String)KEY_PART_DELIMITER, (String)KEY_PART_DELIMITER_ESCAPE);
    }

    private static String decodeKeyPart(String keyPart) {
        return StringUtils.replace((String)StringUtils.replace((String)keyPart, (String)KEY_PART_DELIMITER_ESCAPE, (String)KEY_PART_DELIMITER), (String)AMPERSAND_ESCAPE, (String)"&");
    }
}

