/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.jahia.services.content.ApiEventListener;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.ExternalEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.render.filter.cache.AclCacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.HtmlCacheEventJob;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.settings.SettingsBean;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlCacheEventListener
extends DefaultEventListener
implements ExternalEventListener,
ApiEventListener {
    private static Logger logger = LoggerFactory.getLogger(HtmlCacheEventListener.class);
    private ModuleCacheProvider cacheProvider;
    private SchedulerService schedulerService;

    @Override
    public int getEventTypes() {
        return 63;
    }

    @Override
    public boolean isDeep() {
        return false;
    }

    @Override
    public String getPath() {
        return "(?!/jcr:system).*";
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void onEvent(EventIterator events) {
        int operationType = ((JCREventIterator)events).getOperationType();
        if (logger.isDebugEnabled()) {
            logger.debug("{} events received. Operation type {}", (Object)events.getSize(), (Object)operationType);
        }
        boolean isExternal = false;
        ArrayList<Event> list = new ArrayList<Event>();
        while (events.hasNext()) {
            Event event = (Event)events.next();
            try {
                isExternal = isExternal || this.isExternal(event);
                list.add(isExternal ? new FlushEvent(event.getPath(), event.getIdentifier(), event.getType()) : event);
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (isExternal) {
            try {
                JobDetail jobDetail = BackgroundJob.createJahiaJob("Cache flush", HtmlCacheEventJob.class);
                jobDetail.setDurability(false);
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                jobDataMap.put((Object)"events", list);
                this.schedulerService.scheduleJobNow(jobDetail, true);
            }
            catch (SchedulerException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.processEvents(list, ((JCREventIterator)events).getSession(), true);
        }
    }

    public void processEvents(List<Event> events, JCRSessionWrapper sessionWrapper, boolean propagateToOtherClusterNodes) {
        Cache depCache = this.cacheProvider.getDependenciesCache();
        HashSet<String> flushed = new HashSet<String>();
        HashSet<String> checkedAclEntries = new HashSet<String>();
        final AclCacheKeyPartGenerator cacheKeyGenerator = (AclCacheKeyPartGenerator)this.cacheProvider.getKeyGenerator().getPartGenerator("acls");
        final HashSet<String> userGroupsKeyToFlush = new HashSet<String>();
        final HashSet<String> principalsForGroupSignature = new HashSet<String>();
        for (Event event : events) {
            if (logger.isDebugEnabled()) {
                logger.debug("Event: {}", (Object)event);
            }
            try {
                String eventNodePath;
                String path = eventNodePath = event.getPath();
                boolean flushParent = false;
                boolean flushChilds = false;
                boolean flushForVanityUrl = false;
                if (path.contains("j:view")) {
                    flushParent = true;
                }
                int type = event.getType();
                if (path.contains("j:invalidLanguages")) {
                    flushParent = true;
                }
                if (type == 4 || type == 16 || type == 8) {
                    if (path.endsWith("/j:published")) {
                        flushParent = true;
                    }
                    eventNodePath = path = path.substring(0, path.lastIndexOf("/"));
                } else if (type == 1 || type == 32 || type == 2) {
                    flushParent = true;
                }
                if (path.contains("vanityUrlMapping")) {
                    flushForVanityUrl = true;
                }
                if (path.contains("j:acl") && !path.endsWith("j:acl")) {
                    if (cacheKeyGenerator != null && !checkedAclEntries.contains(path)) {
                        checkedAclEntries.add(path);
                        String nodeName = StringUtils.substringAfterLast((String)path, (String)"/");
                        String key = "";
                        if (nodeName.startsWith("GRANT_")) {
                            key = StringUtils.substringAfter((String)path, (String)"GRANT_");
                        } else if (nodeName.startsWith("DENY_")) {
                            key = StringUtils.substringAfter((String)path, (String)"DENY_");
                        } else if (nodeName.startsWith("REF")) {
                            int g = nodeName.indexOf("_g_");
                            int u = nodeName.indexOf("_u_");
                            if (g == nodeName.lastIndexOf("_g_") && u == nodeName.lastIndexOf("_u_")) {
                                key = nodeName.substring(Math.max(u + 1, g + 1));
                            }
                        } else {
                            logger.warn("Cannot parse ACL event for: {}", (Object)nodeName);
                        }
                        String siteKey = JCRContentUtils.getSiteKey(path);
                        Object principalKey = null;
                        String principalKeyWithSite = null;
                        if (key.startsWith("u_")) {
                            principalKey = "u:" + key.substring(2);
                            if (siteKey != null) {
                                principalKeyWithSite = (String)principalKey + ":" + siteKey;
                            }
                        } else if (key.startsWith("g_")) {
                            principalKey = "g:" + key.substring(2);
                            if (siteKey != null) {
                                principalKeyWithSite = (String)principalKey + ":" + siteKey;
                            }
                        } else {
                            principalKey = key;
                        }
                        userGroupsKeyToFlush.add((String)principalKey);
                        if (principalKeyWithSite != null) {
                            userGroupsKeyToFlush.add(principalKeyWithSite);
                        }
                        if (cacheKeyGenerator.isRelevantForAllPrincipalsCacheEntry(path)) {
                            principalsForGroupSignature.add((String)principalKey);
                        }
                    }
                    flushParent = true;
                    flushChilds = true;
                }
                if (type == 32) {
                    if (cacheKeyGenerator != null) {
                        final String fPath = path;
                        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, this.workspace, null, new JCRCallback<Object>(){

                            @Override
                            public Object doInJCR(JCRSessionWrapper systemSession) throws RepositoryException {
                                QueryManagerWrapper queryManager = systemSession.getWorkspace().getQueryManager();
                                JCRNodeIteratorWrapper nodes = queryManager.createQuery("select * from ['jnt:ace'] where isdescendantnode('" + JCRContentUtils.sqlEncode(fPath) + "/')", "JCR-SQL2").execute().getNodes();
                                if (nodes.hasNext()) {
                                    String siteKey = JCRContentUtils.getSiteKey(fPath);
                                    boolean relevantForGroupSignature = cacheKeyGenerator.isRelevantForAllPrincipalsCacheEntry(fPath);
                                    for (JCRNodeWrapper nodeWrapper : nodes) {
                                        String principal = nodeWrapper.getProperty("j:principal").getString();
                                        userGroupsKeyToFlush.add(principal);
                                        if (relevantForGroupSignature) {
                                            principalsForGroupSignature.add(principal);
                                        }
                                        if (siteKey == null) continue;
                                        userGroupsKeyToFlush.add(principal + ":" + siteKey);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    flushParent = true;
                    flushChilds = true;
                }
                if (path.endsWith("/j:requiredPermissionNames") && cacheKeyGenerator != null) {
                    cacheKeyGenerator.flushPermissionCacheEntry(StringUtils.substringBeforeLast((String)path, (String)"/j:requiredPermissionNames"), propagateToOtherClusterNodes);
                }
                if (!flushed.contains(path = StringUtils.substringBeforeLast((String)StringUtils.substringBeforeLast((String)path, (String)"/j:translation"), (String)"/j:acl"))) {
                    block46: {
                        flushed.add(path);
                        this.flushDependenciesOfPath(depCache, path, propagateToOtherClusterNodes);
                        try {
                            String uuid = path == eventNodePath ? event.getIdentifier() : sessionWrapper.getNode(path).getIdentifier();
                            this.flushDependenciesOfPath(depCache, uuid, propagateToOtherClusterNodes);
                        }
                        catch (PathNotFoundException uuid) {
                        }
                        catch (RepositoryException e) {
                            if (e.getCause() != null && e.getCause() instanceof NoSuchItemStateException) break block46;
                            throw e;
                        }
                    }
                    this.cacheProvider.flushRegexpDependenciesOfPath(path, propagateToOtherClusterNodes);
                }
                if (flushChilds) {
                    this.cacheProvider.flushChildrenDependenciesOfPath(path, propagateToOtherClusterNodes);
                }
                if (flushParent && !flushed.contains(path = StringUtils.substringBeforeLast((String)path, (String)"/"))) {
                    block47: {
                        flushed.add(path);
                        this.flushDependenciesOfPath(depCache, path, propagateToOtherClusterNodes);
                        try {
                            this.flushDependenciesOfPath(depCache, sessionWrapper.getNode(path).getIdentifier(), propagateToOtherClusterNodes);
                        }
                        catch (PathNotFoundException e) {
                        }
                        catch (RepositoryException e) {
                            if (e.getCause() != null && e.getCause() instanceof NoSuchItemStateException) break block47;
                            throw e;
                        }
                    }
                    this.cacheProvider.flushRegexpDependenciesOfPath(path, propagateToOtherClusterNodes);
                }
                if (!flushForVanityUrl || flushed.contains(path = StringUtils.substringBeforeLast((String)path, (String)"/vanityUrlMapping"))) continue;
                flushed.add(path);
                this.flushDependenciesOfPath(depCache, path, propagateToOtherClusterNodes);
                try {
                    this.flushDependenciesOfPath(depCache, sessionWrapper.getNode(path).getIdentifier(), propagateToOtherClusterNodes);
                }
                catch (PathNotFoundException e) {
                }
                catch (RepositoryException e) {
                    if (e.getCause() != null && e.getCause() instanceof NoSuchItemStateException) continue;
                    throw e;
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (cacheKeyGenerator != null) {
            if (userGroupsKeyToFlush.contains("")) {
                cacheKeyGenerator.flushUsersGroupsKey(propagateToOtherClusterNodes);
            } else {
                cacheKeyGenerator.flushUsersGroupsKeys(userGroupsKeyToFlush, principalsForGroupSignature, propagateToOtherClusterNodes);
            }
        }
    }

    private void flushDependenciesOfPath(Cache depCache, String path, boolean propagateToOtherClusterNodes) {
        Element element = depCache.get((Serializable)((Object)path));
        if (element != null) {
            Set deps;
            if (logger.isDebugEnabled()) {
                logger.debug("Flushing dependencies for path: {}", (Object)path);
            }
            if ((deps = (Set)element.getObjectValue()).contains("ALL")) {
                this.cacheProvider.flushNonCacheableFragments();
            } else {
                for (String dep : deps) {
                    this.cacheProvider.removeNonCacheableFragmentsByEncodedPath(dep);
                }
            }
            this.cacheProvider.invalidate(path, propagateToOtherClusterNodes);
            depCache.remove(element.getObjectKey());
        }
        if (propagateToOtherClusterNodes && SettingsBean.getInstance().isClusterActivated()) {
            this.cacheProvider.propagatePathFlushToCluster(path);
        }
    }

    public void setCacheProvider(ModuleCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public static class FlushEvent
    implements Event,
    Serializable {
        private static final long serialVersionUID = -4835978210219006748L;
        private String path;
        private String id;
        private int type;

        public FlushEvent(String path, String id, int type) {
            this.path = path;
            this.id = id;
            this.type = type;
        }

        public String getUserID() {
            return null;
        }

        public String getIdentifier() throws RepositoryException {
            return this.id;
        }

        public Map getInfo() throws RepositoryException {
            return null;
        }

        public String getUserData() throws RepositoryException {
            return null;
        }

        public long getDate() throws RepositoryException {
            return 0L;
        }

        public int getType() {
            return this.type;
        }

        public String getPath() throws RepositoryException {
            return this.path;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Event: Path: ").append(this.path).append(", ID: ").append(this.id).append(", Type: ").append(EventState.valueOf((int)this.getType()));
            return sb.toString();
        }
    }
}

