/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.scripting.bundle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.scripting.bundle.BundleScriptEngineFactory;
import org.jahia.services.render.scripting.bundle.BundleScriptResolver;
import org.jahia.services.render.scripting.bundle.BundleScriptingContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleScriptEngineManager
extends ScriptEngineManager {
    private static final String SCRIPT_ENGINE_FACTORY_CLASS_NAME = ScriptEngineFactory.class.getName();
    private static final String META_INF_SERVICES = "META-INF/services";
    private static final String EXTENSION = "extension";
    private static final String MIME_TYPE = "MIME type";
    private static final String NAME = "name";
    private static Logger logger = LoggerFactory.getLogger(BundleScriptEngineManager.class);
    private Bindings globalScopeBindings;
    private final Map<String, ScriptEngineFactory> extensionsToScriptFactories = new ConcurrentHashMap<String, ScriptEngineFactory>(17);
    private final Map<String, ScriptEngineFactory> namesToScriptFactories = new ConcurrentHashMap<String, ScriptEngineFactory>(17);
    private final Map<String, ScriptEngineFactory> mimeTypesToScriptFactories = new ConcurrentHashMap<String, ScriptEngineFactory>(17);
    private final Map<Long, List<BundleScriptEngineFactory>> bundleIdsToScriptFactories = new ConcurrentHashMap<Long, List<BundleScriptEngineFactory>>(17);
    private final Map<ClassLoader, Map<String, ScriptEngine>> engineCache = new ConcurrentHashMap<ClassLoader, Map<String, ScriptEngine>>(17);

    public static BundleScriptEngineManager getInstance() {
        return Holder.INSTANCE;
    }

    private BundleScriptEngineManager() {
        this.globalScopeBindings = new SimpleBindings();
    }

    @Override
    public Object get(String key) {
        return this.globalScopeBindings.get(key);
    }

    @Override
    public Bindings getBindings() {
        return this.globalScopeBindings;
    }

    @Override
    public void put(String key, Object value) {
        this.globalScopeBindings.put(key, value);
    }

    @Override
    public void setBindings(Bindings bindings) {
        this.globalScopeBindings = bindings;
    }

    private ScriptEngine getEngine(String key, Map<String, ScriptEngineFactory> factoriesForKeyType, KeyType keyType) {
        ScriptEngine scriptEngine;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Map<String, ScriptEngine> stringScriptEngineMap = this.engineCache.get(contextClassLoader);
        if (stringScriptEngineMap == null) {
            stringScriptEngineMap = new ConcurrentHashMap<String, ScriptEngine>();
            this.engineCache.put(contextClassLoader, stringScriptEngineMap);
        }
        if ((scriptEngine = stringScriptEngineMap.get(key)) == null) {
            ScriptEngineFactory scriptEngineFactory = factoriesForKeyType.get(key);
            if (scriptEngineFactory != null) {
                if (scriptEngineFactory instanceof BundleScriptEngineFactory) {
                    BundleScriptEngineFactory factory = (BundleScriptEngineFactory)scriptEngineFactory;
                    factory.configurePreScriptEngineCreation();
                }
                scriptEngine = scriptEngineFactory.getScriptEngine();
                scriptEngine.setBindings(this.getBindings(), 200);
            } else {
                switch (keyType) {
                    case EXTENSION: {
                        scriptEngine = super.getEngineByExtension(key);
                        break;
                    }
                    case MIME_TYPE: {
                        scriptEngine = super.getEngineByMimeType(key);
                        break;
                    }
                    case NAME: {
                        scriptEngine = super.getEngineByName(key);
                        break;
                    }
                    default: {
                        scriptEngine = null;
                    }
                }
            }
            if (scriptEngine != null) {
                stringScriptEngineMap.put(key, scriptEngine);
            }
        }
        return scriptEngine;
    }

    @Override
    public ScriptEngine getEngineByExtension(String extension) {
        return this.getEngine(extension, this.extensionsToScriptFactories, KeyType.EXTENSION);
    }

    @Override
    public ScriptEngine getEngineByMimeType(String mimeType) {
        return this.getEngine(mimeType, this.mimeTypesToScriptFactories, KeyType.MIME_TYPE);
    }

    @Override
    public ScriptEngine getEngineByName(String shortName) {
        return this.getEngine(shortName, this.namesToScriptFactories, KeyType.NAME);
    }

    @Override
    public List<ScriptEngineFactory> getEngineFactories() {
        HashSet<ScriptEngineFactory> bundleScriptEngineFactories = new HashSet<ScriptEngineFactory>();
        bundleScriptEngineFactories.addAll(this.extensionsToScriptFactories.values());
        bundleScriptEngineFactories.addAll(this.namesToScriptFactories.values());
        bundleScriptEngineFactories.addAll(this.mimeTypesToScriptFactories.values());
        return new ArrayList<ScriptEngineFactory>(bundleScriptEngineFactories);
    }

    private void registerFactory(String key, ScriptEngineFactory factory, Map<String, ScriptEngineFactory> registrations, String keyType) {
        ScriptEngineFactory existing = registrations.get(key);
        if (existing != null) {
            throw new IllegalArgumentException(this.getFactoryClassName(factory) + " cannot be registered with " + keyType + " '" + key + "' because this " + keyType + " is already registered with " + this.getFactoryClassName(existing));
        }
        registrations.put(key, factory);
    }

    private String getFactoryClassName(ScriptEngineFactory factory) {
        return factory instanceof BundleScriptEngineFactory ? ((BundleScriptEngineFactory)factory).getWrappedFactoryClassName() : factory.getClass().getCanonicalName();
    }

    @Override
    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        this.registerFactory(extension, factory, this.extensionsToScriptFactories, EXTENSION);
    }

    @Override
    public void registerEngineMimeType(String type, ScriptEngineFactory factory) {
        this.registerFactory(type, factory, this.mimeTypesToScriptFactories, MIME_TYPE);
    }

    @Override
    public void registerEngineName(String name, ScriptEngineFactory factory) {
        this.registerFactory(name, factory, this.namesToScriptFactories, NAME);
    }

    private List<BundleScriptEngineFactory> getScriptEngineFactories(Bundle bundle) throws IOException {
        HashMap<String, Integer> extensionsPrioritiesMap;
        List<String> factoryCandidates = this.findFactoryCandidates(bundle);
        if (factoryCandidates.isEmpty()) {
            return null;
        }
        Dictionary headers = bundle.getHeaders();
        String extensionsPriorities = (String)headers.get("Jahia-Scripting-Extensions-Priorities");
        if (extensionsPriorities != null) {
            String[] extensionPriorityPairs = StringUtils.split((String)extensionsPriorities);
            extensionsPrioritiesMap = new HashMap<String, Integer>(extensionPriorityPairs.length);
            for (String extensionPriorityPair : extensionPriorityPairs) {
                String[] extensionPrioritySplit = StringUtils.split((String)extensionPriorityPair, (char)'=');
                boolean valid = false;
                if (extensionPrioritySplit != null && extensionPrioritySplit.length == 2) {
                    try {
                        extensionsPrioritiesMap.put(extensionPrioritySplit[0], Integer.parseInt(extensionPrioritySplit[1]));
                        valid = true;
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                    }
                }
                if (valid) continue;
                logger.warn("Invalid extension - priority pair: {}. Format is extension=priority, priority should be an integer. Extension will be ignored.", (Object)extensionPriorityPair);
            }
        } else {
            extensionsPrioritiesMap = null;
        }
        ClassLoader classLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        BundleScriptingContext scriptingContext = new BundleScriptingContext(classLoader, extensionsPrioritiesMap);
        ArrayList<BundleScriptEngineFactory> factories = new ArrayList<BundleScriptEngineFactory>(factoryCandidates.size());
        for (String factoryCandidate : factoryCandidates) {
            ScriptEngineFactory factory;
            try {
                Class<ScriptEngineFactory> factoryClass = bundle.loadClass(factoryCandidate).asSubclass(ScriptEngineFactory.class);
                factory = factoryClass.cast(factoryClass.newInstance());
            }
            catch (ClassNotFoundException e) {
                logger.warn("ScriptEngineFactory {} was registered to be loaded but no associated class was found in bundle {}. Ignoring.", (Object)factoryCandidate, (Object)bundle);
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.warn("Couldn't instantiate ScriptEngineFactory {}. Cause: {}. Ignoring.", (Object)factoryCandidate, (Object)e.getLocalizedMessage());
                continue;
            }
            catch (ClassCastException e) {
                logger.warn("Registered ScriptEngineFactory {} doesn't implement ScriptEngineFactory in bundle {}. Ignoring.", (Object)factoryCandidate, (Object)bundle);
                continue;
            }
            BundleScriptEngineFactory bundleScriptEngineFactory = new BundleScriptEngineFactory(factory, scriptingContext);
            factories.add(bundleScriptEngineFactory);
        }
        return factories;
    }

    private List<String> findFactoryCandidates(Bundle bundle) throws IOException {
        if ("system.bundle".equals(bundle.getSymbolicName())) {
            return Collections.emptyList();
        }
        if (bundle.getState() == 32) {
            Enumeration urls = bundle.findEntries(META_INF_SERVICES, SCRIPT_ENGINE_FACTORY_CLASS_NAME, false);
            if (urls == null) {
                return Collections.emptyList();
            }
            ArrayList<String> factoryCandidates = new ArrayList<String>();
            while (urls.hasMoreElements()) {
                URL u = (URL)urls.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(u.openStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        factoryCandidates.add(line.trim());
                    }
                }
            }
            return factoryCandidates;
        }
        return Collections.emptyList();
    }

    public void removeScriptEngineFactoriesIfNeeded(Bundle bundle) {
        List<BundleScriptEngineFactory> factories = this.bundleIdsToScriptFactories.remove(bundle.getBundleId());
        if (factories != null) {
            for (BundleScriptEngineFactory bundleScriptEngineFactory : factories) {
                BundleScriptResolver.getInstance().remove(bundleScriptEngineFactory, bundle);
                bundleScriptEngineFactory.destroy(bundle);
                this.removeFactoryFromRegistrationMaps(bundleScriptEngineFactory);
            }
            this.engineCache.clear();
        }
    }

    private void removeFactoryFromRegistrationMaps(BundleScriptEngineFactory bundleScriptEngineFactory) {
        List<String> extensions = bundleScriptEngineFactory.getExtensions();
        for (String string : extensions) {
            this.extensionsToScriptFactories.remove(string);
        }
        List<String> mimeTypes = bundleScriptEngineFactory.getMimeTypes();
        for (String mimeType : mimeTypes) {
            this.mimeTypesToScriptFactories.remove(mimeType);
        }
        List<String> list = bundleScriptEngineFactory.getNames();
        for (String name : list) {
            this.namesToScriptFactories.remove(name);
        }
    }

    public void addScriptEngineFactoriesIfNeeded(Bundle bundle) {
        try {
            List<BundleScriptEngineFactory> factories = this.getScriptEngineFactories(bundle);
            if (factories != null && !factories.isEmpty()) {
                this.addFactories(bundle, factories);
            }
        }
        catch (IOException e) {
            logger.error("Error trying to get bundle " + bundle + " script engine factory information", (Throwable)e);
        }
    }

    private void addFactories(Bundle bundle, List<BundleScriptEngineFactory> factories) {
        for (BundleScriptEngineFactory factory : factories) {
            try {
                List<String> extensions = factory.getExtensions();
                for (String string : extensions) {
                    this.registerEngineExtension(string, factory);
                }
                List<String> mimeTypes = factory.getMimeTypes();
                for (String mimeType : mimeTypes) {
                    this.registerEngineMimeType(mimeType, factory);
                }
                List<String> list = factory.getNames();
                for (String name : list) {
                    this.registerEngineName(name, factory);
                }
                factory.configurePreRegistration(bundle);
            }
            catch (Exception e) {
                this.removeFactoryFromRegistrationMaps(factory);
                throw e;
            }
            BundleScriptResolver.getInstance().register(factory, bundle);
        }
        this.engineCache.clear();
        this.bundleIdsToScriptFactories.put(bundle.getBundleId(), factories);
    }

    public ScriptEngineFactory getFactoryForExtension(String extension) {
        if (StringUtils.isEmpty((String)extension)) {
            throw new IllegalArgumentException("Null or empty extension");
        }
        return this.extensionsToScriptFactories.get(extension);
    }

    private static class Holder {
        static final BundleScriptEngineManager INSTANCE = new BundleScriptEngineManager();

        private Holder() {
        }
    }

    private static enum KeyType {
        EXTENSION,
        MIME_TYPE,
        NAME;

    }
}

