/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.AbstractHit;
import org.jahia.services.search.Hit;
import org.jahia.services.search.PageHit;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRNodeHit
extends AbstractHit<JCRNodeWrapper> {
    private static final Pattern SITES_CONTENTS_FILES = Pattern.compile("/sites/([^/]+)/(contents|files)/.*");
    private static Logger logger = LoggerFactory.getLogger(JCRNodeHit.class);
    private String link = null;
    private Map<String, JCRPropertyWrapper> propertiesFacade;
    private List<Hit> usages;
    private JCRNodeWrapper displayableNode = null;
    private Node foundNode = null;
    private boolean isDisplayableNodeChecked = false;
    private Set<String> usageFilterSites;
    private String excerpt;
    private List<Row> rows = null;

    public JCRNodeHit(JCRNodeWrapper node, RenderContext context) {
        super(node, context);
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    private Node getFoundNode() throws RepositoryException {
        if (this.foundNode == null) {
            this.foundNode = (Node)this.resource;
            if (this.getRows() != null) {
                String path = this.getRows().get(0).getPath();
                if (!((JCRNodeWrapper)this.resource).getPath().equals(path)) {
                    this.foundNode = ((JCRNodeWrapper)this.resource).getSession().getNode(path);
                }
            }
        }
        return this.foundNode;
    }

    @Override
    public Date getCreated() {
        try {
            return this.getFoundNode().getProperty("jcr:created").getDate().getTime();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    @Override
    public String getCreatedBy() {
        try {
            return this.getFoundNode().getProperty("jcr:createdBy").getString();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    @Override
    public Date getLastModified() {
        try {
            return this.getFoundNode().getProperty("jcr:lastModified").getDate().getTime();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    @Override
    public String getLastModifiedBy() {
        try {
            return this.getFoundNode().getProperty("jcr:lastModifiedBy").getString();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    @Override
    public String getLink() {
        if (this.link == null && this.getDisplayableNode() != null) {
            this.link = this.context.getURLGenerator().getContext() + this.resolveURL(this.getLinkTemplateType()) + this.getQueryParameter();
        }
        return this.link;
    }

    public String getPath() {
        return ((JCRNodeWrapper)this.resource).getPath();
    }

    public Map<String, JCRPropertyWrapper> getProperties() {
        if (this.propertiesFacade == null) {
            this.propertiesFacade = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){
                private Map<Object, JCRPropertyWrapper> accessedProperties = new HashMap<Object, JCRPropertyWrapper>();

                public Object transform(Object input) {
                    JCRPropertyWrapper property = null;
                    if (this.accessedProperties.containsKey(input)) {
                        property = this.accessedProperties.get(input);
                    } else {
                        try {
                            property = ((JCRNodeWrapper)JCRNodeHit.this.resource).getProperty(String.valueOf(input));
                        }
                        catch (RepositoryException e) {
                            logger.warn("Error accessing property '" + input + "'.", (Throwable)e);
                        }
                        this.accessedProperties.put(input, property);
                    }
                    return property;
                }
            });
        }
        return this.propertiesFacade;
    }

    @Override
    public String getTitle() {
        if (this.getDisplayableNode() == null) {
            return null;
        }
        return this.getDisplayableNode().getDisplayableName();
    }

    public String getName() {
        return ((JCRNodeWrapper)this.resource).getName();
    }

    @Override
    public String getType() {
        try {
            return ((JCRNodeWrapper)this.resource).getPrimaryNodeTypeName();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException("Unable to retrieve primary node type for the resource " + this.getPath(), e);
        }
    }

    public String getIconType() {
        return "";
    }

    @Override
    public List<Hit> getUsages() {
        if (this.usages == null) {
            this.usages = Collections.emptyList();
            if (this.shouldRetrieveUsages((JCRNodeWrapper)this.resource)) {
                this.usages = new ArrayList<Hit>();
                HashSet<String> addedLinks = new HashSet<String>();
                try {
                    PropertyIterator it = ((JCRNodeWrapper)this.resource).getWeakReferences();
                    while (it.hasNext()) {
                        try {
                            JCRNodeHit hit;
                            JCRNodeWrapper node;
                            JCRNodeWrapper refNode = (JCRNodeWrapper)it.nextProperty().getParent().getParent();
                            if (this.usageFilterSites != null && !this.usageFilterSites.contains(refNode.getResolveSite().getName()) || (node = JCRContentUtils.findDisplayableNode(refNode, this.context, refNode.getResolveSite())) == null) continue;
                            JCRNodeHit jCRNodeHit = hit = node.isNodeType("jnt:page") ? new PageHit(node, this.context) : new JCRNodeHit(node, this.context);
                            if (node.equals(this.resource) || !addedLinks.add(hit.getLink())) continue;
                            this.usages.add(hit);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
        return this.usages;
    }

    private boolean shouldRetrieveUsages(JCRNodeWrapper node) {
        boolean shouldRetrieveUsages = false;
        if (SITES_CONTENTS_FILES.matcher(node.getPath()).matches()) {
            shouldRetrieveUsages = true;
        }
        return shouldRetrieveUsages;
    }

    public JCRNodeWrapper getDisplayableNode() {
        if (!this.isDisplayableNodeChecked && this.displayableNode == null) {
            JCRSiteNode site;
            this.isDisplayableNodeChecked = true;
            try {
                site = ((JCRNodeWrapper)this.resource).getResolveSite();
            }
            catch (RepositoryException e) {
                site = null;
            }
            this.displayableNode = JCRContentUtils.findDisplayableNode((JCRNodeWrapper)this.resource, this.context, site);
            if (this.displayableNode == null && !CollectionUtils.isEmpty(this.getUsages())) {
                this.displayableNode = ((JCRNodeHit)this.getUsages().get(0)).getDisplayableNode();
            }
            if (this.displayableNode == null && Boolean.valueOf(SettingsBean.getInstance().getPropertiesFile().getProperty("search.displayableNodeCompat")).booleanValue()) {
                this.displayableNode = (JCRNodeWrapper)this.resource;
            }
        }
        return this.displayableNode;
    }

    private String resolveURL(String templateType) {
        if (this.getDisplayableNode() != null) {
            return this.context.getURLGenerator().buildURL(this.getDisplayableNode(), this.getDisplayableNode().getLanguage(), null, templateType);
        }
        return null;
    }

    public void setUsageFilterSites(Set<String> usageFilterSites) {
        this.usageFilterSites = usageFilterSites;
    }

    @Override
    public String getExcerpt() {
        if (this.excerpt == null && this.rows != null) {
            try {
                for (Row row : this.rows) {
                    Value excerptValue = row.getValue("rep:excerpt(.)");
                    if (excerptValue == null) continue;
                    if (excerptValue.getString().contains("###tags#") || excerptValue.getString().contains("###defaultCategory#")) {
                        StringBuilder r = new StringBuilder();
                        String separator = "";
                        String type = "";
                        for (String s : Patterns.COMMA.split(excerptValue.getString())) {
                            String s2 = Messages.getInternal(s.contains("tags") ? "label.tags" : "label.category", this.context.getRequest().getLocale());
                            String s1 = s.substring(s.indexOf("###"), s.lastIndexOf("###"));
                            String identifier = s1.substring(s1.lastIndexOf("#") + 1);
                            Object v = "";
                            if (identifier.startsWith("<span")) {
                                identifier = identifier.substring(identifier.indexOf(">") + 1, identifier.lastIndexOf("</span>"));
                                v = "<span class=\" searchHighlightedText\">" + this.getTitle() + "</span>";
                            } else {
                                v = this.getTitle();
                            }
                            if (!type.equals(s2)) {
                                r.append(s2).append(":");
                                type = s2;
                                separator = "";
                            }
                            r.append(separator).append((String)v);
                            separator = ", ";
                        }
                        this.setExcerpt(r.toString());
                    } else {
                        if (StringUtils.isEmpty((String)excerptValue.getString())) continue;
                        this.setExcerpt(excerptValue.getString());
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("Search details cannot be retrieved", (Throwable)e);
            }
        }
        return this.excerpt;
    }

    public void setExcerpt(String excerpt) {
        this.excerpt = excerpt;
    }

    public void addRow(Row row) {
        if (this.rows == null) {
            this.rows = new ArrayList<Row>();
        }
        this.rows.add(row);
    }

    public List<Row> getRows() {
        return this.rows;
    }
}

