/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.list.LazyList;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.settings.SettingsBean;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SearchCriteria
implements Serializable {
    private static final int MAX_LIMIT = SettingsBean.getInstance().getMaxSearchLimit();
    private static final long serialVersionUID = 4633533116047727827L;
    private static final ToStringStyle TO_STRING_STYLE = ToStringStyle.MULTI_LINE_STYLE;
    private DateValue created = new DateValue();
    private String createdBy;
    private boolean excludeFileReferences;
    private Collection<BaseFacetDefinition> facetDefinitions;
    private Map<String, Map<String, FacetValue>> facets = LazyMap.decorate(new HashMap(), (Factory)new FacetMapFactory());
    private HierarchicalValue filePath = new HierarchicalValue();
    private String fileType;
    private int itemsPerPage;
    private CommaSeparatedMultipleValue languages = new CommaSeparatedMultipleValue();
    private DateValue lastModified = new DateValue();
    private String lastModifiedBy;
    private int limit = MAX_LIMIT;
    private String nodeType;
    private long offset;
    private String originSiteKey;
    private HierarchicalValue pagePath = new HierarchicalValue();
    private Map<String, Map<String, NodeProperty>> properties = LazyMap.decorate(new HashMap(), (Factory)new NodePropertyMapFactory());
    private String rawQuery;
    private CommaSeparatedMultipleValue sites = new CommaSeparatedMultipleValue();
    private CommaSeparatedMultipleValue sitesForReferences = new CommaSeparatedMultipleValue();
    private List<Term> terms = LazyList.decorate(new LinkedList(), (Factory)new TermFactory());
    private List<Ordering> orderings = LazyList.decorate(new LinkedList(), (Factory)new OrderingFactory());

    private static boolean isValueEmpty(String value) {
        return StringUtils.isBlank((String)value);
    }

    private static List<String> listToString(List<?> items) {
        LinkedList<String> toStringItems = new LinkedList<String>();
        for (Object obj : items) {
            if (obj instanceof Term) {
                Term term = (Term)obj;
                toStringItems.add(new ToStringBuilder(obj, TO_STRING_STYLE).append("term", (Object)term.getTerm()).append("match", (Object)term.getMatch()).append("fields", (Object)ReflectionToStringBuilder.reflectionToString((Object)term.getFields(), (ToStringStyle)TO_STRING_STYLE)).toString());
                continue;
            }
            toStringItems.add(ReflectionToStringBuilder.reflectionToString(obj, (ToStringStyle)TO_STRING_STYLE));
        }
        return toStringItems;
    }

    public DateValue getCreated() {
        return this.created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Collection<BaseFacetDefinition> getFacetDefinitions() {
        return this.facetDefinitions;
    }

    public Map<String, Map<String, FacetValue>> getFacets() {
        return this.facets;
    }

    public HierarchicalValue getFilePath() {
        return this.filePath;
    }

    public String getFileType() {
        return this.fileType;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public CommaSeparatedMultipleValue getLanguages() {
        return this.languages;
    }

    public DateValue getLastModified() {
        return this.lastModified;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getOriginSiteKey() {
        return this.originSiteKey;
    }

    public HierarchicalValue getPagePath() {
        return this.pagePath;
    }

    public Map<String, Map<String, NodeProperty>> getProperties() {
        return this.properties;
    }

    public List<NodeProperty> getPropertiesAll() {
        LinkedList<NodeProperty> props = new LinkedList<NodeProperty>();
        for (Map<String, NodeProperty> docTypeEntry : this.getProperties().values()) {
            for (NodeProperty prop : docTypeEntry.values()) {
                props.add(prop);
            }
        }
        return props;
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public String getRawQuery() {
        return this.rawQuery;
    }

    public CommaSeparatedMultipleValue getSites() {
        return this.sites;
    }

    public CommaSeparatedMultipleValue getSitesForReferences() {
        return this.sitesForReferences;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public List<Ordering> getOrderings() {
        return this.orderings;
    }

    public boolean isEmpty() {
        boolean empty;
        boolean bl = empty = SearchCriteria.isValueEmpty(this.getNodeType()) && SearchCriteria.isValueEmpty(this.getFileType()) && SearchCriteria.isValueEmpty(this.getCreatedBy()) && this.getCreated().isEmpty() && SearchCriteria.isValueEmpty(this.getLastModifiedBy()) && this.getLastModified().isEmpty() && this.getPagePath().isEmpty() && this.getFilePath().isEmpty();
        if (empty) {
            for (Term term : this.getTerms()) {
                if (term.isEmpty()) continue;
                empty = false;
                break;
            }
        }
        if (empty) {
            block1: for (Map map : this.getProperties().values()) {
                for (NodeProperty prop : map.values()) {
                    if (!prop.isEmpty()) {
                        empty = false;
                        continue block1;
                    }
                    if (empty) continue;
                    continue block1;
                }
            }
        }
        return empty;
    }

    public void setCreated(DateValue creationDate) {
        this.created = creationDate;
    }

    public void setCreatedBy(String author) {
        this.createdBy = author;
    }

    public void setFacetDefinitions(Collection<BaseFacetDefinition> facetDefinitions) {
        this.facetDefinitions = facetDefinitions != null ? Collections.unmodifiableCollection(facetDefinitions) : null;
    }

    public void setFacets(Map<String, Map<String, FacetValue>> facets) {
        this.facets = facets;
    }

    public void setFilePath(HierarchicalValue fileLocation) {
        this.filePath = fileLocation;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public void setLanguages(CommaSeparatedMultipleValue languages) {
        this.languages = languages;
    }

    public void setLastModified(DateValue lastModificationDate) {
        this.lastModified = lastModificationDate;
    }

    public void setLastModifiedBy(String lastEditor) {
        this.lastModifiedBy = lastEditor;
    }

    public void setLimit(int limit) {
        this.limit = limit <= 0 ? MAX_LIMIT : Math.min(limit, MAX_LIMIT);
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setOriginSiteKey(String originSiteKey) {
        this.originSiteKey = originSiteKey;
    }

    public void setPagePath(HierarchicalValue pagePath) {
        this.pagePath = pagePath;
    }

    public void setProperties(Map<String, Map<String, NodeProperty>> properties) {
        this.properties = properties;
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public void setRawQuery(String rawQuery) {
        this.rawQuery = rawQuery;
    }

    public void setSites(CommaSeparatedMultipleValue sites) {
        this.sites = sites;
    }

    public void setSitesForReferences(CommaSeparatedMultipleValue sitesForReferences) {
        this.sitesForReferences = sitesForReferences;
    }

    public void setTerm(String term) {
        this.getTerms().clear();
        Term search = this.getTerms().get(0);
        search.setTerm(term);
        search.getFields().setFileContent(true);
    }

    public void setTerms(List<Term> textSearches) {
        this.terms = textSearches;
    }

    public void setOrderings(List<Ordering> orderings) {
        this.orderings = orderings;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, TO_STRING_STYLE).append("createdBy", (Object)this.getCreatedBy()).append("created", (Object)this.getCreated()).append("lastModifiedBy", (Object)this.getLastModifiedBy()).append("lastModified", (Object)this.getLastModified()).append("pagePath", (Object)this.getPagePath()).append("fileType", (Object)this.getFileType()).append("nodeType", (Object)this.getNodeType()).append("filePath", (Object)this.getFilePath()).append("properties", SearchCriteria.listToString(this.getPropertiesAll())).append("terms", SearchCriteria.listToString(this.getTerms())).append("orderings", SearchCriteria.listToString(this.getOrderings())).append("itemsPerPage", this.getItemsPerPage()).append("sites", (Object)this.getSites()).append("sitesForReferences", (Object)this.getSitesForReferences()).append("languages", (Object)this.getLanguages()).append("limit", this.getLimit()).append("offset", this.getOffset()).append("originSiteKey", (Object)this.getOriginSiteKey()).toString();
    }

    public boolean isFileSearch() {
        for (Term term : this.getTerms()) {
            if (term.getFields() == null || !term.getFields().isSiteContent() && (term.getFields().isDescription() || term.getFields().isFileContent() || term.getFields().isFilename() || term.getFields().isKeywords() || term.getFields().isTitle()) || term.getFields().isDescription() && term.getFields().isFileContent() && term.getFields().isFilename() && term.getFields().isKeywords() && term.getFields().isTitle()) continue;
            return false;
        }
        return !this.isPropertiesSearchOnContent();
    }

    public boolean isSiteSearch() {
        for (Term term : this.getTerms()) {
            if (term.getFields() == null || !term.getFields().isSiteContent()) continue;
            return true;
        }
        if (!this.getPagePath().isEmpty()) {
            return true;
        }
        return this.isPropertiesSearchOnContent();
    }

    private boolean isPropertiesSearchOnContent() {
        for (NodeProperty property : this.getPropertiesAll()) {
            try {
                ExtendedNodeType propertyNodeType = NodeTypeRegistry.getInstance().getNodeType(property.getNodeType());
                if (!propertyNodeType.isNodeType("jnt:content") && !propertyNodeType.isNodeType("jnt:page")) continue;
                return true;
            }
            catch (NoSuchNodeTypeException noSuchNodeTypeException) {
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = 31 * result + (this.excludeFileReferences ? 1231 : 1237);
        result = 31 * result + (this.facetDefinitions == null ? 0 : this.facetDefinitions.hashCode());
        result = 31 * result + (this.facets == null ? 0 : this.facets.hashCode());
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.fileType == null ? 0 : this.fileType.hashCode());
        result = 31 * result + this.itemsPerPage;
        result = 31 * result + (this.languages == null ? 0 : this.languages.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.lastModifiedBy == null ? 0 : this.lastModifiedBy.hashCode());
        result = 31 * result + (this.limit ^ this.limit >>> 32);
        result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (this.orderings == null ? 0 : this.orderings.hashCode());
        result = 31 * result + (this.originSiteKey == null ? 0 : this.originSiteKey.hashCode());
        result = 31 * result + (this.pagePath == null ? 0 : this.pagePath.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.rawQuery == null ? 0 : this.rawQuery.hashCode());
        result = 31 * result + (this.sites == null ? 0 : this.sites.hashCode());
        result = 31 * result + (this.sitesForReferences == null ? 0 : this.sitesForReferences.hashCode());
        result = 31 * result + (this.terms == null ? 0 : this.terms.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCriteria other = (SearchCriteria)obj;
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.createdBy == null ? other.createdBy != null : !this.createdBy.equals(other.createdBy)) {
            return false;
        }
        if (this.excludeFileReferences != other.excludeFileReferences) {
            return false;
        }
        if (this.facetDefinitions == null ? other.facetDefinitions != null : !this.facetDefinitions.equals(other.facetDefinitions)) {
            return false;
        }
        if (this.facets == null ? other.facets != null : !this.facets.equals(other.facets)) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.fileType == null ? other.fileType != null : !this.fileType.equals(other.fileType)) {
            return false;
        }
        if (this.itemsPerPage != other.itemsPerPage) {
            return false;
        }
        if (this.languages == null ? other.languages != null : !this.languages.equals(other.languages)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.lastModifiedBy == null ? other.lastModifiedBy != null : !this.lastModifiedBy.equals(other.lastModifiedBy)) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (this.nodeType == null ? other.nodeType != null : !this.nodeType.equals(other.nodeType)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.orderings == null ? other.orderings != null : !this.orderings.equals(other.orderings)) {
            return false;
        }
        if (this.originSiteKey == null ? other.originSiteKey != null : !this.originSiteKey.equals(other.originSiteKey)) {
            return false;
        }
        if (this.pagePath == null ? other.pagePath != null : !this.pagePath.equals(other.pagePath)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.rawQuery == null ? other.rawQuery != null : !this.rawQuery.equals(other.rawQuery)) {
            return false;
        }
        if (this.sites == null ? other.sites != null : !this.sites.equals(other.sites)) {
            return false;
        }
        if (this.sitesForReferences == null ? other.sitesForReferences != null : !this.sitesForReferences.equals(other.sitesForReferences)) {
            return false;
        }
        return !(this.terms == null ? other.terms != null : !this.terms.equals(other.terms));
    }

    public boolean isExcludeFileReferences() {
        return this.excludeFileReferences;
    }

    public void setExcludeFileReferences(boolean excludeFileReferences) {
        this.excludeFileReferences = excludeFileReferences;
    }

    public static class Ordering
    implements Serializable {
        private static final long serialVersionUID = -8242956239071973316L;
        private Order order = Order.DESCENDING;
        private CaseConversion caseConversion;
        private Operand operand = Operand.SCORE;
        private boolean normalize;
        private String propertyName;

        public Order getOrder() {
            return this.order;
        }

        public void setOrder(Order order) {
            this.order = order;
        }

        public CaseConversion getCaseConversion() {
            return this.caseConversion;
        }

        public void setCaseConversion(CaseConversion caseConversion) {
            this.caseConversion = caseConversion;
        }

        public boolean isNormalize() {
            return this.normalize;
        }

        public void setNormalize(boolean normalize) {
            this.normalize = normalize;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public Operand getOperand() {
            return this.operand;
        }

        public void setOperand(Operand operand) {
            this.operand = operand;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.caseConversion == null ? 0 : this.caseConversion.hashCode());
            result = 31 * result + (this.normalize ? 1231 : 1237);
            result = 31 * result + (this.operand == null ? 0 : this.operand.hashCode());
            result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
            result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ordering other = (Ordering)obj;
            if (this.caseConversion != other.caseConversion) {
                return false;
            }
            if (this.normalize != other.normalize) {
                return false;
            }
            if (this.operand != other.operand) {
                return false;
            }
            if (this.order != other.order) {
                return false;
            }
            return !(this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName));
        }

        public static enum Operand {
            SCORE,
            PROPERTY;

        }

        public static enum CaseConversion {
            LOWER,
            UPPER;

        }

        public static enum Order {
            ASCENDING,
            DESCENDING;

        }
    }

    public static class Term
    implements Serializable {
        private static final long serialVersionUID = -3881090179063748926L;
        private SearchFields fields = new SearchFields();
        private MatchType match = MatchType.AS_IS;
        private String term;
        private boolean applyFilter;

        public SearchFields getFields() {
            return this.fields;
        }

        public MatchType getMatch() {
            return this.match;
        }

        public String getTerm() {
            return this.term;
        }

        public boolean isEmpty() {
            return SearchCriteria.isValueEmpty(this.term);
        }

        public void setFields(SearchFields searchFields) {
            this.fields = searchFields;
        }

        public void setMatch(MatchType matchType) {
            this.match = matchType;
        }

        public void setTerm(String term) {
            this.term = term;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }

        public boolean isApplyFilter() {
            return this.applyFilter;
        }

        public void setApplyFilter(boolean applyFilter) {
            this.applyFilter = applyFilter;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.applyFilter ? 1231 : 1237);
            result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
            result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
            result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Term other = (Term)obj;
            if (this.applyFilter != other.applyFilter) {
                return false;
            }
            if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
                return false;
            }
            if (this.match != other.match) {
                return false;
            }
            return !(this.term == null ? other.term != null : !this.term.equals(other.term));
        }

        public static class SearchFields
        implements Serializable {
            private static final long serialVersionUID = 6583369520862461173L;
            private boolean description;
            private boolean fileContent;
            private boolean filename;
            private boolean keywords;
            private boolean siteContent;
            private boolean tags;
            private boolean title;

            public boolean isDescription() {
                return this.description;
            }

            public boolean isFileContent() {
                return this.fileContent;
            }

            public boolean isFilename() {
                return this.filename;
            }

            public boolean isKeywords() {
                return this.keywords;
            }

            public boolean isSiteContent() {
                return this.siteContent;
            }

            public boolean isTags() {
                return this.tags;
            }

            public boolean isTitle() {
                return this.title;
            }

            public void setAll(boolean allValue) {
                this.setDescription(allValue);
                this.setFileContent(allValue);
                this.setFilename(allValue);
                this.setKeywords(allValue);
                this.setSiteContent(allValue);
                this.setTags(allValue);
                this.setTitle(allValue);
            }

            public void setCustom(String[] customFields) {
                for (String custom : customFields) {
                    if (custom == null) continue;
                    if (custom.contains("siteContent")) {
                        this.setSiteContent(true);
                    }
                    if (custom.contains("fileContent")) {
                        this.setFileContent(true);
                    }
                    if (custom.contains("description")) {
                        this.setDescription(true);
                    }
                    if (custom.contains("title")) {
                        this.setTitle(true);
                    }
                    if (custom.contains("filename")) {
                        this.setFilename(true);
                    }
                    if (custom.contains("keywords")) {
                        this.setKeywords(true);
                    }
                    if (custom.contains("tags")) {
                        this.setTags(true);
                    }
                    if (!custom.contains("files")) continue;
                    this.setDescription(true);
                    this.setFileContent(true);
                    this.setFilename(true);
                    this.setKeywords(true);
                    this.setTitle(true);
                }
            }

            public void setDescription(boolean description) {
                this.description = description;
            }

            public void setFileContent(boolean everywhere) {
                this.fileContent = everywhere;
            }

            public void setFilename(boolean filename) {
                this.filename = filename;
            }

            public void setKeywords(boolean keywords) {
                this.keywords = keywords;
            }

            public void setSiteContent(boolean content) {
                this.siteContent = content;
                this.tags = content;
            }

            public void setFiles(boolean files) {
                this.setDescription(files);
                this.setFileContent(files);
                this.setFilename(files);
                this.setKeywords(files);
                this.setTitle(files);
            }

            public void setTags(boolean tags) {
                this.tags = tags;
            }

            public void setTitle(boolean title) {
                this.title = title;
            }

            public String toString() {
                return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.description ? 1231 : 1237);
                result = 31 * result + (this.fileContent ? 1231 : 1237);
                result = 31 * result + (this.filename ? 1231 : 1237);
                result = 31 * result + (this.keywords ? 1231 : 1237);
                result = 31 * result + (this.siteContent ? 1231 : 1237);
                result = 31 * result + (this.tags ? 1231 : 1237);
                result = 31 * result + (this.title ? 1231 : 1237);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SearchFields other = (SearchFields)obj;
                if (this.description != other.description) {
                    return false;
                }
                if (this.fileContent != other.fileContent) {
                    return false;
                }
                if (this.filename != other.filename) {
                    return false;
                }
                if (this.keywords != other.keywords) {
                    return false;
                }
                if (this.siteContent != other.siteContent) {
                    return false;
                }
                if (this.tags != other.tags) {
                    return false;
                }
                return this.title == other.title;
            }
        }

        public static enum MatchType {
            ALL_WORDS,
            ANY_WORD,
            AS_IS,
            EXACT_PHRASE,
            WITHOUT_WORDS,
            EXACT_PROPERTY_VALUE,
            NO_EXACT_PROPERTY_VALUE;

        }
    }

    private static class TermFactory
    implements Factory,
    Serializable {
        private static final long serialVersionUID = -7196425250357122068L;

        private TermFactory() {
        }

        public Object create() {
            return new Term();
        }
    }

    private static class OrderingFactory
    implements Factory,
    Serializable {
        private static final long serialVersionUID = -2291640852801927345L;

        private OrderingFactory() {
        }

        public Object create() {
            return new Ordering();
        }
    }

    protected static class NodePropertyMapFactory
    implements Factory,
    Serializable {
        private static final long serialVersionUID = 5271166314214230283L;

        protected NodePropertyMapFactory() {
        }

        public Object create() {
            return LazyMap.decorate(new HashMap(), (Factory)new NodePropertyFactory());
        }
    }

    protected static class NodePropertyFactory
    implements Factory,
    Serializable {
        private static final long serialVersionUID = 3303613294641347422L;

        protected NodePropertyFactory() {
        }

        public Object create() {
            return new NodeProperty();
        }
    }

    private static class FacetValueFactory
    implements Factory,
    Serializable {
        private static final long serialVersionUID = -7067653312417793462L;

        private FacetValueFactory() {
        }

        public Object create() {
            return new FacetValue();
        }
    }

    public static class FacetValue
    extends MultipleValue {
        private static final long serialVersionUID = 8254717328505039602L;
    }

    private static class FacetMapFactory
    implements Factory,
    Serializable {
        private static final long serialVersionUID = 7123060746726311423L;

        private FacetMapFactory() {
        }

        public Object create() {
            return LazyMap.decorate(new HashMap(), (Factory)new FacetValueFactory());
        }
    }

    public static class NodePropertyDescriptor
    implements Serializable {
        private static final long serialVersionUID = 857471721394958140L;
        private String[] allowedValues;
        private boolean constrained;
        private String defaultValue;
        private String label;
        private boolean multiple;
        private String name;
        private Map<String, String> selectorOptions;
        private NodeProperty.Type type = NodeProperty.Type.TEXT;

        public NodePropertyDescriptor(String name, String label, NodeProperty.Type type) {
            this.name = name;
            this.label = label;
            this.type = type;
        }

        public String[] getAllowedValues() {
            return this.allowedValues;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getSelectorOptions() {
            return this.selectorOptions;
        }

        public NodeProperty.Type getType() {
            return this.type;
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        public boolean isMultiple() {
            return this.multiple;
        }

        public void setAllowedValues(String[] allowedValues) {
            this.allowedValues = allowedValues;
        }

        public void setConstrained(boolean constrained) {
            this.constrained = constrained;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setMultiple(boolean multiple) {
            this.multiple = multiple;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSelectorOptions(Map<String, String> selectorOptions) {
            this.selectorOptions = new HashMap<String, String>(selectorOptions);
        }

        public void setType(NodeProperty.Type type) {
            this.type = type;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.allowedValues);
            result = 31 * result + (this.constrained ? 1231 : 1237);
            result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.multiple ? 1231 : 1237);
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.selectorOptions == null ? 0 : this.selectorOptions.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodePropertyDescriptor other = (NodePropertyDescriptor)obj;
            if (!Arrays.equals(this.allowedValues, other.allowedValues)) {
                return false;
            }
            if (this.constrained != other.constrained) {
                return false;
            }
            if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.multiple != other.multiple) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.selectorOptions == null ? other.selectorOptions != null : !this.selectorOptions.equals(other.selectorOptions)) {
                return false;
            }
            return this.type == other.type;
        }
    }

    public static class NodeProperty
    extends MultipleValue {
        private static final long serialVersionUID = 1356495981201889467L;
        private HierarchicalValue categoryValue = new HierarchicalValue();
        private boolean constrained;
        private DateValue dateValue = new DateValue();
        private Term.MatchType match = Term.MatchType.AS_IS;
        private boolean multiple;
        private String name;
        private String nodeType;
        private Type type = Type.TEXT;

        public HierarchicalValue getCategoryValue() {
            return this.categoryValue;
        }

        public DateValue getDateValue() {
            return this.dateValue;
        }

        public Term.MatchType getMatch() {
            return this.match;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isAllEmpty() {
            return super.isEmpty() && this.categoryValue.isEmpty() && this.dateValue.isEmpty();
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        @Override
        public boolean isEmpty() {
            boolean empty = false;
            if (Type.CATEGORY == this.type) {
                empty = this.categoryValue.isEmpty();
            } else if (Type.DATE == this.type) {
                empty = this.dateValue.isEmpty();
            } else if (Type.TEXT == this.type || Type.BOOLEAN == this.type) {
                empty = super.isEmpty();
            } else {
                throw new IllegalArgumentException("Unknown node property value type '" + this.type + "'");
            }
            return empty;
        }

        public boolean isMultiple() {
            return this.multiple;
        }

        public void setCategoryValue(HierarchicalValue categoryValue) {
            this.categoryValue = categoryValue;
        }

        public void setConstrained(boolean constrained) {
            this.constrained = constrained;
        }

        public void setDateValue(DateValue dateValue) {
            this.dateValue = dateValue;
        }

        public void setMatch(Term.MatchType matchType) {
            this.match = matchType;
        }

        public void setMultiple(boolean multiple) {
            this.multiple = multiple;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.categoryValue == null ? 0 : this.categoryValue.hashCode());
            result = 31 * result + (this.constrained ? 1231 : 1237);
            result = 31 * result + (this.dateValue == null ? 0 : this.dateValue.hashCode());
            result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
            result = 31 * result + (this.multiple ? 1231 : 1237);
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeProperty other = (NodeProperty)obj;
            if (this.categoryValue == null ? other.categoryValue != null : !this.categoryValue.equals(other.categoryValue)) {
                return false;
            }
            if (this.constrained != other.constrained) {
                return false;
            }
            if (this.dateValue == null ? other.dateValue != null : !this.dateValue.equals(other.dateValue)) {
                return false;
            }
            if (this.match != other.match) {
                return false;
            }
            if (this.multiple != other.multiple) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.nodeType == null ? other.nodeType != null : !this.nodeType.equals(other.nodeType)) {
                return false;
            }
            return this.type == other.type;
        }

        public static enum Type {
            BOOLEAN,
            CATEGORY,
            DATE,
            TEXT;

        }
    }

    public static abstract class MultipleValue
    implements Serializable {
        private static final long serialVersionUID = 1797359207235144293L;
        private String[] values;

        public String getValue() {
            return this.values != null && this.values.length > 0 ? this.values[0] : null;
        }

        public String[] getValues() {
            return this.values;
        }

        public boolean isEmpty() {
            boolean empty = true;
            if (this.values != null && this.values.length > 0) {
                for (String val : this.values) {
                    boolean bl = empty = empty && SearchCriteria.isValueEmpty(val);
                    if (!empty) break;
                }
            }
            return empty;
        }

        public void setValue(String value) {
            this.values = new String[]{value};
        }

        public void setValues(String[] values) {
            this.values = values;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultipleValue other = (MultipleValue)obj;
            return Arrays.equals(this.values, other.values);
        }
    }

    public static class HierarchicalValue
    extends CommaSeparatedMultipleValue {
        private static final long serialVersionUID = -2708875840446947769L;
        private boolean includeChildren;

        public boolean isIncludeChildren() {
            return this.includeChildren;
        }

        public void setIncludeChildren(boolean includeChildren) {
            this.includeChildren = includeChildren;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.includeChildren ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HierarchicalValue other = (HierarchicalValue)obj;
            return this.includeChildren == other.includeChildren;
        }
    }

    public static class DateValue
    implements Serializable {
        public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"dd.MM.yyyy");
        private static final long serialVersionUID = -1637520083714465344L;
        private String from;
        private Date fromAsDate;
        private String to;
        private Date toAsDate;
        private Type type = Type.ANYTIME;

        public String getFrom() {
            return this.from;
        }

        public Date getFromAsDate() {
            return this.fromAsDate;
        }

        public String getTo() {
            return this.to;
        }

        public Date getToAsDate() {
            return this.toAsDate;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isEmpty() {
            return Type.ANYTIME.equals((Object)this.type) || Type.RANGE.equals((Object)this.type) && null == this.fromAsDate && null == this.toAsDate;
        }

        public void setFrom(String dateFromAsString) {
            if (dateFromAsString != null && dateFromAsString.length() > 0) {
                this.from = dateFromAsString;
                this.fromAsDate = DATE_FORMAT.parseDateTime(dateFromAsString).toDate();
            } else {
                this.from = null;
                this.fromAsDate = null;
            }
        }

        public void setFromAsDate(Date dateFrom) {
            this.fromAsDate = dateFrom;
            this.from = dateFrom != null ? DATE_FORMAT.print(dateFrom.getTime()) : null;
        }

        public void setTo(String dateToAsString) {
            if (dateToAsString != null && dateToAsString.length() > 0) {
                this.to = dateToAsString;
                this.toAsDate = DATE_FORMAT.parseDateTime(dateToAsString).toDate();
            } else {
                this.to = null;
                this.toAsDate = null;
            }
        }

        public void setToAsDate(Date dateTo) {
            this.toAsDate = dateTo;
            this.to = dateTo != null ? DATE_FORMAT.print(dateTo.getTime()) : null;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.fromAsDate == null ? 0 : this.fromAsDate.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            result = 31 * result + (this.toAsDate == null ? 0 : this.toAsDate.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DateValue other = (DateValue)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            if (this.fromAsDate == null ? other.fromAsDate != null : !this.fromAsDate.equals(other.fromAsDate)) {
                return false;
            }
            if (this.to == null ? other.to != null : !this.to.equals(other.to)) {
                return false;
            }
            if (this.toAsDate == null ? other.toAsDate != null : !this.toAsDate.equals(other.toAsDate)) {
                return false;
            }
            return this.type == other.type;
        }

        public static enum Type {
            ANYTIME,
            LAST_MONTH,
            LAST_SIX_MONTHS,
            LAST_THREE_MONTHS,
            LAST_WEEK,
            RANGE,
            TODAY;

        }
    }

    public static class CommaSeparatedMultipleValue
    extends MultipleValue {
        private static final char MULTIPLE_VALUE_SEPARATOR = ',';
        private static final long serialVersionUID = 2324041504396269857L;

        @Override
        public void setValue(String value) {
            if (StringUtils.isNotEmpty((String)value) && value.indexOf(44) != -1) {
                super.setValues(StringUtils.split((String)value, (char)','));
            } else {
                super.setValue(value);
            }
        }

        public String toString() {
            return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TO_STRING_STYLE);
        }
    }

    public static class BaseFacetDefinition
    implements Serializable {
        private static final long serialVersionUID = 7275734915870152689L;
        private String id;
        private int maxFacetResults;
        private Map<String, Object> fields = new HashMap<String, Object>();

        public BaseFacetDefinition(String id, int maxFacetResults) {
            if (id == null || id.length() == 0) {
                throw new IllegalArgumentException("Facet definition ID should not be null or empty");
            }
            this.id = id;
            this.maxFacetResults = maxFacetResults;
        }

        public String getId() {
            return this.id;
        }

        public int getMaxFacetResults() {
            return this.maxFacetResults;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + this.maxFacetResults;
            result = 31 * result + this.fields.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BaseFacetDefinition other = (BaseFacetDefinition)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.maxFacetResults != other.maxFacetResults) {
                return false;
            }
            return this.fields.equals(other.fields);
        }

        public Object getField(String dataField) {
            return this.fields.get(dataField);
        }

        public void setField(String dataField, Object value) {
            this.fields.put(dataField, value);
        }
    }
}

