/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search.spell;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.JahiaSecondaryIndex;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SpellChecker;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.LocationStepQueryNode;
import org.apache.jackrabbit.spi.commons.query.PathQueryNode;
import org.apache.jackrabbit.spi.commons.query.QueryNodeVisitor;
import org.apache.jackrabbit.spi.commons.query.QueryRootNode;
import org.apache.jackrabbit.spi.commons.query.RelationQueryNode;
import org.apache.jackrabbit.spi.commons.query.TraversingQueryNodeVisitor;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.JahiaExtendedSpellChecker;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.DateUtils;
import org.jahia.utils.LuceneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSpellChecker
implements SpellChecker {
    private static final Logger logger = LoggerFactory.getLogger(CompositeSpellChecker.class);
    public static final String SEPARATOR_IN_SUGGESTION = "#!#";
    public static final String MAX_TERMS_PARAM = "maxTerms";
    public static final String SITES_PARAM = "sites";
    private static Map<String, InternalSpellChecker> spellCheckers = new ConcurrentHashMap<String, InternalSpellChecker>(2);
    private InternalSpellChecker spellChecker;
    private final long refreshInterval;

    public static void updateSpellCheckerIndex() {
        CompositeSpellChecker.updateSpellCheckerIndex(true);
    }

    public static void updateSpellCheckerIndex(boolean inBackground) {
        for (InternalSpellChecker checker : spellCheckers.values()) {
            checker.lastRefresh = 0L;
            checker.refreshSpellChecker(inBackground);
        }
    }

    public CompositeSpellChecker() {
        this(3600000L);
    }

    protected CompositeSpellChecker(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void init(QueryHandler handler) throws IOException {
        if (!(handler instanceof SearchIndex)) {
            throw new IOException("CompositeSpellChecker only works with " + SearchIndex.class.getName());
        }
        this.spellChecker = new InternalSpellChecker((SearchIndex)handler);
        spellCheckers.put(((SearchIndex)handler).getPath(), this.spellChecker);
    }

    public String check(QueryRootNode aqt) throws IOException {
        int parsedMaxTermCount;
        final HashMap<String, String> spellcheckInfo = new HashMap<String, String>();
        try {
            Locale locale;
            aqt.accept((QueryNodeVisitor)new TraversingQueryNodeVisitor(){

                public Object visit(RelationQueryNode node, Object data) throws RepositoryException {
                    Name propertyName;
                    if (!spellcheckInfo.containsKey("statement") && node.getOperation() == 29) {
                        String spellCheckParams = node.getStringValue();
                        String[] s = spellCheckParams.split(CompositeSpellChecker.SEPARATOR_IN_SUGGESTION);
                        spellcheckInfo.put("statement", s[0]);
                        spellcheckInfo.put("maxTermCount", StringUtils.substringAfter((String)s[1], (String)"maxTerms="));
                        if (s.length > 2) {
                            spellcheckInfo.put(CompositeSpellChecker.SITES_PARAM, StringUtils.substringAfter((String)s[2], (String)"sites="));
                        }
                    } else if (!spellcheckInfo.containsKey("language") && node.getRelativePath() != null && node.getRelativePath().getNumOperands() > 0 && "language".equals((propertyName = ((LocationStepQueryNode)node.getRelativePath().getOperands()[0]).getNameTest()).getLocalName())) {
                        spellcheckInfo.put("language", node.getStringValue());
                    }
                    return super.visit(node, data);
                }

                public Object visit(PathQueryNode node, Object data) throws RepositoryException {
                    for (int i : new int[]{0, 1}) {
                        if (node.getPathSteps().length <= i + 1 || !CompositeSpellChecker.SITES_PARAM.equals(node.getPathSteps()[i].getNameTest().getLocalName())) continue;
                        spellcheckInfo.put(CompositeSpellChecker.SITES_PARAM, node.getPathSteps()[++i].getNameTest().getLocalName());
                    }
                    return super.visit(node, data);
                }
            }, null);
            if (!spellcheckInfo.containsKey("statement")) {
                return null;
            }
            if (!spellcheckInfo.containsKey("language") && (locale = JCRSessionFactory.getInstance().getCurrentLocale()) != null) {
                spellcheckInfo.put("language", locale.toString());
            }
        }
        catch (RepositoryException e) {
            logger.debug("issue while checking " + aqt, (Object)e.getMessage());
        }
        int maxTermCount = 1;
        String maxTermCountStr = (String)spellcheckInfo.get("maxTermCount");
        if (!StringUtils.isEmpty((String)maxTermCountStr) && StringUtils.isNumeric((String)maxTermCountStr) && (parsedMaxTermCount = Integer.parseInt(maxTermCountStr)) > 1) {
            maxTermCount = parsedMaxTermCount;
        }
        return this.spellChecker.suggest((String)spellcheckInfo.get("statement"), StringUtils.split((String)((String)spellcheckInfo.get(SITES_PARAM)), (String)"*"), (String)spellcheckInfo.get("language"), maxTermCount);
    }

    public void close() {
        try {
            this.spellChecker.close();
        }
        finally {
            spellCheckers.remove(this.spellChecker.handler.getPath());
        }
    }

    public void updateIndex() {
        this.updateIndex(true);
    }

    public void updateIndex(boolean inBackground) {
        this.spellChecker.lastRefresh = 0L;
        this.spellChecker.refreshSpellChecker(inBackground);
    }

    private final class InternalSpellChecker {
        private long lastRefresh;
        private boolean refreshing = false;
        private final SearchIndex handler;
        private final Directory spellIndexDirectory;
        private JahiaExtendedSpellChecker spellChecker;

        InternalSpellChecker(SearchIndex handler) throws IOException {
            this.handler = handler;
            String path = handler.getPath() + File.separatorChar + "spellchecker";
            this.spellIndexDirectory = FSDirectory.open((File)new File(path), (LockFactory)new NativeFSLockFactory(path));
            if (IndexReader.indexExists((Directory)this.spellIndexDirectory)) {
                this.lastRefresh = System.currentTimeMillis();
            }
            this.spellChecker = new JahiaExtendedSpellChecker(this.spellIndexDirectory);
            this.spellChecker.setAccuracy(Float.parseFloat(SettingsBean.getInstance().getPropertiesFile().getProperty("jahia.jackrabbit.searchIndex.spellChecker.minimumScore")));
            try {
                this.spellChecker.setStringDistance((StringDistance)Class.forName(SettingsBean.getInstance().getPropertiesFile().getProperty("jahia.jackrabbit.searchIndex.spellChecker.distanceImplementation")).newInstance());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (!(handler instanceof JahiaSecondaryIndex)) {
                this.refreshSpellChecker();
            }
        }

        String suggest(String statement, String[] sites, String language, int maxSuggestions) throws IOException {
            ArrayList<String> words = new ArrayList<String>();
            ArrayList<Token> tokens = new ArrayList<Token>();
            this.tokenize(statement, words, tokens, null, language);
            String[][] suggestions = this.check(words.toArray(new String[words.size()]), sites, language, maxSuggestions);
            if (suggestions != null) {
                int possibleSuggestionsCount = 1;
                for (String[] suggestionsPerWord : suggestions) {
                    if (suggestionsPerWord.length <= 1) continue;
                    if (possibleSuggestionsCount > 1) {
                        possibleSuggestionsCount = 1;
                        break;
                    }
                    possibleSuggestionsCount = suggestionsPerWord.length;
                }
                StringBuilder sb = new StringBuilder();
                int loopCount = 0;
                do {
                    if (loopCount > 0) {
                        sb.append(CompositeSpellChecker.SEPARATOR_IN_SUGGESTION);
                    }
                    StringBuilder stmt = new StringBuilder(statement);
                    for (int i = suggestions.length - 1; i >= 0; --i) {
                        int pos;
                        Token t = (Token)tokens.get(i);
                        int n = pos = suggestions[i].length > 1 ? loopCount : 0;
                        if (t.term().equalsIgnoreCase(suggestions[i][pos])) continue;
                        stmt.replace(t.startOffset(), t.endOffset(), suggestions[i][pos]);
                    }
                    sb.append((CharSequence)stmt);
                } while (++loopCount < possibleSuggestionsCount);
                return sb.toString();
            }
            return null;
        }

        void close() {
            try {
                this.spellIndexDirectory.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.spellChecker.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.spellChecker = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tokenize(String statement, List<String> words, List<Token> tokens, String site, String language) throws IOException {
            Analyzer analyzer = this.handler.getIndexingConfig().getPropertyAnalyzer("0:FULL:SPELLCHECK");
            if (analyzer == null) {
                analyzer = this.handler.getTextAnalyzer();
            }
            try (TokenStream ts = analyzer.tokenStream(LuceneUtils.getFullTextFieldName(site, language), (Reader)new StringReader(statement));){
                OffsetAttribute offsetAttribute = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
                TermAttribute termAttribute = (TermAttribute)ts.getAttribute(TermAttribute.class);
                PositionIncrementAttribute position = (PositionIncrementAttribute)ts.getAttribute(PositionIncrementAttribute.class);
                while (ts.incrementToken()) {
                    String origWord = statement.substring(offsetAttribute.startOffset(), offsetAttribute.endOffset());
                    if (position.getPositionIncrement() > 0) {
                        words.add(termAttribute.term());
                        tokens.add(new Token(termAttribute.term(), offsetAttribute.startOffset(), offsetAttribute.endOffset()));
                        continue;
                    }
                    Token current = tokens.get(tokens.size() - 1);
                    if (Math.abs(origWord.length() - current.term().length()) <= Math.abs(origWord.length() - termAttribute.term().length())) continue;
                    words.set(words.size() - 1, termAttribute.term());
                    tokens.set(tokens.size() - 1, new Token(termAttribute.term(), offsetAttribute.startOffset(), offsetAttribute.endOffset()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[][] check(String[] words, String[] sites, String language, int maxSuggestionCount) throws IOException {
            this.refreshSpellChecker();
            boolean hasSuggestion = false;
            try (IndexReader reader = this.handler.getIndexReader();){
                for (int retries = 0; retries < 100; ++retries) {
                    try {
                        String[][] suggestion = new String[words.length][];
                        for (int i = 0; i < words.length; ++i) {
                            String[] similar = this.spellChecker.suggestSimilar(words[i], maxSuggestionCount, reader, true, sites, language);
                            if (similar.length > 0) {
                                suggestion[i] = similar;
                                hasSuggestion = true;
                                continue;
                            }
                            suggestion[i] = new String[]{words[i]};
                        }
                        if (hasSuggestion) {
                            logger.debug("Successful after {} retries " + retries);
                            String[][] stringArray = suggestion;
                            return stringArray;
                        }
                        String[][] stringArray = null;
                        return stringArray;
                    }
                    catch (AlreadyClosedException alreadyClosedException) {
                        continue;
                    }
                }
                String[][] stringArray = null;
                return stringArray;
            }
        }

        private void refreshSpellChecker() {
            this.refreshSpellChecker(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshSpellChecker(boolean inBackground) {
            if (this.lastRefresh + CompositeSpellChecker.this.refreshInterval < System.currentTimeMillis()) {
                InternalSpellChecker internalSpellChecker = this;
                synchronized (internalSpellChecker) {
                    if (!this.refreshing) {
                        this.refreshing = true;
                        Runnable refresh = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                while (!SpringContextSingleton.getInstance().isInitialized() || JCRSessionFactory.getInstance().getMountPoints().keySet().isEmpty()) {
                                    try {
                                        Thread.sleep(5000L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                try {
                                    JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Set<String>>(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public Set<String> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                                            if (session.nodeExists("/sites")) {
                                                IndexReader reader = null;
                                                try {
                                                    reader = InternalSpellChecker.this.handler.getIndexReader();
                                                    long time = System.currentTimeMillis();
                                                    logger.debug("Starting spell checker index refresh");
                                                    List<JCRSiteNode> siteNodes = JahiaSitesService.getInstance().getSitesNodeList(session);
                                                    for (JCRSiteNode siteNode : siteNodes) {
                                                        for (String language : siteNode.getLanguages()) {
                                                            StringBuilder fullTextName = new StringBuilder(FieldNames.FULLTEXT);
                                                            String name = siteNode.getName();
                                                            fullTextName.append("-").append(name);
                                                            InternalSpellChecker.this.spellChecker.indexDictionary((Dictionary)new LuceneDictionary(reader, fullTextName.toString()), 300, 10, name, language);
                                                            if (language != null) {
                                                                fullTextName.append("-").append(language);
                                                            }
                                                            InternalSpellChecker.this.spellChecker.indexDictionary((Dictionary)new LuceneDictionary(reader, fullTextName.toString()), 300, 10, name, language);
                                                        }
                                                    }
                                                    logger.info("Spell checker index refreshed in {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - time));
                                                }
                                                catch (IOException e) {
                                                    logger.error(e.getMessage(), (Throwable)e);
                                                }
                                                finally {
                                                    if (reader != null) {
                                                        try {
                                                            reader.close();
                                                        }
                                                        catch (IOException e) {
                                                            logger.error(e.getMessage(), (Throwable)e);
                                                        }
                                                    }
                                                }
                                            }
                                            return null;
                                        }
                                    });
                                }
                                catch (RepositoryException e) {
                                    logger.warn("Error creating spellcheck index", (Throwable)e);
                                }
                                finally {
                                    InternalSpellChecker internalSpellChecker = InternalSpellChecker.this;
                                    synchronized (internalSpellChecker) {
                                        InternalSpellChecker.this.refreshing = false;
                                    }
                                }
                            }
                        };
                        if (inBackground) {
                            new Thread(refresh, "SpellChecker Refresh").start();
                        } else {
                            refresh.run();
                        }
                        this.lastRefresh = System.currentTimeMillis();
                    }
                }
            }
        }
    }

    public static final class OneDayRefreshInterval
    extends CompositeSpellChecker {
        public OneDayRefreshInterval() {
            super(86400000L);
        }
    }

    public static final class TwelveHoursRefreshInterval
    extends CompositeSpellChecker {
        public TwelveHoursRefreshInterval() {
            super(43200000L);
        }
    }

    public static final class SixHoursRefreshInterval
    extends CompositeSpellChecker {
        public SixHoursRefreshInterval() {
            super(21600000L);
        }
    }

    public static final class OneHourRefreshInterval
    extends CompositeSpellChecker {
        public OneHourRefreshInterval() {
            super(3600000L);
        }
    }

    public static final class ThirtyMinutesRefreshInterval
    extends CompositeSpellChecker {
        public ThirtyMinutesRefreshInterval() {
            super(1800000L);
        }
    }

    public static final class FiveMinutesRefreshInterval
    extends CompositeSpellChecker {
        public FiveMinutesRefreshInterval() {
            super(300000L);
        }
    }

    public static final class OneMinuteRefreshInterval
    extends CompositeSpellChecker {
        public OneMinuteRefreshInterval() {
            super(60000L);
        }
    }

    public static final class FiveSecondsRefreshInterval
    extends CompositeSpellChecker {
        public FiveSecondsRefreshInterval() {
            super(5000L);
        }
    }
}

