/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.security.shiro;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.pipelines.Pipeline;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.security.shiro.JahiaUserToken;
import org.jahia.services.usermanager.JahiaUser;

public class JahiaAuthenticationFilter
extends AuthenticatingFilter {
    private Pipeline authPipeline;
    private JCRSessionFactory sessionFactory;

    public void setAuthPipeline(Pipeline authPipeline) {
        this.authPipeline = authPipeline;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        return new JahiaUserToken((JahiaUser)WebUtils.toHttp((ServletRequest)request).getAttribute("org.jahia.usermanager.jahiauser"));
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        boolean userSet;
        AuthValveContext authValveContext = new AuthValveContext(WebUtils.toHttp((ServletRequest)request), WebUtils.toHttp((ServletResponse)response), this.sessionFactory);
        this.authPipeline.invoke(authValveContext);
        JahiaUser jahiaUser = this.sessionFactory.getCurrentUser();
        boolean bl = userSet = jahiaUser != null;
        if (userSet) {
            request.setAttribute("org.jahia.usermanager.jahiauser", (Object)jahiaUser);
            this.executeLogin(request, response);
        } else {
            this.saveRequestAndRedirectToLogin(request, response);
        }
        return userSet;
    }

    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        String loginUrl = this.getLoginUrl() + "?redirect=" + WebUtils.toHttp((ServletRequest)request).getRequestURI();
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)loginUrl);
    }
}

