/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.jcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.validation.ConstraintViolationException;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.NonUniqueUrlMappingException;
import org.jahia.services.seo.jcr.ReservedUrlMappingException;

public class VanityUrlManager {
    public static final String JAHIAMIX_VANITYURLMAPPED = "jmix:vanityUrlMapped";
    public static final String JAHIANT_VANITYURL = "jnt:vanityUrl";
    public static final String JAHIANT_VANITYURLS = "jnt:vanityUrls";
    public static final String VANITYURLMAPPINGS_NODE = "vanityUrlMapping";
    public static final String PROPERTY_URL = "j:url";
    public static final String PROPERTY_DEFAULT = "j:default";
    public static final String PROPERTY_ACTIVE = "j:active";
    public static final String PROPERTY_FILE = "j:file";
    public static final Pattern INVALID_CHARS = Pattern.compile("[:*?\"<>|%+]");
    private List<String> reservedJahiaUrls;

    public List<VanityUrl> findExistingVanityUrls(String url, String site, JCRSessionWrapper session) throws RepositoryException {
        StringBuilder xpath = new StringBuilder("/jcr:root");
        StringBuilder sql2 = new StringBuilder("SELECT * FROM [").append(JAHIANT_VANITYURL).append("] AS vanityURL WHERE ");
        if (StringUtils.isNotEmpty((String)site)) {
            xpath.append("/sites/").append(JCRContentUtils.stringToJCRPathExp(site));
            sql2.append("ISDESCENDANTNODE('/sites/").append(JCRContentUtils.sqlEncode(site)).append("') AND ");
        } else {
            xpath.append("/sites");
            sql2.append("ISDESCENDANTNODE('/sites') AND ");
        }
        String urlForQuery = JCRContentUtils.stringToQueryLiteral(url);
        xpath.append("//element(*, ").append(JAHIANT_VANITYURL).append(")[@").append(PROPERTY_URL).append(" = ").append(urlForQuery).append("]");
        sql2.append("vanityURL.[").append(PROPERTY_URL).append("] = ").append(urlForQuery);
        QueryWrapper vanityUrlsQuery = session.getWorkspace().getQueryManager().createDualQuery(xpath.toString(), "xpath", sql2.toString());
        NodeIterator vanityUrls = vanityUrlsQuery.execute().getNodes();
        LinkedList<VanityUrl> existingVanityUrls = new LinkedList<VanityUrl>();
        while (vanityUrls.hasNext()) {
            JCRNodeWrapper vanityUrlNode = (JCRNodeWrapper)vanityUrls.nextNode();
            existingVanityUrls.add(this.populateJCRData(vanityUrlNode, new VanityUrl()));
        }
        return existingVanityUrls;
    }

    public VanityUrl getVanityUrlForCurrentLocale(JCRNodeWrapper contentNode, String siteKey, JCRSessionWrapper session) throws RepositoryException {
        VanityUrl vanityUrl = null;
        if (this.isMapped(contentNode)) {
            boolean isSite = contentNode.getResolveSite().getSiteKey().equals(siteKey);
            String currentLanguage = session.getLocale().toString();
            JCRNodeIteratorWrapper it = session.getNode(contentNode.getPath() + "/vanityUrlMapping").getNodes();
            while (it.hasNext()) {
                JCRNodeWrapper currentNode = (JCRNodeWrapper)it.next();
                if (!currentNode.getPropertyAsString("jcr:language").equals(currentLanguage)) continue;
                if (currentNode.getProperty(PROPERTY_DEFAULT).getBoolean() && isSite) {
                    vanityUrl = this.populateJCRData(currentNode, new VanityUrl());
                }
                if (vanityUrl == null) continue;
                break;
            }
        }
        return vanityUrl;
    }

    public List<VanityUrl> getVanityUrls(JCRNodeWrapper contentNode, String languageCode, JCRSessionWrapper session) throws RepositoryException {
        ArrayList<VanityUrl> vanityUrls = new ArrayList<VanityUrl>();
        if (this.isMapped(contentNode = session.getNodeByUUID(contentNode.getIdentifier()))) {
            JCRNodeIteratorWrapper it = contentNode.getNode(VANITYURLMAPPINGS_NODE).getNodes();
            while (it.hasNext()) {
                JCRNodeWrapper currentNode = (JCRNodeWrapper)it.next();
                if (languageCode != null && !currentNode.getPropertyAsString("jcr:language").equals(languageCode)) continue;
                vanityUrls.add(this.populateJCRData(currentNode, new VanityUrl()));
            }
        }
        return vanityUrls;
    }

    private boolean isMapped(JCRNodeWrapper contentNode) throws RepositoryException {
        return contentNode.isNodeType(JAHIAMIX_VANITYURLMAPPED) && contentNode.hasNode(VANITYURLMAPPINGS_NODE);
    }

    public boolean removeVanityUrlMapping(JCRNodeWrapper contentNode, VanityUrl vanityUrl, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper vanityUrlNode = null;
        JCRNodeWrapper newDefaultVanityUrlNode = null;
        JCRNodeWrapper vanityUrlMappingsNode = null;
        if (this.isMapped(contentNode)) {
            vanityUrlMappingsNode = contentNode.getNode(VANITYURLMAPPINGS_NODE);
            JCRNodeIteratorWrapper it = vanityUrlMappingsNode.getNodes();
            while (it.hasNext()) {
                JCRNodeWrapper currentNode = (JCRNodeWrapper)it.next();
                if (vanityUrl.isDefaultMapping() && currentNode.getPropertyAsString("jcr:language").equals(vanityUrl.getLanguage()) && currentNode.getProperty(PROPERTY_ACTIVE).getBoolean() && !currentNode.getPropertyAsString(PROPERTY_URL).equals(vanityUrl.getUrl())) {
                    newDefaultVanityUrlNode = currentNode;
                    break;
                }
                if (!currentNode.getPropertyAsString(PROPERTY_URL).equals(vanityUrl.getUrl())) continue;
                vanityUrlNode = currentNode;
                if (vanityUrl.isDefaultMapping() && newDefaultVanityUrlNode == null) continue;
                break;
            }
        }
        if (vanityUrlNode != null) {
            session.checkout(vanityUrlMappingsNode);
            vanityUrlNode.remove();
            if (newDefaultVanityUrlNode != null) {
                newDefaultVanityUrlNode.setProperty(PROPERTY_DEFAULT, true);
            }
            session.save();
            return true;
        }
        return false;
    }

    public boolean removeVanityUrlMappings(JCRNodeWrapper contentNode, String languageCode, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper vanityUrlMappingsNode;
        JCRNodeIteratorWrapper it;
        if (this.isMapped(contentNode) && (it = (vanityUrlMappingsNode = contentNode.getNode(VANITYURLMAPPINGS_NODE)).getNodes()).hasNext()) {
            LinkedList<Node> toRemove = new LinkedList<Node>();
            while (it.hasNext()) {
                Node node = it.nextNode();
                if (!languageCode.equals(node.getProperty("jcr:language").getString())) continue;
                toRemove.add(node);
            }
            if (!toRemove.isEmpty()) {
                session.checkout(vanityUrlMappingsNode);
                for (Node node : toRemove) {
                    node.remove();
                }
                session.save();
                return true;
            }
        }
        return false;
    }

    public boolean saveVanityUrlMapping(JCRNodeWrapper contentNode, VanityUrl vanityUrl, JCRSessionWrapper session) throws RepositoryException {
        return this.saveVanityUrlMapping(contentNode, vanityUrl, session, true);
    }

    public boolean saveVanityUrlMapping(JCRNodeWrapper contentNode, VanityUrl vanityUrl, JCRSessionWrapper session, boolean save) throws RepositoryException {
        this.checkUniqueAndValidConstraint(contentNode, vanityUrl, null);
        JCRNodeWrapper vanityUrlNode = null;
        JCRNodeWrapper previousDefaultVanityUrlNode = null;
        JCRNodeWrapper vanityUrlMappingsNode = null;
        if (!contentNode.hasNode(VANITYURLMAPPINGS_NODE)) {
            if (!contentNode.isNodeType(JAHIAMIX_VANITYURLMAPPED)) {
                contentNode.addMixin(JAHIAMIX_VANITYURLMAPPED);
            }
            vanityUrlMappingsNode = contentNode.addNode(VANITYURLMAPPINGS_NODE, JAHIANT_VANITYURLS);
        } else {
            vanityUrlMappingsNode = contentNode.getNode(VANITYURLMAPPINGS_NODE);
            JCRNodeIteratorWrapper it = vanityUrlMappingsNode.getNodes();
            while (it.hasNext()) {
                JCRNodeWrapper currentNode = (JCRNodeWrapper)it.next();
                if (vanityUrl.isDefaultMapping() && currentNode.getPropertyAsString("jcr:language").equals(vanityUrl.getLanguage()) && currentNode.getProperty(PROPERTY_DEFAULT).getBoolean() && !currentNode.getIdentifier().equals(vanityUrl.getIdentifier())) {
                    previousDefaultVanityUrlNode = currentNode;
                    if (vanityUrlNode != null) break;
                }
                if (!currentNode.getIdentifier().equals(vanityUrl.getIdentifier())) continue;
                vanityUrlNode = currentNode;
                if (vanityUrl.isDefaultMapping() && previousDefaultVanityUrlNode == null) continue;
                break;
            }
        }
        if (vanityUrlNode == null) {
            session.checkout(vanityUrlMappingsNode);
            vanityUrlNode = vanityUrlMappingsNode.addNode(JCRContentUtils.escapeLocalNodeName(vanityUrl.getUrl()), JAHIANT_VANITYURL);
        } else {
            if (vanityUrlNode.getProperty(PROPERTY_ACTIVE).getBoolean() == vanityUrl.isActive() && vanityUrlNode.getProperty(PROPERTY_URL).getString().equals(vanityUrl.getUrl()) && vanityUrlNode.getProperty(PROPERTY_DEFAULT).getBoolean() == vanityUrl.isDefaultMapping() && vanityUrlNode.hasProperty(PROPERTY_FILE) && vanityUrlNode.getProperty(PROPERTY_FILE).getBoolean() == vanityUrl.isFile() && vanityUrlNode.getProperty("jcr:language").getString().equals(vanityUrl.getLanguage())) {
                return false;
            }
            session.checkout(vanityUrlMappingsNode);
        }
        vanityUrlNode.setProperty(PROPERTY_URL, vanityUrl.getUrl());
        vanityUrlNode.setProperty("jcr:language", vanityUrl.getLanguage());
        vanityUrlNode.setProperty(PROPERTY_ACTIVE, vanityUrl.isActive());
        vanityUrlNode.setProperty(PROPERTY_DEFAULT, vanityUrl.isDefaultMapping());
        vanityUrlNode.setProperty(PROPERTY_FILE, vanityUrl.isFile());
        String newSystemName = JCRContentUtils.escapeLocalNodeName(vanityUrl.getUrl());
        if (!vanityUrlNode.getName().equals(newSystemName)) {
            session.move(vanityUrlNode.getPath(), vanityUrlNode.getParent().getPath() + "/" + newSystemName);
        }
        if (previousDefaultVanityUrlNode != null) {
            previousDefaultVanityUrlNode.setProperty(PROPERTY_DEFAULT, false);
        }
        if (save) {
            session.save();
        }
        return true;
    }

    public boolean saveVanityUrlMappings(JCRNodeWrapper contentNode, List<VanityUrl> vanityUrls, Set<String> updatedLocales, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper vanityUrlNode;
        HashMap existingMappings = new HashMap();
        HashMap<String, DefaultKeyValue> oldDefaultMappings = new HashMap<String, DefaultKeyValue>();
        JCRNodeWrapper vanityUrlMappingsNode = null;
        if (!contentNode.hasNode(VANITYURLMAPPINGS_NODE)) {
            if (!contentNode.isNodeType(JAHIAMIX_VANITYURLMAPPED)) {
                contentNode.addMixin(JAHIAMIX_VANITYURLMAPPED);
            }
            vanityUrlMappingsNode = contentNode.addNode(VANITYURLMAPPINGS_NODE, JAHIANT_VANITYURLS);
        } else {
            vanityUrlMappingsNode = contentNode.getNode(VANITYURLMAPPINGS_NODE);
            JCRNodeIteratorWrapper it = vanityUrlMappingsNode.getNodes();
            while (it.hasNext()) {
                JCRNodeWrapper currentNode = (JCRNodeWrapper)it.next();
                String language = currentNode.getPropertyAsString("jcr:language");
                if (!updatedLocales.contains(language)) continue;
                Map existingVanityUrls = (Map)existingMappings.get(language);
                if (existingVanityUrls == null) {
                    existingMappings.put(language, new HashMap());
                }
                VanityUrl vanityUrl = this.populateJCRData(currentNode, new VanityUrl());
                ((Map)existingMappings.get(language)).put(currentNode.getName(), vanityUrl);
                if (!currentNode.getProperty(PROPERTY_DEFAULT).getBoolean()) continue;
                oldDefaultMappings.put(language, new DefaultKeyValue((Object)currentNode.getName(), (Object)vanityUrl));
            }
        }
        ArrayList<VanityUrl> toAdd = new ArrayList<VanityUrl>();
        HashMap<String, VanityUrl> toUpdate = new HashMap<String, VanityUrl>();
        HashMap<String, VanityUrl> newDefaultMappings = new HashMap<String, VanityUrl>();
        for (VanityUrl vanityUrl : vanityUrls) {
            VanityUrl otherDefaultMapping;
            if (vanityUrl.isDefaultMapping() && (otherDefaultMapping = newDefaultMappings.put(vanityUrl.getLanguage(), vanityUrl)) != null) {
                throw new ConstraintViolationException("Two mappings are set as default for the same language: " + vanityUrl.getUrl() + " and " + otherDefaultMapping.getUrl() + " for language: " + vanityUrl.getLanguage(), null);
            }
            boolean found = false;
            Map map = (Map)existingMappings.get(vanityUrl.getLanguage());
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!VanityUrlManager.relaxedEquals((VanityUrl)entry.getValue(), vanityUrl)) continue;
                    map.remove(entry.getKey());
                    found = true;
                    if (((VanityUrl)entry.getValue()).isActive() == vanityUrl.isActive() && ((VanityUrl)entry.getValue()).isDefaultMapping() == vanityUrl.isDefaultMapping()) break;
                    vanityUrl.setIdentifier(((VanityUrl)entry.getValue()).getIdentifier());
                    toUpdate.put((String)entry.getKey(), vanityUrl);
                    break;
                }
            }
            if (found || !updatedLocales.contains(vanityUrl.getLanguage())) continue;
            toAdd.add(vanityUrl);
        }
        if (!newDefaultMappings.keySet().containsAll(updatedLocales)) {
            block3: for (String string : updatedLocales) {
                if (newDefaultMappings.containsKey(string)) continue;
                boolean defaultWasSet = false;
                Object var14_25 = null;
                if (oldDefaultMappings.get(string) != null) {
                    VanityUrl vanityUrl = (VanityUrl)((KeyValue)oldDefaultMappings.get(string)).getValue();
                    for (Map.Entry entry : toUpdate.entrySet()) {
                        VanityUrl vanityUrl2 = (VanityUrl)entry.getValue();
                        if (!VanityUrlManager.relaxedEquals(vanityUrl2, vanityUrl)) continue;
                        vanityUrl2.setDefaultMapping(true);
                        newDefaultMappings.put(string, vanityUrl2);
                        defaultWasSet = true;
                    }
                }
                if (defaultWasSet) continue;
                for (VanityUrl vanityUrl : vanityUrls) {
                    if (!string.equals(vanityUrl.getLanguage())) continue;
                    vanityUrl.setDefaultMapping(true);
                    newDefaultMappings.put(string, vanityUrl);
                    continue block3;
                }
            }
        }
        ArrayList<Map.Entry<String, VanityUrl>> toDelete = new ArrayList<Map.Entry<String, VanityUrl>>();
        for (Map existingVanityUrls : existingMappings.values()) {
            toDelete.addAll(existingVanityUrls.entrySet());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : oldDefaultMappings.entrySet()) {
            VanityUrl vanityUrl;
            VanityUrl oldDefaultVanityUrl = (VanityUrl)((KeyValue)entry.getValue()).getValue();
            if (VanityUrlManager.relaxedEquals(oldDefaultVanityUrl, vanityUrl = (VanityUrl)newDefaultMappings.get(entry.getKey()))) continue;
            boolean oldDefaultWillBeDeleted = false;
            for (Map.Entry entry2 : toDelete) {
                if (!oldDefaultVanityUrl.equals(entry2.getValue())) continue;
                oldDefaultWillBeDeleted = true;
                break;
            }
            if (oldDefaultWillBeDeleted || toUpdate.values().contains(oldDefaultVanityUrl)) continue;
            arrayList.add((String)((KeyValue)entry.getValue()).getKey());
        }
        for (VanityUrl vanityUrl : toAdd) {
            this.checkUniqueAndValidConstraint(contentNode, vanityUrl, toDelete);
        }
        if (toUpdate.isEmpty() && toAdd.isEmpty() && toDelete.isEmpty()) {
            return false;
        }
        session.checkout(vanityUrlMappingsNode);
        for (Map.Entry entry : toUpdate.entrySet()) {
            vanityUrlNode = vanityUrlMappingsNode.getNode((String)entry.getKey());
            VanityUrl vanityUrl = (VanityUrl)entry.getValue();
            session.checkout(vanityUrlNode);
            vanityUrlNode.setProperty(PROPERTY_ACTIVE, vanityUrl.isActive());
            vanityUrlNode.setProperty(PROPERTY_DEFAULT, vanityUrl.isDefaultMapping());
            vanityUrlNode.setProperty(PROPERTY_FILE, vanityUrl.isFile());
        }
        for (String string : arrayList) {
            vanityUrlNode = vanityUrlMappingsNode.getNode(string);
            session.checkout(vanityUrlNode);
            vanityUrlNode.setProperty(PROPERTY_DEFAULT, false);
        }
        for (Map.Entry entry : toDelete) {
            vanityUrlNode = vanityUrlMappingsNode.getNode((String)entry.getKey());
            session.checkout(vanityUrlNode);
            vanityUrlNode.remove();
        }
        for (VanityUrl vanityUrl : toAdd) {
            vanityUrlNode = vanityUrlMappingsNode.addNode(JCRContentUtils.escapeLocalNodeName(vanityUrl.getUrl()), JAHIANT_VANITYURL);
            session.checkout(vanityUrlNode);
            vanityUrlNode.setProperty(PROPERTY_URL, vanityUrl.getUrl());
            vanityUrlNode.setProperty("jcr:language", vanityUrl.getLanguage());
            vanityUrlNode.setProperty(PROPERTY_ACTIVE, vanityUrl.isActive());
            vanityUrlNode.setProperty(PROPERTY_DEFAULT, vanityUrl.isDefaultMapping());
            vanityUrlNode.setProperty(PROPERTY_FILE, vanityUrl.isFile());
        }
        session.save();
        return true;
    }

    private void checkUniqueAndValidConstraint(final JCRNodeWrapper contentNode, final VanityUrl vanityUrl, final List<Map.Entry<String, VanityUrl>> toDelete) throws RepositoryException, NonUniqueUrlMappingException {
        Optional<String> anyReservedUrl = this.getReservedJahiaUrls().stream().filter(StringUtils.lowerCase((String)vanityUrl.getUrl())::matches).findAny();
        if (anyReservedUrl.isPresent()) {
            throw new ReservedUrlMappingException(String.format("%s cannot be use as a vanity as matching the reserved url %s", vanityUrl.getUrl(), anyReservedUrl.get()), anyReservedUrl.get());
        }
        if (INVALID_CHARS.matcher(vanityUrl.getUrl()).find()) {
            throw new ConstraintViolationException("Invalid url, characters :*?\"<>|%+ are not allowed", null);
        }
        if (vanityUrl.getUrl().endsWith(".do")) {
            throw new ConstraintViolationException("Invalid url, cannot end with .do", null);
        }
        NonUniqueUrlMappingException ex = JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "default", null, new JCRCallback<NonUniqueUrlMappingException>(){

            @Override
            public NonUniqueUrlMappingException doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    VanityUrlManager.this.checkUniqueAndValidConstraint(contentNode, vanityUrl, toDelete, session);
                }
                catch (NonUniqueUrlMappingException e) {
                    return e;
                }
                return null;
            }
        });
        if (ex != null) {
            throw ex;
        }
        ex = JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, new JCRCallback<NonUniqueUrlMappingException>(){

            @Override
            public NonUniqueUrlMappingException doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    VanityUrlManager.this.checkUniqueAndValidConstraint(contentNode, vanityUrl, toDelete, session);
                }
                catch (NonUniqueUrlMappingException e) {
                    return e;
                }
                return null;
            }
        });
        if (ex != null) {
            throw ex;
        }
    }

    private void checkUniqueAndValidConstraint(JCRNodeWrapper contentNode, VanityUrl vanityUrl, List<Map.Entry<String, VanityUrl>> toDelete, JCRSessionWrapper session) throws RepositoryException, NonUniqueUrlMappingException {
        List<VanityUrl> existingUrls = this.findExistingVanityUrls(vanityUrl.getUrl(), vanityUrl.getSite(), session);
        if (existingUrls != null && !existingUrls.isEmpty()) {
            for (VanityUrl existingUrl : existingUrls) {
                if (vanityUrl.getIdentifier() != null && vanityUrl.getIdentifier().equals(existingUrl.getIdentifier())) continue;
                boolean oldMatchWillBeDeleted = false;
                if (toDelete != null) {
                    for (Map.Entry<String, VanityUrl> entry : toDelete) {
                        if (!existingUrl.equals(entry.getValue())) continue;
                        oldMatchWillBeDeleted = true;
                        break;
                    }
                }
                if (oldMatchWillBeDeleted) continue;
                throw new NonUniqueUrlMappingException(vanityUrl.getUrl(), contentNode.getPath(), StringUtils.removeEnd((String)session.getNodeByUUID(existingUrl.getIdentifier()).getParent().getPath(), (String)"/vanityUrlMapping"), session.getWorkspace().getName());
            }
        }
    }

    private VanityUrl populateJCRData(JCRNodeWrapper node, VanityUrl itemToBePopulated) throws RepositoryException {
        itemToBePopulated.setIdentifier(node.getIdentifier());
        itemToBePopulated.setPath(node.getPath());
        itemToBePopulated.setSite(JCRContentUtils.getSiteKey(node.getPath()));
        itemToBePopulated.setUrl(node.getPropertyAsString(PROPERTY_URL));
        itemToBePopulated.setLanguage(node.getPropertyAsString("jcr:language"));
        itemToBePopulated.setActive(node.getProperty(PROPERTY_ACTIVE).getBoolean());
        itemToBePopulated.setDefaultMapping(node.getProperty(PROPERTY_DEFAULT).getBoolean());
        itemToBePopulated.setFile(node.hasProperty(PROPERTY_FILE) && node.getProperty(PROPERTY_FILE).getBoolean());
        return itemToBePopulated;
    }

    private static boolean relaxedEquals(VanityUrl u1, VanityUrl u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return Objects.equals(u1.getUrl(), u2.getUrl()) && Objects.equals(u1.getPath(), u2.getPath()) && Objects.equals(u1.getLanguage(), u2.getLanguage()) && Objects.equals(u1.getSite(), u2.getSite());
    }

    public void setReservedJahiaUrls(List<String> reservedJahiaUrls) {
        this.reservedJahiaUrls = reservedJahiaUrls;
    }

    public List<String> getReservedJahiaUrls() {
        return this.reservedJahiaUrls;
    }
}

