/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.utils.FileUtils;
import org.jahia.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class ResourceChecksumCalculator
implements ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent> {
    private static Map<String, String> checksums = new ConcurrentHashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(ResourceChecksumCalculator.class);

    public static void flushChecksumCache() {
        checksums.clear();
    }

    private static InputStream getResourceAsStream(String resourcePath) {
        try {
            return WebUtils.getResourceAsStream(resourcePath);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void calculateChecksum(HttpServletRequest request, String ctx, String resourcePath) {
        request.setAttribute("ResourceChecksumCalculator.checksum", (Object)this.getChecksum(request, resourcePath));
    }

    private String getChecksum(HttpServletRequest request, String resourcePath) {
        String checksum = checksums.get(resourcePath);
        if (checksum == null) {
            long startTime = System.currentTimeMillis();
            InputStream resourceAsStream = ResourceChecksumCalculator.getResourceAsStream(resourcePath);
            checksum = resourceAsStream != null ? FileUtils.calculateDigest(resourceAsStream) : "0";
            checksums.put(resourcePath, checksum);
            if (logger.isDebugEnabled()) {
                logger.debug("Checksum for resource {} calculated in {} ms: {}", new Object[]{resourcePath, System.currentTimeMillis() - startTime, checksum});
            }
        }
        return checksum;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        logger.debug("Event received: {}", (Object)event);
        Object prefix = "/modules/";
        if (event.getSource() instanceof String) {
            prefix = (String)prefix + (String)event.getSource() + "/";
        }
        Iterator<Map.Entry<String, String>> iterator = checksums.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getKey().startsWith((String)prefix)) continue;
            logger.debug("Invalidating cached checksum entry for resource: {}", (Object)entry.getKey());
            iterator.remove();
        }
    }
}

