/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.services.seo.urlrewrite.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.RewrittenOutboundUrl;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;

class UrlRewriteEngine
extends UrlRewriter {
    private static final Logger logger = LoggerFactory.getLogger(UrlRewriteEngine.class);

    private static Configuration getConfiguration(ServletContext context, Resource[] confLocations) {
        Configuration cfg = null;
        if (confLocations == null || confLocations.length == 0) {
            logger.warn("No configuration resource location specified for the URL rewrite engine. Using empty one.");
            return Configuration.createEmptyConfiguration();
        }
        try {
            cfg = Configuration.createConfiguration(context, confLocations);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return cfg;
    }

    public UrlRewriteEngine(ServletContext context, Resource[] confLocations) {
        super((Conf)UrlRewriteEngine.getConfiguration(context, confLocations));
        if (confLocations != null) {
            logger.info("Loaded URL rewrite rules from {}", Arrays.asList(confLocations));
        }
    }

    public String rewriteOutbound(String url, HttpServletRequest request, HttpServletResponse response) {
        RewrittenOutboundUrl rou = this.processEncodeURL(response, request, false, url);
        if (rou == null) {
            return response.encodeURL(url);
        }
        if (rou.isEncode()) {
            rou.setTarget(response.encodeURL(rou.getTarget()));
        }
        return this.processEncodeURL(response, request, true, rou.getTarget()).getTarget();
    }
}

