/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.sites;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaService;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.SiteCreationInfo;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JahiaSitesService
extends JahiaService {
    private static final String DEFAULT_SITE_PROPERTY = "j:defaultSite";
    private static Logger logger = LoggerFactory.getLogger(JahiaSitesService.class);
    private static final String[] TRANSLATOR_NODES_PATTERN = new String[]{"translator-*"};
    public static final String SYSTEM_SITE_KEY = "systemsite";
    public static final String SITES_JCR_PATH = "/sites";
    private static final String SITE_COUNT_QUERY = "select [jcr:uuid] from [jnt:virtualsite] as node where ISCHILDNODE(node, '/sites')";
    private static final String SITE_COUNT_QUERY_WITHOUT_SYSTEM_SITE = "select [jcr:uuid] from [jnt:virtualsite] as node where ISCHILDNODE(node, '/sites') and node.[j:nodename] <> 'systemsite'";
    protected JahiaGroupManagerService groupService;
    protected JCRSessionFactory sessionFactory;
    protected EhCacheProvider ehCacheProvider;
    private SelfPopulatingCache siteKeyByServerNameCache;
    private SelfPopulatingCache siteDefaultLanguageBySiteKey;
    private SelfPopulatingCache sitesListCache;
    private String validServerNameRegex;
    private String validSiteKeyCharacters;

    public synchronized void setGroupService(JahiaGroupManagerService groupService) {
        this.groupService = groupService;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private JahiaSitesService() {
    }

    public static JahiaSitesService getInstance() {
        return Holder.INSTANCE;
    }

    public List<String> getSitesNames() {
        return (List)this.getSitesListCache().get((Serializable)((Object)"/")).getObjectValue();
    }

    private SelfPopulatingCache getSitesListCache() {
        if (this.sitesListCache == null) {
            this.sitesListCache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.sitesService.sitesListCache", new CacheEntryFactory(){

                public Object createEntry(Object o) throws Exception {
                    ArrayList<String> sites = new ArrayList<String>();
                    for (JCRSiteNode jcrSiteNode : JahiaSitesService.this.getSitesNodeList(JahiaSitesService.this.sessionFactory.getCurrentSystemSession("live", null, null))) {
                        sites.add(jcrSiteNode.getName());
                    }
                    return sites;
                }
            });
        }
        return this.sitesListCache;
    }

    public List<JCRSiteNode> getSitesNodeList() throws RepositoryException {
        return this.getSitesNodeList(this.getUserSession());
    }

    public List<JCRSiteNode> getSitesNodeList(JCRSessionWrapper session) throws RepositoryException {
        ArrayList<JCRSiteNode> list = new ArrayList<JCRSiteNode>();
        JCRNodeIteratorWrapper ni = session.getNode(SITES_JCR_PATH).getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)ni.next();
            if (!nodeWrapper.isNodeType("jnt:virtualsite")) continue;
            JCRSiteNode siteNode = (JCRSiteNode)nodeWrapper;
            list.add(siteNode);
        }
        return list;
    }

    public JCRSiteNode getFirstSiteFound(JCRSessionWrapper session, String ... skippedSites) throws RepositoryException {
        JCRNodeIteratorWrapper ni = session.getNode(SITES_JCR_PATH).getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper siteNode = (JCRNodeWrapper)ni.next();
            if (!siteNode.isNodeType("jnt:virtualsite") || ArrayUtils.contains((Object[])skippedSites, (Object)siteNode.getName())) continue;
            return (JCRSiteNode)siteNode;
        }
        return null;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() {
    }

    public JahiaSite getSiteByKey(String siteKey) throws JahiaException {
        if (StringUtils.isEmpty((String)siteKey)) {
            return null;
        }
        JCRSiteNode site = null;
        try {
            site = this.getSiteByKey(siteKey, this.getUserSession());
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            logger.error("cannot get site", (Throwable)e);
        }
        return site;
    }

    private JCRSessionWrapper getUserSession() throws RepositoryException {
        return this.sessionFactory.getCurrentUserSession("live");
    }

    public JCRSiteNode getSiteByKey(String siteKey, JCRSessionWrapper session) throws RepositoryException {
        return (JCRSiteNode)session.getNode("/sites/" + siteKey);
    }

    public boolean siteExists(String siteKey, JCRSessionWrapper session) throws RepositoryException {
        return StringUtils.isNotEmpty((String)siteKey) && session.nodeExists("/sites/" + siteKey);
    }

    public JahiaSite getSiteByServerName(String serverName) throws JahiaException {
        if (serverName == null) {
            return null;
        }
        JCRSiteNode site = null;
        try {
            site = this.getSiteByServerName(serverName, this.getUserSession());
        }
        catch (RepositoryException e) {
            logger.error("cannot get site", (Throwable)e);
        }
        return site;
    }

    public JCRSiteNode getSiteByServerName(String serverName, JCRSessionWrapper session) throws RepositoryException {
        String s = JCRContentUtils.sqlEncode(StringUtils.lowerCase((String)serverName));
        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:virtualsite] as s where (lower(s.[j:serverName])='" + s + "' or lower(s.[j:serverNameAliases])='" + s + "')  and ischildnode(s, '/sites/')", "JCR-SQL2");
        NodeIterator ni = q.execute().getNodes();
        if (ni.hasNext()) {
            return (JCRSiteNode)ni.next();
        }
        return null;
    }

    public String getSitenameByServerName(String serverName) throws JahiaException {
        if (serverName == null) {
            return null;
        }
        String siteName = this.getSiteKeyByServerNameCache().get((Serializable)((Object)serverName)).getObjectValue().toString();
        return "".equals(siteName) ? null : siteName;
    }

    private SelfPopulatingCache getSiteKeyByServerNameCache() {
        if (this.siteKeyByServerNameCache == null) {
            this.siteKeyByServerNameCache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.sitesService.siteKeyByServerNameCache", new SiteKeyByServerNameCacheEntryFactory());
        }
        return this.siteKeyByServerNameCache;
    }

    public JahiaSite getSite(String name) throws JahiaException {
        return this.getSiteByServerName(name);
    }

    @Deprecated(since="7.2.2.0", forRemoval=true)
    public JahiaSite addSite(JahiaUser currentUser, String title, String serverName, String siteKey, String descr, Locale selectedLocale, String selectTmplSet, String firstImport, Resource fileImport, String fileImportName, Boolean asAJob, Boolean doImportServerPermissions, String originatingJahiaRelease) throws JahiaException, IOException {
        return this.addSite(currentUser, title, serverName, siteKey, descr, selectedLocale, selectTmplSet, null, firstImport, fileImport, fileImportName, asAJob, doImportServerPermissions, originatingJahiaRelease);
    }

    @Deprecated(since="7.2.2.0", forRemoval=true)
    public JahiaSite addSite(JahiaUser currentUser, String title, String serverName, String siteKey, String descr, Locale selectedLocale, String selectTmplSet, String[] modulesToDeploy, String firstImport, Resource fileImport, String fileImportName, Boolean asAJob, Boolean doImportServerPermissions, String originatingJahiaRelease) throws JahiaException, IOException {
        return this.addSite(SiteCreationInfo.builder().siteKey(siteKey).serverName(serverName).title(title).description(descr).templateSet(selectTmplSet).modulesToDeploy(modulesToDeploy).locale(selectedLocale != null ? selectedLocale.toString() : null).siteAdmin(currentUser).firstImport(firstImport).fileImport(fileImport).fileImportName(fileImportName).originatingJahiaRelease(originatingJahiaRelease).build());
    }

    @Deprecated(since="7.2.2.0", forRemoval=true)
    public JahiaSite addSite(JahiaUser currentUser, String title, String serverName, String siteKey, String descr, Locale selectedLocale, String selectTmplSet, String[] modulesToDeploy, String firstImport, Resource fileImport, String fileImportName, Boolean asAJob, Boolean doImportServerPermissions, String originatingJahiaRelease, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath) throws JahiaException, IOException {
        return this.addSite(SiteCreationInfo.builder().siteKey(siteKey).serverName(serverName).title(title).description(descr).templateSet(selectTmplSet).modulesToDeploy(modulesToDeploy).locale(selectedLocale != null ? selectedLocale.toString() : null).siteAdmin(currentUser).firstImport(firstImport).fileImport(fileImport).fileImportName(fileImportName).originatingJahiaRelease(originatingJahiaRelease).legacyMappingFilePath(legacyMappingFilePath).legacyDefinitionsFilePath(legacyDefinitionsFilePath).build());
    }

    @Deprecated(since="7.2.2.0", forRemoval=true)
    public JahiaSite addSite(JahiaUser currentUser, String title, String serverName, String siteKey, String descr, Locale selectedLocale, String selectTmplSet, String[] modulesToDeploy, String firstImport, Resource fileImport, String fileImportName, Boolean asAJob, Boolean doImportServerPermissions, String originatingJahiaRelease, Resource legacyMappingFilePath, Resource legacyDefinitionsFilePath, JCRSessionWrapper session) throws JahiaException, IOException {
        return this.addSite(SiteCreationInfo.builder().siteKey(siteKey).serverName(serverName).title(title).description(descr).templateSet(selectTmplSet).modulesToDeploy(modulesToDeploy).locale(selectedLocale != null ? selectedLocale.toString() : null).siteAdmin(currentUser).firstImport(firstImport).fileImport(fileImport).fileImportName(fileImportName).originatingJahiaRelease(originatingJahiaRelease).legacyMappingFilePath(legacyMappingFilePath).legacyDefinitionsFilePath(legacyDefinitionsFilePath).build(), session);
    }

    public JahiaSite addSite(SiteCreationInfo info) throws JahiaException, IOException {
        return this.addSite(info, false);
    }

    public JahiaSite addSite(final SiteCreationInfo info, final boolean installModulesWithoutPages) throws JahiaException, IOException {
        JahiaSite site = null;
        final ArrayList errors = new ArrayList(1);
        try {
            site = JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<JahiaSite>(){

                @Override
                public JahiaSite doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        session.getPathMapping().putAll(JCRSessionFactory.getInstance().getCurrentUserSession().getPathMapping());
                        return JahiaSitesService.this.addSite(info, session, installModulesWithoutPages);
                    }
                    catch (IOException e) {
                        errors.add(e);
                    }
                    catch (JahiaException e) {
                        errors.add(e);
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            throw new JahiaException("", "", 0, 0, e);
        }
        if (!errors.isEmpty()) {
            Exception e = (Exception)errors.get(0);
            if (e instanceof JahiaException) {
                throw (JahiaException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new JahiaException("", "", 0, 0, e);
        }
        return site;
    }

    public JahiaSite addSite(SiteCreationInfo info, JCRSessionWrapper session) throws JahiaException, IOException {
        return this.addSite(info, session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JahiaSite addSite(SiteCreationInfo info, JCRSessionWrapper session, boolean installModulesWithoutPages) throws JahiaException, IOException {
        long startTime = System.currentTimeMillis();
        logger.info("Start creation of a site using data: {}", (Object)info);
        String siteKey = info.getSiteKey();
        if (!this.isSiteKeyValid(siteKey, true)) {
            String msg = "Site key is not valid. Allowed characters are: " + this.validSiteKeyCharacters;
            throw new JahiaException(msg, msg, 3, 2);
        }
        boolean importingSystemSite = false;
        JahiaTemplateManagerService templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        JCRSiteNode site = null;
        try {
            if (!this.siteExists(siteKey, session)) {
                JahiaTemplatesPackage templateSet = this.resolveTemplatePackage(info.getTemplateSet());
                String templatePackage = templateSet.getId();
                JCRNodeWrapper sitesFolder = session.getNode(SITES_JCR_PATH);
                try {
                    sitesFolder.getNode(siteKey);
                    throw new IOException("site already exists");
                }
                catch (PathNotFoundException e) {
                    JCRNodeWrapper siteNode = sitesFolder.addNode(siteKey, "jnt:virtualsite");
                    if (sitesFolder.hasProperty("j:virtualsitesFolderSkeleton")) {
                        String skeletons = sitesFolder.getProperty("j:virtualsitesFolderSkeleton").getString();
                        try {
                            JCRContentUtils.importSkeletons(skeletons, sitesFolder.getPath() + "/" + siteKey, session);
                        }
                        catch (Exception importEx) {
                            logger.error("Unable to import data using site skeleton " + skeletons, (Throwable)importEx);
                        }
                    }
                    siteNode.setProperty("j:title", info.getTitle());
                    siteNode.setProperty("j:description", info.getDescription());
                    siteNode.setProperty("j:serverName", info.getServerName());
                    siteNode.setProperty("j:serverNameAliases", info.getServerNameAliases());
                    siteNode.setProperty("j:defaultLanguage", info.getLocale());
                    siteNode.setProperty("j:mixLanguage", false);
                    siteNode.setProperty("j:languages", new String[]{info.getLocale()});
                    siteNode.setProperty("j:inactiveLiveLanguages", new String[0]);
                    siteNode.setProperty("j:inactiveLanguages", new String[0]);
                    siteNode.setProperty("j:mandatoryLanguages", new String[0]);
                    siteNode.setProperty("j:templatesSet", templatePackage);
                    siteNode.setProperty("j:installedModules", new Value[]{session.getValueFactory().createValue(templatePackage)});
                    String target = this.getTargetString(siteKey);
                    this.deployModules(target, info.getModulesToDeploy(), templateSet, session, templateService, installModulesWithoutPages);
                    List<JahiaTemplatesPackage> availableTemplatePackages = templateService.getAvailableTemplatePackages();
                    for (JahiaTemplatesPackage availableTemplatePackage : availableTemplatePackages) {
                        String autoDeployOnSite = availableTemplatePackage.getAutoDeployOnSite();
                        if (autoDeployOnSite == null || !"all".equals(autoDeployOnSite) && !siteKey.equals(autoDeployOnSite) && (!siteKey.equals(SYSTEM_SITE_KEY) || !autoDeployOnSite.equals("system"))) continue;
                        String source = "/modules/" + availableTemplatePackage.getId();
                        try {
                            logger.info("Deploying module {} to {}", (Object)source, (Object)target);
                            templateService.installModule(availableTemplatePackage, target, session);
                        }
                        catch (RepositoryException re) {
                            logger.error("Unable to deploy module " + source + " to " + target + ". Cause: " + re.getMessage(), (Throwable)re);
                        }
                    }
                    site = (JCRSiteNode)siteNode;
                    session.save();
                }
            } else if (siteKey.equals(SYSTEM_SITE_KEY)) {
                site = (JCRSiteNode)this.getSiteByKey(SYSTEM_SITE_KEY);
                importingSystemSite = true;
            } else {
                throw new IOException("site already exists");
            }
            JCRSiteNode siteNode = (JCRSiteNode)session.getNode(site.getPath());
            if (!site.isDefault() && !site.getSiteKey().equals(SYSTEM_SITE_KEY) && this.getNbSites() == 2) {
                this.setDefaultSite(site, session);
            }
            if (!importingSystemSite) {
                JCRGroupNode sitePrivGroup;
                JCRGroupNode adminGroup;
                JahiaGroupManagerService jgms = ServicesRegistry.getInstance().getJahiaGroupManagerService();
                siteNode.setMixLanguagesActive(false);
                session.save();
                JCRGroupNode privGroup = jgms.lookupGroup(null, "privileged", session);
                if (privGroup == null) {
                    privGroup = jgms.createGroup(null, "privileged", null, true, session);
                }
                if ((adminGroup = jgms.lookupGroup(site.getSiteKey(), "site-administrators", session)) == null) {
                    adminGroup = jgms.createGroup(site.getSiteKey(), "site-administrators", null, false, session);
                }
                if (info.getSiteAdmin() != null) {
                    adminGroup.addMember(session.getNode(info.getSiteAdmin().getLocalPath()));
                }
                if ((sitePrivGroup = jgms.lookupGroup(site.getSiteKey(), "site-privileged", session)) == null) {
                    sitePrivGroup = jgms.createGroup(site.getSiteKey(), "site-privileged", null, false, session);
                }
                privGroup.addMember(sitePrivGroup);
                if (!siteKey.equals(SYSTEM_SITE_KEY)) {
                    siteNode.grantRoles("g:site-privileged", Collections.singleton("privileged"));
                    siteNode.denyRoles("g:privileged", Collections.singleton("privileged"));
                }
                siteNode.grantRoles("g:site-administrators", Collections.singleton("site-administrator"));
                session.save();
            }
            Resource initialZip = null;
            if ("fileImport".equals(info.getFirstImport())) {
                initialZip = info.getFileImport();
            }
            if ("importRepositoryFile".equals(info.getFirstImport()) || initialZip != null && initialZip.exists() && !"noImport".equals(info.getFirstImport())) {
                try {
                    HashMap<Object, Object> importInfos = new HashMap<Object, Object>();
                    importInfos.put("originatingJahiaRelease", info.getOriginatingJahiaRelease());
                    ServicesRegistry.getInstance().getImportExportService().importSiteZip(initialZip, site, importInfos, info.getLegacyMappingFilePath(), info.getLegacyDefinitionsFilePath(), session);
                }
                catch (RepositoryException e) {
                    logger.warn("Error importing site ZIP", (Throwable)e);
                }
            }
            logger.debug("Site updated with Home Page");
        }
        catch (RepositoryException e) {
            logger.warn("Error adding home node", (Throwable)e);
        }
        finally {
            logger.info("Done creation of the site {} in {} ms", (Object)info.getSiteKey(), (Object)(System.currentTimeMillis() - startTime));
        }
        return site;
    }

    private JahiaTemplatesPackage resolveTemplatePackage(String templateSetName) {
        JahiaTemplateManagerService templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        JahiaTemplatesPackage pack = templateService.getAnyDeployedTemplatePackage(templateSetName);
        if (pack == null) {
            List<JahiaTemplatesPackage> pkgs = templateService.getNonSystemTemplateSetPackages();
            for (JahiaTemplatesPackage pkg : pkgs) {
                if (!pkg.isActiveVersion()) continue;
                pack = pkg;
            }
        }
        return pack;
    }

    private String getTargetString(String siteKey) {
        return "/sites/" + siteKey;
    }

    public void deployModules(JahiaSite site, String[] modulesToDeploy, JCRSessionWrapper session) {
        JahiaTemplateManagerService templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        this.deployModules(this.getTargetString(site.getSiteKey()), modulesToDeploy, templateService.getAnyDeployedTemplatePackage(site.getTemplatePackageName()), session, templateService, false);
    }

    public void updateModules(JahiaSite site, List<String> newModuleIds, JCRSessionWrapper session) {
        JahiaTemplateManagerService templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        List<String> installedModules = site.getInstalledModules();
        LinkedList<String> modulesToUninstall = new LinkedList<String>(installedModules);
        for (String string : newModuleIds) {
            if (templateService.getAnyDeployedTemplatePackage(string) == null) continue;
            modulesToUninstall.remove(string);
        }
        modulesToUninstall.remove("default");
        modulesToUninstall.remove(((JCRSiteNode)site).getTemplatePackage().getId());
        String siteKey = site.getSiteKey();
        for (JahiaTemplatesPackage jahiaTemplatesPackage : templateService.getAvailableTemplatePackages()) {
            String autoDeployOnSite = jahiaTemplatesPackage.getAutoDeployOnSite();
            if (autoDeployOnSite == null || !"all".equals(autoDeployOnSite) && !siteKey.equals(autoDeployOnSite)) continue;
            modulesToUninstall.remove(jahiaTemplatesPackage.getId());
        }
        if (!modulesToUninstall.isEmpty()) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (String moduleToUninstall : modulesToUninstall) {
                JahiaTemplatesPackage pkg = templateService.getAnyDeployedTemplatePackage(moduleToUninstall);
                linkedHashSet.add(pkg != null ? pkg.getId() : moduleToUninstall);
            }
            ArrayList<String> arrayList = new ArrayList<String>(linkedHashSet);
            logger.info("Uninstalling modules {} from {}", (Object)arrayList.toArray(), (Object)siteKey);
            try {
                templateService.uninstallModulesByIds(arrayList, site.getJCRLocalPath(), session);
            }
            catch (RepositoryException re) {
                logger.error("Unable to uninstall modules " + arrayList.toArray() + " from " + siteKey + ". Cause: " + re.getMessage(), (Throwable)re);
            }
        }
        LinkedList<String> linkedList = new LinkedList<String>(newModuleIds);
        linkedList.removeAll(installedModules);
        if (!linkedList.isEmpty()) {
            List<JahiaTemplatesPackage> list = this.moduleIdsToTemplatesPackage(linkedList, templateService);
            try {
                logger.info("Installing modules " + list + " to " + siteKey);
                templateService.installModules(list, site.getJCRLocalPath(), session);
            }
            catch (RepositoryException re) {
                logger.error("Unable to install modules " + list + " to " + siteKey + ". Cause: " + re.getMessage(), (Throwable)re);
            }
        }
    }

    private void deployModules(String target, String[] modulesToDeploy, JahiaTemplatesPackage templateSet, JCRSessionWrapper session, JahiaTemplateManagerService templateService, boolean installModulesWithoutPages) {
        List<JahiaTemplatesPackage> modules = this.moduleIdsToTemplatesPackage(modulesToDeploy != null ? Arrays.asList(modulesToDeploy) : Collections.emptyList(), templateService);
        modules.add(templateService.getAnyDeployedTemplatePackage("default"));
        modules.add(templateSet);
        try {
            logger.info("Deploying modules {} to {}", (Object)modules.toString(), (Object)target);
            templateService.installModules(modules, target, session, installModulesWithoutPages);
        }
        catch (RepositoryException re) {
            logger.error("Unable to deploy modules " + modules.toString() + " to " + target + ". Cause: " + re.getMessage(), (Throwable)re);
        }
    }

    private List<JahiaTemplatesPackage> moduleIdsToTemplatesPackage(List<String> modules, JahiaTemplateManagerService templateService) {
        if (modules != null) {
            ArrayList<JahiaTemplatesPackage> packages = new ArrayList<JahiaTemplatesPackage>(2 + modules.size());
            for (String s : modules) {
                JahiaTemplatesPackage packageByFileName = templateService.getAnyDeployedTemplatePackage(s);
                if (packages.contains(packageByFileName)) continue;
                packages.add(packageByFileName);
            }
            return packages;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSite(final JahiaSite siteToRemove) throws JahiaException {
        final String siteKeyToRemove = siteToRemove.getSiteKey();
        List<String> serverNames = siteToRemove.getAllServerNames();
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    for (String groupPath : JahiaSitesService.this.groupService.getGroupList(siteKeyToRemove)) {
                        if (!StringUtils.startsWith((String)groupPath, (String)(siteToRemove.getJCRLocalPath() + "/groups/")) || StringUtils.startsWith((String)groupPath, (String)(siteToRemove.getJCRLocalPath() + "/groups/providers/"))) continue;
                        JahiaSitesService.this.groupService.deleteGroup(groupPath, session);
                    }
                    session.save();
                    return true;
                }
            });
            JCRCallback<Boolean> deleteCallback = new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper sites = session.getNode(JahiaSitesService.SITES_JCR_PATH);
                    if (!sites.isCheckedOut()) {
                        session.checkout(sites);
                    }
                    JCRNodeWrapper siteNode = sites.getNode(siteKeyToRemove);
                    if ("default".equals(session.getWorkspace().getName()) && StringUtils.equals((String)sites.getPropertyAsString(JahiaSitesService.DEFAULT_SITE_PROPERTY), (String)siteNode.getIdentifier())) {
                        sites.setProperty(JahiaSitesService.DEFAULT_SITE_PROPERTY, JahiaSitesService.this.getFirstSiteFound(session, JahiaSitesService.SYSTEM_SITE_KEY, siteKeyToRemove));
                    }
                    siteNode.remove();
                    session.save();
                    return true;
                }
            };
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, deleteCallback);
            JCRTemplate.getInstance().doExecuteWithSystemSession(deleteCallback);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.invalidateCache(siteKeyToRemove, serverNames);
        }
    }

    public synchronized void updateSystemSitePermissions(final JahiaSite site) throws JahiaException {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JahiaSitesService.this.updateSystemSitePermissions(site, session);
                    session.save();
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void updateSystemSitePermissions(JahiaSite site, JCRSessionWrapper session) throws RepositoryException {
        JCRSiteNode siteNode;
        JCRNodeWrapper sites = session.getNode(SITES_JCR_PATH);
        if (!sites.isCheckedOut()) {
            session.checkout(sites);
        }
        if (!(siteNode = (JCRSiteNode)site).isCheckedOut()) {
            session.checkout(siteNode);
        }
        if (siteNode.getName().equals(SYSTEM_SITE_KEY)) {
            boolean update = this.updateWorkspacePermissions(session, "default", site);
            if (update |= this.updateWorkspacePermissions(session, "live", site)) {
                JahiaPrivilegeRegistry.init(session);
            }
            this.updateTranslatorRoles(session, site);
        }
    }

    @Deprecated(since="8.0.0.0", forRemoval=true)
    public int getNbSites() throws JahiaException {
        return Math.toIntExact(this.getSiteCount(true));
    }

    public long getSiteCount(boolean includeSystemSite) {
        try {
            return JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
                QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(includeSystemSite ? SITE_COUNT_QUERY : SITE_COUNT_QUERY_WITHOUT_SYSTEM_SITE, "JCR-SQL2");
                return query.execute().getRows().getSize();
            });
        }
        catch (RepositoryException e) {
            logger.error("Failed to count the number of sites", (Throwable)e);
            return 0L;
        }
    }

    public JahiaSite getDefaultSite() {
        JahiaSite site = null;
        try {
            site = this.getDefaultSite(this.getUserSession());
        }
        catch (RepositoryException e) {
            logger.error("cannot get site", (Throwable)e);
        }
        return site;
    }

    public JahiaSite getDefaultSite(JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper node = session.getNode(SITES_JCR_PATH);
        if (node.hasProperty(DEFAULT_SITE_PROPERTY)) {
            try {
                return (JCRSiteNode)node.getProperty(DEFAULT_SITE_PROPERTY).getNode();
            }
            catch (RepositoryException e) {
                List<JCRSiteNode> sitesNodeList = this.getSitesNodeList(session);
                for (JCRSiteNode jcrSiteNode : sitesNodeList) {
                    if (SYSTEM_SITE_KEY.equals(jcrSiteNode.getSiteKey())) continue;
                    return jcrSiteNode;
                }
            }
        }
        return null;
    }

    public void setDefaultSite(final JahiaSite site) {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JahiaSitesService.this.setDefaultSite(site, session);
                    session.save();
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("cannot set default site", (Throwable)e);
        }
    }

    public void setDefaultSite(JahiaSite site, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper node = session.getNode(SITES_JCR_PATH);
        if (!node.isCheckedOut()) {
            session.checkout(node);
        }
        if (site != null) {
            JCRNodeWrapper s = node.getNode(site.getSiteKey());
            node.setProperty(DEFAULT_SITE_PROPERTY, s);
        } else if (node.hasProperty(DEFAULT_SITE_PROPERTY)) {
            node.getProperty(DEFAULT_SITE_PROPERTY).remove();
        }
    }

    public void invalidateCache(JahiaSite site) throws JahiaException {
        if (site == null) {
            return;
        }
        this.invalidateCache(site.getSiteKey(), site.getAllServerNames());
    }

    public void invalidateCache(String siteKey, String serverName) {
        this.invalidateCache(siteKey, serverName != null ? Collections.singletonList(serverName) : null);
    }

    public void invalidateCache(String siteKey, List<String> serverNames) {
        if (this.siteDefaultLanguageBySiteKey != null && siteKey != null) {
            this.siteDefaultLanguageBySiteKey.remove((Serializable)((Object)siteKey));
        }
        if (this.siteKeyByServerNameCache != null && serverNames != null) {
            for (String serverName : serverNames) {
                this.siteKeyByServerNameCache.remove((Serializable)((Object)serverName));
            }
        }
    }

    private boolean updateWorkspacePermissions(JCRSessionWrapper session, String ws, JahiaSite site) throws RepositoryException {
        JCRNodeWrapper n = session.getNode("/permissions/repository-permissions/jcr:all_" + ws + "/jcr:write_" + ws + "/jcr:modifyProperties_" + ws);
        HashSet<String> languages = new HashSet<String>();
        NodeIterator ni = n.getNodes(new String[]{"jcr:modifyProperties_" + ws + "_*"});
        while (ni.hasNext()) {
            Node next = (Node)ni.next();
            languages.add(StringUtils.substringAfter((String)next.getName(), (String)("jcr:modifyProperties_" + ws + "_")));
        }
        boolean updated = false;
        for (String s : site.getLanguages()) {
            if (languages.contains(s)) continue;
            n.addNode("jcr:modifyProperties_" + ws + "_" + s, "jnt:permission");
            updated = true;
        }
        return updated;
    }

    private void updateTranslatorRoles(JCRSessionWrapper session, JahiaSite site) throws RepositoryException {
        if (!session.itemExists("/roles/translator")) {
            return;
        }
        JCRNodeWrapper n = session.getNode("/roles/translator");
        HashSet<String> languages = new HashSet<String>();
        NodeIterator ni = n.getNodes(TRANSLATOR_NODES_PATTERN);
        while (ni.hasNext()) {
            Node next = (Node)ni.next();
            languages.add(StringUtils.substringAfter((String)next.getName(), (String)"translator-"));
        }
        for (String s : site.getLanguages()) {
            if (languages.contains(s)) continue;
            session.checkout(n);
            Node translator = n.addNode("translator-" + s, "jnt:role");
            LinkedList<Value> perms = new LinkedList<Value>();
            perms.add(session.getValueFactory().createValue("jcr:modifyProperties_default_" + s));
            Value[] values = perms.toArray(new Value[perms.size()]);
            translator.setProperty("j:permissionNames", values);
            translator.setProperty("j:roleGroup", "edit-role");
            translator.setProperty("j:privilegedAccess", true);
        }
    }

    public boolean isSiteKeyValid(String siteKey) {
        return this.isSiteKeyValid(siteKey, false);
    }

    private boolean isSiteKeyValid(String siteKey, boolean allowSysstemSite) {
        if (StringUtils.isEmpty((String)siteKey) || !allowSysstemSite && SYSTEM_SITE_KEY.equals(siteKey)) {
            return false;
        }
        boolean valid = true;
        if (this.validSiteKeyCharacters != null && this.validSiteKeyCharacters.length() > 0) {
            for (char toBeTested : siteKey.toCharArray()) {
                if (this.validSiteKeyCharacters.indexOf(toBeTested) != -1) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    public boolean isServerNameValid(String serverName) {
        return StringUtils.isNotEmpty((String)serverName) && !serverName.contains(" ") && serverName.matches(this.validServerNameRegex);
    }

    public boolean updateSystemSiteLanguages(JahiaSite site, JCRSessionWrapper session) {
        if (!site.getSiteKey().equals(SYSTEM_SITE_KEY)) {
            try {
                JCRSiteNode jahiaSite = this.getSiteByKey(SYSTEM_SITE_KEY, session);
                HashSet<String> jahiaSiteLanguages = new HashSet<String>(jahiaSite.getLanguages());
                HashSet<String> siteLanguages = new HashSet<String>(site.getLanguages());
                siteLanguages.addAll(site.getInactiveLanguages());
                if (!jahiaSiteLanguages.containsAll(siteLanguages)) {
                    jahiaSiteLanguages.addAll(siteLanguages);
                    jahiaSite.setLanguages(jahiaSiteLanguages);
                    return true;
                }
            }
            catch (PathNotFoundException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public String getSiteDefaultLanguage(String siteKey) throws JahiaException {
        if (siteKey == null) {
            return null;
        }
        return (String)this.getSiteDefaultLanguageBySiteKeyCache().get((Serializable)((Object)siteKey)).getObjectValue();
    }

    private SelfPopulatingCache getSiteDefaultLanguageBySiteKeyCache() {
        if (this.siteDefaultLanguageBySiteKey == null) {
            this.siteDefaultLanguageBySiteKey = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.sitesService.siteDefaultLanguageBySiteKey", new SiteDefaultLanguageBySiteKeyCacheEntryFactory());
        }
        return this.siteDefaultLanguageBySiteKey;
    }

    public static void flushSitesInternalCaches() {
        JahiaSitesService.getInstance().flushCaches();
    }

    private void flushCaches() {
        if (this.siteKeyByServerNameCache != null) {
            this.siteKeyByServerNameCache.removeAll(false);
        }
        if (this.siteDefaultLanguageBySiteKey != null) {
            this.siteDefaultLanguageBySiteKey.removeAll(false);
        }
        if (this.sitesListCache != null) {
            this.sitesListCache.removeAll();
        }
    }

    public void setEhCacheProvider(EhCacheProvider ehCacheProvider) {
        this.ehCacheProvider = ehCacheProvider;
    }

    public void setValidServerNameRegex(String validServerNameRegex) {
        this.validServerNameRegex = validServerNameRegex;
    }

    public String getValidSiteKeyCharacters() {
        return this.validSiteKeyCharacters;
    }

    public void setValidSiteKeyCharacters(String validSiteKeyCharacters) {
        this.validSiteKeyCharacters = validSiteKeyCharacters;
    }

    public class SiteDefaultLanguageBySiteKeyCacheEntryFactory
    implements CacheEntryFactory {
        public Object createEntry(Object key) throws Exception {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            try {
                JCRSiteNode s;
                JCRSiteNode jCRSiteNode = s = StringUtils.isEmpty((String)((String)key)) ? null : JahiaSitesService.this.getSiteByKey((String)key, session);
                if (s != null) {
                    return s.getDefaultLanguage();
                }
            }
            catch (PathNotFoundException s) {
            }
            catch (RepositoryException e) {
                logger.error("cannot get site", (Throwable)e);
            }
            return "";
        }
    }

    public class SiteKeyByServerNameCacheEntryFactory
    implements CacheEntryFactory {
        public Object createEntry(Object key) throws Exception {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            JCRSiteNode s = JahiaSitesService.this.getSiteByServerName((String)key, session);
            if (s != null) {
                return s.getSiteKey();
            }
            return "";
        }
    }

    private static class Holder {
        static final JahiaSitesService INSTANCE = new JahiaSitesService();

        private Holder() {
        }
    }
}

