/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.tags;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.JahiaService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.tags.TagActionCallback;
import org.jahia.services.tags.TagHandler;
import org.jahia.services.tags.TagsSuggester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaggingService
extends JahiaService
implements JahiaAfterInitializationService {
    private static final Logger logger = LoggerFactory.getLogger(TaggingService.class);
    private TagsSuggester tagsSuggester;
    private TagHandler tagHandler;
    private String tagSeparator = null;
    public static final String JMIX_TAGGED = "jmix:tagged";
    public static final String J_TAG_LIST = "j:tagList";
    private static final Function<JCRValueWrapper, String> JCR_VALUE_WRAPPER_STRING_FUNCTION = new Function<JCRValueWrapper, String>(){

        @Nullable
        public String apply(@Nullable JCRValueWrapper input) {
            try {
                return input != null ? input.getString() : null;
            }
            catch (RepositoryException e) {
                return null;
            }
        }
    };

    public static TaggingService getInstance() {
        return Holder.INSTANCE;
    }

    public void init() throws NoSuchNodeTypeException {
    }

    @Override
    public void initAfterAllServicesAreStarted() throws JahiaInitializationException {
        try {
            Map<String, String> tagPropSelectorOptions = NodeTypeRegistry.getInstance().getNodeType(JMIX_TAGGED).getPropertyDefinition(J_TAG_LIST).getSelectorOptions();
            this.tagSeparator = tagPropSelectorOptions.get("separator");
        }
        catch (NoSuchNodeTypeException e) {
            throw new JahiaInitializationException("Cannot initialize tag service", e);
        }
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public boolean createTag(String tag, String siteKey) throws RepositoryException {
        return false;
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public boolean deleteTag(String tag, String siteKey) throws RepositoryException {
        return false;
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public boolean exists(String tag, String siteKey) throws RepositoryException {
        return false;
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public JCRNodeWrapper getTag(String tag, String siteKey, JCRSessionWrapper session) throws RepositoryException {
        return null;
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public long getTagCount(String tag, String siteKey) throws RepositoryException {
        return 0L;
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public boolean tag(JCRNodeWrapper node, String tag, String siteKey, boolean createTagIfNotExists) throws RepositoryException {
        this.tag(node, tag);
        return true;
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public boolean tag(String nodePath, String tag, String siteKey, boolean createTagIfNotExists, JCRSessionWrapper session) throws RepositoryException {
        this.tag(nodePath, tag, session);
        return true;
    }

    @Deprecated(since="7.2.0.0", forRemoval=true)
    public boolean tag(String nodePath, String tag, String siteKey, boolean createTagIfNotExists) throws RepositoryException {
        return false;
    }

    public List<String> tag(JCRNodeWrapper node, List<String> tags) throws RepositoryException {
        if (tags == null || tags.isEmpty()) {
            return Collections.emptyList();
        }
        List<Object> currentTagValues = new ArrayList();
        ArrayList<String> addedTags = new ArrayList<String>();
        try {
            currentTagValues = Arrays.asList(node.getProperty(J_TAG_LIST).getValues());
        }
        catch (PathNotFoundException e) {
            node.addMixin(JMIX_TAGGED);
        }
        ArrayList<String> currentTags = new ArrayList<String>(Collections2.transform(currentTagValues, JCR_VALUE_WRAPPER_STRING_FUNCTION));
        for (String tag : tags) {
            String[] splitedTags;
            String[] stringArray;
            if (this.tagSeparator != null) {
                stringArray = tag.split(this.tagSeparator);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = tag;
            }
            for (String splitedTag : splitedTags = stringArray) {
                String cleanedTag = this.tagHandler.execute(splitedTag);
                if (!StringUtils.isNotEmpty((String)cleanedTag) || currentTags.contains(cleanedTag)) continue;
                currentTags.add(cleanedTag);
                addedTags.add(cleanedTag);
            }
        }
        if (!addedTags.isEmpty()) {
            node.setProperty(J_TAG_LIST, currentTags.toArray(new String[currentTags.size()]));
        }
        return addedTags;
    }

    public List<String> tag(String nodePath, List<String> tags, JCRSessionWrapper session) throws RepositoryException {
        return this.tag(session.getNode(nodePath), tags);
    }

    public List<String> tag(JCRNodeWrapper node, String tag) throws RepositoryException {
        return this.tag(node, Lists.newArrayList((Object[])new String[]{tag}));
    }

    public List<String> tag(String nodePath, String tag, JCRSessionWrapper session) throws RepositoryException {
        return this.tag(session.getNode(nodePath), Lists.newArrayList((Object[])new String[]{tag}));
    }

    public List<String> untag(JCRNodeWrapper node, List<String> tags) throws RepositoryException {
        if (tags == null || tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> deletedTags = new ArrayList<String>();
        if (node.isNodeType(JMIX_TAGGED) && node.hasProperty(J_TAG_LIST)) {
            try {
                JCRPropertyWrapper tagsProp = node.getProperty(J_TAG_LIST);
                JCRValueWrapper[] currentTagValues = tagsProp.getValues();
                ArrayList currentTags = new ArrayList(Collections2.transform(Arrays.asList(currentTagValues), JCR_VALUE_WRAPPER_STRING_FUNCTION));
                for (String tag : tags) {
                    int index = currentTags.indexOf(tag);
                    if (index == -1) continue;
                    currentTags.remove(index);
                    deletedTags.add(tag);
                }
                if (!deletedTags.isEmpty()) {
                    if (currentTags.isEmpty()) {
                        try {
                            tagsProp.remove();
                            node.removeMixin(JMIX_TAGGED);
                        }
                        catch (NoSuchNodeTypeException noSuchNodeTypeException) {}
                    } else {
                        node.setProperty(J_TAG_LIST, currentTags.toArray(new String[currentTags.size()]));
                    }
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
        return deletedTags;
    }

    public List<String> untag(String nodePath, List<String> tags, JCRSessionWrapper session) throws RepositoryException {
        return this.untag(session.getNode(nodePath), tags);
    }

    public List<String> untag(JCRNodeWrapper node, String tag) throws RepositoryException {
        return this.untag(node, Lists.newArrayList((Object[])new String[]{tag}));
    }

    public List<String> untag(String nodePath, String tag, JCRSessionWrapper session) throws RepositoryException {
        return this.untag(session.getNode(nodePath), Lists.newArrayList((Object[])new String[]{tag}));
    }

    public void renameTag(JCRNodeWrapper node, String selectedTag, String tagNewName) throws RepositoryException {
        if (node.isNodeType(JMIX_TAGGED) && node.hasProperty(J_TAG_LIST) && tagNewName != null && tagNewName.length() > 0) {
            String[] splitedTags;
            String[] stringArray;
            JCRValueWrapper[] tags;
            TreeSet<String> newValues = new TreeSet<String>();
            for (JCRValueWrapper tag : tags = node.getProperty(J_TAG_LIST).getValues()) {
                String tagValue = tag.getString();
                if (tagValue.equals(selectedTag)) continue;
                newValues.add(tagValue);
            }
            if (this.tagSeparator != null) {
                stringArray = tagNewName.split(this.tagSeparator);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = tagNewName;
            }
            for (String splitedTag : splitedTags = stringArray) {
                newValues.add(this.tagHandler.execute(splitedTag));
            }
            node.setProperty(J_TAG_LIST, newValues.toArray(new String[newValues.size()]));
        }
    }

    public void renameTag(String nodePath, String selectedTag, String tagNewName, JCRSessionWrapper session) throws RepositoryException {
        this.renameTag(session.getNode(nodePath), selectedTag, tagNewName);
    }

    public <X> X renameTagUnderPath(String startPath, JCRSessionWrapper session, String selectedTag, String tagNewName, TagActionCallback<X> callback) throws RepositoryException {
        if (StringUtils.isNotEmpty((String)this.tagHandler.execute(tagNewName))) {
            return this.updateOrDeleteTagUnderPath(startPath, session, selectedTag, tagNewName, callback);
        }
        return null;
    }

    public <X> X deleteTagUnderPath(String startPath, JCRSessionWrapper session, String selectedTag, TagActionCallback<X> callback) throws RepositoryException {
        return this.updateOrDeleteTagUnderPath(startPath, session, selectedTag, null, callback);
    }

    private <X> X updateOrDeleteTagUnderPath(String startPath, JCRSessionWrapper session, String selectedTag, String tagNewName, TagActionCallback<X> callback) throws RepositoryException {
        String query = "SELECT * FROM [jmix:tagged] AS result WHERE ISDESCENDANTNODE(result, '" + JCRContentUtils.sqlEncode(startPath) + "') AND (result.[j:tagList] = '" + Text.escapeIllegalXpathSearchChars((String)selectedTag).replaceAll("'", "''") + "')";
        QueryManagerWrapper qm = session.getWorkspace().getQueryManager();
        Query q = qm.createQuery(query, "JCR-SQL2");
        NodeIterator ni = q.execute().getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper node = (JCRNodeWrapper)ni.nextNode();
            try {
                if (StringUtils.isNotEmpty((String)tagNewName)) {
                    this.renameTag(node, selectedTag, tagNewName);
                } else {
                    this.untag(node, selectedTag);
                }
                if (callback == null) continue;
                callback.afterTagAction(node);
            }
            catch (RepositoryException e) {
                if (callback != null) {
                    callback.onError(node, e);
                    continue;
                }
                logger.error("Error trying to " + (StringUtils.isNotEmpty((String)tagNewName) ? "rename" : "delete") + " tag '" + selectedTag + "' on node " + node.getPath(), (Throwable)e);
            }
        }
        if (callback != null) {
            return callback.end();
        }
        return null;
    }

    public void setTagsSuggester(TagsSuggester tagsSuggester) {
        this.tagsSuggester = tagsSuggester;
    }

    public TagHandler getTagHandler() {
        return this.tagHandler;
    }

    public void setTagHandler(TagHandler tagHandler) {
        this.tagHandler = tagHandler;
    }

    public TagsSuggester getTagsSuggester() {
        return this.tagsSuggester;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    private static class Holder {
        static final TaggingService INSTANCE = new TaggingService();

        private Holder() {
        }
    }
}

