/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.RowIterator;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Searchable;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.expression.Criteria;
import net.sf.ehcache.search.expression.EqualTo;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCacheHelper {
    private static final Logger logger = LoggerFactory.getLogger(GroupCacheHelper.class);
    private static final int DEFAULT_TTL_FOR_NON_EXISTING_GROUPS = 600;
    private static final int DEFAULT_TTL_FOR_EXTERNAL_MEMBERSHIP = 7200;
    private EhCacheProvider ehCacheProvider;
    private volatile SelfPopulatingCache groupPathByGroupNameCache;
    private volatile SelfPopulatingCache membershipCache;
    private int membershipCacheTimeToLive = 7200;
    private int timeToLiveForNonExistingGroups = 600;

    private static GroupPathByGroupNameCacheKey getPathCacheKey(String groupPath) {
        return new GroupPathByGroupNameCacheKey(groupPath.startsWith("/sites/") ? StringUtils.substringBetween((String)groupPath, (String)"/sites/", (String)"/") : null, StringUtils.substringAfterLast((String)groupPath, (String)"/"));
    }

    public String getGroupPath(String siteKey, String name) {
        String value = (String)this.getGroupPathByGroupNameCache().get((Serializable)new GroupPathByGroupNameCacheKey(siteKey, name)).getObjectValue();
        if (value.equals("")) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelfPopulatingCache getGroupPathByGroupNameCache() {
        SelfPopulatingCache cache = this.groupPathByGroupNameCache;
        if (cache == null) {
            GroupCacheHelper groupCacheHelper = this;
            synchronized (groupCacheHelper) {
                cache = this.groupPathByGroupNameCache;
                if (cache == null) {
                    this.groupPathByGroupNameCache = cache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.services.usermanager.JahiaGroupManagerService.groupPathByGroupNameCache", new Searchable(), new GroupPathByGroupNameCacheEntryFactory());
                }
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelfPopulatingCache getMembershipCache() {
        SelfPopulatingCache cache = this.membershipCache;
        if (cache == null) {
            GroupCacheHelper groupCacheHelper = this;
            synchronized (groupCacheHelper) {
                cache = this.membershipCache;
                if (cache == null) {
                    this.membershipCache = cache = this.ehCacheProvider.registerSelfPopulatingCache("org.jahia.services.usermanager.JahiaGroupManagerService.membershipCache", new MembershipCacheEntryFactory());
                    int timeToLive = (int)this.membershipCache.getCacheConfiguration().getTimeToLiveSeconds();
                    if (timeToLive > 0) {
                        this.membershipCacheTimeToLive = timeToLive;
                    }
                }
            }
        }
        return cache;
    }

    private void populateGroups(Set<String> groups, JCRNodeWrapper principal) throws RepositoryException, JahiaException {
        try {
            PropertyIterator weakReferences = principal.getWeakReferences("j:member");
            while (weakReferences.hasNext()) {
                this.populateGroup(groups, principal, weakReferences);
            }
        }
        catch (InvalidItemStateException e) {
            logger.warn("Cannot find membership for " + principal.getPath(), (Throwable)e);
        }
    }

    private void populateGroup(Set<String> groups, JCRNodeWrapper principal, PropertyIterator weakReferences) throws RepositoryException, JahiaException {
        try {
            JCRNodeWrapper group;
            Property property = weakReferences.nextProperty();
            if (property != null && property.getPath() != null && property.getPath().contains("/j:members/") && (group = (JCRNodeWrapper)property.getSession().getNode(StringUtils.substringBefore((String)property.getPath(), (String)"/j:members/"))).isNodeType("jnt:group") && groups.add(group.getPath())) {
                this.populateGroups(groups, group);
            }
        }
        catch (ItemNotFoundException e) {
            logger.warn("Cannot find group for " + principal.getPath(), (Throwable)e);
        }
    }

    public void setEhCacheProvider(EhCacheProvider ehCacheProvider) {
        this.ehCacheProvider = ehCacheProvider;
    }

    public void setTimeToLiveForNonExistingGroups(int timeToLiveForNonExistingGroups) {
        this.timeToLiveForNonExistingGroups = timeToLiveForNonExistingGroups;
    }

    public void updatePathCacheAdded(String groupPath) {
        this.getGroupPathByGroupNameCache().put(new Element((Serializable)GroupCacheHelper.getPathCacheKey(groupPath), (Serializable)((Object)groupPath)));
    }

    public void updatePathCacheRemoved(String groupPath) {
        this.getGroupPathByGroupNameCache().remove((Serializable)GroupCacheHelper.getPathCacheKey(groupPath));
    }

    public void clearNonExistingGroupsCache() {
        SelfPopulatingCache cache = this.getGroupPathByGroupNameCache();
        Results results = cache.createQuery().addCriteria((Criteria)new EqualTo("value", (Object)"")).includeKeys().execute();
        for (Result result : results.all()) {
            cache.remove(result.getKey());
        }
    }

    private final class MembershipCacheEntryFactory
    implements CacheEntryFactory {
        private MembershipCacheEntryFactory() {
        }

        public Object createEntry(Object key) throws Exception {
            try {
                return this.internalGetMembershipByPath((String)key);
            }
            catch (PathNotFoundException pathNotFoundException) {
            }
            catch (RepositoryException e) {
                logger.error("Error retrieving membership for user " + (String)key + ", will return empty list", (Throwable)e);
            }
            return Collections.emptyList();
        }

        private Serializable internalGetMembershipByPath(String principalPath) throws RepositoryException {
            JCRNodeWrapper principalNode = JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null).getNode(principalPath);
            LinkedHashSet<String> groups = new LinkedHashSet<String>();
            try {
                GroupCacheHelper.this.populateGroups(groups, principalNode);
            }
            catch (JahiaException e) {
                logger.warn("Error retrieving membership for user " + principalPath, (Throwable)e);
            }
            if (principalNode instanceof JCRUserNode) {
                JCRUserNode userNode = (JCRUserNode)principalNode;
                if (!JahiaUserManagerService.isGuest(userNode)) {
                    this.populateSpecialGroups(groups, "/groups/users");
                    if (userNode.getRealm() != null) {
                        String siteUsers = "/sites/" + userNode.getRealm() + "/groups/site-users";
                        this.populateSpecialGroups(groups, siteUsers);
                    }
                }
                this.populateSpecialGroups(groups, "/groups/guest");
            }
            LinkedList<String> result = new LinkedList<String>(groups);
            if (!principalNode.getProvider().isDefault()) {
                Element e = new Element((Serializable)((Object)principalPath), result);
                e.setTimeToLive(GroupCacheHelper.this.membershipCacheTimeToLive);
                return e;
            }
            return result;
        }

        private void populateSpecialGroups(Set<String> groups, String groupPath) {
            groups.add(groupPath);
            groups.addAll((List)GroupCacheHelper.this.getMembershipCache().get((Serializable)((Object)groupPath)).getObjectValue());
        }
    }

    private final class GroupPathByGroupNameCacheEntryFactory
    implements CacheEntryFactory {
        private GroupPathByGroupNameCacheEntryFactory() {
        }

        public Object createEntry(Object key) throws Exception {
            GroupPathByGroupNameCacheKey k = (GroupPathByGroupNameCacheKey)key;
            String path = this.internalGetGroupPath(k.siteKey, k.groupName);
            if (path != null) {
                return new Element(key, (Object)path);
            }
            return new Element(key, (Object)"", 0, GroupCacheHelper.this.timeToLiveForNonExistingGroups);
        }

        private String internalGetGroupPath(String siteKey, String name) throws RepositoryException {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT [j:nodename] FROM [");
            sb.append("jnt:group");
            sb.append("] as group where localname()='");
            sb.append(JCRContentUtils.sqlEncode(name)).append("' ");
            if (siteKey != null) {
                sb.append("and isdescendantnode(group,'/sites/");
                sb.append(JCRContentUtils.sqlEncode(siteKey));
                sb.append("/groups')");
            } else {
                sb.append("and isdescendantnode(group,'/groups')");
            }
            QueryWrapper query = this.getQueryManager().createQuery(sb.toString(), "JCR-SQL2");
            query.setLimit(1L);
            RowIterator it = query.execute().getRows();
            if (it.hasNext()) {
                return it.nextRow().getPath();
            }
            return null;
        }

        private QueryManagerWrapper getQueryManager() throws RepositoryException {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null);
            return session.getWorkspace().getQueryManager();
        }
    }

    private static final class GroupPathByGroupNameCacheKey
    implements Serializable {
        private static final long serialVersionUID = 6343178106505586294L;
        private final int hash;
        private String siteKey;
        private String groupName;

        private GroupPathByGroupNameCacheKey(String siteKey, String groupName) {
            this.siteKey = siteKey;
            this.groupName = groupName;
            this.hash = this.getHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupPathByGroupNameCacheKey that = (GroupPathByGroupNameCacheKey)o;
            if (!this.groupName.equals(that.groupName)) {
                return false;
            }
            return Objects.equals(this.siteKey, that.siteKey);
        }

        private int getHashCode() {
            int result = this.siteKey != null ? this.siteKey.hashCode() : 0;
            result = 31 * result + this.groupName.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

