/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskIdentityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMTaskIdentityService
implements TaskIdentityService {
    private static transient Logger logger = LoggerFactory.getLogger(JBPMTaskIdentityService.class);
    protected JahiaGroupManagerService groupService;
    protected JahiaUserManagerService userService;

    public List<Group> findGroupsByUser(String userId) {
        ArrayList<Group> results = new ArrayList<Group>();
        JCRUserNode user = this.userService.lookupUserByPath(userId);
        if (user != null) {
            List<String> l = this.groupService.getMembershipByPath(user.getPath());
            for (String groupKey : l) {
                Group groupById = this.getGroupById(groupKey);
                if (groupById == null) continue;
                results.add(groupById);
            }
        }
        return results;
    }

    public void addUser(User user) {
        throw new UnsupportedOperationException("addUser");
    }

    public void addGroup(Group group) {
        throw new UnsupportedOperationException("addGroup");
    }

    public void removeGroup(String groupId) {
        throw new UnsupportedOperationException();
    }

    public void removeUser(String userId) {
        throw new UnsupportedOperationException();
    }

    public void setGroupService(JahiaGroupManagerService groupService) {
        this.groupService = groupService;
    }

    public void setUserService(JahiaUserManagerService userService) {
        this.userService = userService;
    }

    public List<User> getUsers() {
        List<String> userKeyList = this.userService.getUserList();
        ArrayList<User> results = new ArrayList<User>();
        for (String userKey : userKeyList) {
            JCRUserNode jahiaUser = this.userService.lookupUserByPath(userKey);
            results.add(new UserImpl(jahiaUser.getPath(), jahiaUser.getPropertyAsString("firstName"), jahiaUser.getPropertyAsString("lastName"), jahiaUser.getPropertyAsString("email"), UserPreferencesHelper.areEmailNotificationsDisabled(jahiaUser)));
        }
        return results;
    }

    public List<Group> getGroups() {
        ArrayList<Group> results = new ArrayList<Group>();
        List<String> groupKeyList = this.groupService.getGroupList();
        for (String groupKey : groupKeyList) {
            JCRGroupNode jahiaGroup = this.groupService.lookupGroupByPath(groupKey);
            results.add(new GroupImpl(jahiaGroup.getPath(), jahiaGroup.getName(), "jahia"));
        }
        return results;
    }

    public User getUserById(String userId) {
        JahiaUserManagerService service = ServicesRegistry.getInstance().getJahiaUserManagerService();
        JCRUserNode user = service.lookupUserByPath(userId);
        if (user != null) {
            return new UserImpl(userId, user.getPropertyAsString("j:firstName"), user.getPropertyAsString("j:lastName"), user.getPropertyAsString("j:email"), UserPreferencesHelper.areEmailNotificationsDisabled(user));
        }
        return null;
    }

    public Group getGroupById(String groupId) {
        JahiaGroupManagerService service = JahiaGroupManagerService.getInstance();
        JCRGroupNode group = service.lookupGroupByPath(groupId);
        if (group != null) {
            return new GroupImpl(groupId, group.getName(), "jahia");
        }
        return null;
    }

    public OrganizationalEntity getOrganizationalEntityById(String entityId) {
        return null;
    }

    @Entity
    public class GroupImpl
    implements Group {
        private String id;
        private String name;
        private String type;

        GroupImpl(String id, String name, String type) {
            this.id = id;
            this.name = name;
            this.type = type;
        }

        protected GroupImpl() {
        }

        @Id
        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.id);
            objectOutput.writeUTF(this.name);
            objectOutput.writeUTF(this.type);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.id = objectInput.readUTF();
            this.name = objectInput.readUTF();
            this.type = objectInput.readUTF();
        }
    }

    @Entity
    public class UserImpl
    implements User,
    Comparable<UserImpl> {
        private String id;
        private String givenName;
        private String familyName;
        private String businessEmail;
        private boolean emailNotifioncationsDisabled;

        UserImpl(String id, String givenName, String familyName, String businessEmail, boolean emailNotifioncationsDisabled) {
            this.id = id;
            this.givenName = givenName;
            this.familyName = familyName;
            this.businessEmail = businessEmail;
            this.emailNotifioncationsDisabled = emailNotifioncationsDisabled;
        }

        protected UserImpl() {
        }

        @Id
        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getGivenName() {
            return this.givenName;
        }

        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        public String getBusinessEmail() {
            return this.businessEmail;
        }

        public void setBusinessEmail(String businessEmail) {
            this.businessEmail = businessEmail;
        }

        @Override
        public int compareTo(UserImpl o) {
            return (this.getFamilyName() + this.getGivenName()).compareTo(o.getFamilyName() + o.getGivenName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserImpl user = (UserImpl)o;
            return this.id.equals(user.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.id);
            objectOutput.writeUTF(this.givenName);
            objectOutput.writeUTF(this.familyName);
            objectOutput.writeUTF(this.businessEmail);
            objectOutput.writeBoolean(this.emailNotifioncationsDisabled);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.id = objectInput.readUTF();
            this.givenName = objectInput.readUTF();
            this.familyName = objectInput.readUTF();
            this.businessEmail = objectInput.readUTF();
            try {
                this.emailNotifioncationsDisabled = objectInput.readBoolean();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }

        public boolean areEmailNotificationsDisabled() {
            return this.emailNotifioncationsDisabled;
        }
    }
}

