/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.workflow.WorkflowObservationManager;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.jahia.services.workflow.jbpm.JBPM6WorkflowProvider;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.task.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompleteTaskCommand
extends BaseCommand<Object> {
    private static final Logger logger = LoggerFactory.getLogger(CompleteTaskCommand.class);
    private JBPM6WorkflowProvider jbpm6WorkflowProvider;
    private final String taskId;
    private final String outcome;
    private final Map<String, Object> args;
    private final JahiaUser jahiaUser;
    private final WorkflowObservationManager observationManager;

    public CompleteTaskCommand(String taskId, String outcome, Map<String, Object> args, JahiaUser jahiaUser, WorkflowObservationManager observationManager) {
        this.taskId = taskId;
        this.outcome = outcome;
        this.args = args;
        this.jahiaUser = jahiaUser;
        this.observationManager = observationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute() {
        Map<String, Object> taskInputParameters;
        Map<String, Object> taskOutputParameters;
        String uuid;
        long id = Long.parseLong(this.taskId);
        Task task = this.getTaskService().getTaskById(id);
        NodeInstance taskNodeInstance = this.getTaskNodeInstance(task, this.ksession);
        String processId = taskNodeInstance.getProcessInstance().getProcessId();
        Map<String, String> permissions = this.workflowService.getWorkflowRegistration(ISO9075.decode((String)processId)).getPermissions();
        String permission = permissions.get(taskNodeInstance.getNodeName() + "." + this.outcome);
        if (permission != null) {
            String nodeId = (String)taskNodeInstance.getProcessInstance().getVariable("nodeId");
            try {
                if (nodeId != null && !JCRTemplate.getInstance().doExecute(this.jahiaUser, null, null, session -> session.getNodeByIdentifier(nodeId).hasPermission(permission)).booleanValue()) {
                    logger.error("User does not have permission to complete {} with {}", (Object)taskNodeInstance.getNodeName(), (Object)this.outcome);
                    return null;
                }
            }
            catch (RepositoryException e) {
                logger.warn("Cannot read node {}", (Object)nodeId, (Object)e);
            }
        }
        if ((uuid = (String)(taskOutputParameters = this.getTaskOutputParameters(task, taskInputParameters = this.getTaskInputParameters(task, this.getKieSession(), this.getTaskService()), this.getKieSession(), this.getTaskService())).get("task-" + this.taskId)) != null) {
            String workspace = (String)taskInputParameters.get("workspace");
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(this.jahiaUser, workspace, null, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        if (!session.getNodeByUUID(uuid).hasProperty("state") || !session.getNodeByUUID(uuid).getProperty("state").getString().equals("finished")) {
                            session.getNodeByUUID(uuid).setProperty("finalOutcome", CompleteTaskCommand.this.outcome);
                            session.getNodeByUUID(uuid).setProperty("state", "finished");
                            session.save();
                        }
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.observationManager.notifyTaskEnded(this.getKey(), this.taskId);
        ClassLoader l = null;
        try {
            Map<String, Object> argsMap;
            String module = this.getWorkflowService().getModuleForWorkflow(task.getTaskData().getProcessId());
            if (module != null) {
                l = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(module).getChainedClassLoader());
            }
            if ((argsMap = this.args) == null) {
                argsMap = new HashMap<String, Object>();
            }
            argsMap.put("outcome", this.outcome);
            this.getTaskService().start(id, this.jahiaUser.getUserKey());
            this.getTaskService().complete(id, this.jahiaUser.getUserKey(), argsMap);
            if (l != null) {
                Thread.currentThread().setContextClassLoader(l);
            }
        }
        catch (Throwable throwable) {
            if (l != null) {
                Thread.currentThread().setContextClassLoader(l);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n taskId: %s", this.taskId) + String.format("%n outcome: %s", this.outcome) + String.format("%n jahiaUser: %s", this.jahiaUser != null ? this.jahiaUser.getName() : null) + String.format("%n args: %s", Joiner.on((String)",").withKeyValueSeparator("=").join(this.args));
    }
}

